/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemfw4j;

import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.DimensionTypeEnum;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMeasureDimension;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.record.HierarchyRecord;
import com.cognos.xqe.util.xml.stax.ChildElementIterator;
import com.cognos.xqe.util.xml.stax.StaxUtil;
import com.cognos.xqemfw4j.MFWDimension;
import com.cognos.xqemfw4j.MFWMeasure;
import com.cognos.xqemfw4j.MFWMeasureHierarchy;
import com.cognos.xqemfw4j.MFWMetadataConnection;
import com.cognos.xqemfw4j.MFWMultiRequestHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

class MFWMeasureDimension
extends MFWDimension
implements IMeasureDimension {
    private static final String QUERY_HIERARCHYINFO = "/property[name='measureHierarchyInfo']/__Value";
    protected Boolean dualStructures = null;

    MFWMeasureDimension(MFWMetadataConnection mfwConnection, MFWMultiRequestHandle[] mfwHandle) {
        super(mfwConnection, mfwHandle);
        if (null == mfwHandle) {
            throw new NullPointerException();
        }
        String type = this.queryValue(MFWModelRes.getInstance().RID_type, new short[0]);
        DimensionTypeEnum dimensionType = DimensionTypeEnum.fromFMDimensionTypeString(type);
        if (dimensionType != DimensionTypeEnum.MEASURE) {
            this.throwInvalidObject();
        }
    }

    @Override
    public List<IHierarchy> getHierarchies() {
        if (this.hierarchies == null) {
            this.queryHierarchies();
        }
        return this.hierarchies;
    }

    @Override
    public DimensionTypeEnum getType() {
        return DimensionTypeEnum.MEASURE;
    }

    @Override
    public boolean isDBMeasureDimension() {
        return true;
    }

    @Override
    public boolean isMeasuresDimension() {
        return true;
    }

    @Override
    public boolean isRegularDimension() {
        return false;
    }

    @Override
    public boolean isShell() {
        return false;
    }

    @Override
    public boolean isTimeDimension() {
        return false;
    }

    @Override
    public IHierarchy getDefaultHierarchy() {
        if (this.defaultHierarchy == null) {
            this.defaultHierarchy = this.getHierarchies().get(0);
        }
        return this.defaultHierarchy;
    }

    public boolean isDualStructures() {
        if (this.dualStructures == null && DataSourceTypeEnum.isSAPBW(this.getCube().getModelDataSource().getInterface())) {
            this.dualStructures = Boolean.valueOf(this.queryValue(MFWModelRes.getInstance().getResourceID("DualStructures"), new short[0]));
        }
        return this.dualStructures;
    }

    @Override
    public String getUniqueID() {
        if (this.uniqueID == null) {
            this.uniqueID = this.queryValue(MFWModelRes.getInstance().RID_PPDS_CODE, new short[0]);
        }
        return this.uniqueID;
    }

    @Override
    public boolean isKeyFigureStructure() {
        if (this.keyFigureStructure == null) {
            List<IMember> measures;
            boolean sapKeyFigureStructure = false;
            if (DataSourceTypeEnum.isSAPBW(this.getCube().getModelDataSource().getInterface()) && (measures = this.getCube().getMeasuresHierarchy().getLevel(0).getMembers()).size() > 0) {
                MFWMeasure measure = (MFWMeasure)measures.get(0);
                String precision = this.getConnection().queryValue(measure.getHandle(), MFWModelRes.getInstance().RID_precision, new short[0]);
                sapKeyFigureStructure = "zero".equals(precision);
            }
            this.keyFigureStructure = sapKeyFigureStructure;
        }
        return this.keyFigureStructure;
    }

    void queryHierarchies() {
        ArrayList<MFWMeasureHierarchy> queryHierarchies = new ArrayList<MFWMeasureHierarchy>();
        String hierarchyInfo = this.queryValue(QUERY_HIERARCHYINFO);
        if (hierarchyInfo != null) {
            ArrayList<String> externalNames = new ArrayList<String>();
            try {
                XMLStreamReader xmlReader = StaxUtil.createXMLStreamReader(hierarchyInfo);
                while (xmlReader.hasNext() && StaxUtil.moveToElement(xmlReader, "hierarchy")) {
                    ChildElementIterator childIter = new ChildElementIterator(xmlReader);
                    while (childIter.next()) {
                        if (xmlReader.getLocalName().equals("externalName")) {
                            externalNames.add(xmlReader.getElementText());
                            continue;
                        }
                        StaxUtil.skipElement(xmlReader);
                    }
                    if (StaxUtil.testOnEndElement(xmlReader, "hierarchy")) continue;
                    StaxUtil.moveToEndElement(xmlReader, "hierarchy");
                }
                xmlReader.close();
            }
            catch (XMLStreamException ex) {
                throw new XQERuntimeException(ex);
            }
            for (String externalName : externalNames) {
                queryHierarchies.add(new MFWMeasureHierarchy(this, externalName));
            }
        }
        if (queryHierarchies.size() == 0) {
            if (this.isDMR()) {
                queryHierarchies.add(new MFWMeasureHierarchy(this, this.getUniqueName()));
            } else {
                List<HierarchyRecord> hierarchyRecords = this.queryHierarchyRecords();
                if (hierarchyRecords != null) {
                    for (HierarchyRecord hierarchyRecord : hierarchyRecords) {
                        queryHierarchies.add(new MFWMeasureHierarchy(this, hierarchyRecord.getUniqueName()));
                    }
                }
            }
        }
        if (queryHierarchies.size() == 0) {
            queryHierarchies.add(new MFWMeasureHierarchy(this, this.getUniqueName()));
        }
        this.setHierarchies(Collections.unmodifiableList(queryHierarchies));
    }

    private synchronized void setHierarchies(List<IHierarchy> queryHierarchies) {
        if (this.hierarchies == null) {
            this.hierarchies = queryHierarchies;
        }
    }

    @Override
    public boolean isDefaultHierarchyExistInModel() {
        return true;
    }
}

