/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemfw4j;

import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.MemberType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueSizeInfo;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.IAggregateRule;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.MemberTypeEnum;
import com.cognos.xqe.metadata.MetadataKey;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.RollupTypeEnum;
import com.cognos.xqe.metadata.record.MemberRecord;
import com.cognos.xqe.util.LocalizedString;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.bean.BeanPropertySupport;
import com.cognos.xqe.util.xml.XMLWriter;
import com.cognos.xqemfw4j.MFWDimension;
import com.cognos.xqemfw4j.MFWFolder;
import com.cognos.xqemfw4j.MFWHierarchy;
import com.cognos.xqemfw4j.MFWLevel;
import com.cognos.xqemfw4j.MFWMetadata;
import com.cognos.xqemfw4j.MFWMetadataConnection;
import com.cognos.xqemfw4j.MFWMultiRequestHandle;
import com.ibm.icu.text.Collator;
import java.util.List;

class MFWMember
extends MFWMetadata
implements IMember {
    private static final BeanPropertySupport BEAN_PROPERTY_SUPPORT = new BeanPropertySupport(MFWMember.class);
    static final long serialVersionUID = 7647274105530911872L;
    protected String uniqueName = null;
    MFWMember parent = null;
    String v5MUN = null;
    ILevel level = null;
    IHierarchy hierarchy = null;
    String v5UniqueName = null;
    String name = null;
    int numberOfParents = 0;
    int childrenCardinality = 0;
    MemberTypeEnum type = MemberTypeEnum.UNKNOWN;
    RollupTypeEnum rollupType = RollupTypeEnum.ROLLUP;
    boolean suppressed = false;
    private String id;

    MFWMember(MFWMetadataConnection mfwConnection, MFWMultiRequestHandle[] mfwHandle) {
        super(mfwConnection, mfwHandle);
    }

    MFWMember(MFWMetadataConnection mfwConnection, MFWMultiRequestHandle[] mfwHandle, ILevel memLevel) {
        super(mfwConnection, mfwHandle);
        this.level = memLevel;
    }

    MFWMember(String memberUniqueName, MFWLevel mfwLevel) {
        super(mfwLevel.getConnection(), new MFWMultiRequestHandle[0]);
        this.level = mfwLevel;
        this.hierarchy = this.level.getHierarchy();
        this.uniqueName = memberUniqueName;
        this.name = memberUniqueName;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (null == other) {
            return false;
        }
        if (other instanceof TextValue) {
            TextValue otherTextValue = (TextValue)other;
            String tmp = this.getCaption();
            if (null == tmp) {
                return otherTextValue.isNull();
            }
            return tmp.equals(otherTextValue.getString());
        }
        return super.equals(other);
    }

    @Override
    public int compareTo(Object other) {
        if (null == other) {
            return -1;
        }
        if (other instanceof TextValue) {
            TextValue otherTextValue = (TextValue)other;
            String tmp = this.getCaption();
            if (null == tmp) {
                if (otherTextValue.isNull()) {
                    return 0;
                }
                return -1;
            }
            return tmp.compareTo(otherTextValue.getString());
        }
        return super.compareTo(other);
    }

    @Override
    public boolean isCalculatedMember() {
        return false;
    }

    @Override
    public boolean isExtendedCalculatedMember() {
        return false;
    }

    @Override
    public boolean isExtendedCalculatedMemberTypeChildRef() {
        return false;
    }

    @Override
    public boolean isExtendedCalculatedMemberWithFormula() {
        return false;
    }

    @Override
    public boolean isProviderDefaultMember() {
        return false;
    }

    @Override
    public IMember getDataMember() {
        return this;
    }

    @Override
    public List<IMember> getChildren() {
        this.throwNotImplemented();
        return null;
    }

    @Override
    public IMember getParent() {
        return this.parent;
    }

    @Override
    public String getParentUniqueName() {
        String parentUniqueName = null;
        if (this.getParent() != null) {
            parentUniqueName = this.getParent().getUniqueName();
        }
        return parentUniqueName;
    }

    @Override
    public MetadataType getObjectType() {
        return MetadataType.MEMBER;
    }

    @Override
    public ILevel getLevel() {
        if (this.level == null) {
            this.level = this.queryLevel();
        }
        return this.level;
    }

    private ILevel queryLevel() {
        ILevel modelLevel = null;
        MFWMetadata obj = (MFWMetadata)this.getConnection().getParentObject(this);
        while (obj instanceof MFWFolder) {
            obj = (MFWMetadata)this.getConnection().getParentObject(obj);
        }
        if (obj instanceof MFWLevel) {
            modelLevel = (MFWLevel)obj;
        } else if (obj instanceof MFWHierarchy) {
            MFWHierarchy hier = (MFWHierarchy)obj;
            MemberRecord memberRecord = hier.queryMemberRecord(this.getUniqueName());
            modelLevel = memberRecord == null ? hier.getLevel(0) : hier.getLevel(memberRecord.getLevelNumber());
        } else if (obj instanceof MFWDimension) {
            MFWDimension dim = (MFWDimension)obj;
            MFWHierarchy hier = (MFWHierarchy)dim.getDefaultHierarchy();
            MemberRecord memberRecord = hier.queryMemberRecord(this.getUniqueName());
            modelLevel = memberRecord == null ? hier.getLevel(0) : hier.getLevel(memberRecord.getLevelNumber());
        } else if (obj instanceof IMember) {
            int levelCount = 0;
            while (obj != null && !(obj instanceof MFWDimension)) {
                ++levelCount;
                obj = (MFWMetadata)this.getConnection().getParentObject(obj);
            }
            MFWDimension dim = (MFWDimension)obj;
            MFWHierarchy hier = (MFWHierarchy)dim.getDefaultHierarchy();
            modelLevel = hier.getLevel(levelCount);
        }
        return modelLevel;
    }

    private IHierarchy queryHierarchy() {
        IHierarchy modelHierarchy = null;
        MFWMetadata obj = (MFWMetadata)this.getConnection().getParentObject(this);
        while (obj instanceof MFWFolder) {
            obj = (MFWMetadata)this.getConnection().getParentObject(obj);
        }
        if (obj instanceof MFWHierarchy) {
            modelHierarchy = (MFWHierarchy)obj;
        } else if (obj instanceof MFWDimension) {
            MFWDimension dim = (MFWDimension)obj;
            modelHierarchy = dim.getDefaultHierarchy();
        } else if (obj instanceof IMember) {
            while (obj != null && !(obj instanceof MFWDimension)) {
                obj = (MFWMetadata)this.getConnection().getParentObject(obj);
            }
            MFWDimension dim = (MFWDimension)obj;
            modelHierarchy = dim.getDefaultHierarchy();
        }
        return modelHierarchy;
    }

    public int getLevelNumber() {
        return this.getLevel().getIndex();
    }

    @Override
    public int getParentLevelNumber() {
        int levelNumber = -1;
        if (this.getParent() != null) {
            levelNumber = this.getParent().getLevel().getIndex();
        }
        return levelNumber;
    }

    void addChild(MFWMember member) {
        this.throwNotImplemented();
    }

    public List<IMember> getChildren(int startIndex, int count) {
        return this.getChildren().subList(startIndex, startIndex + count);
    }

    @Override
    public int getChildrenCardinality() {
        return this.childrenCardinality;
    }

    @Override
    public boolean isMeasure() {
        return this.getLevel().getHierarchy().getDimension().isMeasuresDimension();
    }

    @Override
    public IDataType getDataType() {
        return MemberType.MEMBERTYPE;
    }

    @Override
    public Object copy() {
        return this;
    }

    @Override
    public boolean isContextMember() {
        return false;
    }

    @Override
    public int getChildIndex(IMember child) {
        return -1;
    }

    @Override
    public IMember[] getChildMembers() {
        List<IMember> childList = this.getChildren();
        IMember[] members = new IMember[childList.size()];
        childList.toArray(members);
        return members;
    }

    @Override
    public IMember getChildMember(String memberName) {
        return null;
    }

    @Override
    public IHierarchy getHierarchy() {
        if (this.hierarchy == null) {
            this.hierarchy = this.queryHierarchy();
        }
        return this.hierarchy;
    }

    @Override
    public IDimension getDimension() {
        IHierarchy theHierarchy = this.getHierarchy();
        if (theHierarchy != null) {
            return theHierarchy.getDimension();
        }
        return null;
    }

    @Override
    public IMember[] getSiblings(boolean includeSelf) {
        return null;
    }

    @Override
    public void toXML(XMLWriter xmlWriter) {
        xmlWriter.beginElement("Member", -1);
        xmlWriter.attribute("Hierarchy", this.level.getHierarchy().getUniqueName());
        xmlWriter.beginElement("UName", -1);
        xmlWriter.data(this.getUniqueName());
        xmlWriter.endElement();
        xmlWriter.beginElement("Caption", -1);
        xmlWriter.data(this.getCaption());
        xmlWriter.endElement();
        xmlWriter.beginElement("LName", -1);
        xmlWriter.data(this.level.getUniqueName());
        xmlWriter.endElement();
        xmlWriter.beginElement("LNum", -1);
        xmlWriter.data(String.valueOf(this.level.getIndex()));
        xmlWriter.endElement();
        xmlWriter.endElement();
    }

    @Override
    public AggregateTypeEnum getRegularAggregate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public AggregateTypeEnum getSemiAggregate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IAggregateRule[] getAggregateRules() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public Object getBusinessKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Value getBusinessKeyValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Value getCaptionValue() {
        StringValue v = DataValueFactory.createStringValue();
        ((Value)v).set(this.getCaption());
        return v;
    }

    @Override
    public String getV5MUN() {
        if (this.v5MUN == null) {
            this.v5MUN = UniqueNameGenerator.createMemberV5UniqueName(this.getLevel(), this.getUniqueName());
        }
        return this.v5MUN;
    }

    @Override
    public int sizeOf() {
        return ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.DEFAULT);
    }

    @Override
    public String toString() {
        return this.getCaption();
    }

    @Override
    public int getNumberOfParents() {
        return this.numberOfParents;
    }

    @Override
    public MemberTypeEnum getType() {
        return this.type;
    }

    @Override
    public RollupTypeEnum getRollupType() {
        return this.rollupType;
    }

    @Override
    public boolean isSuppressed() {
        return this.suppressed;
    }

    @Override
    public BeanPropertySupport getBeanPropertySupport() {
        return BEAN_PROPERTY_SUPPORT;
    }

    @Override
    public String getV5UniqueName() {
        if (this.v5UniqueName == null) {
            this.v5UniqueName = UniqueNameGenerator.createMemberV5UniqueName(this.getLevel(), this.getUniqueName());
        }
        return this.v5UniqueName;
    }

    @Override
    public int fastHash() {
        return this.hashCode();
    }

    @Override
    public Object hashKey() {
        return new MetadataKey(new Object[]{this.getObjectType(), this.getUniqueName()});
    }

    @Override
    public Object hashKey(Collator collator) {
        return this.hashKey();
    }

    @Override
    public void release() {
    }

    @Override
    public boolean isRelational() {
        return false;
    }

    @Override
    public String getUniqueName() {
        if (this.uniqueName == null) {
            String memberUniqueName = null;
            for (MFWMultiRequestHandle handle : this.getHandles()) {
                String handleName = handle.getName();
                if (!"rootMUN".equals(handleName) && !"rootMember".equals(handleName) && !"defaultMemberExternalName".equals(handleName)) continue;
                memberUniqueName = UniqueNameGenerator.createMemberExternalName(this.getHierarchy(), this.queryValue(handle));
                break;
            }
            this.uniqueName = memberUniqueName;
        }
        return this.uniqueName;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            String memberName = null;
            for (MFWMultiRequestHandle handle : this.getHandles()) {
                if (!"rootCaption".equals(handle.getName())) continue;
                String locale = this.getConnection().queryValue(handle, MFWModelRes.getInstance().RID_locale, new short[0]);
                if (!this.getConnection().getExpressionLocaleString().equals(locale)) continue;
                memberName = this.getConnection().queryValue(handle, MFWModelRes.getInstance().RID__Value, new short[0]);
                break;
            }
            this.name = memberName;
        }
        return this.name;
    }

    public LocalizedString getLocalizedCaption() {
        String defaultLocale = this.getConnection().getDefaultLocaleString();
        LocalizedString captions = new LocalizedString(defaultLocale, this.queryName(defaultLocale));
        for (MFWMultiRequestHandle handle : this.getHandles()) {
            if (!"rootCaption".equals(handle.getName())) continue;
            String locale = this.getConnection().queryValue(handle, MFWModelRes.getInstance().RID_locale, new short[0]);
            String localizedName = this.getConnection().queryValue(handle, MFWModelRes.getInstance().RID__Value, new short[0]);
            captions.put(locale, localizedName);
        }
        return captions;
    }

    @Override
    public String getCaption() {
        if (this.caption == null) {
            String memberCaption = null;
            for (MFWMultiRequestHandle handle : this.getHandles()) {
                if (!"rootCaption".equals(handle.getName())) continue;
                String locale = this.getConnection().queryValue(handle, MFWModelRes.getInstance().RID_locale, new short[0]);
                if (!this.getConnection().getContentLocaleString().equals(locale)) continue;
                memberCaption = this.getConnection().queryValue(handle, MFWModelRes.getInstance().RID__Value, new short[0]);
                break;
            }
            this.caption = memberCaption;
        }
        return this.caption;
    }

    @Override
    public boolean isDataBaseCalculation() {
        return false;
    }

    @Override
    public String getID() {
        if (this.id == null) {
            this.id = this.buildID();
        }
        return this.id;
    }
}

