/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemfw4j;

import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.indications.LogIPFControl;
import com.cognos.mfw4j.framework.MFWGateway;
import com.cognos.mfw4j.framework.MFWGatewayReuseIndicator;
import com.cognos.mfw4j.framework.MFWMetadataSource;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNodeHandle;
import com.cognos.mfw4j.framework.MFWQuerySpec;
import com.cognos.mfw4j.framework.MFWRequestContext;
import com.cognos.mfw4j.utilities.IMFWCMRequestExecutor;
import com.cognos.mfw4j.utilities.IMFWUsageIndicator;
import com.cognos.mfw4j.utilities.MFWContentHelper;
import com.cognos.mfw4j.utilities.MFWException;
import com.cognos.mfw4j.utilities.MFWModelNotFoundException;
import com.cognos.mfw4j.utilities.MFWSimpleCMRequestExecutor;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.bibushandler.IRequestEnvironment;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.content.ContentManager;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.model.DataSourceException;
import com.cognos.xqe.data.model.ModelNotFoundException;
import com.cognos.xqe.exception.IMessageKey;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IAccessedViaShortcut;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IFolder;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.IMultiRequestHandle;
import com.cognos.xqe.metadata.INamespace;
import com.cognos.xqe.metadata.IPhysicalTable;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.IRelationship;
import com.cognos.xqe.metadata.IScopeRelationship;
import com.cognos.xqe.metadata.IShortcut;
import com.cognos.xqe.metadata.MetadataBindingException;
import com.cognos.xqe.metadata.MetadataConstants;
import com.cognos.xqe.metadata.dynamic.DMRelationship;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.UnresolvedParameterException;
import com.cognos.xqe.trace.CollectXQELogs;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.transformation.v5tocogsql.util.aggregateAwareness.AggregateAwareness;
import com.cognos.xqe.transformation.v5tocogsql.util.aggregateAwareness.IAggregateAwareness;
import com.cognos.xqe.transformation.v5tocogsql.util.joinRefinement.RQPJoinPathFinder;
import com.cognos.xqe.transformation.v5tocogsql.util.metadataContext.IMetadataContextManager;
import com.cognos.xqe.transformation.v5tocogsql.util.metadataContext.MetadataContextManager;
import com.cognos.xqe.transformation.v5tocogsql.util.undirectedgraph.IUndirectedGraph;
import com.cognos.xqe.transformation.v5tocogsql.util.undirectedgraph.UndirectedGraph;
import com.cognos.xqe.util.ArrayWrapper;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqe.util.Governors;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.Timer;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.usage.UsageTrackingService;
import com.cognos.xqe.util.xml.XMLUtils;
import com.cognos.xqemfw4j.IModelDataSecurityObject;
import com.cognos.xqemfw4j.MFWCube;
import com.cognos.xqemfw4j.MFWMetadata;
import com.cognos.xqemfw4j.MFWMetadataFactory;
import com.cognos.xqemfw4j.MFWMultiRequestGateway;
import com.cognos.xqemfw4j.MFWMultiRequestHandle;
import com.cognos.xqemfw4j.MFWQueryItemOfQuerySubject;
import com.cognos.xqemfw4j.MFWUsageIndicator;
import com.cognos.xqemfw4j.ParameterMapsModel;
import com.cognos.xqemfw4j.ParameterMapsQI;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.dom4j.Element;

public class MFWMetadataConnection
implements MetadataConnection {
    private static final String DOUBLE_QUOTE_END_BRACKET = "\"]";
    private static final String QUOTE_END_BRACKET = "']";
    private static final String MODEL_LAST = "/model[last()]";
    private static final String SLASH_MODEL = "/model";
    public static final String SLASH_REPORT = "/report";
    static final String GATEWAY_ID = "XQEMetadataGateway";
    protected static final String QUERY_PROJECT = "/project";
    private static final String VALUE_STRING_CONSTANT = "value";
    private static final String NAME_STRING_CONSTANT = "name";
    private static final String TXT = ".txt";
    protected static final String LOG_EVENT_GROUP = "MetadataConnection.MFW4J";
    protected static final String LOGMSG_CONNECTED = "Established connection ";
    protected static final String LOGMSG_CONNECTION_FAILED = "Connection failed ";
    protected static final String LOGMSG_RELEASING = "Releasing connection ";
    protected static final String LOGMSG_CAUSED_BY = "; Caused by: ";
    private static final String MSG_FAILED_TO_CONFIGURE_IPF = "Failed to configure IPF";
    private static final String MSG_MALFORMED_CONNECTION_STRING = "Malformed connection string: ";
    private static final String SEMI_COLON = ";";
    private static final String PLUS = "+";
    private static final String EQUAL = "=";
    private static final String OPEN_QUERY_STRING_XPATH = "//*[";
    private static final String OPEN_SQURE_BRACKET = "[";
    private static final String CLOSE_SQURE_BRACKET = "]";
    private static final String CONTENT_PACKAGE_NAME = "/content/package[@name=";
    private static final String MODEL_NAME_MODEL = "]/model[last()]";
    public static final String DATASOURCE_PROPERTIES = "/project/dataSource/*";
    private static final String INDENT = "  ";
    private static final String PATH_SEPARATOR = "/";
    private static XQELogger logger = null;
    private String modelName = null;
    private String packageName = null;
    private String modelPath = null;
    protected String expressionLocaleString = null;
    protected Locale expressionLocale = null;
    protected String contentLocaleString = null;
    protected Locale contentLocale = null;
    protected String productLocaleString = null;
    protected Locale productLocale = null;
    private String defaultLocaleString = null;
    private Locale defaultLocale = null;
    protected MFWMetadataSource metadataSource = null;
    protected MFWMultiRequestGateway gateway = null;
    private MFWGatewayReuseIndicator reuseIndicator = null;
    private final AtomicBoolean connected = new AtomicBoolean(false);
    private static volatile boolean initializationComplete = false;
    private List<IModelDataSource> datasources;
    private ICube[] cubes;
    private Boolean useDesignLocaleForReferenceID;
    private ConcurrentHashMap<ArrayWrapper<MFWMultiRequestHandle>, IMetadata> metadataHandleToObject = new ConcurrentHashMap();
    private ConcurrentHashMap<String, IMetadata> metadataIDToObject = new ConcurrentHashMap();
    private Map<String, String> dataSourceProperties = null;
    private ParameterMapsModel modelParameterMaps = null;
    private ParameterMapsQI modelQIParameterMaps = null;
    private static final Pattern MODEL_PATH_PATTERN = Pattern.compile(".*/?package\\[@name=['\"](.*?)['\"]\\]");
    protected MFWMultiRequestHandle projectHandle = null;
    private List<IShortcut> shortcuts = null;
    private List<IMetadata> entities = null;
    private List<IMetadata> relationships = null;
    private List<IMetadata> relationshipShortcuts = null;
    private List<IMetadata> dummyRelationships = null;
    private List<IMetadata> joins = null;
    private Map<IMetadata, List<IShortcut>> querySubjectOrDimensionToShortcut = null;
    private List<String> functionSetIDList = null;
    String dataCacheExpiry = null;
    private List<String> modelDataSecurityObjects = null;
    private INamespace rootNamespace = null;
    private ConcurrentHashMap<MFWMultiRequestHandle, IShortcut> scMap = new ConcurrentHashMap();
    private HashMap<String, IMetadata> mIdToJoin = null;
    private List<IMetadata> modelScopeRelationships;
    private final IAggregateAwareness aggrAwareNess = new AggregateAwareness();
    private final IMetadataContextManager metadataContextManager = new MetadataContextManager();
    private String mJoinGraph;

    static void throwNotImplemented() throws XQERuntimeException {
        throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "not implemented");
    }

    void throwInvalidObject(String message) throws XQERuntimeException {
        throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "An attempt to construct invalid metadata object \"" + message + " " + "\"");
    }

    void throwInternalError(String message) throws XQERuntimeException {
        throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "internal error \"" + message + " " + "\"");
    }

    public static synchronized void initializeRequiredComponents() {
        if (!initializationComplete) {
            ICCLConfiguration configuration = CCLConfigurationFactory.getInstance();
            if (!LogIPFControl.initialize()) {
                XQEDebugLog.out.println("Failed to initialize IPF");
            }
            if (!LogIPFControl.configure((ICCLConfiguration)configuration)) {
                XQEDebugLog.out.println(MSG_FAILED_TO_CONFIGURE_IPF);
            }
            initializationComplete = true;
        }
    }

    @Override
    public String getModelName() {
        return this.modelName;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public String getModelPath() {
        return this.modelPath;
    }

    public String getExpressionLocaleString() {
        return this.expressionLocaleString;
    }

    @Override
    public Locale getExpressionLocale() {
        if (this.expressionLocale == null) {
            this.expressionLocale = LocaleConverter.strToLocale(this.getExpressionLocaleString());
        }
        return this.expressionLocale;
    }

    public String getContentLocaleString() {
        return this.contentLocaleString;
    }

    @Override
    public Locale getContentLocale() {
        if (this.contentLocale == null) {
            this.contentLocale = LocaleConverter.strToLocale(this.getContentLocaleString());
        }
        return this.contentLocale;
    }

    public String getProductLocaleString() {
        return this.productLocaleString;
    }

    @Override
    public Locale getProductLocale() {
        if (this.productLocale == null) {
            this.productLocale = LocaleConverter.strToLocale(this.getProductLocaleString());
        }
        return this.productLocale;
    }

    @Override
    public String getDefaultLocaleString() {
        if (this.defaultLocaleString == null) {
            this.defaultLocaleString = this.queryValue(this.getProjectHandle(), MFWModelRes.getInstance().RID_defaultLocale, new short[0]);
        }
        return this.defaultLocaleString;
    }

    @Override
    public Locale getDefaultLocale(IMetadata obj) {
        if (this.defaultLocale == null) {
            this.defaultLocale = LocaleConverter.strToLocale(this.getDefaultLocaleString());
        }
        return this.defaultLocale;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(MFWMetadataConnection.class.getName());
        if (null == this.metadataSource) {
            buf.append(" (no metadataSource)");
        } else {
            buf.append(" metadataSource=");
            MFWMetadataConnection.appendConnectionInfo(buf, this.metadataSource);
        }
        return buf.toString();
    }

    @Override
    public void connect(String connectionString, String theExpressionLocale, IExecutionEnvironment execEnv, MFWRequestContext requestContext) {
        if (!this.connected.compareAndSet(false, true)) {
            throw new XQERuntimeException(XQEMessageKeys.MD_MetadataConnectionAlreadyOpen, this.getModelPath());
        }
        XQELogger traceLogger = MFWMetadataConnection.getLogger();
        String theContentLocale = requestContext.getContentLocale();
        String theProductLocale = requestContext.getProductLocale();
        requestContext.setXQEUsageIndicatorService((IMFWUsageIndicator)new MFWUsageIndicator());
        this.modelName = connectionString;
        this.modelPath = connectionString;
        boolean useModelxmlFile = false;
        boolean useRolapModel = false;
        boolean useDimensionalSource = false;
        boolean useReportPath = false;
        if (this.modelPath.endsWith("model.xml")) {
            useModelxmlFile = true;
            if (this.modelPath.startsWith("datasets")) {
                String path = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE).getDataDirectory();
                this.modelPath = path + File.separator + this.modelPath;
            }
        } else if (this.modelPath.contains("rolapDataSource") || this.modelPath.contains("rolapVirtualDataSource")) {
            useRolapModel = true;
        } else if (this.modelPath.startsWith("dimensionalSource")) {
            useDimensionalSource = true;
        } else if (this.modelPath.indexOf(SLASH_REPORT) != -1) {
            useReportPath = true;
        } else {
            this.modelPath = this.verifyModelPath(connectionString);
            Matcher m = MODEL_PATH_PATTERN.matcher(connectionString);
            this.packageName = m.find() ? m.group(1) : connectionString;
        }
        try {
            MFWGateway gatewayImpl;
            MFWMetadataConnection.initializeRequiredComponents();
            this.createMetadataSource(execEnv, useModelxmlFile, useRolapModel, useDimensionalSource, useReportPath);
            try {
                gatewayImpl = MFWGateway.open((String)GATEWAY_ID, (MFWRequestContext)requestContext, (MFWMetadataSource)this.metadataSource);
            }
            catch (MFWException mfwe) {
                this.modelPath = MFWMetadataConnection.verifyModelPathForceLast(connectionString);
                this.createMetadataSource(execEnv, useModelxmlFile, useRolapModel, useDimensionalSource, useReportPath);
                gatewayImpl = MFWGateway.open((String)GATEWAY_ID, (MFWRequestContext)requestContext, (MFWMetadataSource)this.metadataSource);
            }
            MFWMultiRequestGateway.Parameters params = MFWMultiRequestGateway.Parameters.fromRequestContext(requestContext);
            this.gateway = new MFWMultiRequestGateway((ExecutionEnvironment)execEnv, GATEWAY_ID, this.metadataSource, params, gatewayImpl);
            this.reuseIndicator = this.gateway.getReuseIndicator();
            this.projectHandle = this.queryHandle(QUERY_PROJECT);
            this.projectHandle.persist();
            this.expressionLocaleString = this.getUseDesignLocaleForReferenceID() || execEnv.getRequestEnvironment().getUseDesignLocaleForExpressions() ? this.getDefaultLocaleString() : LocaleConverter.localeToStr(LocaleConverter.resolveLocale(theExpressionLocale, this.queryLocales()));
            this.contentLocaleString = LocaleConverter.localeToStr(LocaleConverter.resolveLocale(theContentLocale, this.queryLocales()));
            this.productLocaleString = theProductLocale;
        }
        catch (UnresolvedParameterException ex) {
            throw ex;
        }
        catch (MFWModelNotFoundException ex) {
            throw new ModelNotFoundException(ex, connectionString);
        }
        catch (MFWException ex) {
            if (traceLogger.isOn(LogLevel.ERROR)) {
                StringBuilder logBuf = new StringBuilder();
                logBuf.append(LOGMSG_CONNECTION_FAILED);
                MFWMetadataConnection.appendConnectionInfo(logBuf, this.metadataSource);
                logBuf.append(LOGMSG_CAUSED_BY);
                traceLogger.log(LogLevel.ERROR, logBuf.toString(), (Throwable)ex);
            }
            throw ex;
        }
        catch (Exception ex) {
            if (traceLogger.isOn(LogLevel.ERROR)) {
                StringBuilder logBuf = new StringBuilder();
                logBuf.append(LOGMSG_CONNECTION_FAILED);
                MFWMetadataConnection.appendConnectionInfo(logBuf, this.metadataSource);
                logBuf.append(LOGMSG_CAUSED_BY);
                traceLogger.log(LogLevel.ERROR, logBuf.toString(), (Throwable)ex);
            }
            throw new XQERuntimeException(XQEMessageKeys.MD_MetadataConnectionFailed, (Throwable)ex, this.getModelPath());
        }
        if (traceLogger.isOn()) {
            StringBuilder logBuf = new StringBuilder();
            logBuf.append(LOGMSG_CONNECTED);
            MFWMetadataConnection.appendConnectionInfo(logBuf, this.metadataSource);
            traceLogger.log(logBuf.toString());
        }
        MultiRequestContext multiRequestContext = execEnv.getMultiRequestContext();
        XQEConfiguration configuration = multiRequestContext.getXQEConfiguration();
        if (multiRequestContext.fetchBooleanConfiguration("metadataService.dumpModel", false)) {
            this.toFile(configuration.getXqeLogsDirectory() + "/model/" + this.getPackageName() + TXT);
        }
        this.dumpFMModel((RequestEnvironment)execEnv.getRequestEnvironment());
    }

    private void createMetadataSource(IExecutionEnvironment execEnv, boolean useModelxmlFile, boolean useRolapModel, boolean useDimensionalSource, boolean useReportPath) {
        if (useModelxmlFile) {
            this.metadataSource = MFWMetadataSource.create((String)"modelFM");
            this.metadataSource.addConnectionItem("modelFilePath", (Object)this.modelPath);
        } else if (useRolapModel) {
            this.metadataSource = MFWMetadataSource.create((String)"modelFM");
            this.metadataSource.addConnectionItem("cmSearchPath", (Object)this.modelPath);
        } else if (useDimensionalSource) {
            this.metadataSource = this.createMetadataSourceFromDimensionalSource(this.modelPath);
        } else if (useReportPath) {
            this.metadataSource = MFWMetadataSource.create((String)"reportCRN");
            this.metadataSource.addConnectionItem("cmSearchPath", (Object)this.modelPath);
        } else {
            this.metadataSource = this.createMetadataSourceFromConnectionElement(execEnv.getConnectionElement());
        }
    }

    List<String> queryLocales() {
        List<String> locales = this.queryValues(this.getProjectHandle(), MFWModelRes.getInstance().RID_locale, new short[0]);
        for (String locale : locales) {
            if (!locale.equals(this.getDefaultLocaleString())) continue;
            locales.remove(locale);
            locales.add(0, locale);
            break;
        }
        return locales;
    }

    private MFWMetadataSource createMetadataSourceFromDimensionalSource(String connectionStr) {
        String[] args;
        int openBracketPos = connectionStr.indexOf(91);
        if (openBracketPos < 0) {
            throw new IllegalArgumentException(MSG_MALFORMED_CONNECTION_STRING + connectionStr);
        }
        int closeBracketPos = connectionStr.lastIndexOf(93);
        if (closeBracketPos < 0 || closeBracketPos < openBracketPos) {
            throw new IllegalArgumentException(MSG_MALFORMED_CONNECTION_STRING + connectionStr);
        }
        String sourceType = null;
        String cmDataSource = null;
        String catalog = null;
        String cube = null;
        for (String arg : args = connectionStr.substring(openBracketPos + 1, closeBracketPos).split(SEMI_COLON)) {
            String trimmedArg = arg.trim();
            int equalPos = trimmedArg.indexOf(EQUAL);
            if (equalPos < 0) {
                throw new IllegalArgumentException(MSG_MALFORMED_CONNECTION_STRING + connectionStr);
            }
            String argName = trimmedArg.substring(0, equalPos);
            String argValue = trimmedArg.substring(equalPos + 1);
            if ("sourceType".equals(argName)) {
                sourceType = argValue;
                continue;
            }
            if ("cmDataSource".equals(argName)) {
                cmDataSource = argValue;
                continue;
            }
            if ("catalog".equals(argName)) {
                catalog = argValue;
                continue;
            }
            if (!"cube".equals(argName)) continue;
            cube = argValue;
        }
        if (null == sourceType) {
            throw new IllegalArgumentException("Argument 'sourceType' is missing from the connection string.");
        }
        if (null == cmDataSource) {
            throw new IllegalArgumentException("Argument 'cmDataSource' is missing from the connection string.");
        }
        if (null == catalog) {
            throw new IllegalArgumentException("Argument 'catalog' is missing from the connection string.");
        }
        if (null == cube) {
            throw new IllegalArgumentException("Argument 'cube' is missing from the connection string.");
        }
        MFWMetadataSource aMetadataSrc = MFWMetadataSource.create(sourceType);
        aMetadataSrc.addConnectionItem("cmDataSource", cmDataSource);
        aMetadataSrc.addScope("catalog", catalog);
        aMetadataSrc.addScope("cube", cube);
        return aMetadataSrc;
    }

    private MFWMetadataSource createMetadataSourceFromConnectionElement(Element connectionElm) {
        if (connectionElm == null) {
            return this.getDefaultMetadataSource();
        }
        Element subConnectionElm = connectionElm.element("connection");
        if (subConnectionElm == null) {
            return this.getDefaultMetadataSource();
        }
        Element connectionPropertiesElm = subConnectionElm.element("connectionProperties");
        if (connectionPropertiesElm == null) {
            return this.getDefaultMetadataSource();
        }
        Element modelTypeElm = connectionPropertiesElm.element("modelType");
        if (modelTypeElm == null) {
            return this.getDefaultMetadataSource();
        }
        String modelType = modelTypeElm.attributeValue(VALUE_STRING_CONSTANT);
        if (modelType == null) {
            return this.getDefaultMetadataSource();
        }
        MFWMetadataSource aMetadataSrc = MFWMetadataSource.create((String)modelType);
        if ("modelFM".equals(modelType)) {
            aMetadataSrc.addConnectionItem("cmSearchPath", (Object)this.modelPath);
        }
        List<Element> propertyItems = CollectionCast.uncheckedCast(connectionPropertiesElm.elements("property"));
        for (Element item : propertyItems) {
            String itemName = item.attributeValue(NAME_STRING_CONSTANT);
            String itemValue = item.attributeValue(VALUE_STRING_CONSTANT);
            aMetadataSrc.addConnectionItem(itemName, (Object)itemValue);
        }
        return aMetadataSrc;
    }

    protected MFWMetadataSource getDefaultMetadataSource() {
        MFWMetadataSource source = MFWMetadataSource.create((String)"modelFM");
        source.addConnectionItem("cmSearchPath", (Object)this.modelPath);
        return source;
    }

    Map<String, String> queryMetadataProperties(String queryString) {
        MFWQuerySpec querySpec = MFWQuerySpec.create((String)queryString);
        MFWMultiRequestHandle[] resultantHandles = this.getGateway().query(querySpec);
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        for (int j = 0; j < resultantHandles.length; ++j) {
            MFWMultiRequestHandle handle = resultantHandles[j];
            if (!handle.isProperty()) continue;
            String name = handle.getName().intern();
            String value = this.getGateway().getPropertyValue(handle);
            propertiesMap.put(name, value);
        }
        return propertiesMap;
    }

    @Override
    public List<IMetadata> queryMetadata(String queryString) {
        List<IMetadata> metadataList = null;
        MFWQuerySpec querySpec = MFWQuerySpec.create((String)queryString);
        MFWMultiRequestHandle[] resultantHandles = this.getGateway().query(querySpec);
        metadataList = this.mfwObjectsToMetadataObjects(resultantHandles);
        return metadataList;
    }

    List<IMetadata> queryMetadata(MFWMultiRequestHandle handle, String queryString) {
        List<IMetadata> metadataList = null;
        try {
            MFWMultiRequestHandle[] handles = this.queryHandles(handle, queryString);
            metadataList = this.mfwObjectsToMetadataObjects(handles);
        }
        catch (Exception e) {
            MFWMetadataConnection.handleUnexpectedFailure(e);
            throw new XQERuntimeException(XQEMessageKeys.MD_MetadataConnectionFailed, (Throwable)e, this.getModelPath());
        }
        return metadataList;
    }

    private static void handleUnexpectedFailure(Throwable throwable) {
        MFWMetadataConnection.getLogger().log(LogLevel.ERROR, "Unexpected MetadataResponseParser failure: ", throwable);
    }

    List<IMetadata> queryMetadata(MFWMultiRequestHandle[] handles, short ridChild, short ... ridDescendants) {
        ArrayList<IMetadata> metadataList = null;
        try {
            MFWMultiRequestHandle[] queryHandles = this.queryHandles(handles[handles.length - 1], ridChild, ridDescendants);
            ArrayList<MFWMultiRequestHandle> handleList = null;
            if (handles.length > 0) {
                handleList = new ArrayList<MFWMultiRequestHandle>(handles.length + 1);
                for (int i = 0; i < handles.length; ++i) {
                    handleList.add(handles[i]);
                }
                handleList.add(null);
            }
            metadataList = new ArrayList<IMetadata>();
            for (MFWMultiRequestHandle queryHandle : queryHandles) {
                handleList.set(handleList.size() - 1, queryHandle);
                IMetadata obj = this.mfwObjectToMetadataObject(handleList.toArray(new MFWMultiRequestHandle[handleList.size()]));
                if (obj == null) continue;
                metadataList.add(obj);
            }
        }
        catch (XQERuntimeException e) {
            MFWMetadataConnection.handleUnexpectedFailure(e);
            if (XQEMessages.isInternalException(e)) {
                throw new XQERuntimeException(XQEMessageKeys.MD_MetadataConnectionFailed, (Throwable)e, this.getModelPath());
            }
            throw e;
        }
        catch (Exception e) {
            MFWMetadataConnection.handleUnexpectedFailure(e);
            throw new XQERuntimeException(XQEMessageKeys.MD_MetadataConnectionFailed, (Throwable)e, this.getModelPath());
        }
        return metadataList;
    }

    List<IMetadata> queryMetadata(MFWMultiRequestHandle handle, short ridChild, short ... ridDescendants) {
        return this.queryMetadata(new MFWMultiRequestHandle[]{handle}, ridChild, ridDescendants);
    }

    public List<IMetadata> queryMetadata(short ridChild, short ... ridDescendants) {
        return this.queryMetadata(this.getProjectHandle(), ridChild, ridDescendants);
    }

    MFWMultiRequestHandle[] queryHandles(MFWMultiRequestHandle handle, short ridChild, short ... ridDescendants) {
        if (handle == null) {
            return null;
        }
        if (ridDescendants.length == 0) {
            return this.getGateway().getObjectChildren(handle, ridChild);
        }
        LinkedList<MFWMultiRequestHandle> queryHandleList = new LinkedList<MFWMultiRequestHandle>();
        for (MFWMultiRequestHandle childHandle : this.queryHandles(handle, ridChild, new short[0])) {
            short[] shrinkedDescendants = new short[ridDescendants.length - 1];
            System.arraycopy(ridDescendants, 1, shrinkedDescendants, 0, shrinkedDescendants.length);
            MFWMultiRequestHandle[] descendants = this.queryHandles(childHandle, ridDescendants[0], shrinkedDescendants);
            if (descendants == null) continue;
            queryHandleList.addAll(Arrays.asList(descendants));
        }
        return queryHandleList.toArray(new MFWMultiRequestHandle[0]);
    }

    MFWMultiRequestHandle[] queryHandles(MFWMultiRequestHandle handle, String query) {
        MFWMultiRequestHandle[] queryHandles = null;
        if (handle != null) {
            queryHandles = this.getGateway().queryObject(handle, MFWQuerySpec.create((String)query));
        }
        return queryHandles;
    }

    List<String> queryValues(MFWMultiRequestHandle handle, String query) {
        ArrayList<String> queryValues = null;
        MFWMultiRequestHandle[] queryHandles = this.queryHandles(handle, query);
        if (queryHandles != null) {
            queryValues = new ArrayList<String>(queryHandles.length);
            for (MFWMultiRequestHandle queryHandle : queryHandles) {
                queryValues.add(this.queryValue(queryHandle));
            }
        }
        return queryValues;
    }

    MFWMultiRequestHandle[] queryHandles(String query) {
        MFWMultiRequestHandle[] queryHandles = this.getGateway().query(MFWQuerySpec.create((String)query));
        return queryHandles;
    }

    List<String> queryValues(String query) {
        ArrayList<String> queryValues = null;
        MFWMultiRequestHandle[] queryHandles = this.queryHandles(query);
        if (queryHandles != null) {
            queryValues = new ArrayList<String>(queryHandles.length);
            for (MFWMultiRequestHandle queryHandle : queryHandles) {
                queryValues.add(this.queryValue(queryHandle));
            }
        }
        return queryValues;
    }

    MFWMultiRequestHandle queryHandle(String query) {
        MFWMultiRequestHandle queryHandle = null;
        MFWMultiRequestHandle[] queryHandles = this.queryHandles(query);
        if (queryHandles != null && queryHandles.length > 0) {
            queryHandle = queryHandles[0];
        }
        return queryHandle;
    }

    MFWMultiRequestHandle queryHandle(MFWMultiRequestHandle handle, String query) {
        MFWMultiRequestHandle queryHandle = null;
        MFWMultiRequestHandle[] queryHandles = this.queryHandles(handle, query);
        if (queryHandles != null && queryHandles.length > 0) {
            queryHandle = queryHandles[0];
        }
        return queryHandle;
    }

    MFWMultiRequestHandle queryHandle(MFWMultiRequestHandle handle, short ridChild, short ... ridDescendants) {
        MFWMultiRequestHandle queryHandle = null;
        MFWMultiRequestHandle[] queryHandles = this.queryHandles(handle, ridChild, new short[0]);
        if (queryHandles != null && queryHandles.length > 0) {
            queryHandle = queryHandles[0];
        }
        for (short rid : ridDescendants) {
            queryHandle = this.queryHandle(queryHandle, rid, new short[0]);
        }
        return queryHandle;
    }

    List<String> queryValues(MFWMultiRequestHandle handle, short ridChild, short ... ridDescendants) {
        ArrayList<String> queryValues = null;
        MFWMultiRequestHandle[] queryHandles = this.queryHandles(handle, ridChild, ridDescendants);
        if (queryHandles != null) {
            queryValues = new ArrayList<String>(queryHandles.length);
            for (MFWMultiRequestHandle queryHandle : queryHandles) {
                queryValues.add(this.queryValue(queryHandle));
            }
        }
        return queryValues;
    }

    String queryValue(String query) {
        String queryValue = null;
        MFWMultiRequestHandle handle = this.queryHandle(query);
        if (handle != null) {
            queryValue = this.getGateway().getPropertyValue(handle);
        }
        return queryValue;
    }

    String queryValue(MFWMultiRequestHandle handle, String query) {
        String queryValue = null;
        MFWMultiRequestHandle h = this.queryHandle(handle, query);
        if (h != null) {
            queryValue = this.queryValue(h);
        }
        return queryValue;
    }

    String queryValue(MFWMultiRequestHandle handle, short ridChild, short ... ridDescendants) {
        return this.queryValue(this.queryHandle(handle, ridChild, ridDescendants));
    }

    String queryValue(MFWMultiRequestHandle handle) {
        String queryValue = null;
        if (handle != null && handle.isProperty()) {
            queryValue = this.getGateway().getPropertyValue(handle);
        }
        return queryValue;
    }

    @Override
    public IMetadata bindMetadataReference(String ref) {
        IMetadata metadataFromMap;
        IMetadata metadata = this.metadataIDToObject.get(ref);
        if (metadata == null && (metadataFromMap = this.metadataIDToObject.putIfAbsent(ref, metadata = this.bindMetadataReference(ref, null, null))) != null) {
            metadata = metadataFromMap;
        }
        return metadata;
    }

    @Override
    public IMetadata updateIDToMetadataReferenceMap(String ref, IMetadata metadata) {
        IMetadata metadataFromMap;
        if (metadata != null && (metadataFromMap = this.metadataIDToObject.putIfAbsent(ref, metadata)) != null) {
            metadata = metadataFromMap;
        }
        return metadata;
    }

    protected IMetadata bindMetadataProperty(String queryString) {
        IMetadata result = null;
        List<IMetadata> arrayItems = this.queryMetadata(queryString);
        if (arrayItems.size() > 0) {
            result = arrayItems.get(0);
        }
        if (result == null) {
            this.throwCannotBindException(queryString);
        }
        return result;
    }

    private static String buildPropertyXPath(String propertyName, String propertyValue) {
        StringBuilder queryBuffer = new StringBuilder();
        queryBuffer.append(OPEN_QUERY_STRING_XPATH);
        queryBuffer.append(propertyName);
        queryBuffer.append(EQUAL);
        queryBuffer.append(XMLUtils.xPathLiteral(propertyValue));
        queryBuffer.append(CLOSE_SQURE_BRACKET);
        String queryString = queryBuffer.toString();
        return queryString;
    }

    public static String buildIDXPath(String propertyValue) {
        return MFWMetadataConnection.buildPropertyXPath("ID", propertyValue);
    }

    @Override
    public String verifyModelPath(String aModelPath) {
        Matcher m = MODEL_PATH_PATTERN.matcher(this.modelPath);
        if (!m.find()) {
            aModelPath = CONTENT_PACKAGE_NAME + XMLUtils.xPathLiteral(this.modelPath) + MODEL_NAME_MODEL;
        }
        if ((aModelPath.endsWith(QUOTE_END_BRACKET) || aModelPath.endsWith(DOUBLE_QUOTE_END_BRACKET)) && aModelPath.indexOf(SLASH_MODEL) == -1) {
            aModelPath = aModelPath + MODEL_LAST;
        }
        return aModelPath;
    }

    public static String verifyModelPathForceLast(String modelPath) {
        String name;
        Matcher m = MODEL_PATH_PATTERN.matcher(modelPath);
        if (!m.find()) {
            modelPath = CONTENT_PACKAGE_NAME + XMLUtils.xPathLiteral(modelPath) + MODEL_NAME_MODEL;
        }
        if ((modelPath.endsWith(QUOTE_END_BRACKET) || modelPath.endsWith(DOUBLE_QUOTE_END_BRACKET)) && modelPath.indexOf(SLASH_MODEL) == -1) {
            modelPath = modelPath + MODEL_LAST;
        }
        if (modelPath.endsWith(name = "/model[@name='model']") && modelPath.indexOf("package[@name=") > 0) {
            modelPath = modelPath.substring(0, modelPath.lastIndexOf(name)) + MODEL_LAST;
        }
        return modelPath;
    }

    IMetadata mfwObjectToMetadataObject(MFWMultiRequestHandle handle) {
        return this.mfwObjectToMetadataObject(new MFWMultiRequestHandle[]{handle});
    }

    IMetadata mfwObjectToMetadataObject(MFWMultiRequestHandle[] handles) {
        ArrayWrapper<MFWMultiRequestHandle> key;
        IMetadata metadata = null;
        if (handles.length > 0 && (metadata = this.metadataHandleToObject.get(key = MFWMetadataConnection.getMetadataKey(handles))) == null && (metadata = this.newMFWMetadata(handles)) != null) {
            this.processMetadataForShortcut(handles, metadata);
            IMetadata metadataFromMap = this.metadataHandleToObject.putIfAbsent(key, metadata);
            if (metadataFromMap != null) {
                metadata = metadataFromMap;
            }
        }
        return metadata;
    }

    private static ArrayWrapper<MFWMultiRequestHandle> getMetadataKey(MFWMultiRequestHandle[] handles) {
        ArrayList<MFWMultiRequestHandle> handleList = new ArrayList<MFWMultiRequestHandle>();
        for (int i = 0; i < handles.length; ++i) {
            handleList.add(handles[i]);
        }
        for (MFWMultiRequestHandle handle : handleList) {
            handle.persist();
        }
        MFWMultiRequestHandle[] handleListArray = handleList.toArray(new MFWMultiRequestHandle[handleList.size()]);
        ArrayWrapper<MFWMultiRequestHandle> handleArray = new ArrayWrapper<MFWMultiRequestHandle>(handleListArray);
        return handleArray;
    }

    List<IMetadata> mfwObjectsToMetadataObjects(MFWMultiRequestHandle[][] mfwHandles) {
        ArrayList<IMetadata> metadataList = new ArrayList<IMetadata>();
        for (int i = 0; mfwHandles != null && i < mfwHandles.length; ++i) {
            IMetadata mdResult = this.mfwObjectToMetadataObject(mfwHandles[i]);
            if (mdResult == null) continue;
            metadataList.add(mdResult);
        }
        return metadataList;
    }

    List<IMetadata> mfwObjectsToMetadataObjects(MFWMultiRequestHandle[] mfwHandles) {
        ArrayList<IMetadata> metadataList = new ArrayList<IMetadata>();
        for (int i = 0; mfwHandles != null && i < mfwHandles.length; ++i) {
            IMetadata mdResult = this.mfwObjectToMetadataObject(mfwHandles[i]);
            if (mdResult == null) continue;
            metadataList.add(mdResult);
        }
        return metadataList;
    }

    public String getNamedAttribute(IMetadata object, String attribute) {
        return (String)object.getProperty(attribute);
    }

    @Override
    public IMetadata initialiseObjectProperties(IMetadata object) {
        return object;
    }

    @Override
    public IMetadata initialiseObjectChildren(IMetadata object) {
        return object;
    }

    @Override
    public IMetadata getParentObject(IMetadata object) {
        IMetadata parent = null;
        if (object instanceof MFWMetadata) {
            MFWMultiRequestHandle[] nodes = ((MFWMetadata)object).getHandles();
            MFWMultiRequestHandle node = nodes[nodes.length - 1];
            ArrayList<MFWMultiRequestHandle> nodeList = new ArrayList<MFWMultiRequestHandle>();
            for (int i = 0; i < nodes.length - 1; ++i) {
                String handleName = nodes[i].getName();
                if (handleName == "rootMUN" || handleName == "rootCaption") continue;
                nodeList.add(nodes[i]);
            }
            if (nodes.length > 1) {
                parent = this.mfwObjectToMetadataObject(nodeList.toArray(new MFWMultiRequestHandle[nodeList.size()]));
                return parent;
            }
            if (node != null) {
                ArrayList<MFWMultiRequestHandle> nodeTempList = new ArrayList<MFWMultiRequestHandle>();
                while (node.getParent().getNameRID() != MFWModelRes.getInstance().RID_project) {
                    MFWMultiRequestHandle parentNode = node.getParent();
                    nodeTempList.add(parentNode);
                    node = parentNode;
                }
                for (int i = nodeTempList.size() - 1; i >= 0; --i) {
                    nodeList.add((MFWMultiRequestHandle)nodeTempList.get(i));
                }
                parent = this.mfwObjectToMetadataObject(nodeList.toArray(new MFWMultiRequestHandle[nodeList.size()]));
            }
            if (parent == null && object instanceof IDimension) {
                parent = ((IDimension)object).getCube();
            }
        }
        return parent;
    }

    @Override
    public INamespace getRootNamespace() {
        if (this.rootNamespace == null) {
            INamespace namespace = null;
            List<IMetadata> namespaces = this.queryMetadata(MFWModelRes.getInstance().RID_namespace, new short[0]);
            if (namespaces != null && namespaces.size() > 0) {
                IMetadata obj = namespaces.get(0);
                namespace = obj instanceof MFWCube ? ((MFWCube)obj).getNamespace() : (INamespace)namespaces.get(0);
            }
            this.rootNamespace = namespace;
        }
        return this.rootNamespace;
    }

    @Override
    public List<IModelDataSource> getModelDataSources() {
        if (this.datasources == null) {
            List<IModelDataSource> dsList = CollectionCast.downcast(this.queryMetadata(MFWModelRes.getInstance().RID_dataSource, new short[0]), IMetadata.class, IModelDataSource.class);
            this.datasources = dsList;
        }
        return this.datasources;
    }

    @Override
    public List<String> getModelFunctionSetVendorIDs() {
        if (this.functionSetIDList == null) {
            ArrayList<String> funcSetIDList = new ArrayList<String>();
            MFWMultiRequestHandle[] securityViewsCollection = null;
            MFWMultiRequestHandle[] vSecutyViewCollectors = this.gateway.getObjectChildren(this.getProjectHandle(), MFWModelRes.getInstance().RID_securityViews);
            if (vSecutyViewCollectors != null && vSecutyViewCollectors.length > 0) {
                securityViewsCollection = this.gateway.getObjectChildren(vSecutyViewCollectors[0], MFWModelRes.getInstance().RID_securityView);
            }
            if (securityViewsCollection != null && securityViewsCollection.length > 0) {
                void securityView = securityViewsCollection[0];
                MFWMultiRequestHandle[] functionSetCollection = this.gateway.getObjectChildren((MFWMultiRequestHandle)securityView, MFWModelRes.getInstance().RID_functionSet);
                for (int j = 0; j < functionSetCollection.length; ++j) {
                    String thefunctionSetId = this.gateway.getObjectPropertyValue(functionSetCollection[j], MFWModelRes.getInstance().RID_functionSetID);
                    funcSetIDList.add(thefunctionSetId);
                }
            }
            this.functionSetIDList = funcSetIDList;
        }
        return this.functionSetIDList;
    }

    @Override
    public IModelDataSource getModelDataSource(String dataSourceName) {
        for (IModelDataSource ds : this.getModelDataSources()) {
            if (!ds.getName().equals(dataSourceName)) continue;
            return ds;
        }
        return null;
    }

    @Override
    @Deprecated
    public ICube getCube() {
        throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "not supported");
    }

    @Override
    public ICube getCube(String name) {
        ICube cube = null;
        for (ICube modelCube : this.getCubes()) {
            if (!modelCube.getUniqueName().equals(name)) continue;
            cube = modelCube;
            break;
        }
        return cube;
    }

    @Override
    public Map<String, String> getDataSourceProperties() {
        if (this.dataSourceProperties == null) {
            this.dataSourceProperties = this.queryMetadataProperties(DATASOURCE_PROPERTIES);
        }
        return this.dataSourceProperties;
    }

    protected boolean getUseDesignLocaleForReferenceID() {
        if (this.useDesignLocaleForReferenceID == null) {
            this.useDesignLocaleForReferenceID = "true".equals(this.queryValue(this.getProjectHandle(), MFWModelRes.getInstance().getResourceID("fixIdsToDefaultLocale"), new short[0]));
        }
        return this.useDesignLocaleForReferenceID;
    }

    @Override
    public ICube[] getCubes() {
        if (this.cubes == null) {
            this.cubes = this.queryCubes();
        }
        return this.cubes;
    }

    private ICube[] queryCubes() {
        List<ICube> cubeList = CollectionCast.downcast(this.queryMetadata(MFWModelRes.getInstance().RID_dataSource, MFWModelRes.getInstance().RID_cube), IMetadata.class, ICube.class);
        ICube[] modelCubes = cubeList == null ? new ICube[]{} : cubeList.toArray(new ICube[0]);
        return modelCubes;
    }

    public IMetadata bindMetadataReference(String ref, PlanningEnvironment environment, MFWMultiRequestHandle[] contextHandles) {
        IMetadata mfwMetadata = null;
        try {
            MFWMultiRequestHandle[] resultantHandles = this.getGateway().resolveCrnID(ref);
            if (resultantHandles != null && resultantHandles.length > 0) {
                if (contextHandles != null && contextHandles.length > 0) {
                    MFWMultiRequestHandle[] handles = new MFWMultiRequestHandle[contextHandles.length + 1];
                    System.arraycopy(contextHandles, 0, handles, 0, contextHandles.length);
                    handles[contextHandles.length] = resultantHandles[resultantHandles.length - 1];
                    resultantHandles = handles;
                }
                mfwMetadata = this.mfwObjectToMetadataObject(resultantHandles);
            }
        }
        catch (DataSourceException e) {
            throw e;
        }
        catch (Exception e) {
            MFWMetadataConnection.handleUnexpectedFailure(e);
            throw new XQERuntimeException(XQEMessageKeys.MD_MetadataConnectionFailed, (Throwable)e, this.getModelPath());
        }
        if (mfwMetadata == null) {
            this.throwCannotBindException(ref);
        }
        return mfwMetadata;
    }

    private void throwCannotBindException(String ref) {
        if (ref.indexOf("[__ns_0].") != -1) {
            throw new XQERuntimeException(XQEMessageKeys.MD_MetadataBindingFailedTempCubProperty, ref);
        }
        throw new MetadataBindingException(ref);
    }

    private void processMetadataForShortcut(MFWMultiRequestHandle[] handles, IMetadata metadata) {
        IShortcut scObj = null;
        int sizeOfRemainingHandles = handles.length - 1;
        int shortcutIdx = -1;
        for (int idx = sizeOfRemainingHandles - 1; idx >= 0; --idx) {
            if (handles[idx].getNameRID() != MFWModelRes.getInstance().RID_shortcut) continue;
            shortcutIdx = idx;
            break;
        }
        if (shortcutIdx == -1) {
            return;
        }
        if (metadata instanceof MFWQueryItemOfQuerySubject) {
            MFWQueryItemOfQuerySubject qiObj = (MFWQueryItemOfQuerySubject)metadata;
            IQuerySubject parentQS = null;
            int qsIndex = -1;
            int scIndex = -1;
            for (int idx = sizeOfRemainingHandles - 1; idx >= 0; --idx) {
                if (handles[idx].getNameRID() == MFWModelRes.getInstance().RID_querySubject) {
                    qsIndex = idx;
                    continue;
                }
                if (idx != qsIndex - 1 || handles[idx].getNameRID() != MFWModelRes.getInstance().RID_shortcut) continue;
                scIndex = idx;
                break;
            }
            if (qsIndex != -1 && scIndex != -1) {
                scObj = this.scMap.get(handles[scIndex]);
                if (scObj == null) {
                    parentQS = (IQuerySubject)((Object)this.newMFWMetadata(new MFWMultiRequestHandle[]{handles[qsIndex]}));
                    scObj = (IShortcut)((Object)this.newMFWMetadata(new MFWMultiRequestHandle[]{handles[scIndex]}));
                    ((IAccessedViaShortcut)((Object)parentQS)).setShortcut(scObj);
                    scObj.setTarget(parentQS);
                    IShortcut shortcutFromMap = this.scMap.putIfAbsent(handles[scIndex], scObj);
                    if (shortcutFromMap != null) {
                        scObj = shortcutFromMap;
                    }
                }
                parentQS = (IQuerySubject)scObj.getTarget();
                qiObj.setQuerySubject(parentQS);
            }
        } else if (metadata instanceof IAccessedViaShortcut && shortcutIdx == handles.length - 2) {
            scObj = (IShortcut)this.mfwObjectToMetadataObject(new MFWMultiRequestHandle[]{handles[shortcutIdx]});
            ((IAccessedViaShortcut)metadata).setShortcut(scObj);
        }
    }

    public String toString(IMultiRequestHandle handle) {
        return this.toString(handle, 1);
    }

    public String toString(IMultiRequestHandle handle, int depthLimit) {
        return this.toString(handle, 0, depthLimit);
    }

    public String toString(IMultiRequestHandle[] handles) {
        return this.toString(handles, 1);
    }

    public String toString(IMultiRequestHandle[] handles, int depthLimit) {
        StringBuilder toString = new StringBuilder();
        for (IMultiRequestHandle handle : handles) {
            toString.append(this.toString(handle, depthLimit)).append(MetadataConstants.LINE_SEPARATOR);
        }
        return toString.toString();
    }

    public String toString(String query) {
        return this.toString(MFWQuerySpec.create((String)query));
    }

    public String toString(String query, int depthLimit) {
        return this.toString(MFWQuerySpec.create((String)query), depthLimit);
    }

    public String toString(int depthLimit) {
        return this.toString(QUERY_PROJECT, depthLimit);
    }

    @Override
    public boolean toFile() {
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        String xqeLogsFolder = configuration.getXqeLogsDirectory();
        return this.toFile(xqeLogsFolder + PATH_SEPARATOR + this.getPackageName() + TXT);
    }

    public boolean toFile(String fileName) {
        return MFWMetadataConnection.toFile(fileName, this.toString(Integer.MAX_VALUE));
    }

    public static boolean toFile(String fileName, String content) {
        boolean success = true;
        OutputStreamWriter fileWriter = null;
        try {
            int pathSeparatorIndex = fileName.lastIndexOf(PATH_SEPARATOR);
            if (pathSeparatorIndex == -1) {
                pathSeparatorIndex = fileName.lastIndexOf("\\");
            }
            if (pathSeparatorIndex != -1) {
                String dirPath = fileName.substring(0, pathSeparatorIndex);
                new File(dirPath).mkdirs();
            }
            fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), "UTF-8");
        }
        catch (IOException e) {
            success = false;
            MFWMetadataConnection.getLogger().log(LogLevel.ERROR, (Throwable)e);
            throw new XQERuntimeException(e);
        }
        if (fileWriter != null) {
            XQERuntimeException exception = null;
            try {
                fileWriter.write(content);
            }
            catch (IOException e) {
                success = false;
                MFWMetadataConnection.getLogger().log(LogLevel.ERROR, (Throwable)e);
                exception = new XQERuntimeException(e);
            }
            try {
                fileWriter.close();
            }
            catch (IOException e) {
                if (success) {
                    exception = new XQERuntimeException(e);
                }
                success = false;
                MFWMetadataConnection.getLogger().log(LogLevel.ERROR, (Throwable)e);
            }
            if (exception != null) {
                throw exception;
            }
        }
        return success;
    }

    public String toString(IMultiRequestHandle handle, String query) {
        return this.toString(handle, MFWQuerySpec.create((String)query), 1);
    }

    public String toString(IMultiRequestHandle handle, String query, int depthLimit) {
        return this.toString(handle, MFWQuerySpec.create((String)query), depthLimit);
    }

    private String toString(IMultiRequestHandle handle, int depth, int depthLimit) {
        if (depth > depthLimit || this.getGateway() == null || handle == null) {
            return "";
        }
        StringBuilder toString = new StringBuilder();
        try {
            if (handle.isObject()) {
                MFWMultiRequestHandle[] children = this.getGateway().getAllObjectChildren(handle);
                for (int k = 0; k < children.length; ++k) {
                    int i;
                    if (children[k].isProperty()) {
                        for (i = 0; i < depth; ++i) {
                            toString.append(INDENT);
                        }
                        toString.append(children[k].getName()).append(EQUAL).append(this.getGateway().getPropertyValue(children[k])).append(MetadataConstants.LINE_SEPARATOR);
                        continue;
                    }
                    if (!children[k].isObject()) continue;
                    for (i = 0; i < depth; ++i) {
                        toString.append(INDENT);
                    }
                    toString.append(PLUS).append(children[k].getName()).append(MetadataConstants.LINE_SEPARATOR);
                    toString.append(this.toString((IMultiRequestHandle)children[k], depth + 1, depthLimit));
                }
            } else if (handle.isProperty()) {
                for (int i = 0; i < depth; ++i) {
                    toString.append(INDENT);
                }
                toString.append(handle.getName()).append(EQUAL).append(this.getGateway().getPropertyValue(handle)).append(MetadataConstants.LINE_SEPARATOR);
            }
        }
        catch (Exception exception) {
            toString.append(exception.toString());
            MFWMetadataConnection.getLogger().log(LogLevel.ERROR, (Throwable)exception);
        }
        return toString.toString();
    }

    private String toString(MFWQuerySpec mfwQuerySpec) {
        return this.toString(mfwQuerySpec, 1);
    }

    private String toString(MFWQuerySpec mfwQuerySpec, int depthLimit) {
        String toString = null;
        try {
            toString = this.toString(this.getGateway().query(mfwQuerySpec), depthLimit);
        }
        catch (Exception exception) {
            toString = exception.toString();
            MFWMetadataConnection.getLogger().log(LogLevel.ERROR, (Throwable)exception);
        }
        return toString;
    }

    private String toString(IMultiRequestHandle handle, MFWQuerySpec mfwQuerySpec, int depthLimit) {
        StringBuilder toString = new StringBuilder();
        try {
            MFWMultiRequestHandle[] handles;
            for (MFWMultiRequestHandle nodeHandle : handles = this.getGateway().queryObject(handle, mfwQuerySpec)) {
                toString.append(this.toString((IMultiRequestHandle)nodeHandle, depthLimit)).append(MetadataConstants.LINE_SEPARATOR);
            }
        }
        catch (Exception exception) {
            toString.append(exception.toString());
            MFWMetadataConnection.getLogger().log(LogLevel.ERROR, (Throwable)exception);
        }
        return toString.toString();
    }

    private MFWMetadata newMFWMetadata(MFWMultiRequestHandle[] handles) {
        return MFWMetadataFactory.newInstance(this, handles);
    }

    @Override
    public MFWMultiRequestGateway getGateway() {
        return this.gateway;
    }

    @Override
    public boolean isConnected() {
        return this.connected.get();
    }

    @Override
    public boolean isStale(boolean isMetadataRefreshRequest, boolean isMetadataRequest) {
        if (this.isConnected()) {
            boolean staleReuseIndicator;
            boolean bl = staleReuseIndicator = !this.reuseIndicator.equals((Object)this.gateway.getReuseIndicator());
            if (staleReuseIndicator) {
                return true;
            }
            boolean ignoreRetainPeriod = true;
            try {
                boolean stale = isMetadataRefreshRequest && this.gateway.isStale(ignoreRetainPeriod, isMetadataRequest);
                return stale;
            }
            catch (MFWModelNotFoundException ex) {
                throw new ModelNotFoundException(this.getModelPath());
            }
        }
        return true;
    }

    @Override
    public synchronized void release() {
        if (!this.connected.compareAndSet(true, false)) {
            return;
        }
        XQELogger infoLogger = MFWMetadataConnection.getLogger();
        if (infoLogger.isOn(LogLevel.INFO)) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(LOGMSG_RELEASING);
            MFWMetadataConnection.appendConnectionInfo(buffer, this.metadataSource);
            infoLogger.log(LogLevel.INFO, buffer.toString());
        }
        this.gateway = null;
        this.reuseIndicator = null;
        if (null != this.dataSourceProperties) {
            this.dataSourceProperties.clear();
            this.dataSourceProperties = null;
        }
        if (null != this.datasources) {
            this.datasources.clear();
            this.datasources = null;
        }
        if (null != this.metadataHandleToObject) {
            this.metadataHandleToObject.clear();
            this.metadataHandleToObject = null;
        }
        if (null != this.metadataIDToObject) {
            this.metadataIDToObject.clear();
            this.metadataIDToObject = null;
        }
        this.metadataSource = null;
    }

    protected static XQELogger getLogger() {
        if (null == logger) {
            logger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", LOG_EVENT_GROUP, LogLevel.INFO);
        }
        return logger;
    }

    @Override
    public ParameterMapsModel getParameterMapsModel() {
        if (this.modelParameterMaps == null) {
            this.modelParameterMaps = new ParameterMapsModel(this, this.queryHandles(this.getProjectHandle(), MFWModelRes.getInstance().RID_parameterMaps, new short[0]));
        }
        return this.modelParameterMaps;
    }

    @Override
    public List<IMetadata> getPhysicalMetadata(String dataSource, String catalog, String schema, String name, boolean isTable, boolean mdCallbackEnabled) {
        if (isTable) {
            return this.getPhysicalMetadataViaCRN(dataSource, catalog, schema, name, mdCallbackEnabled);
        }
        return this.getPhysicalMetadataViaXPath(dataSource, catalog, schema, name, isTable);
    }

    private List<IMetadata> getPhysicalMetadataViaCRN(String dataSource, String catalog, String schema, String name, boolean mdCallbackEnabled) {
        ArrayList<IMetadata> list;
        block8: {
            StringBuilder multiPartID = new StringBuilder();
            multiPartID.append("[:physicalSources]");
            multiPartID.append(".");
            if (dataSource != null) {
                multiPartID.append(String.format("[%1$s]", UniqueNameParser.escapeSquareBrackets(dataSource)));
            }
            multiPartID.append(".");
            if (catalog != null) {
                multiPartID.append(String.format("[%1$s]", UniqueNameParser.escapeSquareBrackets(catalog)));
            } else {
                multiPartID.append(String.format("[%1$s]", ""));
            }
            multiPartID.append(".");
            if (schema != null) {
                multiPartID.append(String.format("[%1$s]", UniqueNameParser.escapeSquareBrackets(schema)));
            } else {
                multiPartID.append(String.format("[%1$s]", ""));
            }
            multiPartID.append(".");
            if (name != null) {
                multiPartID.append(String.format("[%1$s]", UniqueNameParser.escapeSquareBrackets(name)));
            }
            IMetadata metadata = null;
            list = new ArrayList<IMetadata>();
            try {
                String mpID = multiPartID.toString();
                metadata = this.bindMetadataReference(mpID);
                this.doMetadataNagging(mpID, dataSource, catalog, schema, name, mdCallbackEnabled);
                list.add(metadata);
            }
            catch (XQERuntimeException ex) {
                if (ex.getMessageKey() == XQEMessageKeys.MD_MetadataBindingFailed) break block8;
                throw ex;
            }
        }
        return list;
    }

    private void doMetadataNagging(String mpID, String dataSource, String catalog, String schema, String table, boolean mdCallbackEnabled) {
        ExecutionEnvironment exeEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        if (((RequestEnvironment)exeEnv.getRequestEnvironment()).getMaxSeverityLevel() < 3 && !exeEnv.getNagCollector().isIPFLoggingEnabled()) {
            return;
        }
        if (!mdCallbackEnabled) {
            exeEnv.addNag(XQEMessages.getMessage(XQEMessageKeys.PLN_MetadataCallbackReason_MetadataCallbackDisabled, XQEMessages.getCurrProductLocale()));
            return;
        }
        MFWGateway mfwGateway = this.getGateway().getGatewayImpl();
        MFWNodeHandle[] result = mfwGateway.findChildObjects(this.getProjectHandle().getNodeHandle(), MFWModelRes.getInstance().RID_physMDExtractFeedback, MFWModelRes.getInstance().RID_appliesTo, mpID);
        IMessageKey.Param4 messageKey = null;
        if (result.length == 0) {
            messageKey = XQEMessageKeys.PLN_MetadataCallbackReason_noQuerySubject;
        } else {
            MFWNodeHandle feedback = result[0];
            String reason = mfwGateway.getObjectPropertyValue(feedback, MFWModelRes.getInstance().RID_type);
            if (reason != null && !reason.equals("success")) {
                if (reason.equals("notDbQuerySubject")) {
                    messageKey = XQEMessageKeys.PLN_MetadataCallbackReason_notDbQuerySubject;
                } else if (reason.equals("sqlNotSelectAll")) {
                    messageKey = XQEMessageKeys.PLN_MetadataCallbackReason_sqlNotSelectAll;
                } else if (reason.equals("incorrectTableType")) {
                    messageKey = XQEMessageKeys.PLN_MetadataCallbackReason_incorrectTableType;
                } else if (reason.equals("duplicateInconsistentQuerySubjects")) {
                    messageKey = XQEMessageKeys.PLN_MetadataCallbackReason_duplicateInconsistentQuerySubjects;
                }
            }
        }
        if (messageKey != null) {
            if (dataSource == null) {
                dataSource = "";
            }
            if (catalog == null) {
                catalog = "";
            }
            if (schema == null) {
                schema = "";
            }
            if (table == null) {
                table = "";
            }
            String nagMsg = XQEMessages.getMessage(messageKey, XQEMessages.getCurrProductLocale(), dataSource, catalog, schema, table);
            exeEnv.addNag(nagMsg);
        }
    }

    private List<IMetadata> getPhysicalMetadataViaXPath(String dataSource, String catalog, String schema, String name, boolean isTable) {
        StringBuilder xpath = new StringBuilder();
        xpath.append("/project/physicalSource");
        xpath.append(String.format("[name='%1$s']", MFWMetadataConnection.encodeSingleQuotes(dataSource)));
        xpath.append("/catalog");
        if (catalog != null) {
            xpath.append(String.format("[name='%1$s']", MFWMetadataConnection.encodeSingleQuotes(catalog)));
        } else {
            xpath.append(String.format("[name='%1$s']", ""));
        }
        xpath.append("/schema");
        if (schema != null) {
            xpath.append(String.format("[name='%1$s']", MFWMetadataConnection.encodeSingleQuotes(schema)));
        } else {
            xpath.append(String.format("[name='%1$s']", ""));
        }
        if (isTable) {
            xpath.append(PATH_SEPARATOR);
            xpath.append("table");
            xpath.append(String.format("[name='%1$s']", name));
        } else {
            xpath.append(PATH_SEPARATOR);
            xpath.append("subroutine");
            xpath.append(String.format("[canonicalName='%1$s']", name));
        }
        return this.queryMetadata(xpath.toString());
    }

    @Override
    public IMetadata getFunction(String name) {
        IMetadata mdFunc = null;
        try {
            mdFunc = this.bindMetadataReference(OPEN_SQURE_BRACKET + name + CLOSE_SQURE_BRACKET);
        }
        catch (MetadataBindingException metadataBindingException) {
            // empty catch block
        }
        return mdFunc;
    }

    @Override
    public IScopeRelationship[] getScopeRelationships(String id) {
        ArrayList<IScopeRelationship> scopeRelationships = new ArrayList<IScopeRelationship>();
        this.getScopeRelationships();
        if (this.modelScopeRelationships != null) {
            for (IMetadata sr : this.modelScopeRelationships) {
                IScopeRelationship scopeRel = (IScopeRelationship)sr;
                if (!scopeRel.getLeftRefObjectId().equals(id) && !scopeRel.getRightRefObjectId().equals(id)) continue;
                scopeRelationships.add(scopeRel);
            }
        }
        return scopeRelationships.toArray(new IScopeRelationship[scopeRelationships.size()]);
    }

    private List<IMetadata> getScopeRelationships() {
        if (this.modelScopeRelationships == null) {
            this.modelScopeRelationships = this.mfwObjectsToMetadataObjects(this.getGateway().lookupObjectsByType((short)249));
        }
        return this.modelScopeRelationships;
    }

    @Override
    public ParameterMapsQI getQIParameterMapsModel() {
        if (this.modelQIParameterMaps == null) {
            this.modelQIParameterMaps = new ParameterMapsQI(this, this.queryHandles(this.getProjectHandle(), MFWModelRes.getInstance().RID_parameterMaps, new short[0]));
        }
        return this.modelQIParameterMaps;
    }

    protected static void appendConnectionInfo(StringBuilder buffer, MFWMetadataSource mdSrc) {
        if (null != mdSrc) {
            String type = mdSrc.getType();
            Map connInfo = mdSrc.getConnectionInfo();
            Map signonInfo = mdSrc.getSignonInfo();
            buffer.append("[type=").append(type);
            buffer.append(",connectionInfo=").append(connInfo);
            buffer.append(",signonInfo=").append(signonInfo);
            buffer.append(CLOSE_SQURE_BRACKET);
        }
    }

    @Override
    public Object getModelConnectionItem(String item) {
        if (this.metadataSource != null) {
            return this.metadataSource.getConnectionItem(item);
        }
        return null;
    }

    MFWMultiRequestHandle getProjectHandle() {
        return this.projectHandle;
    }

    private Map<IMetadata, List<IShortcut>> getQuerySubjectOrDimensionToShortcut() {
        if (this.querySubjectOrDimensionToShortcut == null) {
            HashMap<IMetadata, List<IShortcut>> qsOrDimToSchortcut = new HashMap<IMetadata, List<IShortcut>>();
            for (IShortcut shortcut : this.getShortcutsToQuerySubjectOrDimension()) {
                List<IShortcut> list = qsOrDimToSchortcut.get(shortcut.getTarget());
                if (list == null) {
                    list = new LinkedList<IShortcut>();
                    list.add(shortcut);
                    qsOrDimToSchortcut.put(shortcut.getTarget(), list);
                    continue;
                }
                list.add(shortcut);
            }
            this.querySubjectOrDimensionToShortcut = qsOrDimToSchortcut;
        }
        return this.querySubjectOrDimensionToShortcut;
    }

    @Override
    public List<IShortcut> getAllShortcuts(IMetadata shortcutOrQuerySubject) {
        IMetadata target = shortcutOrQuerySubject;
        if (target instanceof IShortcut) {
            target = ((IShortcut)shortcutOrQuerySubject).getTarget();
        }
        List<IShortcut> qsShortcuts = this.getQuerySubjectOrDimensionToShortcut().get(target);
        return qsShortcuts;
    }

    private List<IShortcut> getShortcutsToQuerySubjectOrDimension() {
        if (this.shortcuts == null) {
            MFWMultiRequestHandle[] modelShortcuts;
            LinkedList<IShortcut> shortcutList = new LinkedList<IShortcut>();
            for (MFWMultiRequestHandle modelShortcut : modelShortcuts = this.getGateway().lookupObjectsByType((short)243)) {
                String targetType = this.queryValue(modelShortcut, MFWModelRes.getInstance().RID_targetType, new short[0]);
                if (!"querySubject".equals(targetType) && !"dimension".equals(targetType)) continue;
                IShortcut shortcut = (IShortcut)this.mfwObjectToMetadataObject(modelShortcut);
                shortcutList.add(shortcut);
            }
            this.shortcuts = shortcutList;
        }
        return this.shortcuts;
    }

    @Override
    public List<IMetadata> getRelationships() {
        if (this.relationships == null) {
            this.relationships = this.mfwObjectsToMetadataObjects(this.getGateway().lookupObjectsByType((short)246));
        }
        return this.relationships;
    }

    @Override
    public List<IMetadata> getRelationshipShortcuts() {
        if (this.relationshipShortcuts == null) {
            this.relationshipShortcuts = this.mfwObjectsToMetadataObjects(this.getGateway().lookupObjectsByType((short)247));
        }
        return this.relationshipShortcuts;
    }

    @Override
    public List<IMetadata> getJoins(Governors governors) {
        if (this.joins == null) {
            this.queryJoins(governors);
        }
        return this.joins;
    }

    private void queryJoins(Governors governors) {
        if (this.joins != null) {
            return;
        }
        ArrayList<IMetadata> modelJoins = new ArrayList<IMetadata>();
        modelJoins.addAll(this.getRelationships());
        modelJoins.addAll(this.getDummyRelationships(governors));
        modelJoins.addAll(this.getRelationshipShortcuts());
        this.joins = modelJoins;
    }

    @Override
    public List<IMetadata> getDummyRelationships(Governors governors) {
        if (this.dummyRelationships == null) {
            this.queryDummyRelationships(governors);
        }
        return this.dummyRelationships;
    }

    private void queryDummyRelationships(Governors governors) {
        if (this.dummyRelationships != null) {
            return;
        }
        ArrayList<IMetadata> relations = new ArrayList<IMetadata>();
        for (IShortcut sc : this.getShortcutsToQuerySubjectOrDimension()) {
            IMetadata target = sc.getTarget();
            String targetNS = null;
            String shortcutNS = null;
            String targetFolder = null;
            String shortcutFolder = null;
            StringBuilder joinV5UniqueName = new StringBuilder();
            IMetadata parent = this.getParentObject(target);
            while (parent != null) {
                if (targetFolder == null && parent instanceof IFolder) {
                    targetFolder = parent.getName();
                }
                if (parent instanceof INamespace) {
                    targetNS = parent.getName();
                    break;
                }
                parent = this.getParentObject(parent);
            }
            parent = this.getParentObject(sc);
            while (parent != null) {
                if (shortcutFolder == null && parent instanceof IFolder) {
                    shortcutFolder = parent.getName();
                }
                if (parent instanceof INamespace) {
                    shortcutNS = parent.getName();
                    break;
                }
                parent = this.getParentObject(parent);
            }
            if (this.isTreatedAsAlias(sc, governors)) continue;
            joinV5UniqueName.append('[');
            joinV5UniqueName.append(targetNS);
            joinV5UniqueName.append('-');
            joinV5UniqueName.append(shortcutNS);
            joinV5UniqueName.append("].[");
            joinV5UniqueName.append(target.getName());
            joinV5UniqueName.append(" <--> ");
            joinV5UniqueName.append(sc.getName());
            joinV5UniqueName.append(']');
            DMRelationship aDummyJoin = new DMRelationship(joinV5UniqueName.toString(), target, sc, "one", "one", "one", "one");
            relations.add(aDummyJoin);
        }
        this.dummyRelationships = relations;
    }

    @Override
    public boolean isTreatedAsAlias(IShortcut sc, Governors governors) {
        if (Governors.ShortCutProcessing.EXPLICIT == governors.getShortcutProcessing()) {
            return "alias".equals(sc.getTreatAs());
        }
        String targetNS = null;
        String shortcutNS = null;
        String targetFolder = null;
        String shortcutFolder = null;
        IMetadata target = sc.getTarget();
        IMetadata parent = this.getParentObject(target);
        while (parent != null) {
            if (targetFolder == null && parent instanceof IFolder) {
                targetFolder = parent.getName();
            }
            if (parent instanceof INamespace) {
                targetNS = parent.getName();
                break;
            }
            parent = this.getParentObject(parent);
        }
        parent = this.getParentObject(sc);
        while (parent != null) {
            if (shortcutFolder == null && parent instanceof IFolder) {
                shortcutFolder = parent.getName();
            }
            if (parent instanceof INamespace) {
                shortcutNS = parent.getName();
                break;
            }
            parent = this.getParentObject(parent);
        }
        return shortcutNS.equals(targetNS) && (targetFolder == null ? shortcutFolder == null : targetFolder.equals(shortcutFolder));
    }

    @Override
    public IMetadata getTargetOfReferenceShortcut(IMetadata metadata) {
        return this.mfwObjectToMetadataObject(((MFWMetadata)metadata).getHandle());
    }

    @Override
    public List<IMetadata> getEntities() {
        if (this.entities == null) {
            this.queryEntities();
        }
        return this.entities;
    }

    public void queryEntities() {
        if (this.entities != null) {
            return;
        }
        ArrayList<IMetadata> modelEntities = new ArrayList<IMetadata>();
        modelEntities.addAll(this.mfwObjectsToMetadataObjects(this.getGateway().lookupObjectsByType((short)238)));
        modelEntities.addAll(this.getShortcutsToQuerySubjectOrDimension());
        modelEntities.addAll(this.mfwObjectsToMetadataObjects(this.getGateway().lookupObjectsByType((short)232)));
        this.entities = modelEntities;
    }

    @Override
    public IUndirectedGraph getGraph(Governors governors) {
        JoinGraph graph = new JoinGraph(governors);
        return graph.getGraph(governors);
    }

    @Override
    public HashMap<String, IMetadata> getIdToJoinMap(Governors governors) {
        if (this.mIdToJoin == null) {
            HashMap<String, IRelationship> idToJoin = new HashMap<String, IRelationship>();
            for (IMetadata mdObj : this.getJoins(governors)) {
                if (!(mdObj instanceof IRelationship)) continue;
                IRelationship joinObj = (IRelationship)mdObj;
                String joinId = joinObj.getV5UniqueName();
                idToJoin.put(joinId, joinObj);
            }
            this.mIdToJoin = idToJoin;
        }
        return this.mIdToJoin;
    }

    @Override
    public List<String> getModelDataSecurityObjects(IRequestEnvironment reqEnv) {
        if (this.modelDataSecurityObjects == null) {
            List<String> viewrefs;
            List<IModelDataSecurityObject> viewrefObjs;
            List<String> dsSearchPaths;
            ArrayList<String> searchPaths = new ArrayList<String>();
            List<IModelDataSecurityObject> securityObjects = CollectionCast.downcast(this.queryMetadata(this.getProjectHandle(), MFWModelRes.getInstance().RID_modelDataSecurityObjects, new short[0]), IMetadata.class, IModelDataSecurityObject.class);
            if (securityObjects != null && securityObjects.size() > 0 && (dsSearchPaths = securityObjects.get(0).getSecurityObjects()) != null && dsSearchPaths.size() > 0) {
                searchPaths.addAll(dsSearchPaths);
            }
            if ((viewrefObjs = CollectionCast.downcast(this.queryMetadata(this.getProjectHandle(), MFWModelRes.getInstance().RID_modelDataViewrefObjects, new short[0]), IMetadata.class, IModelDataSecurityObject.class)) != null && viewrefObjs.size() > 0 && (viewrefs = viewrefObjs.get(0).getSecurityObjects()) != null && viewrefs.size() > 0) {
                for (String viewref : viewrefs) {
                    List<String> viewRefSearchPaths = ContentManager.getModelViewSearchPaths(reqEnv, viewref);
                    if (viewRefSearchPaths == null || viewRefSearchPaths.size() <= 0) continue;
                    searchPaths.addAll(viewRefSearchPaths);
                }
            }
            this.modelDataSecurityObjects = searchPaths;
        }
        return this.modelDataSecurityObjects;
    }

    @Override
    public long getModelModificationTime(String passport, BIBusEnvelope envelope) {
        String messagePart1 = "Unable to retrieve modification time for Model: ";
        String messagePart2 = ". This will affect performance by preventing the cache reuse./n";
        try {
            MFWContentHelper helper = MFWContentHelper.create((String)this.contentLocaleString, (String)this.productLocaleString, (IMFWCMRequestExecutor)new MFWSimpleCMRequestExecutor(envelope, passport));
            MFWContentHelper.CMObjectInfo info = helper.getCMObjectProperties(this.modelPath, this.gateway.getGatewayImpl().getContext());
            return info.getLastModificationTime().getTimeInMillis();
        }
        catch (CCLRuntimeException e) {
            File f = new File(this.modelPath);
            if (f.exists()) {
                return f.lastModified();
            }
            StringBuilder sb = new StringBuilder();
            sb.append("Unable to retrieve modification time for Model: ");
            sb.append(this.modelPath);
            sb.append(". This will affect performance by preventing the cache reuse./n");
            logger.log(LogLevel.ERROR, sb.toString(), (Throwable)e);
        }
        catch (MFWException e) {
        }
        catch (Exception e) {
            File f = new File(this.modelPath);
            if (f.exists()) {
                return f.lastModified();
            }
            StringBuilder sb = new StringBuilder();
            sb.append("Unable to retrieve modification time for Model: ");
            sb.append(this.modelPath);
            sb.append(". This will affect performance by preventing the cache reuse./n");
            logger.log(LogLevel.ERROR, sb.toString(), (Throwable)e);
        }
        return -1L;
    }

    private static String encodeSingleQuotes(String str) {
        return str.replaceAll("'", "&apos;");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpFMModel(RequestEnvironment reqEnv) {
        if (CollectXQELogs.isLoggingEnabled(reqEnv)) {
            CollectXQELogs xqeLogs = new CollectXQELogs(reqEnv.getOrCreateReportLogsDir());
            String cmSearchPath = (String)this.metadataSource.getConnectionItem("cmSearchPath");
            if (cmSearchPath != null && cmSearchPath.length() > 0) {
                MFWContentHelper helper = null;
                helper = MFWContentHelper.create((String)this.contentLocaleString, (String)this.productLocaleString, (IMFWCMRequestExecutor)new MFWSimpleCMRequestExecutor(reqEnv.getRequestEnvelope(), reqEnv.getCAMPassport()));
                InputStream is = null;
                is = helper.queryPackage(cmSearchPath, true);
                try {
                    String modelContent = IOUtils.toString((InputStream)is);
                    xqeLogs.dumpFMModel(modelContent);
                }
                catch (IOException e) {
                    MFWMetadataConnection.getLogger().log(LogLevel.ERROR, (Throwable)e);
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            MFWMetadataConnection.getLogger().log(LogLevel.ERROR, (Throwable)e);
                        }
                    }
                    if (helper != null) {
                        helper.destroy();
                    }
                }
            }
        }
    }

    @Override
    public IAggregateAwareness getAggregateAwareness() {
        return this.aggrAwareNess;
    }

    @Override
    public IMetadataContextManager getMetadataContextManager() {
        return this.metadataContextManager;
    }

    @Override
    public IPhysicalTable getPhysicalTable(String theDataSource, String theCatalog, String theSchema, String theName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getModelType() {
        return null;
    }

    @Override
    public void refreshMetadata() {
    }

    @Override
    public void transferNags(IExecutionEnvironment execEnv) {
    }

    public void setDataCacheExpiry(String theDataCacheExpiry) {
        this.dataCacheExpiry = theDataCacheExpiry;
    }

    public String getDataCacheExpiry() {
        return this.dataCacheExpiry;
    }

    @Override
    public String getID(IMetadata metadata) {
        return metadata.getID();
    }

    @Override
    public String getV5UniqueName(IMetadata metadata) {
        return metadata.getV5UniqueName();
    }

    @Override
    public String getJoinGraph() {
        return this.mJoinGraph;
    }

    @Override
    public void setJoinGraph(String joinGraph) {
        this.mJoinGraph = joinGraph;
    }

    private final class JoinGraph {
        private IUndirectedGraph mGraph = null;

        private JoinGraph(Governors governors) {
            this.buildGraph(governors);
        }

        private IUndirectedGraph getGraph(Governors governors) {
            return this.mGraph;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void buildGraph(Governors governors) {
            Timer timer = null;
            if (UsageTrackingService.isEnabled()) {
                timer = new Timer();
                timer.start();
            }
            try {
                UndirectedGraph newGraph = new UndirectedGraph(MFWMetadataConnection.this.modelPath);
                for (IMetadata entObj : MFWMetadataConnection.this.getEntities()) {
                    String entId = entObj.getID();
                    newGraph.addNode(entId);
                }
                for (IMetadata mdObj : MFWMetadataConnection.this.getJoins(governors)) {
                    if (!(mdObj instanceof IRelationship)) continue;
                    IRelationship joinObj = (IRelationship)mdObj;
                    int weight = RQPJoinPathFinder.Weight.Default.getWeight();
                    if (mdObj instanceof DMRelationship) {
                        weight = RQPJoinPathFinder.Weight.Shortcut.getWeight();
                    }
                    newGraph.addEdge(joinObj.getV5UniqueName(), joinObj.getLeftRefObjectId(), joinObj.getRightRefObjectId(), weight, false);
                }
                this.mGraph = newGraph;
            }
            finally {
                if (timer != null) {
                    timer.stop();
                    if (this.mGraph != null) {
                        this.mGraph.recordBuildTime(timer.getElapsedTimeInMilliseconds());
                        this.mGraph.recordNodesEdgesCount();
                    }
                }
            }
        }
    }
}

