/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemfw4j;

import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.record.LevelRecord;
import com.cognos.xqe.util.xml.stax.ChildElementIterator;
import com.cognos.xqe.util.xml.stax.StaxUtil;
import com.cognos.xqemfw4j.MFWHierarchy;
import com.cognos.xqemfw4j.MFWMetadataConnection;
import com.cognos.xqemfw4j.MFWMultiRequestHandle;
import com.cognos.xqemfw4j.MFWParentChildLevel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

class MFWParentChildHierarchy
extends MFWHierarchy {
    private static final String QUERY_LEVELSINFO = "/property[name='parentChildLevelInfo']/__Value";

    MFWParentChildHierarchy(MFWMetadataConnection mfwConnection, MFWMultiRequestHandle[] mfwHandle) {
        super(mfwConnection, mfwHandle);
        if (!super.isParentChild()) {
            this.throwInvalidObject();
        }
    }

    @Override
    public boolean isAutoGenerated() {
        return true;
    }

    @Override
    public List<ILevel> getLevels() {
        if (this.levels == null) {
            this.queryLevels();
        }
        return this.levels;
    }

    void queryLevels() {
        List<Object> queryLevels = new ArrayList();
        String levelsInfo = this.queryValue(QUERY_LEVELSINFO);
        if (levelsInfo != null) {
            ArrayList<String> externalNames = new ArrayList<String>();
            try {
                XMLStreamReader xmlReader = StaxUtil.createXMLStreamReader(levelsInfo);
                while (xmlReader.hasNext() && StaxUtil.moveToElement(xmlReader, "level")) {
                    ChildElementIterator childIter = new ChildElementIterator(xmlReader);
                    while (childIter.next()) {
                        if (xmlReader.getLocalName().equals("externalName")) {
                            externalNames.add(xmlReader.getElementText());
                            continue;
                        }
                        StaxUtil.skipElement(xmlReader);
                    }
                    if (StaxUtil.testOnEndElement(xmlReader, "level")) continue;
                    StaxUtil.moveToEndElement(xmlReader, "level");
                }
                xmlReader.close();
            }
            catch (XMLStreamException ex) {
                throw new XQERuntimeException(ex);
            }
            for (int levelIndex = 0; levelIndex < externalNames.size(); ++levelIndex) {
                MFWParentChildLevel level = new MFWParentChildLevel(this, levelIndex, (String)externalNames.get(levelIndex));
                queryLevels.add(level);
            }
            queryLevels = Collections.unmodifiableList(queryLevels);
        } else {
            List<LevelRecord> levelRecords = this.queryLevelRecords();
            if (levelRecords == null) {
                queryLevels = Collections.unmodifiableList(new ArrayList());
            } else {
                queryLevels = new ArrayList(levelRecords.size());
                for (LevelRecord levelRecord : levelRecords) {
                    MFWParentChildLevel level = new MFWParentChildLevel(this, levelRecord.getLevelNumber(), levelRecord.getUniqueName());
                    queryLevels.add(level);
                }
                queryLevels = Collections.unmodifiableList(queryLevels);
            }
        }
        this.setLevels(queryLevels);
    }

    @Override
    public String getCaption() {
        if (this.caption == null) {
            this.caption = this.queryCaption();
        }
        return this.caption;
    }

    @Override
    protected String queryCaption() {
        String contentLocale = this.getConnection().getContentLocaleString();
        String caption = null;
        for (MFWMultiRequestHandle handleName : this.queryHandles(MFWModelRes.getInstance().RID_name, new short[0])) {
            if (!contentLocale.equals(this.getConnection().queryValue(handleName, MFWModelRes.getInstance().RID_locale, new short[0]))) continue;
            caption = this.getConnection().queryValue(handleName, MFWModelRes.getInstance().RID__Value, new short[0]);
        }
        return caption;
    }

    private synchronized void setLevels(List<ILevel> queryLevels) {
        if (this.levels == null) {
            this.levels = queryLevels;
        }
    }
}

