/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemfw4j;

import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IRelationship;
import com.cognos.xqe.metadata.IScopeRelationship;
import com.cognos.xqe.metadata.IShortcut;
import com.cognos.xqe.metadata.MetadataBindingException;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqemfw4j.MFWMetadata;
import com.cognos.xqemfw4j.MFWMetadataConnection;
import com.cognos.xqemfw4j.MFWMultiRequestHandle;
import com.cognos.xqemfw4j.MFWShortcut;
import java.util.ArrayList;
import java.util.List;

class MFWScopeRelationship
extends MFWMetadata
implements IScopeRelationship {
    private String id = null;
    private String name = null;
    private IDimension nonMeasureDimension = null;
    private Enum<IRelationship.Cardinality> leftCard = null;
    private Enum<IRelationship.Cardinality> rightCard = null;
    private IMetadata leftRefObj = null;
    private IMetadata rightRefObj = null;
    private String leftRefObjId = null;
    private String rightRefObjId = null;
    private Scope[] scopes = null;
    static final long serialVersionUID = 7647274105530911872L;

    MFWScopeRelationship(MFWMetadataConnection mfwConnection, MFWMultiRequestHandle[] mfwHandle) {
        super(mfwConnection, mfwHandle);
    }

    @Override
    public MetadataType getObjectType() {
        return MetadataType.SCOPE_RELATIONSHIP;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = this.queryValue(MFWModelRes.getInstance().RID_name, new short[0]);
        }
        return this.name;
    }

    @Override
    public String getID() {
        if (this.id == null) {
            this.id = this.queryValue(MFWModelRes.getInstance().RID_ID, new short[0]);
        }
        return this.id;
    }

    @Override
    public String getUniqueID() {
        return this.getID();
    }

    @Override
    public String getLeftRefObjectId() {
        if (this.leftRefObjId == null) {
            this.leftRefObjId = this.queryValue(MFWModelRes.getInstance().RID_leftrefobj, new short[0]);
        }
        return this.leftRefObjId;
    }

    @Override
    public String getRightRefObjectId() {
        if (this.rightRefObjId == null) {
            this.rightRefObjId = this.queryValue(MFWModelRes.getInstance().RID_rightrefobj, new short[0]);
        }
        return this.rightRefObjId;
    }

    @Override
    public IMetadata getLeftRefObject() {
        if (this.leftRefObj == null) {
            String left = this.getLeftRefObjectId();
            this.leftRefObj = this.getConnection().bindMetadataReference(left);
        }
        return this.leftRefObj;
    }

    @Override
    public IMetadata getRightRefObject() {
        if (this.rightRefObj == null) {
            String right = this.getRightRefObjectId();
            this.rightRefObj = this.getConnection().bindMetadataReference(right);
        }
        return this.rightRefObj;
    }

    @Override
    public Enum<IRelationship.Cardinality> getLeftCardinality() {
        if (this.leftCard == null) {
            String leftMin = this.queryValue(MFWModelRes.getInstance().RID_leftmincard, new short[0]);
            String leftMax = this.queryValue(MFWModelRes.getInstance().RID_leftmaxcard, new short[0]);
            this.leftCard = this.getCardinality(leftMin, leftMax);
        }
        return this.leftCard;
    }

    @Override
    public Enum<IRelationship.Cardinality> getRightCardinality() {
        if (this.rightCard == null) {
            String rightMin = this.queryValue(MFWModelRes.getInstance().RID_rightmincard, new short[0]);
            String rightMax = this.queryValue(MFWModelRes.getInstance().RID_rightmaxcard, new short[0]);
            this.rightCard = this.getCardinality(rightMin, rightMax);
        }
        return this.rightCard;
    }

    protected Enum<IRelationship.Cardinality> getCardinality(String min, String max) {
        if (min.equals("zero")) {
            if (max.equals("one")) {
                return IRelationship.Cardinality.ZERO_ONE;
            }
            if (max.equals("many")) {
                return IRelationship.Cardinality.ZERO_MANY;
            }
        }
        if (min.equals("one")) {
            if (max.equals("one")) {
                return IRelationship.Cardinality.ONE_ONE;
            }
            if (max.equals("many")) {
                return IRelationship.Cardinality.ONE_MANY;
            }
        }
        throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "getCardinality():  Unexpected cardinality.");
    }

    @Override
    public IDimension getNonMeasureDimension() {
        if (this.nonMeasureDimension == null) {
            IDimension nonMeasureDim = this.getNonMeasureDimension(this.getRightRefObject());
            if (nonMeasureDim == null) {
                nonMeasureDim = this.getNonMeasureDimension(this.getLeftRefObject());
            }
            this.nonMeasureDimension = nonMeasureDim;
        }
        return this.nonMeasureDimension;
    }

    @Override
    public ILevel getLowestLevel(IMeasure measureItem, ILevel levelOfDimension) {
        IHierarchy inHierarchy = levelOfDimension.getHierarchy();
        IHierarchy targetHierarchy = this.getHierarchyTarget(levelOfDimension.getHierarchy());
        measureItem = this.getMeasureTarget(measureItem);
        for (Scope scope : this.getScopes()) {
            for (MeasureScope measureScope : scope.getMeasureScopes()) {
                if (!measureScope.getMeasure().equals(measureItem)) continue;
                if (measureScope.isMeasureExcluded()) {
                    if (!(targetHierarchy == inHierarchy ? inHierarchy.equals(scope.getLevelRef()) : targetHierarchy.equals(scope.getLevelRef()) || inHierarchy.equals(scope.getLevelRef()))) continue;
                    return null;
                }
                if (targetHierarchy == inHierarchy) {
                    if (!inHierarchy.equals(((ILevel)scope.getLevelRef()).getHierarchy())) continue;
                    return (ILevel)scope.getLevelRef();
                }
                if (!targetHierarchy.equals(((ILevel)scope.getLevelRef()).getHierarchy()) && !inHierarchy.equals(((ILevel)scope.getLevelRef()).getHierarchy())) continue;
                return this.findLevel(inHierarchy, scope.getLevelRef());
            }
        }
        List<ILevel> levels = inHierarchy.getLevels();
        ILevel level = levels.get(levels.size() - 1);
        return level;
    }

    private ILevel findLevel(IHierarchy inHierarchy, IMetadata inLevel) {
        for (ILevel level : inHierarchy.getLevels()) {
            if (!level.getName().equals(inLevel.getName())) continue;
            return level;
        }
        return null;
    }

    private IHierarchy getHierarchyTarget(IHierarchy hierarchy) {
        IDimension measureDim = hierarchy.getDimension();
        IDimension targetDim = MetadataUtil.getTargetDim(measureDim);
        if (targetDim != measureDim) {
            for (IMetadata h : targetDim.getChildMetadataObjects()) {
                if (!(h instanceof IHierarchy) || !h.getName().equals(hierarchy.getName())) continue;
                hierarchy = (IHierarchy)h;
                break;
            }
        }
        return hierarchy;
    }

    private IMeasure getMeasureTarget(IMeasure measureItem) {
        IDimension measureDim = measureItem.getDimension();
        IDimension targetDim = MetadataUtil.getTargetDim(measureDim);
        if (targetDim != measureDim) {
            for (IMetadata m : targetDim.getDescendantMetadataObjectsSkipFolders()) {
                if (!(m instanceof IMeasure) || !m.getName().equals(measureItem.getName())) continue;
                measureItem = (IMeasure)m;
                break;
            }
        }
        return measureItem;
    }

    private Scope[] getScopes() {
        if (this.scopes == null) {
            MFWMultiRequestHandle[] scopeHandles;
            ArrayList<Scope> scps = new ArrayList<Scope>();
            for (MFWMultiRequestHandle handle : scopeHandles = this.queryHandles(MFWModelRes.getInstance().RID_scope, new short[0])) {
                Scope newScope = new Scope(this.getConnection(), new MFWMultiRequestHandle[]{handle});
                scps.add(newScope);
            }
            Scope[] sArray = new Scope[scps.size()];
            scps.toArray(sArray);
            this.scopes = sArray;
        }
        return this.scopes;
    }

    private IDimension getNonMeasureDimension(IMetadata metadata) {
        IDimension dimension = null;
        if (metadata instanceof MFWShortcut) {
            MFWShortcut shortCut = (MFWShortcut)metadata;
            metadata = shortCut.getTargetWithShortcut();
        } else if (metadata.getObjectType() == MetadataType.SHORTCUT) {
            IShortcut shortCut = (IShortcut)metadata;
            metadata = shortCut.getTarget();
        }
        if (metadata.getObjectType() != MetadataType.DIMENSION) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Ref object should be a dimension");
        }
        dimension = (IDimension)metadata;
        if (dimension.isMeasuresDimension()) {
            return null;
        }
        return dimension;
    }

    @Override
    public IDimension getMeasureDimension() {
        if (this.getNonMeasureDimension() == this.getRightRefObject()) {
            return (IDimension)this.getLeftRefObject();
        }
        IMetadata rightRefObject = this.getRightRefObject();
        if (rightRefObject instanceof MFWShortcut) {
            rightRefObject = ((MFWShortcut)rightRefObject).getTargetWithShortcut();
        }
        return (IDimension)rightRefObject;
    }

    private class MeasureScope
    extends MFWMetadata {
        private IMeasure measure;
        private Boolean excluded;

        MeasureScope(MFWMetadataConnection mfwConnection, MFWMultiRequestHandle[] mfwHandles) {
            super(mfwConnection, mfwHandles);
            this.excluded = null;
        }

        IMeasure getMeasure() {
            if (this.measure == null) {
                XQELogger logger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "3rdParty", LogLevel.WARN);
                String measureId = this.queryValue(MFWModelRes.getInstance().RID_refobj, new short[0]);
                IMetadata metadata = null;
                try {
                    metadata = this.getConnection().bindMetadataReference(measureId);
                }
                catch (MetadataBindingException ex) {
                    logger.log("The model MeasureScope should refer to a valid measure");
                    return null;
                }
                catch (XQERuntimeException e) {
                    throw e;
                }
                if (metadata instanceof IDimension) {
                    logger.log("The model MeasureScope should refer to a measure, not a dimension");
                    return null;
                }
                this.measure = (IMeasure)metadata;
                if (this.measure == null) {
                    throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "MeasureScope must have a 'refObj'");
                }
            }
            return this.measure;
        }

        boolean isMeasureExcluded() {
            if (this.excluded == null) {
                Boolean ex;
                String isExcluded = this.queryValue(MFWModelRes.getInstance().RID_excluded, new short[0]);
                if (isExcluded == null) {
                    throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "MeasureScope must have an 'excluded' attribute.");
                }
                this.excluded = ex = Boolean.valueOf(Boolean.parseBoolean(isExcluded));
            }
            return this.excluded;
        }

        @Override
        public String toString() {
            return this.getHandle().toString();
        }
    }

    class Scope
    extends MFWMetadata {
        private IMetadata levelRef;
        final String toString;
        ArrayList<MeasureScope> measureScopes;

        Scope(MFWMetadataConnection mfwConnection, MFWMultiRequestHandle[] mfwHandles) {
            super(mfwConnection, mfwHandles);
            this.measureScopes = null;
            MFWMultiRequestHandle[] measureScopeHandles = this.queryHandles(mfwHandles[0], MFWModelRes.getInstance().RID_measureScope, new short[0]);
            this.toString = mfwHandles[0].toString();
            this.measureScopes = new ArrayList(measureScopeHandles.length);
            for (MFWMultiRequestHandle handle : measureScopeHandles) {
                MeasureScope measureScope = new MeasureScope(this.getConnection(), new MFWMultiRequestHandle[]{handle});
                IMeasure measure = measureScope.getMeasure();
                if (measure == null) continue;
                this.measureScopes.add(measureScope);
            }
        }

        IMetadata getLevelRef() {
            if (this.levelRef == null) {
                String levelId = this.queryValue(MFWModelRes.getInstance().RID_levelRef, new short[0]);
                this.levelRef = this.getConnection().bindMetadataReference(levelId);
            }
            return this.levelRef;
        }

        List<MeasureScope> getMeasureScopes() {
            return this.measureScopes;
        }

        @Override
        public String toString() {
            return this.toString;
        }
    }
}

