/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemfw4j;

import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.providers.ProviderManager;
import com.cognos.xqe.data.providers.olap.IOLAPDataProvider;
import com.cognos.xqe.data.providers.olap.IOLAPMetadataProvider;
import com.cognos.xqe.data.providers.olap.MetadataQueryArguments;
import com.cognos.xqe.data.providers.olap.MetadataRestriction;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.IVirtualDimension;
import com.cognos.xqe.metadata.record.DimensionRecord;
import com.cognos.xqe.metadata.record.HierarchyRecord;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqemfw4j.MFWCube;
import com.cognos.xqemfw4j.MFWDimension;
import com.cognos.xqemfw4j.MFWVirtualDefaultHierarchy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class MFWVirtualDimension
extends MFWDimension
implements IVirtualDimension {
    private String virtualID = null;

    MFWVirtualDimension(MFWCube mfwCube, DimensionRecord dimensionRecord) {
        super(mfwCube.getConnection(), null);
        this.uniqueName = dimensionRecord.getUniqueName();
        this.name = dimensionRecord.getName();
        this.uniqueID = dimensionRecord.getUniqueId();
        this.cube = mfwCube;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IHierarchy queryHierarchy(String hierarchyUName) {
        IModelDataSource modelDS = this.getCube().getModelDataSource();
        IOLAPDataProvider dataProvider = ProviderManager.getInstance().getOLAPProvider(modelDS.getInterface());
        ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        IDataSource ds = executionEnvironment.getOrAddDataSource(modelDS);
        MetadataQueryArguments mdQueryArgs = MetadataQueryArguments.buildArguments(ds, executionEnvironment, modelDS.getConnection().getExpressionLocale());
        IOLAPMetadataProvider metadataProvider = dataProvider.getMetadataProvider(mdQueryArgs);
        MetadataRestriction restrictions = new MetadataRestriction();
        if (this.getCube().getModelDataSource().getCatalog() != null) {
            restrictions.add(RestrictionType.CATALOG, modelDS.getCatalog().getUniqueName());
        }
        restrictions.add(RestrictionType.CUBE, this.getCube().getUniqueName());
        restrictions.add(RestrictionType.DIMENSION_UNIQUE_NAME, this.getUniqueName());
        restrictions.add(RestrictionType.HIERARCHY_UNIQUE_NAME, hierarchyUName);
        List<HierarchyRecord> records = null;
        try {
            records = metadataProvider.getHierarchies(restrictions);
            MFWVirtualDefaultHierarchy vHier = new MFWVirtualDefaultHierarchy(this, records.get(0));
            if (ds.getType().equals("BW")) {
                ArrayList<MFWVirtualDefaultHierarchy> hiers = new ArrayList<MFWVirtualDefaultHierarchy>();
                if (this.hierarchies != null) {
                    hiers.addAll(this.hierarchies);
                }
                hiers.add(vHier);
                this.hierarchies = Collections.unmodifiableList(hiers);
            }
            MFWVirtualDefaultHierarchy mFWVirtualDefaultHierarchy = vHier;
            return mFWVirtualDefaultHierarchy;
        }
        finally {
            metadataProvider.release();
        }
    }

    @Override
    public String getV5UniqueName() {
        String parentName = this.cube.getUniqueName();
        return UniqueNameGenerator.appendUniqueName(parentName, this.getName());
    }

    @Override
    public String getID() {
        if (this.virtualID == null) {
            return this.buildID() + "/" + this.getName();
        }
        return this.virtualID;
    }

    @Override
    public boolean isAutoGenerated() {
        return true;
    }

    @Override
    protected boolean containsShortcut() {
        return false;
    }

    @Override
    public List<IHierarchy> getHierarchies() {
        return this.hierarchies;
    }
}

