/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemfw4j;

import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.util.IParameterMaps;
import com.cognos.xqe.util.xml.XMLUtils;
import com.cognos.xqemfw4j.MFWMetadata;
import com.cognos.xqemfw4j.MFWMetadataConnection;
import com.cognos.xqemfw4j.MFWMultiRequestHandle;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class ParameterMapsModel
extends MFWMetadata
implements IParameterMaps {
    int priority = IParameterMaps.EPRIORITY.MODEL.getKey();
    private String id = null;
    private final Map<String, Map<String, String>> entriesMap = new ConcurrentHashMap<String, Map<String, String>>();
    String[] mapNames = null;
    private String queryParameterMapByName = "/parameterMap[name=%s]";

    ParameterMapsModel(MFWMetadataConnection mfwConnection, MFWMultiRequestHandle[] mfwHandle) {
        super(mfwConnection, mfwHandle);
    }

    @Override
    public String get(String nameOfMap, String key) {
        Map<String, String> theMap = this.getAllEntries(nameOfMap);
        return theMap.get(key);
    }

    @Override
    public String get(String key) {
        return this.get("_env", key);
    }

    @Override
    public Map<String, String> getAllEntries(String nameOfMap) {
        Map<String, String> map = this.entriesMap.get(nameOfMap);
        if (map != null) {
            return map;
        }
        map = new ConcurrentHashMap<String, String>();
        String query = String.format("/parameterMap[name=%s]/parameterMapEntry", XMLUtils.xPathLiteral(nameOfMap));
        MFWMultiRequestHandle[] entries = this.getConnection().queryHandles(this.getHandle(), query);
        if (entries != null) {
            for (MFWMultiRequestHandle entry : entries) {
                String key = this.getConnection().queryValue(entry, MFWModelRes.getInstance().RID_key, new short[0]);
                String value = this.getConnection().queryValue(entry, MFWModelRes.getInstance().RID_value, new short[0]);
                if (key == null || value == null) continue;
                map.put(key, value);
            }
        }
        this.entriesMap.put(nameOfMap, map);
        return map;
    }

    @Override
    public String[] getMapNames() {
        if (this.mapNames == null) {
            this.loadMapNamesFromModel();
        }
        return this.mapNames;
    }

    private void loadMapNamesFromModel() {
        ArrayList<String> mapNamesArray = new ArrayList<String>();
        MFWMultiRequestHandle[] mapNamesHandle = this.queryHandles(MFWModelRes.getInstance().RID_parameterMap, MFWModelRes.getInstance().RID_name);
        if (mapNamesHandle != null) {
            for (MFWMultiRequestHandle aMap : mapNamesHandle) {
                if (this.getConnection().queryHandle(aMap.getParent(), MFWModelRes.getInstance().RID_parameterMapEntry, new short[0]) == null) continue;
                mapNamesArray.add(this.getConnection().queryValue(aMap));
            }
        }
        this.mapNames = mapNamesArray.toArray(new String[mapNamesArray.size()]);
    }

    @Override
    public String getDefault(String nameOfMap) {
        String defaultValueProperty = null;
        String query = String.format(this.queryParameterMapByName, XMLUtils.xPathLiteral(nameOfMap));
        MFWMultiRequestHandle entryFound = this.getConnection().queryHandle(this.getHandle(), query);
        if (entryFound != null) {
            defaultValueProperty = this.getConnection().queryValue(entryFound, MFWModelRes.getInstance().RID_defaultValue, new short[0]);
        }
        return defaultValueProperty;
    }

    @Override
    public boolean getHiddenProperty(String mapName) {
        String hiddenProperty = this.getHiddenPropertyFromModel(mapName);
        if (hiddenProperty != null) {
            return Boolean.valueOf(hiddenProperty);
        }
        return false;
    }

    private String getHiddenPropertyFromModel(String mapName) {
        String hiddenProperty = null;
        String query = String.format(this.queryParameterMapByName, XMLUtils.xPathLiteral(mapName));
        MFWMultiRequestHandle entryFound = this.getConnection().queryHandle(this.getHandle(), query);
        if (entryFound != null) {
            hiddenProperty = this.getConnection().queryValue(entryFound, MFWModelRes.getInstance().RID_hidden, new short[0]);
        }
        return hiddenProperty;
    }

    @Override
    public void setDefault(String nameOfMap, String value) {
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int newPriority) {
        this.priority = IParameterMaps.EPRIORITY.MODEL.getKey();
    }

    @Override
    public ArrayList<String> getArray(String map, String key) throws XQERuntimeException {
        ArrayList<String> value = null;
        String valStr = this.get(map, key);
        if (valStr != null) {
            value = new ArrayList<String>();
            value.add(valStr);
        }
        return value;
    }

    @Override
    public ArrayList<String> getArray(String key) throws XQERuntimeException {
        return this.getArray("_env", key);
    }

    @Override
    public Map<String, ArrayList<String>> getArrayAllEntries(String nameOfMap) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getID() {
        if (this.id == null) {
            this.id = this.queryValue(MFWModelRes.getInstance().RID_ID, new short[0]);
        }
        return this.id;
    }

    @Override
    public boolean isModelMap() {
        return true;
    }

    @Override
    public boolean isQueryItemMap() {
        return false;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof ParameterMapsModel) {
            return ((ParameterMapsModel)other).getID().equals(this.id);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getID().hashCode();
    }
}

