/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemfw4j;

import com.cognos.i18n.Calendar;
import com.cognos.i18n.DateTimeFormat;
import com.cognos.i18n.NumericFormat;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.macro.MacroExpander;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.DateType;
import com.cognos.xqe.data.types.DoubleType;
import com.cognos.xqe.data.types.ExactNumericType;
import com.cognos.xqe.data.types.FloatType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.IntervalDayTimeType;
import com.cognos.xqe.data.types.IntervalYearMonthType;
import com.cognos.xqe.data.types.NumericType;
import com.cognos.xqe.data.types.TimeType;
import com.cognos.xqe.data.types.TimeWithTZType;
import com.cognos.xqe.data.types.TimestampType;
import com.cognos.xqe.data.types.TimestampWithTZType;
import com.cognos.xqe.data.values.DateValue;
import com.cognos.xqe.data.values.ExactNumericValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.IntegerValue;
import com.cognos.xqe.data.values.IntervalDayTimeValue;
import com.cognos.xqe.data.values.IntervalYearMonthValue;
import com.cognos.xqe.data.values.LongValue;
import com.cognos.xqe.data.values.NumericValue;
import com.cognos.xqe.data.values.SmallintValue;
import com.cognos.xqe.data.values.TimeValue;
import com.cognos.xqe.data.values.TimeWithTZValue;
import com.cognos.xqe.data.values.TimestampValue;
import com.cognos.xqe.data.values.TimestampWithTZValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.IMessageKey;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.NagParameterMapBasedQueryItemSubquery;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.TransformationEngine;
import com.cognos.xqe.query.engine.UnresolvedParameterException;
import com.cognos.xqe.query.executor.QueryExecutor;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.query.planner.QueryPlanner;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIEdgeIterator;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.rsapi.RSAPIPartialDataset;
import com.cognos.xqe.rsapi.RSAPIRow;
import com.cognos.xqe.rsapi.RSAPIRowset;
import com.cognos.xqe.runtree.relational.XSql;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.transformation.v5.util.V5SubQueryBuilder;
import com.cognos.xqe.util.ConcurrentParameterAccessCoordinator;
import com.cognos.xqe.util.Governors;
import com.cognos.xqe.util.IParameterMaps;
import com.cognos.xqe.util.LoopDetectionChain;
import com.cognos.xqe.util.ParameterAccessCoordinator;
import com.cognos.xqe.util.ParameterMapsApp;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqemfw4j.MFWMetadata;
import com.cognos.xqemfw4j.MFWMetadataConnection;
import com.cognos.xqemfw4j.MFWMultiRequestHandle;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

class ParameterMapsQI
extends MFWMetadata
implements IParameterMaps {
    private static final String NAME = "name";
    private final ParameterAccessCoordinator qiPAC;
    private int priority = IParameterMaps.EPRIORITY.MODEL.getKey();
    private final Map<String, Boolean> mapsAllEntriesLoaded = new ConcurrentHashMap<String, Boolean>();
    private String id = null;
    private String[] mapNames = null;
    private String queryParameterMapByName = "/parameterMap[name='%s']";
    private static final int CONVERT_MILLIS = 1000;
    private static final String START_TIME = "startTime";
    private ConcurrentHashMap<IParameterMaps, TimeInfo> ageOfMaps = new ConcurrentHashMap();
    private static final int DOUBLE_FRACTIONAL_DIGITS = 15;
    private static final int FLOAT_FRACTIONAL_DIGITS = 6;
    private static final int NUMBER_TEN = 10;
    private static final int FOR_NANO_SECONDS = 1000000;
    private static final int NUMBER_THIRTEEN = 13;
    private static final int NUMBER_TWENTYTWO = 22;
    private static final int NUMBER_NINEHUNDREDNINTYNINE = 999;
    private static final double NUMBER_ONEEMINUSSEVEN = 1.0E-7;
    private static final double NUMBER_NINEEPLUSNINE = 9.0E9;
    private static final String STRING_OVERNINEEPLUSNINE = "0.##############E+0";
    private static final String STRING_HOUR = "hour";
    private static final String STRING_MINUTE = "minute";
    private static final String STRING_SECOND = "second";
    private static final String STRING_ZERO = "0";
    private static final String STRING_SPACE = " ";
    private static final String STRING_SPACEA = " a";
    private static final String STRING_MINUS = "-";
    private static final String STRING_COLON = ":";
    private static final String STRING_DOT = ".";
    private static final String STRING_DOTZERO = ".0";
    private static final String STRING_COLONZERODOTZERO = ":0.0";
    private static final String STRING_COLONZEROCOLONZERODOTZERO = ":0:0.0";

    ParameterMapsQI(MFWMetadataConnection mfwConnection, MFWMultiRequestHandle[] mfwHandle) {
        super(mfwConnection, mfwHandle);
        this.qiPAC = new ConcurrentParameterAccessCoordinator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String get(String nameOfMap, String key) throws XQERuntimeException {
        String value = null;
        long startTime = this.getStartTime();
        ParameterMapsQI parameterMapsQI = this;
        synchronized (parameterMapsQI) {
            if (this.qiPAC.getAllMapsWithMapName(nameOfMap).isEmpty()) {
                value = this.getValueLoadedFromModel(nameOfMap, key);
            } else if (this.qiMapAllEntriesLoaded(nameOfMap)) {
                IParameterMaps aMap = this.qiPAC.getAllMapsWithMapName(nameOfMap).get(0);
                if (this.dataIsTooOld(aMap, nameOfMap, startTime).booleanValue()) {
                    this.qiPAC.removeParameterMap(aMap);
                    this.ageOfMaps.remove(aMap);
                    value = this.getValueLoadedFromModel(nameOfMap, key);
                } else {
                    value = this.qiPAC.get(nameOfMap, key);
                }
            } else {
                value = this.qiPAC.get(nameOfMap, key, false);
                IParameterMaps aMap = this.qiPAC.getSpecificMap(nameOfMap, key);
                if (value != null && this.dataIsTooOld(aMap, nameOfMap, startTime).booleanValue()) {
                    this.qiPAC.removeParameterMap(aMap);
                    this.ageOfMaps.remove(aMap);
                    value = this.getValueLoadedFromModel(nameOfMap, key);
                }
                if (value == null) {
                    value = this.getValueLoadedFromModel(nameOfMap, key);
                }
            }
        }
        if (value == null) {
            value = this.qiPAC.getDefault(nameOfMap);
        }
        return value;
    }

    private HashMap<String, ArrayList<String>> loadFromModel(String nameOfMap, String key) {
        MFWMultiRequestHandle[] entriesFound;
        ExecutionEnvironment execEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        if (null == execEnv) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_ExecutionEnvironmentMissing_INTERNAL);
        }
        PlanningEnvironment planEnv = QueryPlanner.setupEnvironment(execEnv.getRequestEnvironment());
        if (execEnv.getGovernors() == null) {
            Governors governors = new Governors();
            execEnv.setGovernors(governors);
            governors.loadGovernors(((RequestEnvironment)execEnv.getRequestEnvironment()).getRequestPAC());
        }
        if ((entriesFound = this.queryHandles(MFWModelRes.getInstance().RID_parameterMap, MFWModelRes.getInstance().RID_queryItemMap)) != null) {
            for (MFWMultiRequestHandle anEntry : entriesFound) {
                int fr;
                MFWMultiRequestHandle paramMap = anEntry.getParent();
                String name = this.getConnection().queryValue(paramMap, MFWModelRes.getInstance().RID_name, new short[0]);
                if (!name.equals(nameOfMap)) continue;
                String keyRef = this.getConnection().queryValue(anEntry, MFWModelRes.getInstance().RID_keyRef, new short[0]);
                String valRef = this.getConnection().queryValue(anEntry, MFWModelRes.getInstance().RID_valueRef, new short[0]);
                String defaultVal = this.getConnection().queryValue(paramMap, MFWModelRes.getInstance().RID_defaultValue, new short[0]);
                String freshness = this.getConnection().queryValue(paramMap, MFWModelRes.getInstance().RID_freshness, new short[0]);
                if (freshness == null) {
                    fr = -1;
                } else {
                    if (MacroExpander.isMacro(freshness)) {
                        MacroExpander expander = new MacroExpander();
                        freshness = expander.expand(null, planEnv, freshness);
                    }
                    try {
                        int origfr = Integer.parseInt(freshness);
                        fr = origfr > 2147483 ? Integer.MAX_VALUE : origfr * 1000;
                    }
                    catch (NumberFormatException e) {
                        fr = -1;
                        IMessageKey.Param2 messageKey = XQEMessageKeys.FRE_InvalidFreshnessValue;
                        Locale locale = XQEMessages.getCurrProductLocale();
                        String nagmsg = XQEMessages.getMessage(messageKey, locale, freshness, name);
                        execEnv.addNag(nagmsg);
                        FreshnessLogger.log(nagmsg);
                    }
                    if (fr < -1) {
                        fr = -1;
                    }
                }
                String detailFilter = null;
                if (key != null && this.getConnection().queryValue(paramMap, MFWModelRes.getInstance().getResourceID("loadAsNeeded"), new short[0]).equals("true")) {
                    detailFilter = key;
                }
                LoopDetectionChain ldc = execEnv.getMultiRequestContext().getQIParameterMapLDC();
                HashMap<Object, Object> resultMap = null;
                try {
                    if (!ldc.push(nameOfMap)) {
                        throw new XQERuntimeException(XQEMessageKeys.PLN_LoopInParamMap, nameOfMap);
                    }
                    resultMap = this.loadFromDatabase(this.connection.getModelName(), keyRef, valRef, detailFilter, nameOfMap, execEnv);
                }
                catch (UnresolvedParameterException upe) {
                    if ("getParameters".equals(((RequestEnvironment)execEnv.getRequestEnvironment()).getOperationName())) {
                        resultMap = new HashMap();
                        ArrayList<String> values = new ArrayList<String>();
                        if (defaultVal != null) {
                            values.add(defaultVal);
                        } else {
                            values.add(this.getDummyValue(valRef));
                        }
                        resultMap.put(key, values);
                        HashMap<Object, Object> hashMap = resultMap;
                        return hashMap;
                    }
                    throw upe;
                }
                finally {
                    ldc.pop();
                }
                ParameterMapsApp aMap = new ParameterMapsApp(name, IParameterMaps.EPRIORITY.MODEL.getKey());
                aMap.setDefault(name, defaultVal);
                for (Map.Entry<Object, Object> entry : resultMap.entrySet()) {
                    aMap.setArray(name, (String)entry.getKey(), (ArrayList)entry.getValue());
                }
                this.qiPAC.addParameterMap(aMap);
                this.ageOfMaps.put(aMap, new TimeInfo(System.currentTimeMillis(), fr));
                if (detailFilter == null) {
                    this.recordQIMapAllEntriesLoaded(nameOfMap);
                }
                return resultMap;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<String, ArrayList<String>> loadFromDatabase(String modelName, String keyRef, String valRef, String detailFilter, String mapName, ExecutionEnvironment execEnv) {
        boolean validationAtInfoLevel;
        RequestEnvironment reqEnv = (RequestEnvironment)execEnv.getRequestEnvironment();
        PlanningEnvironment planEnv = QueryPlanner.setupEnvironment(reqEnv);
        PlanningEnvironment subPlanEnv = V5SubQueryBuilder.createPlanningEnvironment(execEnv, planEnv);
        ExecutionEnvironment subExecEnv = (ExecutionEnvironment)subPlanEnv.getExecutionEnvironment();
        RequestEnvironment subReqEnv = (RequestEnvironment)subExecEnv.getRequestEnvironment();
        V5QuerySet v5QuerySet = this.createQuery(modelName, keyRef, valRef, detailFilter, subPlanEnv);
        V5QueryResultDefinition v5QueryResultDefiniton = (V5QueryResultDefinition)v5QuerySet.getFirstChildByType(101055);
        boolean bl = validationAtInfoLevel = "validate".equals(reqEnv.getOperationName()) && reqEnv.getMaxSeverityLevel() == 3;
        if (validationAtInfoLevel) {
            v5QueryResultDefiniton.addQueryFeedback("CognosCommandText");
            v5QueryResultDefiniton.addQueryFeedback("nativeCommandText");
        }
        subReqEnv.setOperationName("execute");
        Parameters parameters = subReqEnv.getRequestParameters();
        Parameters unresolvedParams = parameters.getUnresolvedParameters();
        for (Parameter parameter : unresolvedParams.values()) {
            parameters.removeParameter(parameter.getName());
        }
        try {
            TransformationEngine.getInstance().applyTransformations(v5QuerySet, subPlanEnv);
        }
        catch (UnresolvedParameterException upe) {
            parameters.putAll(unresolvedParams);
            throw new UnresolvedParameterException(reqEnv, v5QuerySet, parameters);
        }
        parameters.putAll(unresolvedParams);
        IXQEQueryNode[] results = v5QuerySet.getChildrenOfType(401005);
        if (results == null || results.length != 1) {
            return null;
        }
        RSAPIDataset dataset = (RSAPIDataset)results[0];
        if (validationAtInfoLevel) {
            NagParameterMapBasedQueryItemSubquery nag = new NagParameterMapBasedQueryItemSubquery();
            nag.setActualQueryName(dataset.getName());
            nag.setParameterMapName(mapName);
            nag.setCognosSQL(dataset.getCognosSQL());
            for (IXQEQueryNode xSql : this.findNativeSqlNodes(dataset)) {
                nag.addNativeSQL(((XSql)xSql).getSqlText());
            }
            execEnv.addNag(nag);
        }
        if (dataset.getNumEdges() != 1) {
            return null;
        }
        RSAPIEdge edge = dataset.getEdge(0);
        if (edge.getNumRowsets() != 1) {
            return null;
        }
        RSAPIEdgeRowset rowset = edge.getRowset(0);
        if (((RSAPIRowset)rowset).getNumColumns() != 2) {
            return null;
        }
        int[] startRowNumbers = new int[1];
        int[] numRows = new int[1];
        startRowNumbers[0] = 1;
        numRows[0] = 0;
        RSAPIPartialDataset partialDataset = null;
        boolean includeContext = false;
        boolean includeContextValues = false;
        HashMap<String, ArrayList<String>> theResult = new HashMap<String, ArrayList<String>>();
        partialDataset = QueryExecutor.getInstance().getPartialDataset(dataset, startRowNumbers, numRows, includeContext, includeContextValues, subExecEnv);
        try {
            subPlanEnv.setPlanningActive(subReqEnv);
            try (RSAPIEdgeIterator it = partialDataset.edgeIterator(0);){
                boolean bGovernorSettingIsOFF;
                int numRowsRead = 0;
                boolean bl2 = bGovernorSettingIsOFF = execEnv.getGovernors().getFormatQueryItemsForParameterMaps() == Governors.FormatQueryItemsForParameterMaps.OFF;
                while (it.hasNext()) {
                    IDataType dataType;
                    RSAPIRow row = it.next();
                    IValue kval = row.getColumn(0);
                    IValue vval = row.getColumn(1);
                    if (bGovernorSettingIsOFF) {
                        this.convertToNonFormattedString(kval, vval, theResult);
                    } else {
                        this.convertToFormattedString(kval, vval, theResult);
                    }
                    if (numRowsRead == 0 && validationAtInfoLevel && ((dataType = kval.getDataType()) == DoubleType.DOUBLETYPE || dataType == FloatType.FLOATTYPE)) {
                        String dataTypeName = dataType.getTypeName();
                        IMessageKey.Param3 messageKey = XQEMessageKeys.PLN_ParameterMapQueryItemDoubleFloatKey;
                        Locale locale = XQEMessages.getCurrProductLocale();
                        String nagmsg = XQEMessages.getMessage(messageKey, locale, mapName, dataTypeName, "cast");
                        execEnv.addNag(nagmsg);
                    }
                    ++numRowsRead;
                }
            }
        }
        finally {
            partialDataset.release();
            dataset.releaseResultset(subExecEnv);
        }
        return theResult;
    }

    public V5QuerySet createQuery(String modelName, String keyRef, String valRef, String detailFilter, PlanningEnvironment planEnv) {
        XQENodeFactory nf = planEnv.getNodeFactory();
        if (nf == null) {
            return null;
        }
        String q1 = "q1";
        String ki = "ki";
        String aggregate = "aggregate";
        String vi = "vi";
        String none = "none";
        String refDataItem = "refDataItem";
        V5QuerySet v5QuerySet = (V5QuerySet)nf.createNode(101002);
        v5QuerySet.setStringPropertyValue("modelPath", modelName);
        v5QuerySet.addToIndex();
        IXQEQueryNode v5Query = nf.createNode(101006);
        v5Query.setPropertyValue(NAME, q1);
        v5QuerySet.addChild(v5Query);
        V5Source v5Source = (V5Source)nf.createNode(101007);
        v5Source.setModel(modelName);
        v5Query.addChild(v5Source);
        v5Query.setPropertyValue(V5Query.QueryHint.LOCAL_CACHE.getPropertyName(), false);
        v5Query.setPropertyValue("containsQueryHint", true);
        IXQEQueryNode v5Selection = nf.createNode(101009);
        v5Selection.setPropertyValue("autoSummary", false);
        v5Query.addChild(v5Selection);
        if (detailFilter != null) {
            IXQEQueryNode v5DetailFilters = nf.createNode(101008);
            v5Query.addChild(v5DetailFilters);
            IXQEQueryNode v5FilterExpression = nf.createNode(101013);
            v5DetailFilters.addChild(v5FilterExpression);
            v5FilterExpression.setPropertyValue("expression", keyRef + " = '" + detailFilter + "'");
        }
        IXQEQueryNode v5DataItem = nf.createNode(101003);
        v5DataItem.setPropertyValue(NAME, ki);
        v5DataItem.setPropertyValue(aggregate, none);
        v5Selection.addChild(v5DataItem);
        IXQEQueryNode v5Expression = nf.createNode(101004);
        v5Expression.setPropertyValue("expression", keyRef);
        v5DataItem.addChild(v5Expression);
        v5DataItem = nf.createNode(101003);
        v5DataItem.setPropertyValue(NAME, vi);
        v5DataItem.setPropertyValue(aggregate, none);
        v5Selection.addChild(v5DataItem);
        v5Expression = nf.createNode(101004);
        v5Expression.setPropertyValue("expression", valRef);
        v5DataItem.addChild(v5Expression);
        V5QueryResultDefinition v5QueryResultDefiniton = (V5QueryResultDefinition)nf.createNode(101055);
        v5QueryResultDefiniton.setPropertyValue("refQuery", q1);
        v5QueryResultDefiniton.setPropertyValue(NAME, "qrd1");
        v5QuerySet.addChild(v5QueryResultDefiniton);
        IXQEQueryNode v5Edge = nf.createNode(101049);
        v5Edge.setPropertyValue(NAME, "e");
        v5QueryResultDefiniton.addChild(v5Edge);
        IXQEQueryNode v5EdgeGroup = nf.createNode(101050);
        v5Edge.addChild(v5EdgeGroup);
        IXQEQueryNode v5ValueSet = nf.createNode(101057);
        v5ValueSet.setPropertyValue(NAME, "vs");
        v5EdgeGroup.addChild(v5ValueSet);
        IXQEQueryNode v5GroupBody = nf.createNode(101051);
        v5GroupBody.setPropertyValue(NAME, "gb");
        v5ValueSet.addChild(v5GroupBody);
        IXQEQueryNode v5DataItemRef = nf.createNode(101015);
        v5DataItemRef.setPropertyValue(refDataItem, ki);
        v5GroupBody.addChild(v5DataItemRef);
        v5DataItemRef = nf.createNode(101015);
        v5DataItemRef.setPropertyValue(refDataItem, vi);
        v5GroupBody.addChild(v5DataItemRef);
        return v5QuerySet;
    }

    @Override
    public String get(String key) throws XQERuntimeException {
        return null;
    }

    @Override
    public Map<String, String> getAllEntries(String nameOfMap) {
        Map<String, String> entries = null;
        if (this.qiPAC.getAllMapsWithMapName(nameOfMap).isEmpty()) {
            HashMap<String, ArrayList<String>> temp = this.loadFromModel(nameOfMap, null);
            entries = new HashMap<String, String>();
            for (Map.Entry entry : temp.entrySet()) {
                ArrayList val = (ArrayList)entry.getValue();
                entries.put((String)entry.getKey(), (String)val.get(val.size() - 1));
            }
            this.recordQIMapAllEntriesLoaded(nameOfMap);
        } else {
            entries = this.qiPAC.getAllEntries(nameOfMap);
        }
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<String> getArray(String nameOfMap, String key) throws XQERuntimeException {
        ArrayList<String> value = null;
        long startTime = this.getStartTime();
        ParameterMapsQI parameterMapsQI = this;
        synchronized (parameterMapsQI) {
            if (this.qiPAC.getAllMapsWithMapName(nameOfMap).isEmpty()) {
                value = this.loadFromModel(nameOfMap, key).get(key);
            } else if (this.qiMapAllEntriesLoaded(nameOfMap)) {
                IParameterMaps aMap = this.qiPAC.getAllMapsWithMapName(nameOfMap).get(0);
                if (this.dataIsTooOld(aMap, nameOfMap, startTime).booleanValue()) {
                    this.qiPAC.removeParameterMap(aMap);
                    this.ageOfMaps.remove(aMap);
                    value = this.loadFromModel(nameOfMap, key).get(key);
                } else {
                    value = this.qiPAC.getArray(nameOfMap, key);
                }
            } else {
                value = this.qiPAC.getArray(nameOfMap, key);
                IParameterMaps aMap = this.qiPAC.getSpecificMap(nameOfMap, key);
                if (value != null && this.dataIsTooOld(aMap, nameOfMap, startTime).booleanValue()) {
                    this.qiPAC.removeParameterMap(aMap);
                    this.ageOfMaps.remove(aMap);
                    value = this.loadFromModel(nameOfMap, key).get(key);
                }
                if (value == null) {
                    value = this.loadFromModel(nameOfMap, key).get(key);
                }
            }
        }
        if (value == null) {
            value = new ArrayList();
            String val = this.qiPAC.getDefault(nameOfMap);
            value.add(val);
        }
        return value;
    }

    @Override
    public ArrayList<String> getArray(String key) throws XQERuntimeException {
        return this.getArray("_env", key);
    }

    @Override
    public Map<String, ArrayList<String>> getArrayAllEntries(String nameOfMap) {
        Map<String, ArrayList<String>> entries = null;
        if (this.qiPAC.getAllMapsWithMapName(nameOfMap).isEmpty()) {
            entries = this.loadFromModel(nameOfMap, null);
            this.recordQIMapAllEntriesLoaded(nameOfMap);
        } else {
            entries = this.qiPAC.getArrayAllEntries(nameOfMap);
        }
        return entries;
    }

    @Override
    public String getDefault(String nameOfMap) {
        String defaultValue = null;
        if (this.qiPAC.getAllMapsWithMapName(nameOfMap).isEmpty()) {
            String query = String.format(this.queryParameterMapByName, nameOfMap);
            MFWMultiRequestHandle entryFound = this.getConnection().queryHandle(this.getHandle(), query);
            defaultValue = entryFound != null ? this.getConnection().queryValue(entryFound, MFWModelRes.getInstance().RID_defaultValue, new short[0]) : null;
        } else {
            defaultValue = this.qiPAC.getDefault(nameOfMap);
        }
        return defaultValue;
    }

    @Override
    public String[] getMapNames() {
        if (this.mapNames == null) {
            this.loadMapNamesFromModel();
        }
        return this.mapNames;
    }

    private void loadMapNamesFromModel() {
        ArrayList<String> mapNamesArrayList = new ArrayList<String>();
        MFWMultiRequestHandle[] mapHandle = this.queryHandles(MFWModelRes.getInstance().RID_parameterMap, MFWModelRes.getInstance().RID_name);
        if (mapHandle != null) {
            for (MFWMultiRequestHandle aMap : mapHandle) {
                if (this.getConnection().queryHandle(aMap.getParent(), MFWModelRes.getInstance().RID_queryItemMap, new short[0]) == null) continue;
                mapNamesArrayList.add(this.getConnection().queryValue(aMap));
            }
        }
        String[] mapNamesArray = mapNamesArrayList.toArray(new String[mapNamesArrayList.size()]);
        this.mapNames = mapNamesArray;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setDefault(String nameOfMap, String value) {
        this.qiPAC.setDefault(nameOfMap, value);
    }

    @Override
    public void setPriority(int newPriority) {
        this.priority = IParameterMaps.EPRIORITY.MODEL.getKey();
    }

    private boolean qiMapAllEntriesLoaded(String nameOfMap) {
        return this.mapsAllEntriesLoaded.containsKey(nameOfMap);
    }

    private void recordQIMapAllEntriesLoaded(String nameOfMap) {
        this.mapsAllEntriesLoaded.put(nameOfMap, true);
    }

    @Override
    public String getID() {
        if (this.id == null) {
            this.id = this.queryValue(MFWModelRes.getInstance().RID_ID, new short[0]);
        }
        return this.id;
    }

    private List<IXQEQueryNode> findNativeSqlNodes(IXQEQueryNode root) {
        ArrayList<IXQEQueryNode> nodeList = new ArrayList<IXQEQueryNode>();
        this.findNativeSqlNodes(root, nodeList);
        return nodeList;
    }

    private void findNativeSqlNodes(IXQEQueryNode aNode, List<IXQEQueryNode> nodeList) {
        if (aNode instanceof XSql) {
            nodeList.add(aNode);
        }
        for (int i = 0; i < aNode.getNumberChildren(); ++i) {
            this.findNativeSqlNodes(aNode.getChild(i), nodeList);
        }
    }

    @Override
    public boolean getHiddenProperty(String mapName) {
        String hiddenProperty = this.getHiddenPropertyFromModel(mapName);
        if (hiddenProperty != null) {
            return Boolean.valueOf(hiddenProperty);
        }
        return false;
    }

    private String getHiddenPropertyFromModel(String mapName) {
        String hiddenProperty = null;
        String query = String.format(this.queryParameterMapByName, mapName);
        MFWMultiRequestHandle entryFound = this.getConnection().queryHandle(this.getHandle(), query);
        if (entryFound != null) {
            hiddenProperty = this.getConnection().queryValue(entryFound, MFWModelRes.getInstance().RID_hidden, new short[0]);
        }
        return hiddenProperty;
    }

    private String getValueLoadedFromModel(String nameOfMap, String key) {
        String value = null;
        ArrayList<String> temp = this.loadFromModel(nameOfMap, key).get(key);
        if (temp != null) {
            value = temp.get(temp.size() - 1);
        }
        return value;
    }

    private Boolean dataIsTooOld(IParameterMaps aMap, String nameOfMap, long startTime) {
        long createdTime = this.ageOfMaps.get(aMap).getCreatedTime();
        long mapAge = this.ageOfMaps.get(aMap).getMaxAgeInMilliSeconds();
        if (mapAge < 0L) {
            return false;
        }
        if (createdTime + mapAge < startTime) {
            IMessageKey.Param1 messageKey = XQEMessageKeys.FRE_FreshnessExpired;
            Locale locale = XQEMessages.getCurrProductLocale();
            FreshnessLogger.log(XQEMessages.getMessage(messageKey, locale, nameOfMap));
            return true;
        }
        IMessageKey.Param1 messageKey = XQEMessageKeys.FRE_FreshnessGood;
        Locale locale = XQEMessages.getCurrProductLocale();
        FreshnessLogger.log(XQEMessages.getMessage(messageKey, locale, nameOfMap));
        return false;
    }

    private long getStartTime() {
        Element startTimeElem;
        ExecutionEnvironment execEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        RequestEnvironment reqEnv = (RequestEnvironment)execEnv.getRequestEnvironment();
        long startTime = -1L;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        Element infoElem = reqEnv.getInfo();
        if (infoElem == null) {
            infoElem = DocumentHelper.createElement((String)"info");
            reqEnv.setInfo(infoElem);
        }
        if ((startTimeElem = infoElem.element(START_TIME)) == null) {
            startTime = System.currentTimeMillis();
            String startTimeString = dateFormat.format(new Date(System.currentTimeMillis()));
            startTimeElem = infoElem.addElement(START_TIME);
            startTimeElem.setText(startTimeString);
        } else {
            String startTimeString = startTimeElem.getText();
            startTimeString = startTimeString.trim();
            try {
                Date date = dateFormat.parse(startTimeString);
                startTime = date.getTime();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return startTime;
    }

    @Override
    public boolean isModelMap() {
        return false;
    }

    @Override
    public boolean isQueryItemMap() {
        return true;
    }

    public String getDummyValue(String valRef) {
        IMetadata md = this.getConnection().bindMetadataReference(valRef);
        IDataType dt = md.getDataType();
        String dummyVal = "";
        if (dt != null) {
            if (dt.isNumeric()) {
                dummyVal = "1";
            } else {
                switch (dt.getCCLTypeCode()) {
                    case 57: {
                        dummyVal = "2006-05-01";
                        break;
                    }
                    case 58: {
                        dummyVal = "12:00:00.000";
                        break;
                    }
                    case 60: {
                        dummyVal = "1 02:03:04.000";
                        break;
                    }
                    case 17: {
                        dummyVal = "1-02";
                        break;
                    }
                    case 52: {
                        dummyVal = "12:00:00.000-05:00";
                        break;
                    }
                    case 59: {
                        dummyVal = "2006-05-01 12:00:00.000-05:00";
                        break;
                    }
                    case 53: {
                        dummyVal = "2006-05-01 12:00:00.000";
                        break;
                    }
                    default: {
                        dummyVal = "";
                    }
                }
            }
        }
        return dummyVal;
    }

    String getFormatedValueStr(Value value) {
        String valueString = new String();
        IDataType dataType = value.getDataType();
        valueString = dataType instanceof ExactNumericType ? this.getExactNumericValue(value) : (dataType instanceof NumericType ? this.getNumericValue(value) : (dataType instanceof TimestampWithTZType ? this.getTimeStampTZValue(value) : (dataType instanceof TimestampType ? this.getTimeStampValue(value) : (dataType instanceof IntervalYearMonthType ? this.getIntervalYearMonthValue(value) : (dataType instanceof IntervalDayTimeType ? this.getIntervalDayTimeValue(value) : (dataType instanceof DateType ? this.getDateValue(value) : (dataType instanceof TimeWithTZType ? this.getTimeWithTZValue(value) : (dataType instanceof TimeType ? this.getTimeValue(value) : value.toString()))))))));
        return valueString;
    }

    private String getTimeWithTZValue(Value value) {
        String timeValueString = this.getTimeValue(value);
        TimeWithTZValue ttzValue = (TimeWithTZValue)value;
        return this.addTimeZone(timeValueString, ttzValue.getTimeZoneHour(), ttzValue.getTimeZoneMinute());
    }

    private String getTimeValue(Value value) {
        TimeValue timeValue = (TimeValue)value;
        Calendar cal = new Calendar();
        int hour = timeValue.getHour();
        cal.set(timeValue.getYear(), timeValue.getMonth() - 1, timeValue.getDay(), hour, timeValue.getMinute(), timeValue.getSecond());
        String tsFormatString = null;
        tsFormatString = hour >= 0 && hour < 10 || hour >= 13 && hour <= 22 ? "h:mm:ss" : "hh:mm:ss";
        DateTimeFormat fmt = new DateTimeFormat(tsFormatString, null);
        String valueString = fmt.format(cal);
        int nanoSeconds = timeValue.getNanoseconds();
        if (nanoSeconds >= 1000000) {
            valueString = valueString + STRING_DOT + this.getMillisecondsString(nanoSeconds);
        }
        DateTimeFormat fmtForAmPm = new DateTimeFormat(STRING_SPACEA, null);
        valueString = valueString + fmtForAmPm.format(cal);
        return valueString;
    }

    private String getDateValue(Value value) {
        DateValue dsValue = (DateValue)value;
        Calendar cal = new Calendar();
        cal.set(dsValue.getYear(), dsValue.getMonth() - 1, dsValue.getDay(), 0, 0, 0);
        DateTimeFormat fmt = new DateTimeFormat("MMM d, yyyy", null);
        String valueString = fmt.format(cal);
        return valueString;
    }

    private String getIntervalDayTimeValue(Value value) {
        String valueString = "";
        IntervalDayTimeValue idValue = (IntervalDayTimeValue)value;
        String descriptor = ((IntervalDayTimeType)value.getDataType()).getQualifier().getDescriptor();
        if (descriptor.startsWith("day")) {
            if (idValue.getSign() == -1) {
                valueString = STRING_MINUS;
            }
            valueString = valueString + idValue.getDay();
            if (idValue.getHour() == 0 && idValue.getMinute() == 0 && idValue.getSecond() == 0 && idValue.getNanoseconds() < 1000000) {
                valueString = valueString + "0 0:0:0.0";
                return valueString;
            }
            if (descriptor.endsWith(STRING_HOUR)) {
                valueString = valueString + STRING_SPACE + idValue.getHour() + STRING_COLONZEROCOLONZERODOTZERO;
            } else if (descriptor.endsWith(STRING_MINUTE)) {
                valueString = valueString + STRING_SPACE + idValue.getHour() + STRING_COLON + idValue.getMinute() + STRING_COLONZERODOTZERO;
            } else if (descriptor.endsWith(STRING_SECOND)) {
                valueString = valueString + STRING_SPACE + idValue.getHour() + STRING_COLON + idValue.getMinute() + STRING_COLON + idValue.getSecond() + STRING_DOTZERO;
            }
        } else if (descriptor.startsWith(STRING_HOUR)) {
            valueString = idValue.getSign() == -1 ? "-0 " : "0 ";
            valueString = valueString + idValue.getHour();
            if (idValue.getMinute() == 0 && idValue.getSecond() == 0 && idValue.getNanoseconds() < 1000000) {
                valueString = valueString + STRING_COLONZEROCOLONZERODOTZERO;
                return valueString;
            }
            if (descriptor.endsWith(STRING_MINUTE)) {
                valueString = valueString + STRING_COLON + idValue.getMinute() + STRING_COLONZERODOTZERO;
            } else if (descriptor.endsWith(STRING_SECOND)) {
                valueString = valueString + STRING_COLON + idValue.getMinute() + STRING_COLON + idValue.getSecond() + STRING_DOTZERO;
            }
        } else if (descriptor.startsWith(STRING_MINUTE)) {
            valueString = idValue.getSign() == -1 ? "-0 0:" : "0 0:";
            valueString = valueString + idValue.getMinute();
            if (idValue.getSecond() == 0 && idValue.getNanoseconds() < 1000000) {
                valueString = valueString + STRING_COLONZERODOTZERO;
                return valueString;
            }
            if (descriptor.endsWith(STRING_SECOND)) {
                valueString = valueString + STRING_COLON + idValue.getSecond() + STRING_DOTZERO;
            }
        } else if (descriptor.startsWith(STRING_SECOND)) {
            valueString = idValue.getSign() == -1 ? "-0 0:0:" : "0 0:0:";
            valueString = valueString + idValue.getSecond();
            if (idValue.getNanoseconds() < 1000000) {
                valueString = valueString + STRING_DOTZERO;
                return valueString;
            }
        }
        if (idValue.getNanoseconds() >= 1000000) {
            valueString = valueString + STRING_DOT + this.getMillisecondsString(idValue.getNanoseconds());
        }
        return valueString;
    }

    private String getMillisecondsString(int nanoSeconds) {
        float milli = (float)nanoSeconds / 1000000.0f;
        if (milli >= 999.0f) {
            milli = 999.0f;
        }
        return String.format("%1$03.0f", Float.valueOf(milli));
    }

    private String getIntervalYearMonthValue(Value value) {
        String valueString;
        IntervalYearMonthValue iymValue = (IntervalYearMonthValue)value;
        int year = iymValue.getYear();
        int month = iymValue.getMonth();
        if (year == 0 && month == 0) {
            return "0-0";
        }
        if (year != 0) {
            String yearStr = Integer.valueOf(year).toString();
            if (year > 999) {
                NumericFormat fmt = new NumericFormat();
                fmt.setGroupingUsed(false);
                yearStr = fmt.format((long)year);
            }
            valueString = iymValue.getSign() == -1 ? STRING_MINUS : "";
            valueString = valueString + yearStr;
            valueString = month != 0 ? valueString + STRING_MINUS + month : valueString + "-0";
        } else {
            valueString = iymValue.getSign() == -1 ? STRING_MINUS + Integer.valueOf(year).toString() + STRING_MINUS + month : Integer.valueOf(month).toString();
        }
        return valueString;
    }

    private String getTimeStampValue(Value value) {
        TimestampValue tsValue = (TimestampValue)value;
        Calendar cal = new Calendar();
        int hour = tsValue.getHour();
        int nanoSeconds = tsValue.getNanoseconds();
        cal.set(tsValue.getYear(), tsValue.getMonth() - 1, tsValue.getDay(), hour, tsValue.getMinute(), tsValue.getSecond());
        String tsFormatString = null;
        tsFormatString = hour >= 0 && hour < 10 || hour >= 13 && hour <= 22 ? "MMM d, yyyy h:mm:ss" : "MMM d, yyyy hh:mm:ss";
        DateTimeFormat fmt = new DateTimeFormat(tsFormatString, null);
        String valueString = fmt.format(cal);
        if (nanoSeconds >= 1000000) {
            valueString = valueString + STRING_DOT + this.getMillisecondsString(nanoSeconds);
        }
        DateTimeFormat fmtForAmPm = new DateTimeFormat(STRING_SPACEA, null);
        valueString = valueString + fmtForAmPm.format(cal);
        return valueString;
    }

    private String getTimeStampTZValue(Value value) {
        TimestampWithTZValue tsValue = (TimestampWithTZValue)value;
        Calendar cal = new Calendar();
        int hour = tsValue.getHour();
        int nanoSeconds = tsValue.getNanoseconds();
        cal.set(tsValue.getYear(), tsValue.getMonth() - 1, tsValue.getDay(), hour, tsValue.getMinute(), tsValue.getSecond());
        String tsFormatString = null;
        tsFormatString = hour >= 0 && hour < 10 || hour >= 13 && hour <= 22 ? "MMMM d, yyyy h:mm:ss" : "MMMM d, yyyy hh:mm:ss";
        DateTimeFormat fmt = new DateTimeFormat(tsFormatString, null);
        String valueString = fmt.format(cal);
        if (nanoSeconds >= 1000000) {
            valueString = valueString + STRING_DOT + this.getMillisecondsString(nanoSeconds);
        }
        DateTimeFormat fmtForAmPm = new DateTimeFormat(STRING_SPACEA, null);
        valueString = valueString + fmtForAmPm.format(cal);
        valueString = this.addTimeZone(valueString, tsValue.getTimeZoneHour(), tsValue.getTimeZoneMinute());
        return valueString;
    }

    private String getNumericValue(Value value) {
        if (this.isFloat(value)) {
            return this.formatFloat(value);
        }
        return this.formatDouble(value);
    }

    private boolean isFloat(Value value) {
        return value.getDataType() == DataTypeFactory.getFloatType();
    }

    private String formatFloat(Value value) {
        NumericValue nv = (NumericValue)value;
        if (nv.getFloat() == 0.0f) {
            return STRING_ZERO;
        }
        NumericFormat fmt = new NumericFormat();
        fmt.setGroupingUsed(false);
        fmt.setMaximumFractionDigits(6);
        String valueString = fmt.format((double)nv.getFloat());
        int decimalPosition = valueString.indexOf(STRING_DOT);
        int numberOfFractionalDigits = 6;
        if (decimalPosition > 0) {
            numberOfFractionalDigits = 15 - decimalPosition;
        }
        fmt.setMaximumFractionDigits(numberOfFractionalDigits);
        if (this.isScientific(nv.getDouble())) {
            fmt.setPattern("0.######E+0");
        }
        double doubleValue = this.translateFloatToDouble(nv.getFloat());
        return fmt.format(doubleValue);
    }

    private String formatDouble(Value value) {
        NumericValue nv = (NumericValue)value;
        if (nv.getDouble() == 0.0) {
            return STRING_ZERO;
        }
        NumericFormat fmt = new NumericFormat();
        fmt.setGroupingUsed(false);
        fmt.setMaximumFractionDigits(15);
        String valueString = fmt.format(nv.getDouble());
        int decimalPosition = valueString.indexOf(STRING_DOT);
        int numberOfFractionalDigits = 15;
        if (decimalPosition > 0) {
            numberOfFractionalDigits = 15 - decimalPosition;
        }
        fmt.setMaximumFractionDigits(numberOfFractionalDigits);
        if (this.isScientific(nv.getDouble())) {
            fmt.setPattern(STRING_OVERNINEEPLUSNINE);
        }
        return fmt.format(nv.getDouble());
    }

    private double translateFloatToDouble(float floatValue) {
        String floatStrVal = String.format("%1$f", Float.valueOf(floatValue));
        return Double.valueOf(floatStrVal);
    }

    private String getExactNumericValue(Value value) {
        if (this.isInteger(value)) {
            return this.formatInteger(value);
        }
        return this.formatDecimal(value);
    }

    private String formatInteger(Value value) {
        BigDecimal bdValue = ((ExactNumericValue)value).getBigDecimal();
        if (bdValue.compareTo(new BigDecimal(0)) == 0) {
            return STRING_ZERO;
        }
        bdValue = bdValue.stripTrailingZeros();
        NumericFormat fmt = new NumericFormat();
        fmt.setGroupingUsed(false);
        if (bdValue.scale() != 0) {
            fmt.setMaximumFractionDigits(bdValue.scale());
        }
        if (this.isScientific(bdValue.doubleValue())) {
            fmt.setPattern("0.###E+0");
        }
        return fmt.format(bdValue);
    }

    private String formatDecimal(Value value) {
        BigDecimal bdValue = ((ExactNumericValue)value).getBigDecimal();
        if (bdValue.compareTo(new BigDecimal(0)) == 0) {
            return STRING_ZERO;
        }
        if (bdValue.scale() != 0) {
            bdValue = bdValue.stripTrailingZeros();
        }
        NumericFormat fmt = new NumericFormat();
        fmt.setGroupingUsed(false);
        String bdString = bdValue.abs().toString();
        int decimalPosition = bdString.length() - bdValue.scale();
        if (bdString.indexOf(STRING_DOT) >= 0) {
            --decimalPosition;
        }
        if (decimalPosition > 15) {
            fmt.setPattern(STRING_OVERNINEEPLUSNINE);
        }
        fmt.setMaximumFractionDigits(bdValue.scale());
        return fmt.format(bdValue);
    }

    private boolean isScientific(Double number) {
        Double temp = Math.abs(number);
        if (temp < 1.0E-7) {
            return true;
        }
        return temp > 9.0E9;
    }

    private boolean isInteger(Value value) {
        return value instanceof SmallintValue || value instanceof IntegerValue || value instanceof LongValue;
    }

    String addTimeZone(String valueString, int hrs, int minutes) {
        String returnStr = valueString;
        String strHrs = new String();
        String strMins = new String();
        strHrs = Integer.toString(hrs);
        if (hrs < 0) {
            if (strHrs.length() == 2) {
                String temp = strHrs.substring(0, 1);
                temp = temp + STRING_ZERO;
                strHrs = temp = temp + strHrs.substring(1, 2);
            } else if (strHrs.length() == 1) {
                strHrs = STRING_ZERO + strHrs;
            }
        } else if (strHrs.length() == 1) {
            strHrs = STRING_ZERO + strHrs;
        }
        if (minutes < 0) {
            minutes = -minutes;
        }
        if ((strMins = Integer.toString(minutes)).length() == 1) {
            strMins = STRING_ZERO + strMins;
        }
        returnStr = returnStr + " GMT";
        returnStr = hrs > 0 ? returnStr + "+" : returnStr + "";
        returnStr = returnStr + strHrs + STRING_COLON + strMins;
        return returnStr;
    }

    private void convertToNonFormattedString(IValue kval, IValue vval, HashMap<String, ArrayList<String>> theResult) {
        String kv = kval.toString();
        String vv = null;
        vv = vval.isNull() ? "" : vval.toString();
        if (theResult.containsKey(kv)) {
            theResult.get(kv).add(vv);
        } else {
            ArrayList<String> values = new ArrayList<String>();
            values.add(vv);
            theResult.put(kv, values);
        }
    }

    private void convertToFormattedString(IValue kval, IValue vval, HashMap<String, ArrayList<String>> theResult) {
        String kv = null;
        if (((Value)kval).isOK()) {
            kv = this.getFormatedValueStr((Value)kval);
        }
        String vv = null;
        if (((Value)vval).isOK()) {
            vv = this.getFormatedValueStr((Value)vval);
        }
        if (kv != null && vv != null) {
            if (theResult.containsKey(kv)) {
                theResult.get(kv).add(vv);
            } else {
                ArrayList<String> values = new ArrayList<String>();
                values.add(vv);
                theResult.put(kv, values);
            }
        }
    }

    private static class FreshnessLogger {
        private static final XQELogger TRACE_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "ParameterMapQueryItem.Freshness", LogLevel.INFO);

        private FreshnessLogger() {
        }

        public static void log(String message) {
            TRACE_LOGGER.log(message);
        }
    }

    private class TimeInfo {
        long createdTime = 0L;
        int maxAgeInMilliSeconds = 0;

        TimeInfo(long theCreatedTime, int theMaxAgeInMilliSeconds) {
            this.createdTime = theCreatedTime;
            this.maxAgeInMilliSeconds = theMaxAgeInMilliSeconds;
        }

        public long getCreatedTime() {
            return this.createdTime;
        }

        public void setCreatedTime(long theCreatedTime) {
            this.createdTime = theCreatedTime;
        }

        public int getMaxAgeInMilliSeconds() {
            return this.maxAgeInMilliSeconds;
        }

        public void setMaxAgeInMilliSeconds(int theMaxAgeInMilliSeconds) {
            this.maxAgeInMilliSeconds = theMaxAgeInMilliSeconds;
        }
    }
}

