/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemoser;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQECCLConfigurationFactory;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.OperationEnum;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.SingletonHelper;
import com.ibm.bi.org.apache.hadoop.io.CryptoProvider;
import com.ibm.bi.rest.RESTClient;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.GZIPInputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;

public abstract class BaseHTTPClient {
    protected static final String ACCEPT = "Accept";
    protected static final String ACCEPT_ENCODING = "Accept-Encoding";
    protected static final String APPLICATION_JSON = "application/json";
    protected static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    protected static final String APPLICATION_PARQUET = "application/vnd.ibm.bi.pq";
    protected static final String TEXT_XML = "text/xml";
    protected static final String CONTENT_ENCODING = "Content-Encoding";
    protected static final String GZIP = "gzip";
    private static final String HTTPS = "https";
    private static final String MOSER_COOKIE = "Cookie";
    private static final String MOSER_CAMPASSPORT = "cam_passport";
    private static final String STR_EQUAL = "=";
    private static final String XSRF_TOKEN = "XSRF-TOKEN";
    private static final String X_XSRF_TOKEN = "X-XSRF-TOKEN";
    private static final String SEMICOLON = ";";
    private static final String TRUSTED_HEADER = "X-CA-Authorization";
    protected static final String TrustedServiceID = "XQE";
    private static final XQELogger TRACE_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "HTTPClient", LogLevel.INFO);
    protected String camPassport;
    protected Map<String, String> cookies;
    protected HttpClient client;
    protected boolean useHttpCompression;
    private static SingletonHelper<HttpClient> singletonHelper = new SingletonHelper<HttpClient>(){

        @Override
        protected HttpClient newInstance() {
            ICCLConfiguration cclConfig = XQECCLConfigurationFactory.getInstance();
            HttpClient singleclient = null;
            try {
                String dispAddr = cclConfig.getValue("internalDispatcher", false);
                URL dispURL = new URL(dispAddr);
                if (dispURL.getProtocol().equalsIgnoreCase(BaseHTTPClient.HTTPS)) {
                    singleclient = CryptoProvider.createHttpClient((String)dispURL.getHost(), (int)dispURL.getPort(), (boolean)true);
                } else {
                    MultiThreadedHttpConnectionManager conMgr = new MultiThreadedHttpConnectionManager();
                    HttpConnectionManagerParams params = conMgr.getParams();
                    params.setDefaultMaxConnectionsPerHost(Integer.MAX_VALUE);
                    params.setMaxTotalConnections(Integer.MAX_VALUE);
                    conMgr.setParams(params);
                    singleclient = new HttpClient((HttpConnectionManager)conMgr);
                    HostConfiguration hc = new HostConfiguration();
                    hc.setHost(dispURL.getHost(), dispURL.getPort());
                    singleclient.setHostConfiguration(hc);
                }
                return singleclient;
            }
            catch (Exception e) {
                throw new XQERuntimeException(e);
            }
        }

        @Override
        protected void releaseImpl(HttpClient theInstance) {
        }

        @Override
        protected void initializeImpl(HttpClient theInstance) {
        }
    };

    public BaseHTTPClient(String passp, Map<String, String> c) {
        this.camPassport = passp;
        this.cookies = c;
        this.client = singletonHelper.getInstance();
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        this.useHttpCompression = configuration.getBooleanProperty("general.useRestHttpCompression[@enabled]", true);
    }

    protected static void setCookies(HttpMethodBase method, String cmPassport, Map<String, String> theCookies) {
        if (cmPassport == null && theCookies == null) {
            return;
        }
        TreeMap<String, String> c = new TreeMap<String, String>();
        if (theCookies != null) {
            c.putAll(theCookies);
        }
        if (cmPassport != null && !cmPassport.isEmpty() && !c.containsKey(MOSER_CAMPASSPORT)) {
            c.put(MOSER_CAMPASSPORT, cmPassport);
        }
        if (c.isEmpty()) {
            return;
        }
        StringBuilder sbCookies = new StringBuilder();
        String xsrfToken = null;
        boolean first = true;
        for (Map.Entry e : c.entrySet()) {
            if (first) {
                first = false;
            } else {
                sbCookies.append(SEMICOLON);
            }
            sbCookies.append((String)e.getKey());
            sbCookies.append(STR_EQUAL);
            sbCookies.append((String)e.getValue());
            if (!XSRF_TOKEN.equals(e.getKey())) continue;
            xsrfToken = (String)e.getValue();
            method.setRequestHeader(X_XSRF_TOKEN, xsrfToken);
        }
        method.getParams().setCookiePolicy("ignoreCookies");
        if (xsrfToken == null) {
            xsrfToken = "XQE_" + System.currentTimeMillis();
            if (!c.isEmpty()) {
                sbCookies.append(SEMICOLON);
            }
            sbCookies.append(XSRF_TOKEN);
            sbCookies.append(STR_EQUAL);
            sbCookies.append(xsrfToken);
            method.setRequestHeader(X_XSRF_TOKEN, xsrfToken);
        }
        method.setRequestHeader(MOSER_COOKIE, sbCookies.toString());
    }

    protected static void setCookiesClientConfig(RESTClient method, String cmPassport, Map<String, String> theCookies) {
        if (cmPassport == null && theCookies == null) {
            return;
        }
        TreeMap<String, String> c = new TreeMap<String, String>();
        if (theCookies != null) {
            c.putAll(theCookies);
        }
        if (cmPassport != null && !cmPassport.isEmpty() && !c.containsKey(MOSER_CAMPASSPORT)) {
            c.put(MOSER_CAMPASSPORT, cmPassport);
        }
        if (c.isEmpty()) {
            return;
        }
        StringBuilder sbCookies = new StringBuilder();
        String xsrfToken = null;
        boolean first = true;
        for (Map.Entry e : c.entrySet()) {
            if (first) {
                first = false;
            } else {
                sbCookies.append(SEMICOLON);
            }
            sbCookies.append((String)e.getKey());
            sbCookies.append(STR_EQUAL);
            sbCookies.append((String)e.getValue());
            if (!XSRF_TOKEN.equals(e.getKey())) continue;
            xsrfToken = (String)e.getValue();
            method.setRequestHeader(X_XSRF_TOKEN, xsrfToken);
        }
        if (xsrfToken == null) {
            xsrfToken = "XQE_" + System.currentTimeMillis();
            if (!c.isEmpty()) {
                sbCookies.append(SEMICOLON);
            }
            sbCookies.append(XSRF_TOKEN);
            sbCookies.append(STR_EQUAL);
            sbCookies.append(xsrfToken);
            method.setRequestHeader(X_XSRF_TOKEN, xsrfToken);
        }
        method.setRequestHeader(MOSER_COOKIE, sbCookies.toString());
    }

    protected static void setAcceptEncoding(HttpMethodBase method, boolean isHttpCompressionEnabled) {
        if (isHttpCompressionEnabled) {
            method.setRequestHeader(ACCEPT_ENCODING, GZIP);
        }
    }

    protected static void log(LogLevel aLogLevel, String text) {
        TRACE_LOGGER.log(aLogLevel, text);
    }

    protected static void log(LogLevel aLogLevel, OperationEnum anOp, String text) {
        TRACE_LOGGER.log(aLogLevel, anOp, text);
    }

    protected static boolean loggingEnabled() {
        return TRACE_LOGGER.isOn();
    }

    public static String encodeURIComponent(String input) {
        String result;
        try {
            result = URLEncoder.encode(input, "UTF-8").replaceAll("\\+", "%20").replaceAll("\\%21", "!").replaceAll("\\%27", "'").replaceAll("\\%28", "(").replaceAll("\\%29", ")").replaceAll("\\%7E", "~");
        }
        catch (UnsupportedEncodingException e) {
            result = input;
        }
        return result;
    }

    protected static InputStream getResponseBodyAsStream(HttpMethodBase method) throws IOException {
        Header h = method.getResponseHeader(CONTENT_ENCODING);
        if (h != null && GZIP.equals(h.getValue())) {
            return new GZIPInputStream(method.getResponseBodyAsStream());
        }
        return method.getResponseBodyAsStream();
    }

    protected void makeTrusted(HttpMethodBase httpMethodBase) {
        String jcamCryptoClassPath = "com.ibm.bi.platform.commons.crypto.JCAMCrypto";
        Class<?> jcamCryptoClass = null;
        try {
            jcamCryptoClass = Class.forName("com.ibm.bi.platform.commons.crypto.JCAMCrypto");
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            BaseHTTPClient.log(LogLevel.WARN, "Failed to get JCAMCrypto class: \n" + e.getLocalizedMessage());
            return;
        }
        Class<?> trustedRequestSessionClass = null;
        try {
            Method method = jcamCryptoClass.getMethod("createTrustedRequestSession", null);
            Object trustedRequestSession = method.invoke(null, (Object[])null);
            trustedRequestSessionClass = trustedRequestSession.getClass();
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            BaseHTTPClient.log(LogLevel.WARN, "Failed to get JCAMCrypto TrustedRequestSession class: \n" + e.getLocalizedMessage());
            return;
        }
        try {
            Object trustedRequestSession = trustedRequestSessionClass.newInstance();
            Method method = trustedRequestSessionClass.getMethod("generateToken", String.class);
            String trustToken = (String)method.invoke(trustedRequestSession, TrustedServiceID);
            httpMethodBase.setRequestHeader(TRUSTED_HEADER, trustToken);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            BaseHTTPClient.log(LogLevel.WARN, "Failed to call JCAMCryoto token method: \n" + e.getLocalizedMessage());
        }
    }
}

