/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemoser;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.provider.MetadataService;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.OperationEnum;
import com.cognos.xqemoser.BaseHTTPClient;
import com.cognos.xqemoser.HTTPClientResponse;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.io.IOUtils;

public class ContentServiceClient
extends BaseHTTPClient {
    private static final String DATA = "data";
    private static final String ITEMS = "items";
    private static final String SLASH = "/";
    private static final String VERSION_QUERY_PARAM = "?version=2147483646";
    private static final String STATUS = " status: ";
    private final String contentBasePath = MetadataService.getInstance().getContentServiceBasePath();
    private final String contentSearchBasePath = MetadataService.getInstance().getContentServiceSearchBasePath();

    public ContentServiceClient(String passp, Map<String, String> c) {
        super(passp, c);
    }

    public HTTPClientResponse getJSON(String storeId, String suffix, String type, String ... fields) {
        String url = this.generateGetURL(storeId, suffix, type, fields);
        if (ContentServiceClient.loggingEnabled()) {
            ContentServiceClient.log(LogLevel.INFO, OperationEnum.START, "start cs reading " + url);
        }
        GetMethod httpGet = null;
        try {
            httpGet = new GetMethod();
            httpGet.setPath(url);
            httpGet.setRequestHeader("Accept", "application/json");
            ContentServiceClient.setAcceptEncoding((HttpMethodBase)httpGet, this.useHttpCompression);
            ContentServiceClient.setCookies((HttpMethodBase)httpGet, this.camPassport, this.cookies);
            this.makeTrusted((HttpMethodBase)httpGet);
            int code = this.client.executeMethod((HttpMethod)httpGet);
            HTTPClientResponse resp = new HTTPClientResponse(code, (HttpMethodBase)httpGet);
            if (ContentServiceClient.loggingEnabled()) {
                ContentServiceClient.log(LogLevel.INFO, OperationEnum.END, "end cs reading " + url + STATUS + code);
            }
            HTTPClientResponse hTTPClientResponse = resp;
            return hTTPClientResponse;
        }
        catch (Exception e) {
            throw new XQERuntimeException(XQEMessageKeys.CM_FailContentService, (Throwable)e, url);
        }
        finally {
            if (httpGet != null) {
                httpGet.releaseConnection();
            }
        }
    }

    public HTTPClientResponse getSearchPathJSON(String searchPath, String ... fields) {
        String url = this.generateSearchPathGetURL(searchPath, fields);
        if (ContentServiceClient.loggingEnabled()) {
            ContentServiceClient.log(LogLevel.INFO, OperationEnum.START, "start cs reading " + url);
        }
        GetMethod httpGet = null;
        try {
            httpGet = new GetMethod();
            httpGet.setPath(url);
            httpGet.setRequestHeader("Accept", "application/json");
            ContentServiceClient.setAcceptEncoding((HttpMethodBase)httpGet, this.useHttpCompression);
            ContentServiceClient.setCookies((HttpMethodBase)httpGet, this.camPassport, this.cookies);
            this.makeTrusted((HttpMethodBase)httpGet);
            int code = this.client.executeMethod((HttpMethod)httpGet);
            HTTPClientResponse resp = new HTTPClientResponse(code, (HttpMethodBase)httpGet);
            if (ContentServiceClient.loggingEnabled()) {
                ContentServiceClient.log(LogLevel.INFO, OperationEnum.END, "end cs reading " + url + STATUS + code);
            }
            HTTPClientResponse hTTPClientResponse = resp;
            return hTTPClientResponse;
        }
        catch (Exception e) {
            throw new XQERuntimeException(XQEMessageKeys.CM_FailContentService, (Throwable)e, url);
        }
        finally {
            if (httpGet != null) {
                httpGet.releaseConnection();
            }
        }
    }

    public String generateFieldsQueryParameter(String[] fields) {
        StringBuilder fieldsQueryParameter = new StringBuilder();
        boolean first = true;
        for (String field : fields) {
            if (first) {
                fieldsQueryParameter.append("?fields=");
                first = false;
            } else {
                fieldsQueryParameter.append("%2C");
            }
            fieldsQueryParameter.append(ContentServiceClient.encodeURIComponent(field));
        }
        return fieldsQueryParameter.toString();
    }

    private String generateGetURL(String storeId, String suffix, String type, String[] fields) {
        StringBuilder url = new StringBuilder(this.contentBasePath);
        url.append(ContentServiceClient.encodeURIComponent(storeId));
        if (suffix != null) {
            url.append(SLASH);
            url.append(suffix);
        }
        url.append(this.generateFieldsQueryParameter(fields));
        if (type != null) {
            if (fields.length > 0) {
                url.append("&");
            } else {
                url.append("?");
            }
            url.append("types=");
            url.append(type);
        }
        return url.toString();
    }

    private String generateSearchPathGetURL(String searchPath, String[] fields) {
        StringBuilder url = new StringBuilder(this.contentSearchBasePath);
        url.append(this.generateFieldsQueryParameter(fields));
        if (fields.length > 0) {
            url.append("&");
        } else {
            url.append("?");
        }
        url.append("searchPath=");
        url.append(ContentServiceClient.encodeURIComponent(searchPath));
        return url.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getData(String storeId, OutputStream os) {
        StringBuilder url = new StringBuilder(this.contentBasePath);
        url.append(ContentServiceClient.encodeURIComponent(storeId));
        url.append(SLASH);
        url.append(DATA);
        url.append(VERSION_QUERY_PARAM);
        GetMethod httpGet = null;
        try {
            if (ContentServiceClient.loggingEnabled()) {
                ContentServiceClient.log(LogLevel.INFO, OperationEnum.START, "start cs data reading " + url);
            }
            httpGet = new GetMethod();
            httpGet.setPath(url.toString());
            httpGet.setRequestHeader("Accept", "application/octet-stream, application/vnd.ibm.bi.pq");
            ContentServiceClient.setCookies((HttpMethodBase)httpGet, this.camPassport, this.cookies);
            this.makeTrusted((HttpMethodBase)httpGet);
            int code = this.client.executeMethod((HttpMethod)httpGet);
            if (code != 200) {
                throw new XQERuntimeException(XQEMessageKeys.CM_FailContentService, url);
            }
            try (InputStream is = null;){
                is = ContentServiceClient.getResponseBodyAsStream((HttpMethodBase)httpGet);
                IOUtils.copy((InputStream)is, (OutputStream)os);
                if (ContentServiceClient.loggingEnabled()) {
                    ContentServiceClient.log(LogLevel.INFO, OperationEnum.END, "end cs data reading " + url + STATUS + code);
                }
            }
        }
        catch (Exception e) {
            throw new XQERuntimeException(XQEMessageKeys.CM_FailContentService, (Throwable)e, (Object)url);
        }
        finally {
            if (httpGet != null) {
                httpGet.releaseConnection();
            }
        }
    }

    public void putData(String storeId, long length, InputStream is) {
        StringBuilder url = new StringBuilder(this.contentBasePath);
        url.append(ContentServiceClient.encodeURIComponent(storeId));
        url.append(SLASH);
        url.append(DATA);
        PutMethod httpPut = null;
        try {
            if (ContentServiceClient.loggingEnabled()) {
                ContentServiceClient.log(LogLevel.INFO, OperationEnum.START, "start cs put data " + url);
            }
            httpPut = new PutMethod();
            httpPut.setPath(url.toString());
            httpPut.setRequestHeader("Accept", "application/json");
            ContentServiceClient.setCookies((HttpMethodBase)httpPut, this.camPassport, this.cookies);
            this.makeTrusted((HttpMethodBase)httpPut);
            InputStreamRequestEntity requestEntity = new InputStreamRequestEntity(is, length, "application/vnd.ibm.bi.pq");
            httpPut.setRequestEntity((RequestEntity)requestEntity);
            int code = this.client.executeMethod((HttpMethod)httpPut);
            if (code != 200) {
                throw new XQERuntimeException(XQEMessageKeys.CM_FailContentService, url);
            }
            if (ContentServiceClient.loggingEnabled()) {
                ContentServiceClient.log(LogLevel.INFO, OperationEnum.END, "end cs put data " + url + STATUS + code);
            }
        }
        catch (Exception e) {
            throw new XQERuntimeException(XQEMessageKeys.CM_FailContentService, (Throwable)e, (Object)url);
        }
        finally {
            if (httpPut != null) {
                httpPut.releaseConnection();
            }
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    public HTTPClientResponse postWithReplace(String storeId, String payload) {
        StringBuilder url = new StringBuilder(this.contentBasePath);
        url.append(ContentServiceClient.encodeURIComponent(storeId));
        url.append(SLASH);
        url.append(ITEMS);
        url.append("?recursive=true&updateAction=replace");
        PostMethod httpPost = null;
        try {
            if (ContentServiceClient.loggingEnabled()) {
                ContentServiceClient.log(LogLevel.INFO, OperationEnum.START, "start cs post replace " + url);
            }
            httpPost = new PostMethod();
            httpPost.setPath(url.toString());
            httpPost.setRequestHeader("Accept", "application/json");
            ContentServiceClient.setAcceptEncoding((HttpMethodBase)httpPost, this.useHttpCompression);
            ContentServiceClient.setCookies((HttpMethodBase)httpPost, this.camPassport, this.cookies);
            this.makeTrusted((HttpMethodBase)httpPost);
            byte[] rawBytes = payload.getBytes(StandardCharsets.UTF_8);
            ByteArrayInputStream is = new ByteArrayInputStream(rawBytes);
            InputStreamRequestEntity requestEntity = new InputStreamRequestEntity((InputStream)is, (long)rawBytes.length, "application/json");
            httpPost.setRequestEntity((RequestEntity)requestEntity);
            int code = this.client.executeMethod((HttpMethod)httpPost);
            HTTPClientResponse resp = new HTTPClientResponse(code, (HttpMethodBase)httpPost);
            if (ContentServiceClient.loggingEnabled()) {
                ContentServiceClient.log(LogLevel.INFO, OperationEnum.END, "end cs post replace " + url + STATUS + code);
            }
            HTTPClientResponse hTTPClientResponse = resp;
            return hTTPClientResponse;
        }
        catch (Exception e) {
            throw new XQERuntimeException(XQEMessageKeys.CM_FailContentService, (Throwable)e, (Object)url);
        }
        finally {
            if (httpPost != null) {
                httpPost.releaseConnection();
            }
        }
    }

    public int updateCMEntity(String storeId, String payload) {
        StringBuilder url = new StringBuilder(this.contentBasePath);
        url.append(ContentServiceClient.encodeURIComponent(storeId));
        url.append("?updateAction=update");
        PutMethod httpPut = null;
        try {
            if (ContentServiceClient.loggingEnabled()) {
                ContentServiceClient.log(LogLevel.INFO, OperationEnum.START, "start cs put update " + url);
            }
            httpPut = new PutMethod();
            httpPut.setPath(url.toString());
            httpPut.setRequestHeader("Accept", "application/json");
            ContentServiceClient.setAcceptEncoding((HttpMethodBase)httpPut, this.useHttpCompression);
            ContentServiceClient.setCookies((HttpMethodBase)httpPut, this.camPassport, this.cookies);
            this.makeTrusted((HttpMethodBase)httpPut);
            byte[] rawBytes = payload.getBytes(StandardCharsets.UTF_8);
            ByteArrayInputStream is = new ByteArrayInputStream(rawBytes);
            InputStreamRequestEntity requestEntity = new InputStreamRequestEntity((InputStream)is, (long)rawBytes.length, "application/json");
            httpPut.setRequestEntity((RequestEntity)requestEntity);
            int code = this.client.executeMethod((HttpMethod)httpPut);
            if (ContentServiceClient.loggingEnabled()) {
                ContentServiceClient.log(LogLevel.INFO, OperationEnum.END, "end cs put update " + url + STATUS + code);
            }
            int n = code;
            return n;
        }
        catch (Exception e) {
            throw new XQERuntimeException(XQEMessageKeys.CM_FailContentService, (Throwable)e, (Object)url);
        }
        finally {
            if (httpPut != null) {
                httpPut.releaseConnection();
            }
        }
    }

    public static String extractLocationHeader(HTTPClientResponse resp) {
        return resp.getResponseHeader("location");
    }
}

