/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemoser;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqemoser.BaseHTTPClient;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpCookie;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.io.IOUtils;

public class HTTPClientResponse {
    public static final int HTTP_ERR = 400;
    private static final XQELogger HTTP_CLIENT_WARN_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "HTTPClient", LogLevel.WARN);
    private byte[] rawResponse;
    private int responseCode;
    private Map<String, String> responseHeaders;
    private List<HttpCookie> cookies;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTTPClientResponse(int code, HttpMethodBase method) {
        this.responseCode = code;
        if (method != null) {
            Header[] headers = method.getResponseHeaders();
            if (headers != null) {
                this.responseHeaders = new HashMap<String, String>();
                for (Header header : headers) {
                    if ("set-cookie".equalsIgnoreCase(header.getName())) {
                        if (this.cookies == null) {
                            this.cookies = new ArrayList<HttpCookie>();
                        }
                        this.cookies.addAll(HttpCookie.parse(header.getValue()));
                        continue;
                    }
                    this.responseHeaders.put(header.getName().toLowerCase(), header.getValue());
                }
            }
            InputStream is = null;
            try {
                is = BaseHTTPClient.getResponseBodyAsStream(method);
                this.rawResponse = IOUtils.toByteArray((InputStream)is);
            }
            catch (IOException iOException) {
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            if (code >= 400) {
                HTTP_CLIENT_WARN_LOGGER.log(String.format("Received invalid response from CM.%nHTTP Status Code: %1d%nCM Response: %2s", code, this.toString()));
            }
        }
    }

    public int getRespondeCode() {
        return this.responseCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getJSONObjectResponse() {
        if (this.rawResponse == null) {
            return null;
        }
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(this.rawResponse);
            JSONObject jSONObject = JSONObject.parse((InputStream)is);
            return jSONObject;
        }
        catch (IOException e) {
            JSONObject jSONObject = null;
            return jSONObject;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONArray getJSONArrayResponse() {
        if (this.rawResponse == null) {
            return null;
        }
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(this.rawResponse);
            JSONArray jSONArray = JSONArray.parse((InputStream)is);
            return jSONArray;
        }
        catch (IOException e) {
            JSONArray jSONArray = null;
            return jSONArray;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public byte[] getRawResponse() {
        return this.rawResponse;
    }

    public final List<HttpCookie> getCookies() {
        if (this.cookies == null) {
            return Collections.emptyList();
        }
        return this.cookies;
    }

    public String getResponseHeader(String name) {
        if (this.responseHeaders == null) {
            return null;
        }
        return this.responseHeaders.get(name.toLowerCase());
    }

    public void setResponseHeader(String name, String value) {
        if (this.responseHeaders == null) {
            this.responseHeaders = new HashMap<String, String>();
        }
        this.responseHeaders.put(name.toLowerCase(), value);
    }

    public String toString() {
        JSONObject output = new JSONObject();
        if (this.rawResponse != null) {
            try {
                output.put((Object)"rawResponse", (Object)new String(this.rawResponse, "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        output.put((Object)"responseCode", (Object)this.responseCode);
        if (this.responseHeaders != null) {
            JSONObject headers = new JSONObject();
            for (Map.Entry<String, String> entry : this.responseHeaders.entrySet()) {
                headers.put((Object)entry.getKey(), (Object)entry.getValue());
            }
            output.put((Object)"responseHeaders", (Object)headers);
        }
        return output.toString();
    }
}

