/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemoser;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

public class JDBCStringBuilder {
    private static final String DATASOURCES_JSON = "datasources.json";
    private static final String STRING_SEMICOLON = ";";
    private static final HashMap<String, String> SUBPROTOCOL_TO_DRIVER_MAP = new HashMap();

    private static void loadDatasources() {
        JSONObject obj = null;
        try {
            InputStream in = JDBCStringBuilder.class.getResourceAsStream(DATASOURCES_JSON);
            if (in != null) {
                obj = JSONObject.parse((InputStream)in);
                JDBCStringBuilder.buildMap(obj);
                return;
            }
        }
        catch (IOException e) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalError_INTERNAL);
        }
    }

    private static void buildMap(JSONObject obj) {
        JSONArray ds = (JSONArray)obj.get((Object)"data");
        for (Object d : ds) {
            JSONObject o = (JSONObject)d;
            SUBPROTOCOL_TO_DRIVER_MAP.put((String)o.get((Object)"subProtocol"), (String)o.get((Object)"driverName"));
        }
    }

    public static String buildConnectionString(String url, String driver, String options) {
        StringBuilder sb = new StringBuilder();
        sb.append("URL=").append(url).append(STRING_SEMICOLON);
        String d = null;
        if (driver != null && !driver.isEmpty()) {
            d = driver;
        } else {
            JDBCStringBuilder.findJDBCDriverClassFromSubprotocol(url);
        }
        if (d != null) {
            sb.append("DRIVER_NAME=").append(d).append(STRING_SEMICOLON);
        }
        if (options != null) {
            sb.append(options).append(STRING_SEMICOLON);
        }
        return sb.toString();
    }

    private static String findJDBCDriverClassFromSubprotocol(String url) {
        String[] parts = url.split(":");
        if (parts.length > 2) {
            return SUBPROTOCOL_TO_DRIVER_MAP.get(parts[1]);
        }
        return null;
    }

    static {
        JDBCStringBuilder.loadDatasources();
    }
}

