/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemoser;

import com.cognos.xqe.config.ConfigService;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqemoser.MoserModuleManager;
import com.cognos.xqemoser.MoserModuleUtil;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;

public final class MoserCacheCleanupRunnable
implements Runnable {
    private static final Pattern FIRST = Pattern.compile("[A-F0-9]{2}");
    private static final Pattern SECOND = Pattern.compile("[A-F0-9]{1}");
    private static final Pattern STOREID_PATTERN = Pattern.compile("(i[A-F0-9]{32})(.*)(\\.data)");
    private static final String NO_CLEANUP = "Unable to clean up cached dataset file ";
    private static volatile MoserCacheCleanupRunnable cacheCleanupThread = null;
    private HashSet<String> dataSetDirectories = new HashSet();
    private String currentDataSetDirectory;
    private static final XQELogger ERROR_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Resources.Dataset", LogLevel.ERROR);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MoserCacheCleanupRunnable getInstance() {
        if (cacheCleanupThread != null) return cacheCleanupThread;
        Class<MoserCacheCleanupRunnable> clazz = MoserCacheCleanupRunnable.class;
        synchronized (MoserCacheCleanupRunnable.class) {
            if (cacheCleanupThread != null) return cacheCleanupThread;
            cacheCleanupThread = new MoserCacheCleanupRunnable();
            // ** MonitorExit[var0] (shouldn't be in output)
            return cacheCleanupThread;
        }
    }

    private MoserCacheCleanupRunnable() {
    }

    public synchronized void addDirectory(String datasetCacheDirectory) {
        this.currentDataSetDirectory = datasetCacheDirectory;
        MoserCacheCleanupRunnable.cacheCleanupThread.dataSetDirectories.add(datasetCacheDirectory);
    }

    @Override
    public synchronized void run() {
        try {
            if (MoserModuleManager.loggingEnabled()) {
                MoserModuleManager.log(LogLevel.INFO, "Starting dataset cache cleanup thread.");
            }
            Iterator<String> datasetDirectory = this.dataSetDirectories.iterator();
            while (datasetDirectory.hasNext()) {
                String dir = datasetDirectory.next();
                try {
                    if (dir.equals(this.currentDataSetDirectory)) continue;
                    this.deleteDirectories(dir, CleanOption.CLEAN_TRUE);
                    datasetDirectory.remove();
                }
                catch (Throwable t) {
                    MoserModuleManager.log(LogLevel.ERROR, "Unexpected error caught in dataset cache cleanup thread for directory " + dir);
                }
            }
            try {
                this.deleteDirectories(this.currentDataSetDirectory, CleanOption.CLEAN_FALSE);
            }
            catch (Throwable t) {
                MoserModuleManager.log(LogLevel.ERROR, "Unexpected error caught in dataset cache cleanup thread for current directory " + this.currentDataSetDirectory);
            }
            if (MoserModuleManager.loggingEnabled()) {
                MoserModuleManager.log(LogLevel.INFO, "Finishing dataset cache cleanup thread.");
            }
        }
        catch (Throwable t) {
            MoserModuleManager.log(LogLevel.ERROR, "Unexpected error caught in dataset cache cleanup thread.", t);
        }
    }

    protected void deleteDirectories(String dir, CleanOption forceDelete) {
        block12: {
            try {
                File datasetDir = new File(dir);
                if (datasetDir.exists() && datasetDir.isDirectory()) {
                    for (File someFile : datasetDir.listFiles()) {
                        if (!someFile.isDirectory() || !FIRST.matcher(someFile.getName()).matches()) continue;
                        for (File someFile2 : someFile.listFiles()) {
                            if (!someFile2.isDirectory() || !SECOND.matcher(someFile2.getName()).matches()) continue;
                            ArrayList<File> files = null;
                            for (File someFile3 : someFile2.listFiles()) {
                                String fName;
                                if (STOREID_PATTERN.matcher(someFile3.getName()).matches()) {
                                    if (forceDelete == CleanOption.CLEAN_TRUE) {
                                        if (MoserModuleManager.loggingEnabled()) {
                                            MoserModuleManager.log(LogLevel.INFO, "Deleted dataset cache cleanup file: " + someFile3.getName());
                                        }
                                        if (FileUtils.deleteQuietly((File)someFile3) || !ERROR_LOGGER.isOn()) continue;
                                        ERROR_LOGGER.log(LogLevel.ERROR, NO_CLEANUP + someFile3.getName());
                                        continue;
                                    }
                                    if (forceDelete != CleanOption.CLEAN_FALSE) continue;
                                    long lastModified = someFile3.lastModified() / 1000L;
                                    long now = Instant.now().getEpochSecond();
                                    if (lastModified + ConfigService.getInstance().getDatasetCleanupMaxAge() >= now) continue;
                                    if (MoserModuleManager.loggingEnabled()) {
                                        MoserModuleManager.log(LogLevel.INFO, "Deleted expired dataset cache cleanup file: " + someFile3.getName());
                                        MoserModuleManager.log(LogLevel.INFO, "Last modified: " + Long.toString(lastModified) + ", now: " + Long.toString(now));
                                    }
                                    if (FileUtils.deleteQuietly((File)someFile3) || !ERROR_LOGGER.isOn()) continue;
                                    ERROR_LOGGER.log(LogLevel.ERROR, NO_CLEANUP + someFile3.getName());
                                    continue;
                                }
                                if (forceDelete != CleanOption.CLEAN_TEMPORARY || !(fName = someFile3.getName()).endsWith(".tmp")) continue;
                                if (files == null) {
                                    files = new ArrayList<File>();
                                }
                                files.add(someFile3);
                            }
                            if (files != null) {
                                this.cleanTemporaryDataFile(files);
                            }
                            if (someFile2.listFiles().length != 0) continue;
                            FileUtils.deleteDirectory((File)someFile2);
                        }
                        if (someFile.listFiles().length != 0) continue;
                        FileUtils.deleteDirectory((File)someFile);
                    }
                }
            }
            catch (IOException e) {
                if (!ERROR_LOGGER.isOn()) break block12;
                ERROR_LOGGER.log(LogLevel.ERROR, "An error occurred while cleaning up cached dataset files in " + dir, (Throwable)e);
            }
        }
    }

    private void cleanTemporaryDataFile(ArrayList<File> files) {
        long now = Instant.now().getEpochSecond();
        for (File f : files) {
            long lastModified = f.lastModified() / 1000L;
            if (lastModified + (long)MoserModuleUtil.maxTmpAge >= now) continue;
            FileUtils.deleteQuietly((File)f);
        }
    }

    protected static enum CleanOption {
        CLEAN_TRUE,
        CLEAN_FALSE,
        CLEAN_TEMPORARY;

    }
}

