/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemoser;

import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.provider.MetadataService;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.LoopDetectionChain;
import com.cognos.xqe.util.Pair;
import com.cognos.xqemoser.BaseHTTPClient;
import com.cognos.xqemoser.IMoserModuleReader;
import com.cognos.xqemoser.ModuleIdPair;
import com.cognos.xqemoser.MoserEnv;
import com.cognos.xqemoser.MoserModuleManager;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.json.java.OrderedJSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;

public class MoserCollectRequiredObjects {
    private static final String STR_DOT_TOPMODULE = ".topmodule";
    private static final int FOUR = 4;
    private static final int MAX_URI_THRESHOLD = 8000;
    protected HashMap<String, Pair> businessModules = new HashMap();
    protected String topModuleId;
    protected JSONObject topModule;
    protected String theUserPassport;
    protected Map<String, String> theCookiesToMoser;
    protected HashMap<String, Pair> requiredQuerySubjectsBaseModule = new HashMap();
    protected boolean bStatus = false;
    protected HashMap<String, JSONObject> allModulesForXQE;
    protected String etag;
    protected String lastModified;
    protected LoopDetectionChain ldc = new LoopDetectionChain();
    private String topModuleType;
    private long lifetime = -1L;

    public MoserCollectRequiredObjects(String userPassport, Map<String, String> cookiesToMoser) {
        this.theUserPassport = userPassport;
        this.theCookiesToMoser = cookiesToMoser;
    }

    public String getEtag() {
        return this.etag;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    public void setBaseModuleJSON(JSONObject moduleJSON, String moduleId) {
        if (!this.bStatus) {
            return;
        }
        Pair p = this.requiredQuerySubjectsBaseModule.get(moduleId);
        if (p != null) {
            this.setJSON(p, moduleJSON);
        }
    }

    protected Set<String> getRequiredObjects(Pair p) {
        return (Set)p.getFirst();
    }

    protected JSONObject getJSON(Pair p) {
        return (JSONObject)p.getSecond();
    }

    protected void setJSON(Pair p, JSONObject moduleJSON) {
        JSONObject saved = (JSONObject)p.getSecond();
        if (saved == null) {
            p.setSecond(moduleJSON);
        }
    }

    protected static boolean getDefinitionForAllRequiredModules(MoserEnv env) {
        return MetadataService.getInstance().getMoserAllModules() && env.getModuleReader().isXQEMoserWhole();
    }

    public void collectRequiredObjects(ModuleIdPair topModuleIdPair, MoserEnv env) {
        IMoserModuleReader theMoserModuleReader = env.getModuleReader();
        if (MoserCollectRequiredObjects.getDefinitionForAllRequiredModules(env)) {
            RequestEnvironment reqEnv;
            this.allModulesForXQE = new HashMap();
            String orgModuleId = topModuleIdPair.getModuleId();
            HttpServletRequest servletRequest = null;
            if (env.getExecutionEnvironment() != null && (reqEnv = (RequestEnvironment)env.getExecutionEnvironment().getRequestEnvironment()) != null) {
                servletRequest = reqEnv.getHttpServletRequest();
            }
            JSONObject response = theMoserModuleReader.read(orgModuleId, this.theUserPassport, this.theCookiesToMoser, null, null, servletRequest);
            this.etag = (String)response.get((Object)"cacheKey");
            this.lastModified = (String)response.get((Object)"lastModified");
            String modulesDef = (String)response.get((Object)"moduleDef");
            if (MoserModuleManager.loggingEnabled()) {
                MoserModuleManager.log(LogLevel.INFO, "start parsing modules " + orgModuleId);
            }
            try {
                JSONObject jObj = OrderedJSONObject.parse((String)modulesDef);
                for (Object k : jObj.keySet()) {
                    String kName = (String)k;
                    Object v = jObj.get(k);
                    if (v == null) continue;
                    if (kName.equals("type")) {
                        this.topModuleType = (String)v;
                        continue;
                    }
                    if (kName.equals("lifeTime") && v instanceof Number) {
                        long tm = ((Number)v).longValue();
                        if (tm < 0L) continue;
                        this.lifetime = tm * 1000L;
                        continue;
                    }
                    if (kName.endsWith(STR_DOT_TOPMODULE)) {
                        kName = kName.substring(0, kName.length() - STR_DOT_TOPMODULE.length());
                        topModuleIdPair.setSecond(kName);
                        this.allModulesForXQE.put(kName, (JSONObject)v);
                        continue;
                    }
                    this.allModulesForXQE.put(kName, (JSONObject)v);
                }
            }
            catch (Exception e) {
                XQERuntimeException exception = new XQERuntimeException(XQEMessageKeys.MSR_InvalidModuleDefinition, (Throwable)e);
                if (MoserModuleManager.loggingEnabled()) {
                    MoserModuleManager.log(LogLevel.ERROR, exception.getLocalizedMessage() + System.lineSeparator() + modulesDef);
                }
                throw exception;
            }
            if (MoserModuleManager.loggingEnabled()) {
                MoserModuleManager.log(LogLevel.INFO, "end parsing modules " + orgModuleId);
            }
        } else {
            this.collectRequiredObjectsLegacy(topModuleIdPair, env);
        }
    }

    @Deprecated
    void collectRequiredObjectsLegacy(ModuleIdPair topModuleIdPair, MoserEnv env) {
        this.topModuleId = topModuleIdPair.getModuleId();
        this.topModule = this.getModuleJSON(this.topModuleId, env);
        if (this.topModule != null) {
            this.lastModified = (String)this.topModule.get((Object)"lastModified");
        }
        this.bStatus = this.loadReferencedBusinessModule(this.topModule, env);
        if (!this.bStatus) {
            return;
        }
        boolean b = this.distributeReferencedObjects(this.topModuleId, this.topModule, null);
        if (!b) {
            this.bStatus = false;
            return;
        }
        for (Pair p : this.requiredQuerySubjectsBaseModule.values()) {
            Set<String> requiredObjects = this.getRequiredObjects(p);
            if (requiredObjects == null || requiredObjects.isEmpty()) continue;
            int byteSize = 0;
            for (String s : requiredObjects) {
                byteSize += 4;
                try {
                    byteSize += s.getBytes("UTF-8").length;
                }
                catch (Exception e) {
                    this.bStatus = false;
                    break;
                }
            }
            if (byteSize <= 8000) continue;
            this.bStatus = false;
        }
        if (!this.bStatus) {
            return;
        }
        for (Pair p : this.businessModules.values()) {
            this.cleanUpSubBusinessModule(this.getJSON(p), this.getRequiredObjects(p));
        }
    }

    protected void cleanUpSubBusinessModule(JSONObject moduleJSON, Set<String> required) {
        if (moduleJSON == null) {
            return;
        }
        moduleJSON.remove((Object)"relationship");
        moduleJSON.remove((Object)"calculation");
        if (required == null || required.isEmpty()) {
            moduleJSON.remove((Object)"querySubject");
        } else {
            JSONArray querySubjects = (JSONArray)moduleJSON.get((Object)"querySubject");
            ArrayList<JSONObject> toDelete = new ArrayList<JSONObject>();
            for (int i = 0; i < querySubjects.size(); ++i) {
                JSONObject aQS = (JSONObject)querySubjects.get(i);
                String name = (String)aQS.get((Object)"identifier");
                if (required.contains(name)) continue;
                toDelete.add(aQS);
            }
            querySubjects.removeAll(toDelete);
        }
    }

    protected boolean distributeReferencedObjects(String moduleId, JSONObject moduleJSON, Set<String> required) {
        if (moduleJSON == null) {
            return false;
        }
        TreeSet<String> refObjects = this.getReferencedObjectnames(moduleJSON, required);
        for (String ref : refObjects) {
            String[] parts = ref.split("\\.");
            if (this.distributeToSubModule(moduleId, moduleJSON, parts)) continue;
            return false;
        }
        JSONArray uses = (JSONArray)moduleJSON.get((Object)"use");
        JSONArray useSpecs = (JSONArray)moduleJSON.get((Object)"useSpec");
        if (this.isBusinessModule(useSpecs, uses)) {
            for (int i = 0; i < useSpecs.size(); ++i) {
                boolean b;
                Pair p;
                Set<String> subRequired;
                JSONObject useSpec = (JSONObject)useSpecs.get(i);
                String storeId = (String)useSpec.get((Object)"storeID");
                String type = (String)useSpec.get((Object)"type");
                if (!"module".equals(type) || (subRequired = this.getRequiredObjects(p = this.businessModules.get(storeId))) == null || (b = this.distributeReferencedObjects(storeId, this.getJSON(p), subRequired))) continue;
                return false;
            }
        }
        return true;
    }

    protected Pair getModuleDefinition(String moduleId) {
        Pair p = this.businessModules.get(moduleId);
        if (p != null) {
            return p;
        }
        p = this.requiredQuerySubjectsBaseModule.get(moduleId);
        return p;
    }

    protected boolean distributeToSubModule(String moduleId, JSONObject moduleJSON, String[] parts) {
        if (parts.length == 0) {
            return false;
        }
        if (parts.length == 1) {
            Pair p = this.getModuleDefinition(moduleId);
            if (p != null) {
                Set<String> required = this.getRequiredObjects(p);
                required.add(parts[0]);
                return true;
            }
            return false;
        }
        String alias = parts[0];
        String subModuleId = this.getSubModuleIdByAlias(moduleJSON, alias);
        if (subModuleId == null) {
            return false;
        }
        Pair p = this.getModuleDefinition(subModuleId);
        if (p == null) {
            return false;
        }
        String[] subParts = new String[parts.length - 1];
        System.arraycopy(parts, 1, subParts, 0, subParts.length);
        return this.distributeToSubModule(subModuleId, this.getJSON(p), subParts);
    }

    protected String getSubModuleIdByAlias(JSONObject jObj, String alias) {
        JSONArray useSpecs = (JSONArray)jObj.get((Object)"useSpec");
        if (useSpecs == null) {
            return null;
        }
        for (int i = 0; i < useSpecs.size(); ++i) {
            JSONObject spec = (JSONObject)useSpecs.get(i);
            String useSpecAlias = (String)spec.get((Object)"identifier");
            String storeId = (String)spec.get((Object)"storeID");
            if (!alias.equals(useSpecAlias)) continue;
            return storeId;
        }
        return null;
    }

    protected boolean isBusinessModule(JSONArray useSpecs, JSONArray uses) {
        if (useSpecs == null || useSpecs.isEmpty()) {
            return false;
        }
        return uses == null || uses.isEmpty();
    }

    protected boolean loadReferencedBusinessModule(JSONObject moduleJSON, MoserEnv env) {
        JSONArray uses = (JSONArray)moduleJSON.get((Object)"use");
        JSONArray useSpecs = (JSONArray)moduleJSON.get((Object)"useSpec");
        if (!this.isBusinessModule(useSpecs, uses)) {
            return false;
        }
        for (int i = 0; i < useSpecs.size(); ++i) {
            JSONObject spec = (JSONObject)useSpecs.get(i);
            String alias = (String)spec.get((Object)"identifier");
            String storeId = (String)spec.get((Object)"storeID");
            String type = (String)spec.get((Object)"type");
            if (alias == null || storeId == null || type == null || "package".equals(type)) {
                return false;
            }
            if (!"module".equals(type)) {
                Pair p = this.requiredQuerySubjectsBaseModule.get(storeId);
                if (p != null) continue;
                p = new Pair(new TreeSet(), null);
                this.requiredQuerySubjectsBaseModule.put(storeId, p);
                continue;
            }
            JSONObject jObj = null;
            Pair p = this.businessModules.get(storeId);
            if (p != null) continue;
            try {
                jObj = this.getModuleJSON(storeId, env);
            }
            catch (XQERuntimeException e) {
                if (!XQEMessageKeys.MD_MetadataConnectionFailed.equals(e.getMessageKey())) {
                    throw e;
                }
                return false;
            }
            p = new Pair(new TreeSet(), jObj);
            this.businessModules.put(storeId, p);
            if (this.loadReferencedBusinessModule(jObj, env)) continue;
            return false;
        }
        return true;
    }

    public JSONObject getModuleJSON(String moduleId, MoserEnv env) {
        if (this.allModulesForXQE != null) {
            return this.allModulesForXQE.get(moduleId);
        }
        return this.getModuleJSONLegacy(moduleId, false, env);
    }

    @Deprecated
    protected JSONObject getModuleJSONLegacy(String moduleId, boolean filter, MoserEnv env) {
        JSONObject jObj = this.getExistingModuleJSON(moduleId);
        if (jObj != null) {
            return jObj;
        }
        List<String> required = null;
        if (filter) {
            required = this.getRequiredObjectNames(moduleId);
        }
        if (required != null && required.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("xqemoser=true");
        if (required != null) {
            for (String nm : required) {
                sb.append("&qs=");
                if (MoserModuleManager.getDefaultDataFilePath() != null) {
                    sb.append(nm);
                    continue;
                }
                sb.append(BaseHTTPClient.encodeURIComponent(nm));
            }
        }
        return this.getModuleJSONWithQueryParam(moduleId, sb.toString(), env);
    }

    public JSONObject getModuleJSONWithQueryParam(String moduleId, String queryParam, MoserEnv env) {
        String last;
        RequestEnvironment reqEnv;
        HttpServletRequest r = null;
        IMoserModuleReader theMoserModuleReader = env.getModuleReader();
        if (env.getExecutionEnvironment() != null && (reqEnv = (RequestEnvironment)env.getExecutionEnvironment().getRequestEnvironment()) != null) {
            r = reqEnv.getHttpServletRequest();
        }
        JSONObject response = theMoserModuleReader.read(moduleId, this.theUserPassport, this.theCookiesToMoser, queryParam, null, r);
        String moduleDef = (String)response.get((Object)"moduleDef");
        if (MoserModuleManager.loggingEnabled()) {
            MoserModuleManager.log(LogLevel.INFO, "start parsing module " + moduleId);
        }
        JSONObject jObj = null;
        try {
            jObj = OrderedJSONObject.parse((String)moduleDef);
        }
        catch (Exception e) {
            XQERuntimeException exception = new XQERuntimeException(XQEMessageKeys.MSR_InvalidModuleDefinition, (Throwable)e);
            if (MoserModuleManager.loggingEnabled()) {
                MoserModuleManager.log(LogLevel.ERROR, exception.getLocalizedMessage() + System.lineSeparator() + moduleDef);
            }
            throw exception;
        }
        if (MoserModuleManager.loggingEnabled()) {
            MoserModuleManager.log(LogLevel.INFO, "end parsing module " + moduleId);
        }
        if (jObj.isEmpty()) {
            XQERuntimeException exception = new XQERuntimeException(XQEMessageKeys.MSR_InvalidModuleDefinition);
            if (MoserModuleManager.loggingEnabled()) {
                MoserModuleManager.log(LogLevel.ERROR, exception.getLocalizedMessage() + System.lineSeparator() + jObj);
            }
            throw exception;
        }
        String etagStr = (String)response.get((Object)"cacheKey");
        if (etagStr != null && !etagStr.isEmpty()) {
            jObj.put((Object)"cacheKey", (Object)etagStr);
        }
        if ((last = (String)response.get((Object)"lastModified")) != null && !last.isEmpty()) {
            jObj.put((Object)"lastModified", (Object)last);
        }
        return jObj;
    }

    private JSONObject getExistingModuleJSON(String moduleId) {
        if (this.topModuleId.equals(moduleId)) {
            return this.topModule;
        }
        Pair p = this.businessModules.get(moduleId);
        if (p != null) {
            return this.getJSON(p);
        }
        p = this.requiredQuerySubjectsBaseModule.get(moduleId);
        if (p != null) {
            return this.getJSON(p);
        }
        return null;
    }

    public List<String> getRequiredObjectNames(String moduleId) {
        if (!this.bStatus) {
            return null;
        }
        if (moduleId.endsWith(".physicalmodule")) {
            return this.getRequiredObjectNamesForPhysicalModule(moduleId.substring(0, moduleId.length() - ".physicalmodule".length()));
        }
        Pair p = this.requiredQuerySubjectsBaseModule.get(moduleId);
        if (p == null) {
            return null;
        }
        Set<String> requiredQuerySubjects = this.getRequiredObjects(p);
        if (requiredQuerySubjects == null) {
            return null;
        }
        return new ArrayList<String>(requiredQuerySubjects);
    }

    protected List<String> getRequiredObjectNamesForPhysicalModule(String baseModuleId) {
        Pair p = this.requiredQuerySubjectsBaseModule.get(baseModuleId);
        if (p == null) {
            return null;
        }
        JSONObject jObj = this.getJSON(p);
        Set<String> requiredQuerySubjects = this.getRequiredObjects(p);
        if (requiredQuerySubjects == null || jObj == null) {
            return null;
        }
        TreeSet<String> requiredTables = this.getReferencedObjectnames(jObj, requiredQuerySubjects);
        return new ArrayList<String>(requiredTables);
    }

    protected TreeSet<String> getReferencedObjectnames(JSONObject jObj, Set<String> required) {
        TreeSet<String> rt = new TreeSet<String>();
        JSONArray allQSs = (JSONArray)jObj.get((Object)"querySubject");
        if (allQSs == null) {
            return rt;
        }
        for (int i = 0; i < allQSs.size(); ++i) {
            JSONArray refs;
            String name;
            JSONObject aQS = (JSONObject)allQSs.get(i);
            if (required != null && !required.contains(name = (String)aQS.get((Object)"identifier")) || (refs = (JSONArray)aQS.get((Object)"ref")) == null) continue;
            for (int j = 0; j < refs.size(); ++j) {
                String ref = (String)refs.get(j);
                rt.add(ref);
            }
        }
        return rt;
    }

    public String getTopModuleType() {
        return this.topModuleType;
    }

    public long getLifeTime() {
        return this.lifetime;
    }
}

