/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemoser;

import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DateTimeValue;
import com.cognos.xqe.metadata.ICatalog;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.IMultiRequestHandle;
import com.cognos.xqe.metadata.INamespace;
import com.cognos.xqe.metadata.IVariable;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.bean.BeanPropertySupport;
import com.cognos.xqemoser.MoserBaseMetadata;
import com.cognos.xqemoser.MoserDimension;
import com.cognos.xqemoser.MoserMetadataConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class MoserCube
extends MoserBaseMetadata
implements ICube {
    protected MoserMetadataConnection moserConnection;
    protected List<IDimension> dimensions = new ArrayList<IDimension>();
    protected final DateTimeValue createTime;

    public MoserCube(MoserMetadataConnection connection) {
        super(connection.getNextId(), "cube", -1);
        this.objectType = MetadataType.CUBE;
        this.moserConnection = connection;
        this.createTime = DataValueFactory.createTimestampValue();
        this.createTime.set(System.currentTimeMillis());
    }

    @Override
    public Set<String> getAvailableProperties() {
        return Collections.emptySet();
    }

    @Override
    public Object getProperty(String propertyName) {
        return null;
    }

    @Override
    public IDataType getDataType() {
        return null;
    }

    @Override
    public MetadataConnection getConnection() {
        return this.moserConnection;
    }

    @Override
    public IMetadata getParentObject() {
        return null;
    }

    @Override
    public List<IMetadata> getDescendantMetadataObjectsSkipFolders() {
        return this.getChildMetadataObjects();
    }

    @Override
    public List<IMetadata> getChildMetadataObjects() {
        return new ArrayList<IMetadata>(this.dimensions);
    }

    @Override
    public String getV5UniqueName() {
        return UniqueNameGenerator.createUniqueName(this.getName());
    }

    @Override
    public String getID() {
        return this.getUniqueID();
    }

    @Override
    public boolean hasChildMetadataObjects() {
        return !this.dimensions.isEmpty();
    }

    @Override
    public String getDescription() {
        return this.getName();
    }

    @Override
    public String getUniqueID() {
        return this.getName();
    }

    @Override
    public BeanPropertySupport getBeanPropertySupport() {
        return new BeanPropertySupport(MoserCube.class);
    }

    @Override
    public boolean isDMR() {
        return true;
    }

    @Override
    public boolean isMFW() {
        return false;
    }

    @Override
    public IMetadata getParentObjectSkipFolders() {
        return null;
    }

    @Override
    public boolean isAccessible() {
        return true;
    }

    @Override
    public void setParentMetadataObject(IMetadata parent) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IMultiRequestHandle[] getHandles() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int compareTo(Object o) {
        if (!(o instanceof MoserBaseMetadata)) {
            return -1;
        }
        MoserBaseMetadata other = (MoserBaseMetadata)o;
        return Long.compare(this.objectId, other.objectId);
    }

    @Override
    public ICube.CubeTypeEnum getType() {
        return ICube.CubeTypeEnum.DMR;
    }

    @Override
    public String getUniqueName() {
        return this.getName();
    }

    @Override
    public DateTimeValue getCreatedDate() {
        return this.createTime;
    }

    @Override
    public DateTimeValue getUpdatedDate() {
        return this.createTime;
    }

    @Override
    public DateTimeValue getSchemaUpdatedDate() {
        return this.createTime;
    }

    @Override
    public List<IDimension> getDimensions() {
        return new ArrayList<IDimension>(this.dimensions);
    }

    @Override
    public int getDimensionCount() {
        return this.dimensions.size();
    }

    @Override
    public IDimension getDimension(String name) {
        for (IDimension dim : this.getDimensions()) {
            if (!dim.getUniqueName().equals(name)) continue;
            return dim;
        }
        return null;
    }

    @Override
    public IHierarchy getHierarchy(String name) {
        for (IDimension dim : this.getDimensions()) {
            for (IHierarchy hier : dim.getHierarchies()) {
                if (!hier.getUniqueName().equals(name)) continue;
                return hier;
            }
        }
        return null;
    }

    @Override
    public IHierarchy getMeasuresHierarchy() {
        return null;
    }

    @Override
    public int getDimensionIndex(IDimension d) {
        return this.getDimensions().indexOf(d);
    }

    @Override
    public IDimension getDimension(int index) {
        if (index < 0 || index >= this.getDimensionCount()) {
            return null;
        }
        return this.dimensions.get(index);
    }

    @Override
    public boolean getPropagateNulls() {
        return false;
    }

    @Override
    public ICatalog getCatalog() {
        return this.getModelDataSource().getCatalog();
    }

    @Override
    public IMeasure getDefaultMeasure() {
        return null;
    }

    @Override
    public ICube.CubeSuppressionTypeEnum getSuppressionType() {
        return ICube.CubeSuppressionTypeEnum.NULL;
    }

    @Override
    public INamespace getNamespace() {
        return null;
    }

    @Override
    public IModelDataSource getModelDataSource() {
        List<IModelDataSource> srcs = this.moserConnection.getModelDataSources();
        if (srcs.isEmpty()) {
            return null;
        }
        return srcs.get(0);
    }

    @Override
    public List<IVariable> getVariables() {
        return Collections.emptyList();
    }

    @Override
    public IDimension getMeasureDimension() {
        return null;
    }

    @Override
    public IDimension queryDimension(String dimensionUName) {
        return this.getDimension(dimensionUName);
    }

    @Override
    public boolean hasSAPReplacementVariable() {
        return false;
    }

    @Override
    public boolean isReplacementVariableUsed(IDimension dimension) {
        return false;
    }

    protected void addDimension(MoserDimension dim) {
        this.dimensions.add(dim);
        dim.parentCube = this;
    }

    @Override
    public String getCubeCurrentPeriod() {
        return null;
    }
}

