/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemoser;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEIDGenerator;
import com.cognos.xqe.ast.XQEUberNodeFactory;
import com.cognos.xqe.ast.macro.MXNodeFactory;
import com.cognos.xqe.ast.v5.V5NodeFactory;
import com.cognos.xqe.ast.v5Exp.V5ExpNodeFactory;
import com.cognos.xqe.ast.v5Exp.V5ExpressionProcessor;
import com.cognos.xqe.ast.v5Exp.V5MultiPartIdentifier;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.IRelationship;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.planner.QueryPlanner;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.util.joinRefinement.RQPJoinPathFinder;
import com.cognos.xqe.transformation.v5tocogsql.util.undirectedgraph.UndirectedGraph;
import com.cognos.xqe.util.Pair;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqemoser.MoserCalculation;
import com.cognos.xqemoser.MoserEnv;
import com.cognos.xqemoser.MoserFilter;
import com.cognos.xqemoser.MoserMetadataConnection;
import com.cognos.xqemoser.MoserModule;
import com.cognos.xqemoser.MoserModuleUtil;
import com.cognos.xqemoser.MoserQueryItem;
import com.cognos.xqemoser.MoserQuerySubject;
import com.cognos.xqemoser.QsClassifierType;
import com.ibm.bi.platform.moser.common.generated.metadata.UseSpecType;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public final class MoserETagUtil {
    public static Set<String> collectRequiredModuleStoreIds(MoserMetadataConnection mc, Set<String> objNames, MoserEnv env) {
        Set qss;
        Pair moduleStoreId;
        HashSet<String> requiredModules = new HashSet<String>();
        HashMap<Pair, HashSet<MoserQuerySubject>> metadataByModule = new HashMap<Pair, HashSet<MoserQuerySubject>>();
        for (String ref : objNames) {
            Pair key;
            HashSet<MoserQuerySubject> st;
            String[] fmStoredId;
            IMetadata md = mc.getMetadata(ref, fmStoredId = new String[]{null}, false);
            if (md == null) {
                return null;
            }
            if (fmStoredId[0] != null) {
                requiredModules.add(fmStoredId[0]);
                continue;
            }
            HashSet<MoserQuerySubject> qss2 = new HashSet<MoserQuerySubject>();
            MoserModule theModule = MoserETagUtil.collectQuerySubject(md, qss2);
            if (theModule == null) {
                return null;
            }
            String moduleStoreId2 = theModule.getUniqueName();
            if (mc.module.equals(theModule)) {
                moduleStoreId2 = mc.getModuleManager().topModuleStoreId;
            }
            if ((st = (HashSet<MoserQuerySubject>)metadataByModule.get(key = new Pair(moduleStoreId2, theModule))) == null) {
                st = new HashSet<MoserQuerySubject>();
                metadataByModule.put(key, st);
            }
            st.addAll(qss2);
        }
        if (metadataByModule.size() > 1) {
            return null;
        }
        if (metadataByModule.size() == 1 && !MoserETagUtil.resolveModulesFromQuerySubject(moduleStoreId = (Pair)metadataByModule.keySet().iterator().next(), qss = (Set)metadataByModule.get(moduleStoreId), requiredModules, env)) {
            return null;
        }
        if (requiredModules.isEmpty()) {
            return null;
        }
        return requiredModules;
    }

    protected static IMetadata getMoserParent(IMetadata md) {
        for (IMetadata p = md.getParentObject(); p != null; p = p.getParentObject()) {
            if (!(p instanceof MoserQuerySubject) && !(p instanceof MoserQueryItem)) continue;
            return p;
        }
        return null;
    }

    protected static MoserModule collectQuerySubject(IMetadata md, Set<MoserQuerySubject> qss) {
        if (md instanceof MoserQueryItem) {
            MoserQuerySubject qs = ((MoserQueryItem)md).parentQS;
            qss.add(qs);
            return qs.getParentModule();
        }
        if (md instanceof MoserCalculation || md instanceof MoserFilter) {
            IMetadata parent = MoserETagUtil.getMoserParent(md);
            if (parent instanceof MoserQuerySubject) {
                MoserQuerySubject qs = (MoserQuerySubject)parent;
                qss.add(qs);
                return qs.getParentModule();
            }
            if (parent instanceof MoserQueryItem) {
                MoserQuerySubject qs = ((MoserQueryItem)parent).parentQS;
                qss.add(qs);
                return qs.getParentModule();
            }
            String expr = null;
            MoserModule module = null;
            if (md instanceof MoserCalculation) {
                MoserCalculation moserCalc = (MoserCalculation)md;
                expr = moserCalc.getExpression();
                module = moserCalc.getParentModule();
            } else {
                MoserFilter moserFilter = (MoserFilter)md;
                expr = moserFilter.getExpression();
                module = moserFilter.parentModule;
            }
            return MoserETagUtil.collectQuerySubjectFromExpr(expr, module, qss);
        }
        return null;
    }

    protected static MoserModule collectQuerySubjectFromExpr(String expr, MoserModule moserModule, Set<MoserQuerySubject> qss) {
        IXQEQueryNode node = null;
        try {
            node = MoserETagUtil.parseExprStr(expr, moserModule);
        }
        catch (XQERuntimeException e) {
            return null;
        }
        IXQEQueryNode[] objs = node.getDescendantsOfType(201030, true);
        if (objs.length == 0) {
            return moserModule;
        }
        HashSet<String> allObjNames = new HashSet<String>();
        for (IXQEQueryNode o : objs) {
            V5MultiPartIdentifier multiPart = (V5MultiPartIdentifier)o;
            String id = multiPart.getIdentifier();
            if (id == null || id.isEmpty()) {
                return null;
            }
            allObjNames.add(id);
        }
        for (String ref : allObjNames) {
            IMetadata md = moserModule.getExpressionObjectByShortNameThis(ref);
            if (md == null) {
                return null;
            }
            if (MoserETagUtil.collectQuerySubject(md, qss) != null) continue;
            return null;
        }
        return moserModule;
    }

    protected static IXQEQueryNode parseExprStr(String expr, MoserModule module) {
        MoserMetadataConnection conn = module.getMetadataConnection();
        Locale exprLC = module.getExpressionLocale();
        if (exprLC == null) {
            exprLC = conn.getExpressionLocale();
        }
        if (exprLC == null) {
            exprLC = new Locale("en");
        }
        ExecutionEnvironment execEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        PlanningEnvironment planEnv = QueryPlanner.setupEnvironment(execEnv.getRequestEnvironment());
        planEnv.setMetdataConnection(conn);
        XQETrace trace = new XQETrace();
        XQEIDGenerator idGenerator = new XQEIDGenerator();
        XQEUberNodeFactory nodeFactory = new XQEUberNodeFactory();
        nodeFactory.addNodeFactory(new V5NodeFactory());
        nodeFactory.addNodeFactory(new V5ExpNodeFactory());
        nodeFactory.addNodeFactory(new MXNodeFactory());
        nodeFactory.setNodeIDGenerator(idGenerator);
        nodeFactory.setTrace(trace);
        nodeFactory.setPlanningEnvironment(planEnv);
        planEnv.setTrace(trace);
        planEnv.setNodeFactory(nodeFactory);
        IXQEQueryNode node = V5ExpressionProcessor.process(expr, planEnv, exprLC, null, false);
        return node;
    }

    protected static boolean isDataModule(String storeId, MoserModule module) {
        if (MoserModuleUtil.isSessionTempID(storeId)) {
            return true;
        }
        return UseSpecType.MODULE.value().equals(module.getType());
    }

    protected static boolean resolveModulesFromQuerySubject(Pair moduleStoreId, Set<MoserQuerySubject> qss, Set<String> requiredModules, MoserEnv env) {
        int n;
        String storeId = (String)moduleStoreId.getFirst();
        requiredModules.add(storeId);
        MoserModule module = (MoserModule)moduleStoreId.getSecond();
        if (qss.isEmpty() || !MoserETagUtil.isDataModule(storeId, module)) {
            return true;
        }
        if (qss.size() > 1 && !module.relationships.isEmpty()) {
            MoserETagUtil.addQuerySubjectsForJoins(module, qss);
        }
        ArrayList<MoserQuerySubject> lst = new ArrayList<MoserQuerySubject>(qss);
        HashSet<MoserQuerySubject> qsUseSameModule = new HashSet<MoserQuerySubject>();
        int i = 0;
        int size = lst.size();
        do {
            MoserQuerySubject qs = lst.get(i);
            Set<MoserQuerySubject> qssAdded = MoserETagUtil.getRefQuerySubjectsSameModule(qs);
            n = 0;
            if (qssAdded == null || qssAdded.isEmpty()) continue;
            for (MoserQuerySubject q : qssAdded) {
                if (qss.contains(q)) continue;
                qss.add(q);
                lst.add(q);
                ++n;
            }
            qsUseSameModule.add(qs);
        } while (++i < (size += n));
        HashMap<Pair, HashSet<MoserQuerySubject>> qssFromSubModules = new HashMap<Pair, HashSet<MoserQuerySubject>>();
        for (MoserQuerySubject moserQuerySubject : qss) {
            if (moserQuerySubject.originalRefs != null) {
                block3: for (String r : moserQuerySubject.originalRefs) {
                    String refInQS = r.trim();
                    String[] nameParts = refInQS.split("\\.");
                    if (nameParts.length != 2) continue;
                    for (JSONObject m : module.mUseSpecs) {
                        if (!nameParts[0].equals(m.get((Object)"identifier"))) continue;
                        String sId = (String)m.get((Object)"storeID");
                        if (sId == null || !UseSpecType.MODULE.value().equals(m.get((Object)"type"))) continue block3;
                        requiredModules.add(sId);
                        continue block3;
                    }
                }
            }
            QsClassifierType tp = moserQuerySubject.getClassifier();
            if (qsUseSameModule.contains(moserQuerySubject) || !QsClassifierType.QUERY_SUBJECT.equals((Object)tp) || moserQuerySubject.refs == null) continue;
            for (String ref : moserQuerySubject.refs) {
                IMetadata srcObj = MoserModuleUtil.getSourceQuerySubjectRelationshipFromSourceModule(module, module.getMetadataConnection().theConnectionPassport, module.getMetadataConnection().cookies, ref, env);
                if (srcObj instanceof MoserQuerySubject) {
                    MoserQuerySubject srcQS = (MoserQuerySubject)srcObj;
                    MoserModule srcModule = srcQS.getParentModule();
                    String srcStoreId = srcModule.getUniqueName();
                    Pair srcKey = new Pair(srcStoreId, srcModule);
                    HashSet<MoserQuerySubject> srcQss = (HashSet<MoserQuerySubject>)qssFromSubModules.get(srcKey);
                    if (srcQss == null) {
                        srcQss = new HashSet<MoserQuerySubject>();
                        qssFromSubModules.put(srcKey, srcQss);
                    }
                    srcQss.add(srcQS);
                    continue;
                }
                return false;
            }
        }
        for (Map.Entry entry : qssFromSubModules.entrySet()) {
            if (MoserETagUtil.resolveModulesFromQuerySubject((Pair)entry.getKey(), (Set)entry.getValue(), requiredModules, env)) continue;
            return false;
        }
        return true;
    }

    protected static void addQuerySubjectsForJoins(MoserModule module, Set<MoserQuerySubject> qss) {
        UndirectedGraph newGraph = new UndirectedGraph(null);
        HashMap<String, MoserQuerySubject> seen = new HashMap<String, MoserQuerySubject>();
        for (MoserQuerySubject moserQuerySubject : module.querySubjects) {
            String string = moserQuerySubject.getID();
            newGraph.addNode(string);
            seen.put(string, moserQuerySubject);
        }
        HashMap<String, IRelationship> seenJoins = new HashMap<String, IRelationship>();
        for (IRelationship iRelationship : module.relationships) {
            int weight = RQPJoinPathFinder.Weight.Default.getWeight();
            String leftId = iRelationship.getLeftRefObjectId();
            String rightId = iRelationship.getRightRefObjectId();
            if (!seen.containsKey(leftId) || !seen.containsKey(rightId)) continue;
            String id = iRelationship.getID();
            newGraph.addEdge(id, leftId, rightId, weight, false);
            seenJoins.put(id, iRelationship);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (MoserQuerySubject q : qss) {
            arrayList.add(q.getID());
        }
        int[] nArray = new int[1];
        ArrayList<ArrayList<String>> shortestJoinPaths = new ArrayList<ArrayList<String>>();
        newGraph.getAllShortestPathTrees(arrayList, shortestJoinPaths, nArray, false);
        for (ArrayList<String> l : shortestJoinPaths) {
            for (String s : l) {
                IRelationship joinObj = (IRelationship)seenJoins.get(s);
                String leftId = joinObj.getLeftRefObjectId();
                String rightId = joinObj.getRightRefObjectId();
                qss.add((MoserQuerySubject)seen.get(leftId));
                qss.add((MoserQuerySubject)seen.get(rightId));
            }
        }
    }

    protected static Set<MoserQuerySubject> getRefQuerySubjectsSameModule(MoserQuerySubject qs) {
        HashSet<MoserQuerySubject> rt;
        block6: {
            block5: {
                QsClassifierType tp = qs.getClassifier();
                if (tp == null || QsClassifierType.SQL_QUERY_SUBJECT.equals((Object)tp)) {
                    return null;
                }
                rt = null;
                if (!QsClassifierType.QUERY_SUBJECT.equals((Object)tp)) break block5;
                if (qs.refs == null) break block6;
                MoserModule module = qs.getParentModule();
                for (String ref : qs.refs) {
                    IMetadata md = module.querySubjectsById.get(ref);
                    if (md == null) continue;
                    if (rt == null) {
                        rt = new HashSet();
                    }
                    rt.add((MoserQuerySubject)md);
                }
                break block6;
            }
            for (IQuerySubject q : qs.sourceQuerySubjects) {
                if (rt == null) {
                    rt = new HashSet<MoserQuerySubject>();
                }
                rt.add((MoserQuerySubject)q);
            }
        }
        return rt;
    }
}

