/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemoser;

import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.LevelType;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IMultiRequestHandle;
import com.cognos.xqe.metadata.IProperty;
import com.cognos.xqe.metadata.ISortItem;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.util.bean.BeanPropertySupport;
import com.cognos.xqemoser.MoserBaseMetadata;
import com.cognos.xqemoser.MoserHierarchy;
import com.cognos.xqemoser.MoserQueryItemOfLevel;
import com.cognos.xqemoser.MoserSortItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class MoserLevel
extends MoserBaseMetadata
implements ILevel {
    protected String uniqueId;
    protected MoserHierarchy parentHierarchy;
    protected Map<String, Object> properties = new TreeMap<String, Object>();
    protected boolean bRoot;
    protected boolean bLeaf;
    protected int levelIndex;
    protected ArrayList<MoserQueryItemOfLevel> queryItems = new ArrayList();
    protected List<MoserSortItem> sortItems = new ArrayList<MoserSortItem>();

    public MoserLevel(long id, String n) {
        super(id, n, -1);
        this.objectType = MetadataType.LEVEL;
    }

    @Override
    public Set<String> getAvailableProperties() {
        return new TreeSet<String>(this.properties.keySet());
    }

    @Override
    public Object getProperty(String propertyName) {
        return this.properties.get(propertyName);
    }

    @Override
    public IDataType getDataType() {
        return LevelType.LEVELTYPE;
    }

    @Override
    public MetadataConnection getConnection() {
        return this.parentHierarchy.getConnection();
    }

    @Override
    public IMetadata getParentObject() {
        return this.parentHierarchy;
    }

    @Override
    public List<IMetadata> getDescendantMetadataObjectsSkipFolders() {
        return this.getChildMetadataObjects();
    }

    @Override
    public List<IMetadata> getChildMetadataObjects() {
        return new ArrayList<IMetadata>(this.queryItems);
    }

    @Override
    public String getV5UniqueName() {
        return this.parentHierarchy.getV5UniqueName() + "." + this.getName();
    }

    @Override
    public String getID() {
        return this.getUniqueID();
    }

    @Override
    public boolean hasChildMetadataObjects() {
        return !this.queryItems.isEmpty();
    }

    @Override
    public String getDescription() {
        return this.getName();
    }

    @Override
    public String getUniqueID() {
        return this.uniqueId;
    }

    @Override
    public BeanPropertySupport getBeanPropertySupport() {
        return new BeanPropertySupport(MoserLevel.class);
    }

    @Override
    public boolean isDMR() {
        return true;
    }

    @Override
    public boolean isMFW() {
        return false;
    }

    @Override
    public IMetadata getParentObjectSkipFolders() {
        return this.getParentObject();
    }

    @Override
    public boolean isAccessible() {
        return true;
    }

    @Override
    public void setParentMetadataObject(IMetadata parent) {
        if (!(parent instanceof MoserHierarchy)) {
            throw new UnsupportedOperationException();
        }
        this.parentHierarchy = (MoserHierarchy)parent;
    }

    @Override
    public IMultiRequestHandle[] getHandles() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int compareTo(Object o) {
        if (!(o instanceof MoserBaseMetadata)) {
            return -1;
        }
        MoserBaseMetadata other = (MoserBaseMetadata)o;
        return Long.compare(this.objectId, other.objectId);
    }

    @Override
    public String getUniqueName() {
        return this.getUniqueID();
    }

    @Override
    public List<IMember> getMembers() {
        return null;
    }

    @Override
    public List<IMember> getMembers(int startIndex, int count) {
        return this.getMembers();
    }

    @Override
    public IHierarchy getHierarchy() {
        return this.parentHierarchy;
    }

    @Override
    public ILevel getPreviousLevel() {
        ILevel previousLevel = null;
        int index = this.getIndex() - 1;
        if (index >= 0) {
            previousLevel = this.getHierarchy().getLevels().get(index);
        }
        return previousLevel;
    }

    @Override
    public ILevel getNextLevel() {
        ILevel nextLevel = null;
        int index = this.getIndex() + 1;
        if (index < this.getHierarchy().getLevels().size()) {
            nextLevel = this.getHierarchy().getLevels().get(index);
        }
        return nextLevel;
    }

    @Override
    public boolean isLeafLevel() {
        return this.bLeaf;
    }

    @Override
    public boolean isRootLevel() {
        return this.bRoot;
    }

    @Override
    public int getCardinality() {
        return 0;
    }

    @Override
    public List<IProperty> getMemberProperties() {
        return new ArrayList<IProperty>(this.queryItems);
    }

    @Override
    public int getIndex() {
        return this.levelIndex;
    }

    @Override
    public IDimension getDimension() {
        return this.parentHierarchy.getDimension();
    }

    @Override
    public IProperty getMemberProperty(String name) {
        List<IProperty> allProperties = this.getMemberProperties();
        for (IProperty prop : allProperties) {
            if (!prop.getUniqueName().equals(name)) continue;
            return prop;
        }
        return null;
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public double getOrderOfMagnitude() {
        return 0.0;
    }

    @Override
    public boolean isAutoGenerated() {
        return false;
    }

    @Override
    public IMember getMember(String uniqueName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ISortItem[] getSortItems() {
        ISortItem[] rt = new ISortItem[this.sortItems.size()];
        for (int i = 0; i < rt.length; ++i) {
            rt[i] = this.sortItems.get(i);
        }
        return rt;
    }

    public void setUniqueID(String uid) {
        this.uniqueId = uid;
    }
}

