/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemoser;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.query.engine.QueryEngine;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.Pair;
import com.cognos.xqe.util.SingletonHelper;
import com.cognos.xqemoser.IMoserModuleReader;
import com.cognos.xqemoser.MoserMetadataConnection;
import com.cognos.xqemoser.MoserModuleManager;
import com.ibm.json.java.JSONObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class MoserModuleIsStaleChecker {
    private static final long DEFAULT_ISSTALE_PERIOD_IN_MILLISECONDS = 30000L;
    private static long wakeupIntervalInMillis = -1L;
    private static SingletonHelper<MoserModuleIsStaleChecker> singletonHelper = new SingletonHelper<MoserModuleIsStaleChecker>(){

        @Override
        protected MoserModuleIsStaleChecker newInstance() {
            return new MoserModuleIsStaleChecker();
        }

        @Override
        protected void releaseImpl(MoserModuleIsStaleChecker theInstance) {
            theInstance.cancelIsStaleCheckerThread();
        }

        @Override
        protected void initializeImpl(MoserModuleIsStaleChecker theInstance) {
        }
    };
    private Map<Pair, Boolean> isModuleStaleMap;
    private Map<String, ConcurrentLinkedQueue<MoserMetadataConnection>> connectionCache;
    IMoserModuleReader moduleReader = null;
    private IsModuleStaleCheckTask staleCheckerTask;
    private XQELogger logger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "ModuleManager.StaleChecker", LogLevel.TRACE);

    private MoserModuleIsStaleChecker() {
        this.moduleReader = MoserModuleManager.getRESTModuleReader();
        this.initCaches();
        this.startIsStaleCheckerThread();
    }

    public static MoserModuleIsStaleChecker getInstance() {
        return singletonHelper.getInstance();
    }

    public static void releaseInstance() {
        singletonHelper.releaseInstance();
    }

    public void registerConnection(MoserMetadataConnection conn, String moduleId, String etag) {
        this.log("Registering module=" + moduleId + " etag=" + etag);
        ConcurrentLinkedQueue connList = new ConcurrentLinkedQueue();
        ConcurrentLinkedQueue<MoserMetadataConnection> listToAdd = this.connectionCache.putIfAbsent(moduleId, connList);
        if (listToAdd == null) {
            listToAdd = connList;
        }
        listToAdd.add(conn);
        this.isModuleStaleMap.put(this.getPair(moduleId, etag), Boolean.FALSE);
    }

    public void deregisterConnection(MoserMetadataConnection conn, String moduleId, String etag) {
        this.log("Deregistering module=" + moduleId + " etag=" + etag);
        ConcurrentLinkedQueue<MoserMetadataConnection> connList = this.connectionCache.get(moduleId);
        if (connList != null) {
            connList.remove(conn);
            if (connList.isEmpty()) {
                this.connectionCache.remove(moduleId);
            }
            this.isModuleStaleMap.remove(this.getPair(moduleId, etag));
        } else if (connList == null) {
            this.isModuleStaleMap.remove(this.getPair(moduleId, etag));
        }
    }

    public boolean checkIsStale(String moduleId, String etag) {
        Boolean b = this.isModuleStaleMap.get(this.getPair(moduleId, etag));
        if (b == null) {
            this.log("CheckIsStale returning true because module not in isModuleStaleMap");
            return true;
        }
        if (b.booleanValue()) {
            this.log("CheckIsStale returning true.");
        } else {
            this.log("CheckIsStale returning false.");
        }
        return b;
    }

    public static void setWakeupInterval(long intervalInMillis) {
        wakeupIntervalInMillis = intervalInMillis;
    }

    private void initCaches() {
        this.isModuleStaleMap = new ConcurrentHashMap<Pair, Boolean>();
        this.connectionCache = new ConcurrentHashMap<String, ConcurrentLinkedQueue<MoserMetadataConnection>>();
    }

    private void startIsStaleCheckerThread() {
        this.log("Starting background thread.");
        if (wakeupIntervalInMillis <= 0L) {
            XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
            wakeupIntervalInMillis = config.getLongProperty("general.isStaleCheckPeriod[@value]", 30000L);
        }
        this.staleCheckerTask = new IsModuleStaleCheckTask();
        QueryEngine.getInstance().getTimer().scheduleAtFixedRate((TimerTask)this.staleCheckerTask, wakeupIntervalInMillis, wakeupIntervalInMillis);
    }

    private void log(String message) {
        if (this.logger.isOn()) {
            this.logger.log(message);
        }
    }

    protected void cancelIsStaleCheckerThread() {
        if (this.staleCheckerTask != null) {
            this.log("Stopping background thread.");
            this.staleCheckerTask.cancel();
        }
    }

    private Pair getPair(String moduleId, String etag) {
        Pair moduleAndEtag = new Pair();
        moduleAndEtag.setFirst(moduleId);
        moduleAndEtag.setSecond(etag);
        return moduleAndEtag;
    }

    private class IsModuleStaleCheckTask
    extends TimerTask {
        private IsModuleStaleCheckTask() {
        }

        @Override
        public void run() {
            MoserModuleIsStaleChecker.this.log("Start checking modules are stale.");
            HashMap<String, Boolean> checkedModules = new HashMap<String, Boolean>();
            for (Pair moduleAndEtag : new HashSet(MoserModuleIsStaleChecker.this.isModuleStaleMap.keySet())) {
                String moduleId = (String)moduleAndEtag.getFirst();
                Boolean staleFlag = (Boolean)checkedModules.get(moduleId);
                if (staleFlag == null) {
                    staleFlag = this.isStale(moduleId, (String)moduleAndEtag.getSecond());
                    checkedModules.put(moduleId, staleFlag);
                }
                if (!staleFlag.booleanValue()) continue;
                MoserModuleIsStaleChecker.this.log("Module " + moduleId + " is stale. Removing from cache.");
                MoserModuleIsStaleChecker.this.isModuleStaleMap.remove(moduleAndEtag);
                MoserModuleIsStaleChecker.this.connectionCache.remove(moduleId);
            }
            MoserModuleIsStaleChecker.this.log("End checking modules are stale.");
        }

        private boolean isStale(String moduleId, String etag) {
            try {
                JSONObject jObj = MoserModuleIsStaleChecker.this.moduleReader.read(moduleId, null, null, null, etag, null);
                String responseCodeStr = (String)jObj.get((Object)"responseStatus");
                int status = Integer.parseInt(responseCodeStr);
                return status != 304;
            }
            catch (Throwable t) {
                return true;
            }
        }
    }
}

