/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemoser;

import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.OperationEnum;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.Pair;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.datasets.DatasetManager;
import com.cognos.xqe.util.datasets.IDatasetManager;
import com.cognos.xqemoser.DaaSMoserModuleReader;
import com.cognos.xqemoser.IMoserModule;
import com.cognos.xqemoser.IMoserModuleReader;
import com.cognos.xqemoser.ModuleIdPair;
import com.cognos.xqemoser.MoserCollectRequiredObjects;
import com.cognos.xqemoser.MoserDataSource;
import com.cognos.xqemoser.MoserEnv;
import com.cognos.xqemoser.MoserMetadataConnection;
import com.cognos.xqemoser.MoserModule;
import com.cognos.xqemoser.MoserModuleIsStaleChecker;
import com.cognos.xqemoser.MoserModuleReader;
import com.cognos.xqemoser.MoserModuleUtil;
import com.cognos.xqemoser.MoserPhysicalTable;
import com.cognos.xqemoser.WAMoserModuleReader;
import com.ibm.bi.platform.moser.common.utils.FormatConverter;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.servlet.http.HttpServletRequest;

public final class MoserModuleManager {
    private static final XQELogger TRACE_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "ModuleManager", LogLevel.INFO);
    private static final String SERVICE_PREFIX_ENV = "SERVICE_PREFIX";
    private final ReentrantReadWriteLock moduleRWLock = new ReentrantReadWriteLock();
    private final Lock writeLock = this.moduleRWLock.writeLock();
    private final Lock readLock = this.moduleRWLock.readLock();
    protected final ConcurrentHashMap<Pair, IMoserModule> allModules = new ConcurrentHashMap();
    private static IMoserModuleReader defaultReader = null;
    private static String defaultDataFilePath = null;
    private static IDatasetManager datasetManager = null;
    private final AtomicLong idCount = new AtomicLong(0L);
    private MoserMetadataConnection metadataConnection;
    private MoserCollectRequiredObjects collector = null;
    protected String topModuleStoreId;
    private String lastModified;
    protected FormatConverter fc = new FormatConverter();
    protected long lifetime = -1L;

    public MoserModuleManager(MoserMetadataConnection mdConn) {
        this.metadataConnection = mdConn;
    }

    public static IMoserModuleReader getMoserModuleReader() {
        if (defaultReader != null) {
            return defaultReader;
        }
        return MoserModuleManager.getRESTModuleReader();
    }

    public static IMoserModuleReader getRESTModuleReader() {
        if (defaultReader != null && defaultReader.is304Capable()) {
            return defaultReader;
        }
        if (System.getProperties().containsKey(SERVICE_PREFIX_ENV)) {
            return new DaaSMoserModuleReader();
        }
        return new MoserModuleReader();
    }

    public long getNextId() {
        return this.idCount.incrementAndGet();
    }

    public static void setExplicitMoserModuleReader(IMoserModuleReader reader, String dataPath) {
        defaultReader = reader;
        defaultDataFilePath = dataPath;
    }

    public static IMoserModuleReader getDefaultModuleReader() {
        return defaultReader;
    }

    public static String getDefaultDataFilePath() {
        return defaultDataFilePath;
    }

    public static void setExplicitDatasetManager(IDatasetManager dsManager) {
        datasetManager = dsManager;
    }

    public static IDatasetManager getDatasetManager() {
        return datasetManager;
    }

    public IMoserModule getModule(ModuleIdPair idPair, String userPassport, Map<String, String> cookiesToMoser, MoserEnv env) {
        return this.getModuleById(idPair, userPassport, cookiesToMoser, null, false, env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IMoserModule getPhysicalModuleFromPhysicalDefinition(ModuleIdPair idPair, JSONObject physical, String userPassport, Map<String, String> cookiesToMoser, MoserEnv env) {
        IMoserModule module = null;
        this.writeLock.lock();
        try {
            String connectionString = idPair.getModuleId();
            module = MoserModuleUtil.loadMoserModule(this.metadataConnection, connectionString, physical, userPassport, cookiesToMoser, null, false, env, this.fc);
            if (module != null) {
                this.addModule(new Pair(idPair, userPassport), module);
            }
        }
        finally {
            this.writeLock.unlock();
        }
        return module;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IMetadata> getPhysicalMetadaFromCM(MoserModule module, String moduleId, String param, String userPassport, Map<String, String> cookiesToMoser, String[] dsKeys, MoserEnv env, IPlanningEnvironment planEnv) {
        this.writeLock.lock();
        try {
            MoserCollectRequiredObjects c = new MoserCollectRequiredObjects(userPassport, cookiesToMoser);
            JSONObject moduleJSON = c.getModuleJSONWithQueryParam(moduleId, param, env);
            if (moduleJSON == null) {
                List<IMetadata> list = null;
                return list;
            }
            MoserModule tmp = (MoserModule)MoserModuleUtil.loadMoserModule(this.metadataConnection, moduleId, moduleJSON, userPassport, cookiesToMoser, null, false, env, this.fc);
            if (tmp == null) {
                List<IMetadata> list = null;
                return list;
            }
            ArrayList<MoserPhysicalTable> rt = new ArrayList<MoserPhysicalTable>();
            List<MoserDataSource> dss = tmp.getDataSourcesInThis();
            for (MoserDataSource ds : dss) {
                rt.addAll(ds.getTables());
            }
            if (rt.size() == 1) {
                String cmDS = dsKeys[0];
                String cat = dsKeys[1];
                String schema = dsKeys[2];
                MoserDataSource exist = null;
                for (MoserDataSource s : module.getDataSourcesInThis()) {
                    if (!s.matchCMNameCatalogSchema(cmDS, cat, schema, planEnv)) continue;
                    exist = s;
                    break;
                }
                if (exist == null) {
                    module.addDataSource(dss.get(0));
                } else {
                    MoserPhysicalTable ptb = (MoserPhysicalTable)rt.get(0);
                    dss.get(0).addTable(ptb.getName(), ptb);
                }
            }
            ArrayList<MoserPhysicalTable> arrayList = rt;
            return arrayList;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IMoserModule getModuleById(ModuleIdPair idPair, String userPassport, Map<String, String> cookiesToMoser, JSONObject moduleInfo, boolean bTop, MoserEnv env) {
        IMoserModule module = this.getExistModuleWrapper(idPair, userPassport);
        if (module != null) {
            return module;
        }
        this.writeLock.lock();
        try {
            String connectionString = idPair.getModuleId();
            JSONObject moduleJSON = this.collector.getModuleJSON(connectionString, env);
            if (moduleJSON == null) {
                IMoserModule iMoserModule = null;
                return iMoserModule;
            }
            this.collector.setBaseModuleJSON(moduleJSON, connectionString);
            if (MoserModuleManager.loggingEnabled()) {
                MoserModuleManager.log(LogLevel.INFO, "start loading module " + connectionString);
            }
            if (!this.collector.ldc.push(connectionString, connectionString)) {
                throw new XQERuntimeException(XQEMessageKeys.MSR_LoopInModule, this.collector.ldc.serialize());
            }
            module = MoserModuleUtil.loadMoserModule(this.metadataConnection, connectionString, moduleJSON, userPassport, cookiesToMoser, moduleInfo, bTop, env, this.fc);
            this.collector.ldc.pop();
            if (MoserModuleManager.loggingEnabled()) {
                MoserModuleManager.log(LogLevel.INFO, "end loading module " + connectionString);
            }
            if (module != null) {
                this.addModule(new Pair(idPair, userPassport), module);
            }
        }
        finally {
            this.writeLock.unlock();
        }
        return module;
    }

    private void addModule(Pair pair, IMoserModule newModule) {
        this.allModules.put(pair, newModule);
        if (MoserModuleManager.loggingEnabled()) {
            MoserModuleManager.log(LogLevel.TRACE, "add module: pair(" + pair.toString() + "); moduleId=" + newModule.getIdentifier());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMoserModule getExistModuleWrapper(ModuleIdPair idPair, String userPassport) {
        this.readLock.lock();
        try {
            IMoserModule iMoserModule = this.allModules.get(new Pair(idPair, userPassport));
            return iMoserModule;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModule(ModuleIdPair idPair, String userPassport, IMoserModule module) {
        this.writeLock.lock();
        try {
            this.addModule(new Pair(idPair, userPassport), module);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public static void log(LogLevel aLogLevel, String text) {
        TRACE_LOGGER.log(aLogLevel, text);
    }

    public static void log(LogLevel aLogLevel, Throwable t) {
        TRACE_LOGGER.log(aLogLevel, t);
    }

    public static void log(LogLevel aLogLevel, String text, Throwable t) {
        TRACE_LOGGER.log(aLogLevel, text, t);
    }

    public static void log(LogLevel aLogLevel, OperationEnum anOp, String text) {
        TRACE_LOGGER.log(aLogLevel, anOp, text);
    }

    public static boolean loggingEnabled() {
        return TRACE_LOGGER.isOn();
    }

    public Pair getModuleUsingAlias(String alias) {
        for (Map.Entry<Pair, IMoserModule> entry : this.allModules.entrySet()) {
            String entryAlias = ((ModuleIdPair)entry.getKey().getFirst()).getAlias();
            if (entryAlias == null || !entryAlias.equals(alias)) continue;
            return new Pair(((ModuleIdPair)entry.getKey().getFirst()).getFirst(), entry.getValue());
        }
        return null;
    }

    public List<ModuleIdPair> getAllModulePairs() {
        ArrayList<ModuleIdPair> list = new ArrayList<ModuleIdPair>();
        for (Map.Entry<Pair, IMoserModule> entry : this.allModules.entrySet()) {
            list.add((ModuleIdPair)entry.getKey().getFirst());
        }
        return list;
    }

    public JSONArray toJSONArray() {
        JSONArray modules = new JSONArray();
        for (Map.Entry<Pair, IMoserModule> entry : this.allModules.entrySet()) {
            IMoserModule module = entry.getValue();
            modules.add((Object)module.toJSON());
        }
        return modules;
    }

    public IMoserModule buildTopModule(ModuleIdPair idPair, String userPassport, Map<String, String> cookiesToMoser, MoserEnv env) {
        String orgModuleId = idPair.getModuleId();
        this.collector = new MoserCollectRequiredObjects(userPassport, cookiesToMoser);
        this.collector.collectRequiredObjects(idPair, env);
        this.lastModified = this.collector.getLastModified();
        this.lifetime = this.collector.getLifeTime();
        this.topModuleStoreId = idPair.getModuleId();
        String etag = this.collector.getEtag();
        JSONObject moduleInfo = this.getTopModuleInfo(this.topModuleStoreId, this.collector.getTopModuleType(), orgModuleId);
        MoserModule module = (MoserModule)this.getModuleById(idPair, userPassport, cookiesToMoser, moduleInfo, true, env);
        module.setType(this.collector.getTopModuleType());
        if (etag != null) {
            module.setCacheKey(etag);
        }
        if (module != null) {
            this.addModuleSource(module, this.topModuleStoreId, moduleInfo);
        }
        module.convertLWOLAPToPackages(userPassport, env);
        this.collector = null;
        return module;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    protected JSONObject getTopModuleInfo(String storeId, String moduleType, String orgModuleId) {
        JSONObject rt = new JSONObject();
        rt.put((Object)"storeID", (Object)storeId);
        if (moduleType != null) {
            rt.put((Object)"type", (Object)moduleType);
        }
        if (MoserModuleReader.isSearchPath(orgModuleId)) {
            rt.put((Object)"searchPath", (Object)orgModuleId);
        }
        return rt;
    }

    protected void addModuleSource(MoserModule module, String storeId, JSONObject moduleInfo) {
        if (module.getSource() != null) {
            return;
        }
        if (moduleInfo == null) {
            MoserModuleUtil.addModuleSource(module, storeId, "module", null);
        } else {
            MoserModuleUtil.addModuleSource(module, storeId, (String)moduleInfo.get((Object)"type"), (String)moduleInfo.get((Object)"searchPath"));
        }
    }

    public Date getDatasetLastModified() {
        Date lastModifiedDate = null;
        for (Map.Entry<Pair, IMoserModule> entry : this.allModules.entrySet()) {
            IMoserModule module = entry.getValue();
            Date currLastModified = module.getDatasetLastModifiedDate();
            if (currLastModified == null) continue;
            if (lastModifiedDate == null) {
                lastModifiedDate = currLastModified;
                continue;
            }
            if (currLastModified.getTime() <= lastModifiedDate.getTime()) continue;
            lastModifiedDate = currLastModified;
        }
        return lastModifiedDate;
    }

    public boolean isStale(String modulePath, String passport, Map<String, String> cookies, String etagStr, MoserEnv env) {
        JSONObject response;
        String responseCodeStr;
        int status;
        RequestEnvironment reqEnv;
        IMoserModuleReader reader = env.getModuleReader();
        if (!reader.is304Capable()) {
            return true;
        }
        if (!MoserCollectRequiredObjects.getDefinitionForAllRequiredModules(env)) {
            return true;
        }
        if (etagStr == null || etagStr.isEmpty()) {
            return true;
        }
        if (!MoserModuleUtil.isSessionTempID(modulePath)) {
            return MoserModuleIsStaleChecker.getInstance().checkIsStale(modulePath, etagStr);
        }
        HttpServletRequest r = null;
        ExecutionEnvironment execEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        if (execEnv != null && (reqEnv = (RequestEnvironment)execEnv.getRequestEnvironment()) != null) {
            r = reqEnv.getHttpServletRequest();
        }
        return (status = Integer.parseInt(responseCodeStr = (String)(response = reader.read(this.topModuleStoreId, passport, cookies, null, etagStr, r)).get((Object)"responseStatus"))) != 304;
    }

    public JSONObject getDataSourceConnectionInfo(String assetId, Map<String, String> cookiesToMoser, MoserEnv env) {
        RequestEnvironment reqEnv;
        HttpServletRequest r = null;
        if (env.getModuleReader() instanceof WAMoserModuleReader && env.getExecutionEnvironment() != null && (reqEnv = (RequestEnvironment)env.getExecutionEnvironment().getRequestEnvironment()) != null) {
            r = reqEnv.getHttpServletRequest();
        }
        return env.getModuleReader().getDataSourceConnectionInfo(assetId, cookiesToMoser, r);
    }

    public String getCSVToParquet(String moduleName, String module, Map<String, String> cookiesToMoser, MoserEnv env) {
        RequestEnvironment reqEnv;
        HttpServletRequest r = null;
        if (env.getModuleReader() instanceof WAMoserModuleReader && env.getExecutionEnvironment() != null && (reqEnv = (RequestEnvironment)env.getExecutionEnvironment().getRequestEnvironment()) != null) {
            r = reqEnv.getHttpServletRequest();
        }
        return env.getModuleReader().getCSVToParquet(moduleName, module, cookiesToMoser, r);
    }

    public String getTopModuleId() {
        return this.topModuleStoreId;
    }

    static {
        datasetManager = DatasetManager.getInstanceNoInit();
    }
}

