/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemoser;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.provider.MetadataService;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.OperationEnum;
import com.cognos.xqemoser.BaseHTTPClient;
import com.cognos.xqemoser.HTTPClientResponse;
import com.cognos.xqemoser.IMoserModuleReader;
import com.cognos.xqemoser.MoserModuleManager;
import com.ibm.bi.rest.RESTClient;
import com.ibm.bi.rest.RESTClientConfig;
import com.ibm.bi.rest.RESTClientFactory;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.IOUtils;

public class MoserModuleReader
extends BaseHTTPClient
implements IMoserModuleReader {
    private static final String STR_SPACES = "   ";
    private static final String STR_STATUS = " status=";
    private static final String STR_UTF8 = "UTF8";
    private static final String XQEMOSER_WHOLE = "xqemoser=whole";
    private static final String XQEMOSER_TRUE = "xqemoser=true";
    private static final String SOAP_ACTION = "SOAPAction";
    private String moserBasePath = MetadataService.getInstance().getMoserBasePath();

    public MoserModuleReader() {
        super(null, null);
    }

    @Override
    public JSONObject read(String modulePath, String camPassport, Map<String, String> cookiesToMoser, String explicitParam, String cacheKey, HttpServletRequest servletRequest) {
        int statusCode;
        this.camPassport = camPassport;
        this.cookies = cookiesToMoser;
        boolean bGetAllModules = MetadataService.getInstance().getMoserAllModules();
        String queryParam = explicitParam;
        if (queryParam == null) {
            queryParam = !bGetAllModules ? XQEMOSER_TRUE : XQEMOSER_WHOLE;
        }
        String urlStr = MoserModuleReader.isSearchPath(modulePath) ? this.moserBasePath + "searchPath?searchPath=" + MoserModuleReader.encodeURIComponent(modulePath) + "&" + queryParam : this.moserBasePath + MoserModuleReader.encodeURIComponent(modulePath) + "?" + queryParam;
        try {
            JSONObject response = this.getResourceAsJSONObject(urlStr, cacheKey, servletRequest);
            String responseCodeStr = (String)response.get((Object)"responseStatus");
            statusCode = Integer.parseInt(responseCodeStr);
            if (statusCode == 200 || statusCode == 304) {
                return response;
            }
        }
        catch (Exception e) {
            throw new XQERuntimeException(XQEMessageKeys.MD_MetadataConnectionFailed, (Throwable)e, modulePath);
        }
        if (statusCode == 403) {
            throw new XQERuntimeException(XQEMessageKeys.MD_MetadataPermissionDenied, modulePath + 12 + statusCode);
        }
        throw new XQERuntimeException(XQEMessageKeys.MD_MetadataConnectionFailed, modulePath + 12 + statusCode);
    }

    protected JSONObject getResourceAsJSONObject(String urlStr, String cacheKey, HttpServletRequest servletRequest) throws UnsupportedEncodingException, IOException {
        return this.getUsingRESTClient(cacheKey, urlStr, servletRequest);
    }

    private JSONObject getUsingRESTClient(String cacheKey, String urlStr, HttpServletRequest request) throws UnsupportedEncodingException, IOException {
        if (MoserModuleReader.loggingEnabled()) {
            MoserModuleReader.log(LogLevel.INFO, OperationEnum.START, "start reading module " + urlStr);
        }
        JSONObject response = new JSONObject();
        try (RESTClient client = this.getClient(request);){
            String soapAction;
            if (request != null && (soapAction = request.getHeader(SOAP_ACTION)) != null) {
                MoserModuleReader.setCookiesClientConfig(client, this.camPassport, this.cookies);
                client.setRequestHeader(SOAP_ACTION, null);
            }
            if (request == null) {
                MoserModuleReader.setCookiesClientConfig(client, this.camPassport, this.cookies);
            }
            client.setRequestHeader("If-None-Match", cacheKey);
            client.setRequestHeader("Accept", "application/json");
            client.makeTrusted("XQE");
            int statusCode = client.getResource(urlStr);
            response.put((Object)"responseStatus", (Object)Integer.toString(statusCode));
            if (200 == statusCode) {
                String lastModified;
                String etag = client.getResponseHeader("ETag");
                if (etag != null) {
                    response.put((Object)"cacheKey", (Object)etag);
                }
                if ((lastModified = client.getResponseHeader("Last-Modified")) != null) {
                    response.put((Object)"lastModified", (Object)lastModified);
                }
                String strResp = new String(IOUtils.toByteArray((InputStream)client.getResponseStream()), STR_UTF8);
                if (MoserModuleReader.loggingEnabled()) {
                    MoserModuleReader.log(LogLevel.INFO, strResp);
                }
                response.put((Object)"moduleDef", (Object)strResp);
                if (MoserModuleReader.loggingEnabled()) {
                    MoserModuleReader.log(LogLevel.INFO, OperationEnum.END, "end reading module " + urlStr + STR_STATUS + statusCode);
                }
            }
            JSONObject jSONObject = response;
            return jSONObject;
        }
    }

    private RESTClient getClient(HttpServletRequest request) {
        if (request != null) {
            return RESTClientFactory.getInstance().getClient(request);
        }
        return RESTClientFactory.getInstance().getClient(new RESTClientConfig("XQE"));
    }

    protected static boolean isSearchPath(String modulePath) {
        return modulePath.startsWith("CAMID") || modulePath.startsWith("/content");
    }

    @Override
    public String getModificationTime(String modulePath, String pass, Map<String, String> cookiesToMoser) {
        GetMethod httpGet;
        block15: {
            this.camPassport = pass;
            this.cookies = cookiesToMoser;
            httpGet = null;
            try {
                JSONObject jObj;
                String urlStr;
                if (MoserModuleReader.isSearchPath(modulePath)) {
                    urlStr = this.moserBasePath + "searchPath/info?searchPath=" + MoserModuleReader.encodeURIComponent(modulePath) + "&attributes=lastModified&attributes=xqemoser";
                } else {
                    urlStr = this.moserBasePath + MoserModuleReader.encodeURIComponent(modulePath);
                    urlStr = urlStr + "/info?attributes=lastModified&attributes=xqemoser";
                }
                if (MoserModuleReader.loggingEnabled()) {
                    MoserModuleReader.log(LogLevel.INFO, OperationEnum.START, "start modification time " + urlStr);
                }
                httpGet = new GetMethod();
                httpGet.setPath(urlStr);
                httpGet.setRequestHeader("Accept", "application/json");
                MoserModuleReader.setAcceptEncoding((HttpMethodBase)httpGet, this.useHttpCompression);
                MoserModuleReader.setCookies((HttpMethodBase)httpGet, this.camPassport, cookiesToMoser);
                int code = this.client.executeMethod((HttpMethod)httpGet);
                if (code != 200) break block15;
                HTTPClientResponse response = new HTTPClientResponse(code, (HttpMethodBase)httpGet);
                if (MoserModuleReader.loggingEnabled()) {
                    MoserModuleReader.log(LogLevel.INFO, OperationEnum.END, "end modification time " + urlStr + STR_STATUS + code);
                }
                if ((jObj = response.getJSONObjectResponse()).isEmpty()) break block15;
                for (Object k : jObj.keySet()) {
                    String kName = (String)k;
                    Object v = jObj.get(k);
                    if (!"lastModified".equals(kName)) continue;
                    if (v != null) {
                        if (v instanceof String) {
                            String string = (String)v;
                            return string;
                        }
                        String string = v.toString();
                        return string;
                    }
                    break;
                }
            }
            catch (Exception e) {
                throw new XQERuntimeException(XQEMessageKeys.MD_MetadataConnectionFailed, (Throwable)e, modulePath);
            }
            finally {
                if (httpGet != null) {
                    httpGet.releaseConnection();
                }
            }
        }
        throw new XQERuntimeException(XQEMessageKeys.MD_MetadataConnectionFailed, modulePath + STR_SPACES + httpGet.getStatusLine().toString());
    }

    protected static void log(LogLevel aLogLevel, String text) {
        if (BaseHTTPClient.loggingEnabled()) {
            BaseHTTPClient.log(aLogLevel, text);
        } else {
            MoserModuleManager.log(aLogLevel, text);
        }
    }

    protected static void log(LogLevel aLogLevel, OperationEnum anOp, String text) {
        if (BaseHTTPClient.loggingEnabled()) {
            BaseHTTPClient.log(aLogLevel, anOp, text);
        } else {
            MoserModuleManager.log(aLogLevel, anOp, text);
        }
    }

    protected static boolean loggingEnabled() {
        return BaseHTTPClient.loggingEnabled() || MoserModuleManager.loggingEnabled();
    }

    @Override
    public boolean isXQEMoserWhole() {
        return true;
    }

    @Override
    public JSONObject getDataSourceConnectionInfo(String assetId, Map<String, String> cookiesToMoser, HttpServletRequest r) {
        return null;
    }

    @Override
    public String getCSVToParquet(String moduleName, String module, Map<String, String> cookiesToMoser, HttpServletRequest r) {
        return null;
    }

    @Override
    public boolean is304Capable() {
        return true;
    }
}

