/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemoser;

import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.io.TempFileUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.apache.commons.lang3.StringEscapeUtils;

public final class MoserOlapPackageGenerator {
    private static final String PACKAGE_CONTENT = "<project containsDynamicContent=\"true\" queryMode=\"dynamic\" useMFW=\"true\" xmlns=\"http://www.developer.cognos.com/schemas/bmt/60/12\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.developer.cognos.com/schemas/bmt/60/12 BMTModelSpecification.xsd\">\t<name>DATASOURCE_NAME</name>\t<property name=\"multilingualLWM\" type=\"hidden\">false</property>\t<locales>\t\t<locale>en</locale>CONTENT_LOCALE_PLACEHOLDEREXPRESSION_LOCALE_PLACEHOLDER\t</locales>\t<defaultLocale>en</defaultLocale>\t<physicalSources/>\t<namespace>\t\t<name locale=\"en\">THE_CUBE_NAME</name>NAMESPACE_CUBE_PLACEHOLDERNAMESPACE_EXPRESSION_CUBE_PLACEHOLDER\t\t<property name=\"dynamicContent\" type=\"hidden\">true</property>\t\t<property name=\"dynamicSource\" type=\"hidden\">&amp;lt;item Name=&amp;quot;DATASOURCE_NAME_IN_PROP&amp;quot; Type=&amp;quot;database&amp;quot; Value=&amp;quot;partial&amp;quot; dbType=&amp;quot;PROVIDER_TYPE_PLACEHOLDER&amp;quot; origin=&amp;quot;portal&amp;quot; storeSpec=&amp;quot;true&amp;quot;&amp;gt;&amp;lt;item Name=&amp;quot;CATALOG_NAME_IN_PROP&amp;quot; Type=&amp;quot;catalog&amp;quot; Value=&amp;quot;partial&amp;quot; uniqueName=&amp;quot;CATALOG_NAME_IN_PROP&amp;quot;&amp;gt;&amp;lt;item Name=&amp;quot;THE_CUBE_NAME_IN_PROP&amp;quot; Type=&amp;quot;cube&amp;quot; Value=&amp;quot;true&amp;quot; uniqueName=&amp;quot;THE_CUBE_NAME_IN_PROP&amp;quot;/&amp;gt;&amp;lt;/item&amp;gt;&amp;lt;/item&amp;gt;</property>\t</namespace>\t<dataSources/>\t<parameterMaps>\t\t<parameterMap hidden=\"true\">\t\t\t<name>_env</name>\t\t</parameterMap>\t\t<parameterMap hidden=\"true\">\t\t\t<name>_governor</name>\t\t</parameterMap>\t</parameterMaps>\t<securityViews>\t\t<securityView>\t\t\t<name>DATASOURCE_NAME</name>\t\t\t<definition>\t\t\t\t<set includeRule=\"include\">\t\t\t\t\t<refobj>[THE_CUBE_NAME]</refobj>\t\t\t\t</set>\t\t\t</definition>\t\t\t<access/>\t\t\t<functionSets>\t\t\t\t<functionSet>\t\t\t\t\t<functionSetID>none</functionSetID>\t\t\t\t</functionSet>\t\t\t</functionSets>\t\t\t<qosOverrides/>\t\t</securityView>\t</securityViews>\t<packages>\t\t<package>\t\t\t<name locale=\"en\">DATASOURCE_NAME</name>\t\t\t<lastChanged>2017-05-29T14:38:00</lastChanged>\t\t\t<lastChangedBy>Anonymous</lastChangedBy>\t\t\t<maxVersions>0</maxVersions>\t\t\t<locales>\t\t\t\t<locale>en</locale>CONTENT_LOCALE_PLACEHOLDEREXPRESSION_LOCALE_PLACEHOLDER\t\t\t</locales>\t\t\t<definition>\t\t\t\t<viewref>[].[securityViews].[DATASOURCE_NAME]</viewref>\t\t\t</definition>\t\t\t<adminAccess/>\t\t\t<useV5DataServer>true</useV5DataServer>\t\t</package>\t</packages></project>";
    private static final String CONTENT_LOCALE_PLACEHOLDER_CONTENT = "<locale>THE_CONTENT_LOCALE</locale>";
    private static final String CONTENT_EXPRESSION_PLACEHOLDER_CONTENT = "<locale>THE_EXPRESSION_LOCALE</locale>";
    private static final String CUBE_NAME_IN_CONTENT_LOCALE_CONTENT = "<name locale=\"THE_CONTENT_LOCALE\">THE_CUBE_NAME</name>";
    private static final String CUBE_NAME_IN_EXPRESSION_LOCALE_CONTENT = "<name locale=\"THE_EXPRESSION_LOCALE\">THE_CUBE_NAME</name>";
    private static final Pattern DATASOURCE_PATTERN = Pattern.compile("DATASOURCE_NAME");
    private static final Pattern CATALOG_PATTERN = Pattern.compile("CATALOG_NAME");
    private static final Pattern DATASOURCE_PATTERN_IN_PROP = Pattern.compile("DATASOURCE_NAME_IN_PROP");
    private static final Pattern CATALOG_PATTERN_IN_PROP = Pattern.compile("CATALOG_NAME_IN_PROP");
    private static final Pattern PROVIDER_TYPE_PLACEHOLDER_PATTERN = Pattern.compile("PROVIDER_TYPE_PLACEHOLDER");
    private static final Pattern THE_CUBE_NAME_PATTERN = Pattern.compile("THE_CUBE_NAME");
    private static final Pattern THE_CUBE_NAME_PATTERN_IN_PROP = Pattern.compile("THE_CUBE_NAME_IN_PROP");
    private static final Pattern CONTENT_LOCALE_PLACEHOLDER_PATTERN = Pattern.compile("CONTENT_LOCALE_PLACEHOLDER");
    private static final Pattern EXPRESSION_LOCALE_PLACEHOLDER_PATTERN = Pattern.compile("EXPRESSION_LOCALE_PLACEHOLDER");
    private static final Pattern THE_CONTENT_LOCALE_PATTERN = Pattern.compile("THE_CONTENT_LOCALE");
    private static final Pattern THE_EXPRESSION_LOCALE_PATTERN = Pattern.compile("THE_EXPRESSION_LOCALE");
    private static final Pattern CUBE_NAME_IN_CONTENT_LOCALE_PLACEHOLDER_PATTERN = Pattern.compile("NAMESPACE_CUBE_PLACEHOLDER");
    private static final Pattern CUBE_NAME_IN_EXPRESSION_LOCALE_PLACEHOLDER_PATTERN = Pattern.compile("NAMESPACE_EXPRESSION_CUBE_PLACEHOLDER");
    private static final String ENGLISH = "en";
    private static final String EMPTY_STRING = "";

    private MoserOlapPackageGenerator() {
    }

    public static String generatePackageContent(String inProviderType, String datasource, String catalog, String cube, String inContentLocale) {
        return MoserOlapPackageGenerator.generatePackageContent(inProviderType, datasource, catalog, cube, inContentLocale, null);
    }

    public static String generatePackageContent(String inProviderType, String datasource, String catalog, String cube, String inContentLocale, String inExpressionLocale) {
        String providerType = inProviderType;
        if (providerType == null) {
            providerType = "TMR";
        }
        String escapedDatasourceName = StringEscapeUtils.escapeXml((String)datasource);
        String escapedCatalogName = StringEscapeUtils.escapeXml((String)catalog);
        String escapedCubeName = StringEscapeUtils.escapeXml((String)cube);
        String doubleEscapedDatasourceName = MoserOlapPackageGenerator.doubleEscape(escapedDatasourceName);
        String doubleEscapedCatalogName = MoserOlapPackageGenerator.doubleEscape(escapedCatalogName);
        String doubleEscapedCubeName = MoserOlapPackageGenerator.doubleEscape(escapedCubeName);
        String contentLocale = MoserOlapPackageGenerator.getLocaleLanguage(inContentLocale);
        String expressionLocale = MoserOlapPackageGenerator.getLocaleLanguage(inExpressionLocale);
        return PROVIDER_TYPE_PLACEHOLDER_PATTERN.matcher(THE_CUBE_NAME_PATTERN.matcher(THE_CUBE_NAME_PATTERN_IN_PROP.matcher(CATALOG_PATTERN.matcher(CATALOG_PATTERN_IN_PROP.matcher(DATASOURCE_PATTERN.matcher(DATASOURCE_PATTERN_IN_PROP.matcher(CUBE_NAME_IN_CONTENT_LOCALE_PLACEHOLDER_PATTERN.matcher(CONTENT_LOCALE_PLACEHOLDER_PATTERN.matcher(CUBE_NAME_IN_EXPRESSION_LOCALE_PLACEHOLDER_PATTERN.matcher(EXPRESSION_LOCALE_PLACEHOLDER_PATTERN.matcher(PACKAGE_CONTENT).replaceAll(MoserOlapPackageGenerator.generateExpressionLocaleString(expressionLocale, contentLocale))).replaceAll(MoserOlapPackageGenerator.generateCubeNameInExpressionLocaleString(escapedCubeName, expressionLocale, contentLocale))).replaceAll(MoserOlapPackageGenerator.generateContentLocaleString(contentLocale))).replaceAll(MoserOlapPackageGenerator.generateCubeNameInContentLocaleString(escapedCubeName, contentLocale))).replaceAll(doubleEscapedDatasourceName)).replaceAll(escapedDatasourceName)).replaceAll(doubleEscapedCatalogName)).replaceAll(escapedCatalogName)).replaceAll(doubleEscapedCubeName)).replaceAll(escapedCubeName)).replaceAll(providerType);
    }

    private static String doubleEscape(String toEscape) {
        return toEscape.replaceAll("&amp;", "&amp;amp;amp;").replaceAll("&quot;", "&amp;amp;quot;").replaceAll("&apos;", "&amp;amp;apos;").replaceAll("&lt;", "&amp;amp;lt;").replaceAll("&gt;", "&amp;amp;gt;");
    }

    private static String generateCubeNameInContentLocaleString(String cubeName, String contentLocale) {
        if (contentLocale == null || ENGLISH.equals(contentLocale)) {
            return EMPTY_STRING;
        }
        return THE_CUBE_NAME_PATTERN.matcher(THE_CONTENT_LOCALE_PATTERN.matcher(CUBE_NAME_IN_CONTENT_LOCALE_CONTENT).replaceAll(contentLocale)).replaceAll(cubeName);
    }

    private static String generateCubeNameInExpressionLocaleString(String cubeName, String expressionLocale, String contentLocale) {
        if (expressionLocale == null || ENGLISH.equals(expressionLocale) || expressionLocale.equals(contentLocale)) {
            return EMPTY_STRING;
        }
        return THE_CUBE_NAME_PATTERN.matcher(THE_EXPRESSION_LOCALE_PATTERN.matcher(CUBE_NAME_IN_EXPRESSION_LOCALE_CONTENT).replaceAll(expressionLocale)).replaceAll(cubeName);
    }

    private static String generateContentLocaleString(String contentLocale) {
        if (contentLocale == null || ENGLISH.equals(contentLocale)) {
            return EMPTY_STRING;
        }
        return THE_CONTENT_LOCALE_PATTERN.matcher(CONTENT_LOCALE_PLACEHOLDER_CONTENT).replaceAll(contentLocale);
    }

    private static String generateExpressionLocaleString(String expressionLocale, String contentLocale) {
        if (expressionLocale == null || ENGLISH.equals(expressionLocale) || expressionLocale.equals(contentLocale)) {
            return EMPTY_STRING;
        }
        return THE_EXPRESSION_LOCALE_PATTERN.matcher(CONTENT_EXPRESSION_PLACEHOLDER_CONTENT).replaceAll(expressionLocale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeToFile(File f, String output) throws IOException {
        FileWriterWithEncoding fw = null;
        BufferedWriter writer = null;
        try {
            fw = new FileWriterWithEncoding(f.getAbsoluteFile(), "UTF-8");
            writer = new BufferedWriter((Writer)fw);
            writer.write(output);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (fw != null) {
                fw.close();
            }
        }
    }

    private static File createTempFile() throws IOException {
        File tempDir = TempFileUtil.createTempDir("moser");
        return File.createTempFile("olappkg", "tempOLAPmodel.xml", tempDir);
    }

    public static String writePackageContentToTempFile(String providerType, String datasource, String catalog, String cube, String contentLocale) throws IOException {
        File tempFile = MoserOlapPackageGenerator.createTempFile();
        MoserOlapPackageGenerator.writeToFile(tempFile, MoserOlapPackageGenerator.generatePackageContent(providerType, datasource, catalog, cube, contentLocale));
        return tempFile.getAbsolutePath();
    }

    public static String writePackageContentToTempFile(String providerType, String datasource, String catalog, String cube, String contentLocale, String expressionLocale) throws IOException {
        File tempFile = MoserOlapPackageGenerator.createTempFile();
        MoserOlapPackageGenerator.writeToFile(tempFile, MoserOlapPackageGenerator.generatePackageContent(providerType, datasource, catalog, cube, contentLocale, expressionLocale));
        return tempFile.getAbsolutePath();
    }

    private static String getLocaleLanguage(String inLocale) {
        if (null == inLocale) {
            return null;
        }
        Locale locale = LocaleConverter.strToLocale(inLocale);
        if (ENGLISH.equals(locale.getLanguage())) {
            return ENGLISH;
        }
        return locale.getLanguage();
    }
}

