/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemoser;

import com.cognos.developer.schemas.bibus._3.ParameterCapabilityEnum;
import com.cognos.xqe.ast.macro.MacroExpander;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.DataTypeComparator;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.MemberType;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.provider.IMetadataConnection;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.UnresolvedParameterException;
import com.cognos.xqe.query.parameters.BoundedRangeParameterValueItem;
import com.cognos.xqe.query.parameters.HierarchicalParmValueItem;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.ParameterCapabilities;
import com.cognos.xqe.query.parameters.ParameterValueItem;
import com.cognos.xqe.query.parameters.ParameterValues;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.query.parameters.UnboundedEndRangeParameterValueItem;
import com.cognos.xqe.query.parameters.UnboundedStartRangeParameterValueItem;
import com.cognos.xqe.query.parameters.V5ParameterValueItem;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.transformation.moser.MoserCommandUtil;
import com.cognos.xqebifw.bibushandler.XQENodeSerializer;
import com.cognos.xqemoser.IMoserModule;
import com.cognos.xqemoser.ModuleIdPair;
import com.cognos.xqemoser.MoserCalculation;
import com.cognos.xqemoser.MoserMetadataConnection;
import com.cognos.xqemoser.MoserModule;
import com.cognos.xqemoser.MoserModuleUtil;
import com.cognos.xqemoser.MoserParameter;
import com.cognos.xqemoser.MoserQueryItem;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.dom4j.Element;

public final class MoserParameterUtil {
    protected static final String ACTIVE = "refActiveParameterValueSet";
    protected static final String PARAMETER_VALUESET = "parameterValueSet";
    protected static final String PARAMETER_VALUE = "parameterValue";
    protected static final String PARAMETER_NAME = "parameterName";
    protected static final String PARAMETER_DATATYPE = "dataType";
    protected static final String PARAMETER_INVERT = "invert";
    protected static final String PARAMETER_VALUES = "values";
    protected static final String PARAMETER_VALUE_OPERATOR = "operator";
    protected static final String PARAMETER_VALUE_USE = "use";
    protected static final String PARAMETER_VALUE_DISPLAY = "display";
    protected static final String PARAMETER_VALUE_USE2 = "use2";
    protected static final String PARAMETER_VALUE_DISPLAY2 = "display2";
    protected static final String PARAMETER_VALUE_OPERATOR_NULL = "isNull";
    protected static final String PARAMETER_VALUE_OPERATOR_BETWEEN = "between";
    protected static final String PARAMETER_VALUE_OPERATOR_EQUAL = "equal";
    protected static final String PARAMETER_VALUE_MODELFILTERITEM = "modelFilterItem";
    protected static final String PARAMETER_VALUE_CAPABILITIES = "capabilities";

    public static void loadParameters(JSONObject jObj, MoserModule module) {
        String activePVSetId = (String)jObj.get((Object)ACTIVE);
        if (activePVSetId == null || activePVSetId.isEmpty()) {
            return;
        }
        JSONObject jActive = null;
        JSONArray jPVSets = (JSONArray)jObj.get((Object)PARAMETER_VALUESET);
        if (jPVSets == null || jPVSets.isEmpty()) {
            return;
        }
        for (int i = 0; i < jPVSets.size(); ++i) {
            JSONObject jPVSet = (JSONObject)jPVSets.get(i);
            String id = (String)jPVSet.get((Object)"identifier");
            if (!activePVSetId.equals(id)) continue;
            jActive = jPVSet;
            break;
        }
        if (jActive == null) {
            return;
        }
        JSONArray jPValues = (JSONArray)jActive.get((Object)PARAMETER_VALUE);
        if (jPValues == null || jPValues.isEmpty()) {
            return;
        }
        for (int i = 0; i < jPValues.size(); ++i) {
            JSONObject jPValue = (JSONObject)jPValues.get(i);
            String name = (String)jPValue.get((Object)PARAMETER_NAME);
            String dataType = (String)jPValue.get((Object)PARAMETER_DATATYPE);
            Boolean invert = (Boolean)jPValue.get((Object)PARAMETER_INVERT);
            MoserParameter parameter = new MoserParameter(name, Parameter.getParameterDataType(dataType));
            if (invert != null) {
                parameter.invert = invert;
            }
            module.parameters.put(name, parameter);
            JSONArray jValues = (JSONArray)jPValue.get((Object)PARAMETER_VALUES);
            if (jValues == null || jValues.isEmpty()) {
                parameter.values.setValueExplicitlyNotSupplied(true);
                continue;
            }
            ParameterValues values = parameter.getParameterValueItems();
            values.clear();
            MoserParameter.VALUE_TYPE tp = null;
            for (int j = 0; j < jValues.size(); ++j) {
                JSONObject aJValue = (JSONObject)jValues.get(j);
                ParameterValueItem item = null;
                String op = (String)aJValue.get((Object)PARAMETER_VALUE_OPERATOR);
                if (PARAMETER_VALUE_OPERATOR_NULL.equals(op)) {
                    item = new V5ParameterValueItem(parameter);
                    tp = MoserParameterUtil.checkType(tp, MoserParameter.VALUE_TYPE.ISNULL);
                } else if (PARAMETER_VALUE_OPERATOR_BETWEEN.equals(op)) {
                    item = MoserParameterUtil.generateRangeValueItem(aJValue, parameter);
                    tp = MoserParameterUtil.checkType(tp, MoserParameter.VALUE_TYPE.RANGE);
                } else {
                    String use = (String)aJValue.get((Object)PARAMETER_VALUE_USE);
                    String display = (String)aJValue.get((Object)PARAMETER_VALUE_DISPLAY);
                    if ("memberUniqueName".equals(dataType)) {
                        HierarchicalParmValueItem hierItem = new HierarchicalParmValueItem(parameter);
                        V5ParameterValueItem v = hierItem.getValue();
                        v.setInternalValue(use);
                        if (display != null) {
                            v.setDisplayValue(display);
                        }
                        item = hierItem;
                        tp = MoserParameterUtil.checkType(tp, MoserParameter.VALUE_TYPE.MUN);
                    } else {
                        V5ParameterValueItem valueItem = new V5ParameterValueItem(parameter);
                        valueItem.setInternalValue(use);
                        if (display != null) {
                            valueItem.setDisplayValue(display);
                        }
                        item = valueItem;
                        tp = MoserParameterUtil.checkType(tp, MoserParameter.VALUE_TYPE.SIMPLE);
                    }
                }
                values.add(item);
                parameter.valueOps.add(op);
            }
            parameter.valueType = tp;
        }
    }

    protected static MoserParameter.VALUE_TYPE checkType(MoserParameter.VALUE_TYPE oldtp, MoserParameter.VALUE_TYPE newTp) {
        if (oldtp == null) {
            return newTp;
        }
        if (oldtp == MoserParameter.VALUE_TYPE.INVALID) {
            return MoserParameter.VALUE_TYPE.INVALID;
        }
        if (oldtp == MoserParameter.VALUE_TYPE.ISNULL) {
            return newTp;
        }
        if (oldtp != newTp) {
            return MoserParameter.VALUE_TYPE.INVALID;
        }
        return newTp;
    }

    protected static ParameterValueItem generateRangeValueItem(JSONObject aJValue, Parameter parameter) {
        String stUse = (String)aJValue.get((Object)PARAMETER_VALUE_USE);
        String stDisplay = (String)aJValue.get((Object)PARAMETER_VALUE_DISPLAY);
        String endUse = (String)aJValue.get((Object)PARAMETER_VALUE_USE2);
        String endDisplay = (String)aJValue.get((Object)PARAMETER_VALUE_DISPLAY2);
        if (stUse != null && endUse != null) {
            BoundedRangeParameterValueItem boundedRange = new BoundedRangeParameterValueItem(parameter);
            V5ParameterValueItem st = boundedRange.getStartValue();
            st.setInternalValue(stUse);
            if (stDisplay != null) {
                st.setDisplayValue(stDisplay);
            }
            V5ParameterValueItem end = boundedRange.getEndValue();
            end.setInternalValue(endUse);
            if (endDisplay != null) {
                end.setDisplayValue(endDisplay);
            }
            return boundedRange;
        }
        if (stUse == null) {
            UnboundedStartRangeParameterValueItem unboundedStart = new UnboundedStartRangeParameterValueItem(parameter);
            V5ParameterValueItem end = unboundedStart.getEndValue();
            end.setInternalValue(endUse);
            if (endDisplay != null) {
                end.setDisplayValue(endDisplay);
            }
            return unboundedStart;
        }
        UnboundedEndRangeParameterValueItem unboundedEnd = new UnboundedEndRangeParameterValueItem(parameter);
        V5ParameterValueItem st = unboundedEnd.getStartValue();
        st.setInternalValue(stUse);
        if (stDisplay != null) {
            st.setDisplayValue(stDisplay);
        }
        return unboundedEnd;
    }

    public static boolean moduleCanProvideParameterValue(Parameter parameter, IPlanningEnvironment env, boolean usedByMacro) {
        return MoserParameterUtil.getModuleParemeter(parameter, env, usedByMacro) != null;
    }

    protected static MoserParameter getModuleParemeter(Parameter parameter, IPlanningEnvironment env, boolean usedByMacro) {
        if (env == null) {
            return null;
        }
        if (parameter.isMasterDetailLinkParameter()) {
            return null;
        }
        MetadataConnection mc = (MetadataConnection)env.getMetadataConnection();
        if (!(mc instanceof MoserMetadataConnection)) {
            return null;
        }
        MoserMetadataConnection moserMC = (MoserMetadataConnection)mc;
        MoserParameter moduleParam = moserMC.module.getParameter(parameter.getName());
        if (moduleParam == null) {
            return null;
        }
        if (!DataTypeComparator.isComparableTo(moduleParam.getDataType(), parameter.getDataType())) {
            return null;
        }
        if (moduleParam.valueType == MoserParameter.VALUE_TYPE.INVALID) {
            return null;
        }
        if (usedByMacro ? moduleParam.valueType != MoserParameter.VALUE_TYPE.ISNULL && moduleParam.valueType != MoserParameter.VALUE_TYPE.SIMPLE : !MoserParameterUtil.checkCapabilities(parameter, moduleParam)) {
            return null;
        }
        return moduleParam;
    }

    public static void cloneParameterValues(Parameter parameter, IPlanningEnvironment env, boolean usedByMacro) {
        MoserParameter moduleParam = MoserParameterUtil.getModuleParemeter(parameter, env, usedByMacro);
        if (moduleParam == null) {
            return;
        }
        ParameterValues moduleValues = moduleParam.getParameterValueItems();
        if (moduleValues.isEmpty()) {
            if (moduleValues.isValueExplicitlyNotSupplied()) {
                parameter.getParameterValueItems().setValueExplicitlyNotSupplied(true);
            }
            return;
        }
        parameter.setLocation(Parameter.LOCATION.MODULE);
        ParameterValues values = parameter.getParameterValueItems();
        values.clear();
        for (ParameterValueItem item : moduleValues) {
            values.add(MoserParameterUtil.cloneParameterValueItem(item, parameter, env));
        }
        parameter.setExternalValues((PlanningEnvironment)env);
    }

    protected static boolean checkCapabilities(Parameter parameter, MoserParameter moduleParam) {
        if (!parameter.isLiteral()) {
            return moduleParam.valueType == MoserParameter.VALUE_TYPE.MUN;
        }
        if (moduleParam.valueType == MoserParameter.VALUE_TYPE.RANGE) {
            ParameterCapabilities capas = parameter.getCapabilities();
            return capas.contains(ParameterCapabilityEnum.boundRange) || capas.contains(ParameterCapabilityEnum.unboundedRange);
        }
        return true;
    }

    protected static ParameterValueItem cloneParameterValueItem(ParameterValueItem item, Parameter parameter, IPlanningEnvironment env) {
        if (item instanceof V5ParameterValueItem) {
            V5ParameterValueItem newItem = new V5ParameterValueItem(parameter);
            V5ParameterValueItem srcItem = (V5ParameterValueItem)item;
            newItem.setInternalValue(MoserParameterUtil.expandMacro(srcItem.getInternalValue(), env));
            newItem.setDisplayValue(MoserParameterUtil.expandMacro(srcItem.getDisplayValue(), env));
            return newItem;
        }
        if (item instanceof BoundedRangeParameterValueItem) {
            BoundedRangeParameterValueItem boundedRange = new BoundedRangeParameterValueItem(parameter);
            V5ParameterValueItem st = boundedRange.getStartValue();
            V5ParameterValueItem end = boundedRange.getEndValue();
            BoundedRangeParameterValueItem srcItem = (BoundedRangeParameterValueItem)item;
            V5ParameterValueItem srcSt = srcItem.getStartValue();
            V5ParameterValueItem srcEnd = srcItem.getEndValue();
            st.setInternalValue(MoserParameterUtil.expandMacro(srcSt.getInternalValue(), env));
            st.setDisplayValue(MoserParameterUtil.expandMacro(srcSt.getDisplayValue(), env));
            end.setInternalValue(MoserParameterUtil.expandMacro(srcEnd.getInternalValue(), env));
            end.setDisplayValue(MoserParameterUtil.expandMacro(srcEnd.getDisplayValue(), env));
            return boundedRange;
        }
        if (item instanceof UnboundedStartRangeParameterValueItem) {
            UnboundedStartRangeParameterValueItem unboundedStart = new UnboundedStartRangeParameterValueItem(parameter);
            UnboundedStartRangeParameterValueItem srcItem = (UnboundedStartRangeParameterValueItem)item;
            V5ParameterValueItem end = unboundedStart.getEndValue();
            V5ParameterValueItem srcEnd = srcItem.getEndValue();
            end.setInternalValue(MoserParameterUtil.expandMacro(srcEnd.getInternalValue(), env));
            end.setDisplayValue(MoserParameterUtil.expandMacro(srcEnd.getDisplayValue(), env));
            return unboundedStart;
        }
        if (item instanceof UnboundedEndRangeParameterValueItem) {
            UnboundedEndRangeParameterValueItem unboundedEnd = new UnboundedEndRangeParameterValueItem(parameter);
            V5ParameterValueItem st = unboundedEnd.getStartValue();
            UnboundedEndRangeParameterValueItem srcItem = (UnboundedEndRangeParameterValueItem)item;
            V5ParameterValueItem srcSt = srcItem.getStartValue();
            st.setInternalValue(MoserParameterUtil.expandMacro(srcSt.getInternalValue(), env));
            st.setDisplayValue(MoserParameterUtil.expandMacro(srcSt.getDisplayValue(), env));
            return unboundedEnd;
        }
        if (item instanceof HierarchicalParmValueItem) {
            HierarchicalParmValueItem hierItem = new HierarchicalParmValueItem(parameter);
            V5ParameterValueItem v = hierItem.getValue();
            HierarchicalParmValueItem srcItem = (HierarchicalParmValueItem)item;
            V5ParameterValueItem srcV = srcItem.getValue();
            v.setInternalValue(MoserParameterUtil.expandMacro(srcV.getInternalValue(), env));
            v.setDisplayValue(MoserParameterUtil.expandMacro(srcV.getDisplayValue(), env));
            return hierItem;
        }
        return null;
    }

    protected static String expandMacro(String src, IPlanningEnvironment env) {
        if (src == null || src.isEmpty()) {
            return src;
        }
        if (!src.contains("#")) {
            return src;
        }
        MacroExpander expander = new MacroExpander();
        return expander.expand(null, env, src);
    }

    protected static Map<String, Parameter> getUsedResolvedParams(RequestEnvironment environment) {
        Parameters parameters = environment.getRequestParameters();
        Parameters allParams = parameters.getNonMasterDetailParameters();
        if (allParams.isEmpty()) {
            return null;
        }
        Set<String> usedParams = environment.getBoundParameters();
        TreeMap<String, Parameter> usedResolvedParams = new TreeMap<String, Parameter>();
        for (Map.Entry entry : allParams.entrySet()) {
            if (!usedParams.contains(entry.getKey()) || !((Parameter)entry.getValue()).isResolved()) continue;
            usedResolvedParams.put((String)entry.getKey(), (Parameter)entry.getValue());
        }
        if (usedResolvedParams.isEmpty()) {
            return null;
        }
        return usedResolvedParams;
    }

    protected static JSONObject getJSONUsedResolvedParams(Map<String, Parameter> usedResolvedParams, RequestEnvironment environment) {
        JSONObject jParams = new JSONObject();
        JSONArray jParamArray = new JSONArray();
        jParams.put((Object)"parameterFeedbackInfo", (Object)jParamArray);
        for (Parameter param : usedResolvedParams.values()) {
            ParameterValues values;
            ParameterCapabilities capas;
            JSONObject jP = new JSONObject();
            jParamArray.add((Object)jP);
            jP.put((Object)PARAMETER_NAME, (Object)param.getParameterName());
            jP.put((Object)PARAMETER_DATATYPE, (Object)MoserParameterUtil.getParameterDataTypeName(param.getDataType()));
            String modelFilterItem = param.getModelItem();
            if (!modelFilterItem.isEmpty()) {
                jP.put((Object)PARAMETER_VALUE_MODELFILTERITEM, (Object)modelFilterItem);
            }
            if (!(capas = param.getCapabilities()).isEmpty()) {
                JSONArray jCapa = new JSONArray();
                jP.put((Object)PARAMETER_VALUE_CAPABILITIES, (Object)jCapa);
                ParameterCapabilityEnum[] sortedSet = new ParameterCapabilityEnum[capas.size()];
                Arrays.sort(capas.toArray(sortedSet), new ParameterCapabilityEnumComparator());
                for (ParameterCapabilityEnum capability : sortedSet) {
                    jCapa.add((Object)capability.toString());
                }
            }
            Parameter.LOCATION location = param.getLocation();
            jP.put((Object)"location", (Object)location.getValue());
            ArrayList<String> ops = null;
            if (location == Parameter.LOCATION.MODULE) {
                ops = new ArrayList<String>();
                Boolean invert = MoserParameterUtil.getInvert(param.getParameterName(), ((ExecutionEnvironment)environment.getExecutionEnvironment()).getMetadataConnection(), ops);
                if (invert != null) {
                    jP.put((Object)PARAMETER_INVERT, (Object)invert);
                }
            }
            if ((values = param.getParameterValueItems()).isEmpty() || values.isValueExplicitlyNotSupplied()) continue;
            JSONArray jValues = new JSONArray();
            jP.put((Object)PARAMETER_VALUES, (Object)jValues);
            for (int i = 0; i < values.size(); ++i) {
                ParameterValueItem v = (ParameterValueItem)values.get(i);
                String defaultOp = "equals";
                if (ops != null && ops.size() > i) {
                    defaultOp = (String)ops.get(i);
                }
                MoserParameterUtil.addJSONValue(jValues, v, defaultOp);
            }
        }
        return jParams;
    }

    public static void serializeUsedParameterValueToXML(Writer writer, RequestEnvironment environment) throws IOException {
        Map<String, Parameter> usedResolvedParams = MoserParameterUtil.getUsedResolvedParams(environment);
        if (usedResolvedParams == null) {
            return;
        }
        JSONObject jParams = MoserParameterUtil.getJSONUsedResolvedParams(usedResolvedParams, environment);
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("name", "usedParameterValue");
        XQENodeSerializer.openTag(writer, "property", attributes);
        writer.write(jParams.toString());
        XQENodeSerializer.closeTag(writer, "property");
    }

    protected static Boolean getInvert(String name, IMetadataConnection mc, List<String> ops) {
        if (!(mc instanceof MoserMetadataConnection)) {
            return null;
        }
        MoserMetadataConnection moserMC = (MoserMetadataConnection)mc;
        MoserParameter moduleParam = moserMC.module.getParameter(name);
        if (moduleParam == null) {
            return null;
        }
        ops.addAll(moduleParam.valueOps);
        return moduleParam.invert;
    }

    protected static String getParameterDataTypeName(IDataType dataType) {
        int cclDataType = dataType.getCCLTypeCode();
        if (dataType instanceof MemberType) {
            cclDataType = 43;
        }
        switch (cclDataType) {
            case 51: {
                return "boolean";
            }
            case 4: 
            case 6: 
            case 8: {
                return "integer";
            }
            case 13: 
            case 57: {
                return "date";
            }
            case 14: 
            case 52: 
            case 58: {
                return "time";
            }
            case 15: 
            case 53: 
            case 59: {
                return "datetime";
            }
            case 17: 
            case 60: {
                return "interval";
            }
            case 10: 
            case 11: 
            case 12: {
                return "decimal";
            }
            case 25: 
            case 30: 
            case 34: 
            case 43: {
                return "memberUniqueName";
            }
        }
        return "string";
    }

    protected static void addJSONValue(JSONArray jValues, ParameterValueItem v, String defaultOp) {
        JSONObject jV = new JSONObject();
        if (v instanceof V5ParameterValueItem) {
            V5ParameterValueItem simpleV = (V5ParameterValueItem)v;
            if (simpleV.hasNullValue()) {
                jV.put((Object)PARAMETER_VALUE_OPERATOR, (Object)PARAMETER_VALUE_OPERATOR_NULL);
            } else {
                String d;
                jV.put((Object)PARAMETER_VALUE_OPERATOR, (Object)defaultOp);
                String u = simpleV.getInternalValue();
                if (u != null) {
                    jV.put((Object)PARAMETER_VALUE_USE, (Object)u);
                }
                if ((d = simpleV.getDisplayValue()) != null) {
                    jV.put((Object)PARAMETER_VALUE_DISPLAY, (Object)d);
                }
            }
            jValues.add((Object)jV);
            return;
        }
        if (v instanceof BoundedRangeParameterValueItem) {
            BoundedRangeParameterValueItem boundedV = (BoundedRangeParameterValueItem)v;
            jV.put((Object)PARAMETER_VALUE_OPERATOR, (Object)PARAMETER_VALUE_OPERATOR_BETWEEN);
            V5ParameterValueItem st = boundedV.getStartValue();
            V5ParameterValueItem end = boundedV.getEndValue();
            String u = st.getInternalValue();
            String d = st.getDisplayValue();
            if (u != null) {
                jV.put((Object)PARAMETER_VALUE_USE, (Object)u);
            }
            if (d != null) {
                jV.put((Object)PARAMETER_VALUE_DISPLAY, (Object)d);
            }
            String u2 = end.getInternalValue();
            String d2 = end.getDisplayValue();
            if (u2 != null) {
                jV.put((Object)PARAMETER_VALUE_USE2, (Object)u2);
            }
            if (d2 != null) {
                jV.put((Object)PARAMETER_VALUE_DISPLAY2, (Object)d2);
            }
            jValues.add((Object)jV);
            return;
        }
        if (v instanceof UnboundedStartRangeParameterValueItem) {
            UnboundedStartRangeParameterValueItem stV = (UnboundedStartRangeParameterValueItem)v;
            jV.put((Object)PARAMETER_VALUE_OPERATOR, (Object)PARAMETER_VALUE_OPERATOR_BETWEEN);
            V5ParameterValueItem end = stV.getEndValue();
            String u2 = end.getInternalValue();
            String d2 = end.getDisplayValue();
            if (u2 != null) {
                jV.put((Object)PARAMETER_VALUE_USE2, (Object)u2);
            }
            if (d2 != null) {
                jV.put((Object)PARAMETER_VALUE_DISPLAY2, (Object)d2);
            }
            jValues.add((Object)jV);
            return;
        }
        if (v instanceof UnboundedEndRangeParameterValueItem) {
            UnboundedEndRangeParameterValueItem endV = (UnboundedEndRangeParameterValueItem)v;
            jV.put((Object)PARAMETER_VALUE_OPERATOR, (Object)PARAMETER_VALUE_OPERATOR_BETWEEN);
            V5ParameterValueItem st = endV.getStartValue();
            String u = st.getInternalValue();
            String d = st.getDisplayValue();
            if (u != null) {
                jV.put((Object)PARAMETER_VALUE_USE, (Object)u);
            }
            if (d != null) {
                jV.put((Object)PARAMETER_VALUE_DISPLAY, (Object)d);
            }
            jValues.add((Object)jV);
            return;
        }
        if (v instanceof HierarchicalParmValueItem) {
            String d;
            HierarchicalParmValueItem hierV = (HierarchicalParmValueItem)v;
            V5ParameterValueItem simpleV = hierV.getValue();
            jV.put((Object)PARAMETER_VALUE_OPERATOR, (Object)defaultOp);
            String u = simpleV.getInternalValue();
            if (u != null) {
                jV.put((Object)PARAMETER_VALUE_USE, (Object)u);
            }
            if ((d = simpleV.getDisplayValue()) != null) {
                jV.put((Object)PARAMETER_VALUE_DISPLAY, (Object)d);
            }
            jValues.add((Object)jV);
            return;
        }
    }

    public static String generatePromptFault(UnresolvedParameterException up) {
        JSONObject jResponse = new JSONObject();
        JSONArray jItems = new JSONArray();
        jResponse.put((Object)"messages", (Object)jItems);
        JSONObject jResult = new JSONObject();
        jItems.add((Object)jResult);
        jResult.put((Object)"severity", (Object)"error");
        jResult.put((Object)"exception", (Object)up.getClass().getSimpleName());
        jResult.put((Object)"code", (Object)up.getFaultCode());
        jResult.put((Object)"message", (Object)up.getFaultString());
        Parameters unresolvedParameters = up.getUnresolvedParameters();
        if (unresolvedParameters != null && !unresolvedParameters.isEmpty()) {
            JSONArray parameterLists = new JSONArray();
            jResult.put((Object)"parameterFault", (Object)parameterLists);
            TreeMap sortedParams = new TreeMap();
            for (Map.Entry entry : unresolvedParameters.entrySet()) {
                sortedParams.put(entry.getKey(), entry.getValue());
            }
            for (Parameter p : sortedParams.values()) {
                ParameterCapabilities capas;
                JSONObject jP = new JSONObject();
                parameterLists.add((Object)jP);
                jP.put((Object)PARAMETER_NAME, (Object)p.getParameterName());
                jP.put((Object)PARAMETER_DATATYPE, (Object)MoserParameterUtil.getParameterDataTypeName(p.getDataType()));
                String modelFilterItem = p.getModelItem();
                if (!modelFilterItem.isEmpty()) {
                    jP.put((Object)PARAMETER_VALUE_MODELFILTERITEM, (Object)modelFilterItem);
                }
                if ((capas = p.getCapabilities()).isEmpty()) continue;
                JSONArray jCapa = new JSONArray();
                jP.put((Object)PARAMETER_VALUE_CAPABILITIES, (Object)jCapa);
                ParameterCapabilityEnum[] sortedSet = new ParameterCapabilityEnum[capas.size()];
                Arrays.sort(capas.toArray(sortedSet), new ParameterCapabilityEnumComparator());
                for (ParameterCapabilityEnum capability : sortedSet) {
                    jCapa.add((Object)capability.toString());
                }
            }
        }
        return jResponse.toString();
    }

    public static String getIdForExpression(IMetadata metadata, String defaultId) {
        if (defaultId.endsWith("]")) {
            return defaultId;
        }
        if (!(metadata instanceof MoserQueryItem) && !(metadata instanceof MoserCalculation)) {
            return defaultId;
        }
        String id = MoserModuleUtil.getId(metadata);
        MoserModule module = null;
        module = metadata instanceof MoserQueryItem ? ((MoserQueryItem)metadata).parentQS.parentModule : ((MoserCalculation)metadata).parentModule;
        MoserMetadataConnection mc = module.getMetadataConnection();
        MoserModule topModule = mc.module;
        if (module.equals(topModule)) {
            return id;
        }
        ArrayList<ModuleIdPair> moduleChain = new ArrayList<ModuleIdPair>();
        LinkedList<ModuleIdPair> stack = new LinkedList<ModuleIdPair>();
        MoserParameterUtil.getModuleChain(mc, topModule, module, stack, moduleChain);
        if (moduleChain.isEmpty()) {
            return defaultId;
        }
        StringBuilder sb = new StringBuilder();
        for (ModuleIdPair p : moduleChain) {
            sb.append(p.getAlias());
            sb.append(".");
        }
        return sb.toString() + id;
    }

    protected static boolean getModuleChain(MoserMetadataConnection mc, MoserModule module, MoserModule stopModule, LinkedList<ModuleIdPair> stack, List<ModuleIdPair> moduleChain) {
        for (ModuleIdPair importModule : module.importModules) {
            if (IMoserModule.ModuleType.REPORT == importModule.getModuleType()) continue;
            stack.addLast(importModule);
            MoserModule importModuleObj = (MoserModule)mc.getModuleManager().getExistModuleWrapper(importModule, mc.theConnectionPassport);
            if (stopModule.equals(importModuleObj)) {
                moduleChain.addAll(stack);
                return true;
            }
            if (MoserParameterUtil.getModuleChain(mc, importModuleObj, stopModule, stack, moduleChain)) {
                return true;
            }
            stack.removeLast();
        }
        return false;
    }

    public static void addRequestParameterValue(Element rootElement, RequestEnvironment reqEnv, PlanningEnvironment planEnv) {
        Element functionSpec = rootElement.element("moserFunction");
        if (functionSpec == null) {
            return;
        }
        String sValue = MoserCommandUtil.getNamedValue(functionSpec, PARAMETER_VALUE);
        if (sValue == null || sValue.isEmpty()) {
            return;
        }
        JSONArray jValues = null;
        try {
            jValues = JSONArray.parse((String)sValue);
        }
        catch (IOException e) {
            if (MoserCommandUtil.INFO_LOGGER.isOn()) {
                MoserCommandUtil.INFO_LOGGER.log(LogLevel.INFO, "invalid parameter value: " + sValue);
            }
            return;
        }
        if (jValues == null || jValues.isEmpty()) {
            return;
        }
        Parameters parameters = reqEnv.getRequestParameters();
        for (Object o : jValues) {
            JSONObject jP = (JSONObject)o;
            String pName = (String)jP.get((Object)PARAMETER_NAME);
            if (pName == null || pName.isEmpty()) continue;
            String dt = (String)jP.get((Object)PARAMETER_DATATYPE);
            Parameter parameter = parameters.getParameter(pName);
            if (parameter != null) continue;
            parameter = new Parameter(pName, Parameter.getParameterDataType(dt));
            parameter.setHasValueProvidedWithRequest(true);
            parameters.addParameter(pName, parameter);
            ParameterValues parameterValues = parameter.getParameterValueItems();
            JSONArray jVs = (JSONArray)jP.get((Object)PARAMETER_VALUES);
            if (jVs == null || jVs.isEmpty()) {
                parameterValues.setValueExplicitlyNotSupplied(true);
                continue;
            }
            for (Object vObj : jVs) {
                JSONObject aJValue = (JSONObject)vObj;
                ParameterValueItem item = null;
                String op = (String)aJValue.get((Object)PARAMETER_VALUE_OPERATOR);
                if (PARAMETER_VALUE_OPERATOR_NULL.equals(op)) {
                    item = new V5ParameterValueItem(parameter);
                } else if (PARAMETER_VALUE_OPERATOR_BETWEEN.equals(op)) {
                    item = MoserParameterUtil.generateRangeValueItem(aJValue, parameter);
                } else {
                    String use = (String)aJValue.get((Object)PARAMETER_VALUE_USE);
                    String display = (String)aJValue.get((Object)PARAMETER_VALUE_DISPLAY);
                    if ("memberUniqueName".equals(dt)) {
                        HierarchicalParmValueItem hierItem = new HierarchicalParmValueItem(parameter);
                        V5ParameterValueItem v = hierItem.getValue();
                        v.setInternalValue(use);
                        if (display != null) {
                            v.setDisplayValue(display);
                        }
                        item = hierItem;
                    } else {
                        V5ParameterValueItem valueItem = new V5ParameterValueItem(parameter);
                        valueItem.setInternalValue(use);
                        if (display != null) {
                            valueItem.setDisplayValue(display);
                        }
                        item = valueItem;
                    }
                }
                parameterValues.add(item);
            }
            parameter.setExternalValues(planEnv);
        }
    }

    public static void appendUsedParameterValueToResponse(Element responseElement, RequestEnvironment reqEnv) {
        Map<String, Parameter> usedResolvedParams = MoserParameterUtil.getUsedResolvedParams(reqEnv);
        if (usedResolvedParams == null) {
            return;
        }
        Element queryFeedbackResultElem = responseElement.addElement("queryFeedbackResult");
        Element propertyElem = queryFeedbackResultElem.addElement("property");
        propertyElem.addAttribute("name", "usedParameterValue");
        JSONObject jParams = MoserParameterUtil.getJSONUsedResolvedParams(usedResolvedParams, reqEnv);
        propertyElem.addText(jParams.toString());
    }

    public static class ParameterCapabilityEnumComparator
    implements Comparator<ParameterCapabilityEnum> {
        @Override
        public int compare(ParameterCapabilityEnum first, ParameterCapabilityEnum second) {
            return first.getValue().compareTo(second.getValue());
        }
    }
}

