/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemoser;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.macro.MacroExpander;
import com.cognos.xqe.ast.sql.SQLRelation;
import com.cognos.xqe.ast.sql.parser.ParseException;
import com.cognos.xqe.metadata.ICatalog;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.transformation.v5tocogsql.util.QuerySubjectSQLGenerator;
import com.cognos.xqemoser.MoserDataSource;
import com.cognos.xqemoser.MoserQuerySubject;
import java.util.List;

public class MoserSQLASTGenerator {
    private final MoserQuerySubject theQS;

    public MoserSQLASTGenerator(MoserQuerySubject querySubject) {
        this.theQS = querySubject;
    }

    public IXQEQueryNode generateSQLAST(PlanningEnvironment environment, IXQEQueryNode ownerNode) throws ParseException {
        QuerySubjectSQLGenerator sqlGenerator = new QuerySubjectSQLGenerator(ownerNode);
        String unexpandedSQL = sqlGenerator.getUnexpandedSQL(this.theQS);
        QuerySubjectSQLGenerator.SqlType sqlType = sqlGenerator.getSqlType();
        IXQEQueryNode sqlAST = sqlGenerator.generateSQLAST(environment, this.theQS);
        sqlAST.detach();
        if (unexpandedSQL.contains("#")) {
            sqlGenerator.getMacroExpandedSQL(environment, unexpandedSQL, sqlType, this.theQS);
        }
        IXQEQueryNode sqlASTcopy = environment.getNodeFactory().deepCopyNode(sqlAST);
        this.expandMacrosinSQLRelation(sqlASTcopy, environment);
        return sqlASTcopy;
    }

    public void expandMacrosinSQLRelation(IXQEQueryNode sqlAST, PlanningEnvironment environment) {
        List<IXQEQueryNode> relationNodes = sqlAST.getDescendantsOfTypesOrdered(new int[]{301016}, true);
        MoserDataSource moserDS = this.theQS.getParentDataSource();
        for (IXQEQueryNode rel : relationNodes) {
            String schema;
            ICatalog cat;
            String catalog;
            SQLRelation relation = (SQLRelation)rel;
            String databaseName = relation.getDatabaseName();
            if (databaseName == null && moserDS != null && (databaseName = moserDS.getCMDataSourceName()) != null) {
                relation.setDatabaseName(databaseName);
            }
            if (MacroExpander.isMacro(databaseName)) {
                relation.setRawCmDatabaseName(databaseName);
                relation.setDatabaseName(QuerySubjectSQLGenerator.getMacroExpandedString(databaseName, environment));
            }
            if ((catalog = relation.getCatalogName()) == null && moserDS != null && (cat = moserDS.getCatalog()) != null) {
                catalog = cat.getName();
                relation.setCatalogName(catalog);
            }
            if (MacroExpander.isMacro(catalog)) {
                relation.setRawCatalogName(catalog);
                catalog = QuerySubjectSQLGenerator.getMacroExpandedString(catalog, environment);
                if (catalog != null && catalog.length() > 0) {
                    relation.setCatalogName(catalog);
                } else {
                    relation.removeProperty("catalog");
                }
            }
            if ((schema = relation.getSchemaName()) == null && moserDS != null && (schema = moserDS.getSchema()) != null) {
                relation.setSchemaName(schema);
            }
            if (MacroExpander.isMacro(schema)) {
                relation.setRawSchemaName(schema);
                schema = QuerySubjectSQLGenerator.getMacroExpandedString(schema, environment);
                if (schema != null && schema.length() > 0) {
                    relation.setSchemaName(schema);
                } else {
                    relation.removeProperty("schema");
                }
            }
            if (moserDS == null) continue;
            relation.setModelDatasourceName(moserDS.getName());
        }
    }
}

