/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemoser;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.provider.MetadataService;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.OperationEnum;
import com.cognos.xqemoser.BaseHTTPClient;
import com.cognos.xqemoser.HTTPClientResponse;
import com.cognos.xqemoser.ReportServiceResponse;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.lang3.StringUtils;

public class ReportService
extends BaseHTTPClient {
    private static final String START_READING_REPORT_SPEC = "Start reading report spec: ";
    private static final String END_READING_REPORT_SPEC = "End reading report spec: ";
    private static final String FAILED_READING_REPORT_SPEC = "Failed reading report spec: ";
    private static final String STATUS = " status: ";
    private final String baseUrl = MetadataService.getInstance().getMoserBasePath().replace("modules/", "");

    public ReportService(String passp, Map<String, String> c) {
        super(passp, c);
    }

    public ReportServiceResponse getSpecification(String id, String eTag) {
        int responseCode;
        GetMethod httpGet = new GetMethod();
        String url = this.baseUrl + "reports/normalizedspec?id=" + ReportService.encodeURIComponent(id);
        if (ReportService.loggingEnabled()) {
            ReportService.log(LogLevel.INFO, OperationEnum.START, START_READING_REPORT_SPEC + url);
        }
        try {
            httpGet.setPath(url);
            httpGet.setRequestHeader("Accept", "text/xml");
            ReportService.setAcceptEncoding((HttpMethodBase)httpGet, this.useHttpCompression);
            if (StringUtils.isNotEmpty((CharSequence)eTag)) {
                httpGet.setRequestHeader("If-None-Match", eTag);
            }
            ReportService.setCookies((HttpMethodBase)httpGet, this.camPassport, this.cookies);
            this.makeTrusted((HttpMethodBase)httpGet);
            responseCode = this.client.executeMethod((HttpMethod)httpGet);
            ReportServiceResponse response = this.buildReportServiceResponse(responseCode, id, httpGet);
            if (ReportService.loggingEnabled()) {
                ReportService.log(LogLevel.INFO, OperationEnum.END, END_READING_REPORT_SPEC + url + STATUS + responseCode);
            }
            if (responseCode == 200 || responseCode == 304) {
                ReportServiceResponse reportServiceResponse = response;
                return reportServiceResponse;
            }
        }
        catch (Exception e) {
            if (ReportService.loggingEnabled()) {
                ReportService.log(LogLevel.INFO, OperationEnum.END, FAILED_READING_REPORT_SPEC + url);
            }
            throw new XQERuntimeException(XQEMessageKeys.MD_MetadataConnectionFailed, (Throwable)e, id);
        }
        finally {
            httpGet.releaseConnection();
        }
        if (ReportService.loggingEnabled()) {
            ReportService.log(LogLevel.INFO, OperationEnum.END, FAILED_READING_REPORT_SPEC + url);
        }
        if (responseCode == 403) {
            throw new XQERuntimeException(XQEMessageKeys.MD_MetadataPermissionDenied, id + 12 + httpGet.getStatusLine().toString());
        }
        throw new XQERuntimeException(XQEMessageKeys.MD_MetadataConnectionFailed, id + 12 + httpGet.getStatusLine().toString());
    }

    private ReportServiceResponse buildReportServiceResponse(int responseCode, String id, GetMethod httpGet) {
        ReportServiceResponse response = new ReportServiceResponse();
        response.setResponseCode(responseCode);
        response.setStoreId(id);
        if (responseCode == 200) {
            String lastModified;
            HTTPClientResponse resp = new HTTPClientResponse(responseCode, (HttpMethodBase)httpGet);
            String respEtag = resp.getResponseHeader("ETag");
            if (respEtag != null) {
                response.setEtag(respEtag);
            }
            if ((lastModified = resp.getResponseHeader("Last-Modified")) != null) {
                response.setLastModified(lastModified);
            }
            String specification = new String(resp.getRawResponse(), StandardCharsets.UTF_8);
            if (ReportService.loggingEnabled()) {
                ReportService.log(LogLevel.INFO, specification);
            }
            response.setSpecification(specification);
        }
        return response;
    }

    protected static void log(LogLevel aLogLevel, String text) {
        if (BaseHTTPClient.loggingEnabled()) {
            BaseHTTPClient.log(aLogLevel, text);
        }
    }

    protected static void log(LogLevel aLogLevel, OperationEnum anOp, String text) {
        if (BaseHTTPClient.loggingEnabled()) {
            BaseHTTPClient.log(aLogLevel, anOp, text);
        }
    }
}

