/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemoser.time;

import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.util.datasets.FlintUtils;
import com.cognos.xqemoser.time.TimeGroupType;
import com.ibm.bi.platform.datasetutils.metadata.Column;
import com.ibm.bi.platform.datasetutils.metadata.ColumnMetadata;
import com.ibm.bi.platform.datasetutils.metadata.RowSchema;
import com.ibm.bi.platform.datasetutils.metadata.TabularRowSchema;
import com.ibm.bi.platform.datasetutils.metadata.types.Type;
import com.ibm.bi.platform.datasetutils.metadata.types.TypeFactory;
import com.ibm.bi.platform.datasetutils.parquet.DatasetParquetWriterBuilder;
import com.ibm.bi.platform.datasetutils.parquet.ParquetVersionEnum;
import com.ibm.bi.platform.datasetutils.utils.ArrayRecord;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAdjusters;
import java.util.Collections;
import java.util.List;
import org.apache.parquet.hadoop.ParquetWriter;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.fs.Path;

public class MoserGregorianTimeTableGenerator {
    public static final String COLUMN_PREFIX = "c";
    public static final String PK_DATE = "TheDate";
    private static final ZoneOffset WRITER_ZONE_OFFSET = ZoneOffset.ofHours(-3);
    private static final ZoneId WRITER_ZONE_ID = ZoneId.ofOffset("UTC", WRITER_ZONE_OFFSET);
    private static final int MONTH_JULY = 7;
    private static final int MONTH_MAY = 5;
    private static final int MONTH_SEPTEMBER = 9;
    private static final int DAY_ELEVEN = 11;
    private static final int DAY_TWEENTY_FIRST = 21;

    public static void createGregorianTimeTable(String fileName, ParquetVersionEnum version, LocalDate st, LocalDate end, List<TimeGroupType> groups) {
        Configuration conf = FlintUtils.getHadoopConfiguration();
        Collections.sort(groups);
        int sz = 1;
        TabularRowSchema recordSchema = new TabularRowSchema();
        recordSchema.appendColumn((ColumnMetadata)new Column(PK_DATE, false, (Type)TypeFactory.DATE_TYPE));
        for (TimeGroupType grp : groups) {
            if (grp == TimeGroupType.DAY) continue;
            String cName = COLUMN_PREFIX + grp.value();
            recordSchema.appendColumn((ColumnMetadata)new Column(cName, false, (Type)TypeFactory.DATE_TYPE));
            ++sz;
        }
        ArrayRecord record = new ArrayRecord(sz);
        Path file = new Path(fileName);
        ParquetWriter writer = null;
        try {
            writer = ((DatasetParquetWriterBuilder)new DatasetParquetWriterBuilder(file, (RowSchema)recordSchema).withConf(conf)).withTimeZoneId(WRITER_ZONE_ID).withParquetVersion(version).build();
            while (st.isBefore(end)) {
                record.setDate(0, st);
                int pos = 1;
                for (TimeGroupType grp : groups) {
                    if (grp == TimeGroupType.DAY) continue;
                    LocalDate dt = MoserGregorianTimeTableGenerator.getLocalDateByGroup(st, grp);
                    record.setDate(pos, dt);
                    ++pos;
                }
                writer.write((Object)record);
                st = st.plusDays(1L);
            }
        }
        catch (Exception e) {
            throw XQERuntimeException.wrap(e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected static LocalDate getLocalDateByGroup(LocalDate st, TimeGroupType grp) {
        switch (grp) {
            case YEAR: {
                return st.with(TemporalAdjusters.firstDayOfYear());
            }
            case MONTH: {
                return st.with(TemporalAdjusters.firstDayOfMonth());
            }
            case QUARTER: {
                int y = st.getYear();
                Month theMonth = st.getMonth();
                Month firstMonthOfQuarter = theMonth.firstMonthOfQuarter();
                return LocalDate.of(y, firstMonthOfQuarter, 1);
            }
            case WEEK: {
                DayOfWeek d = st.getDayOfWeek();
                if (d == DayOfWeek.SUNDAY) {
                    return st;
                }
                return st.plusDays(-d.getValue());
            }
            case HALF_YEAR: {
                int y = st.getYear();
                Month theMonth = st.getMonth();
                if (theMonth.getValue() < 7) {
                    return LocalDate.of(y, Month.JANUARY, 1);
                }
                return LocalDate.of(y, Month.JULY, 1);
            }
            case TRIMESTER: {
                int y = st.getYear();
                Month theMonth = st.getMonth();
                int monthV = theMonth.getValue();
                if (monthV < 5) {
                    return LocalDate.of(y, Month.JANUARY, 1);
                }
                if (monthV >= 9) {
                    return LocalDate.of(y, Month.SEPTEMBER, 1);
                }
                return LocalDate.of(y, Month.MAY, 1);
            }
            case TEN_DAYS: {
                int day = st.getDayOfMonth();
                int y = st.getYear();
                Month theMonth = st.getMonth();
                if (day < 11) {
                    return LocalDate.of(y, theMonth, 1);
                }
                if (day >= 21) {
                    return LocalDate.of(y, theMonth, 21);
                }
                return LocalDate.of(y, theMonth, 11);
            }
        }
        return null;
    }
}

