/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqeqte;

import com.cognos.xqeqte.QTEQueryNode;
import java.lang.reflect.Array;
import java.util.Arrays;

public class QTEDynamicNodeArray<N extends QTEQueryNode> {
    private static final int GROWTH_FACTOR_NUMERATOR = 3;
    private static final int GROWTH_FACTOR_DENUMERATOR = 2;
    private static final int DEFAULT_ARRAY_SIZE = 32768;
    private static final int ARRAY_BLOCK_SIZE = 1024;
    private int mMaxArraySize = 0;
    private static final String EXCEPTION_FORMAT = "Index [%d] out of range for the list size %d";
    private N[] mData;
    private int mSize = 32768;

    public QTEDynamicNodeArray(int multiplier) {
        this.mMaxArraySize = multiplier * 1024;
        this.mData = (QTEQueryNode[])Array.newInstance(QTEQueryNode.class, 32768);
    }

    private void inflate(int index) throws IndexOutOfBoundsException {
        if (index < this.mSize) {
            return;
        }
        if (this.mMaxArraySize > 0 && this.mMaxArraySize == this.mSize) {
            throw new IndexOutOfBoundsException(String.format(EXCEPTION_FORMAT, index, this.mMaxArraySize));
        }
        int newSize = this.mSize;
        do {
            newSize = newSize * 3 / 2;
            newSize += newSize % 2;
            if (this.mMaxArraySize > 0) {
                newSize = Math.min(newSize, this.mMaxArraySize);
            }
            if (index >= newSize) continue;
            this.mSize = newSize;
            this.mData = (QTEQueryNode[])Arrays.copyOf(this.mData, this.mSize);
            return;
        } while (this.mMaxArraySize <= 0 || this.mMaxArraySize != newSize);
        throw new IndexOutOfBoundsException(String.format(EXCEPTION_FORMAT, index, this.mMaxArraySize));
    }

    public N get(int index) throws IndexOutOfBoundsException {
        if (index < this.mSize) {
            return this.mData[index];
        }
        return null;
    }

    public void set(int index, N node) {
        this.inflate(index);
        this.mData[index] = node;
    }

    public int size() {
        return this.mSize;
    }
}

