/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqeqte;

import com.cognos.xqeqte.QTEDynamicNodeArray;
import com.cognos.xqeqte.QTEQueryNode;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class QTENodeCollection<N extends QTEQueryNode>
extends AbstractList<N> {
    private QTEDynamicNodeArray<N> mNodeArray;
    private Set<Integer> mIndexes;
    private Iterator<Integer> mIt;
    private int mIndex;

    public QTENodeCollection(Set<Integer> indexes, QTEDynamicNodeArray<N> nodeArray) {
        this.mNodeArray = nodeArray;
        this.mIndexes = new TreeSet<Integer>();
        for (Integer index : indexes) {
            if (null == this.mNodeArray.get(index)) continue;
            this.mIndexes.add(index);
        }
        this.mIt = this.mIndexes.iterator();
        this.mIndex = -1;
    }

    public QTENodeCollection(boolean keepNulls, Set<Integer> indexes, QTEDynamicNodeArray<N> nodeArray) {
        this.mNodeArray = nodeArray;
        this.mIndexes = indexes;
        this.mIt = this.mIndexes.iterator();
        this.mIndex = -1;
    }

    public QTENodeCollection(QTEDynamicNodeArray<N> nodeArray) {
        this.mNodeArray = nodeArray;
        this.mIndexes = new TreeSet<Integer>();
        for (int index = 0; index < this.mNodeArray.size(); ++index) {
            if (null == this.mNodeArray.get(index)) continue;
            this.mIndexes.add(index);
        }
        this.mIt = this.mIndexes.iterator();
        this.mIndex = -1;
    }

    @Override
    public N get(int index) {
        if (this.mIndex > index) {
            this.mIndex = -1;
            this.mIt = this.mIndexes.iterator();
        }
        Integer ind = -1;
        while (this.mIndex != index && this.mIt.hasNext()) {
            ind = this.mIt.next();
            ++this.mIndex;
        }
        return this.mNodeArray.get(ind);
    }

    @Override
    public int size() {
        return this.mIndexes.size();
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Iterator<Integer> it = this.mIndexes.iterator();
        int i = 0;
        while (it.hasNext()) {
            array[i++] = this.mNodeArray.get(it.next());
        }
        return array;
    }
}

