/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqeqte;

import com.cognos.xqeqte.QTEDynamicNodeArray;
import com.cognos.xqeqte.QTENodeCollection;
import com.cognos.xqeqte.QTEQueryNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class QTENodeIndex<N extends QTEQueryNode> {
    public static final int QUERYTREE_UNLIMITED_DEPTH = 0;
    public static final int INITIAL_QUERY_NODE_INDEX_MULTIPLIER_LIMIT = 0;
    private int mQueryNodeIndexMultiplierLimit = 0;
    private QTEDynamicNodeArray<N> mNodeArray;
    private Map<Integer, Set<Integer>> mTypeIdMap = new HashMap<Integer, Set<Integer>>();
    private static boolean newIndexMode = true;

    public QTENodeIndex() {
        this(0);
    }

    public QTENodeIndex(int queryNodeIndexMultiplierLimit) {
        this.mQueryNodeIndexMultiplierLimit = queryNodeIndexMultiplierLimit;
        this.mNodeArray = new QTEDynamicNodeArray(this.mQueryNodeIndexMultiplierLimit);
    }

    public void removeNode(N node) {
        Integer id = node.getId();
        this.mNodeArray.set(id, null);
    }

    public void addNode(N node) {
        Integer id = node.getId();
        if (newIndexMode) {
            this.mNodeArray.set(id, node);
        } else {
            Integer type = node.getTypeObject();
            this.mNodeArray.set(id, node);
            Set<Integer> ids = this.mTypeIdMap.get(type);
            if (ids == null) {
                ids = new TreeSet<Integer>();
                this.mTypeIdMap.put(type, ids);
            }
            ids.add(id);
        }
    }

    public N getNodeByID(Integer id) {
        if (null == id) {
            return null;
        }
        return this.mNodeArray.get(id);
    }

    public Collection<N> getNodesByType(int nodeType) {
        return this.getNonNullNodesCollectionByType(nodeType);
    }

    public Collection<N> getNodesByType(boolean keepNulls, int nodeType) {
        return this.getNodesCollectionByType(keepNulls, nodeType);
    }

    protected Collection<N> getNodesCollectionByType(boolean keepNulls, int nodeType) {
        Integer key = nodeType;
        if (null == this.mTypeIdMap.get(key)) {
            return new ArrayList();
        }
        return new QTENodeCollection<N>(keepNulls, this.mTypeIdMap.get(key), this.mNodeArray);
    }

    public boolean hasNodeOfType(Integer nodeType) {
        Set<Integer> ids = this.mTypeIdMap.get(nodeType);
        if (ids != null) {
            return !ids.isEmpty();
        }
        return false;
    }

    public int getNumberOfNodesInIndex() {
        int numberOfNodesInIndex = 0;
        for (Set<Integer> index : this.mTypeIdMap.values()) {
            numberOfNodesInIndex += index.size();
        }
        return numberOfNodesInIndex;
    }

    protected Collection<N> getNonNullNodesCollectionByType(int nodeType) {
        Collection<N> indexes = this.getNodesCollectionByType(nodeType);
        if (indexes != null) {
            return indexes;
        }
        return new ArrayList();
    }

    protected Collection<N> getNodesCollectionByType(int nodeType) {
        Integer key = nodeType;
        if (null == this.mTypeIdMap.get(key)) {
            return null;
        }
        return new QTENodeCollection<N>(this.mTypeIdMap.get(key), this.mNodeArray);
    }

    protected Collection<N> getNodesById() {
        return new QTENodeCollection<N>(this.mNodeArray);
    }

    protected boolean containsNodeById(int id) {
        return null != this.mNodeArray.get(id);
    }

    public void recordNodeType(N node) {
        if (newIndexMode) {
            Integer id = node.getId();
            Integer type = node.getTypeObject();
            Set<Integer> ids = this.mTypeIdMap.get(type);
            if (ids == null) {
                ids = new TreeSet<Integer>();
                this.mTypeIdMap.put(type, ids);
            }
            ids.add(id);
        }
    }

    public static void setUseNewIndexMode(boolean flag) {
        newIndexMode = flag;
    }
}

