/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqeqte;

import com.cognos.xqeqte.QTEAbstractTransformation;
import com.cognos.xqeqte.QTEPlanningEnvironment;
import com.cognos.xqeqte.QTEQueryNode;
import com.cognos.xqeqte.QTESharedPassNumbers;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public abstract class QTETransformationLibrary<N extends QTEQueryNode, P extends QTEPlanningEnvironment<N>> {
    protected List<QTEAbstractTransformation<N, P>> transformations = new ArrayList<QTEAbstractTransformation<N, P>>();
    protected Properties mPassNames = new Properties();
    private int mStartingPassNumber;
    private int mNumberOfPasses = 0;
    private List<QTESharedPassNumbers> mSharedPassNumberCollection;

    public void beginPassesConditionUsage() {
    }

    public void endPassesConditionUsage(boolean pass) {
    }

    public String getPassName(int passNumber) {
        String defaultPassName = "[Pass " + passNumber + "]";
        return this.mPassNames.getProperty(String.valueOf(passNumber), defaultPassName);
    }

    protected int getStartingPassNumber() {
        return this.mStartingPassNumber;
    }

    public int getFinalPassNumber() {
        return this.mStartingPassNumber + this.mNumberOfPasses;
    }

    public void assignPassName(int relativePassNumber, String passName) {
        this.mPassNames.setProperty(String.valueOf(this.mStartingPassNumber + relativePassNumber), passName);
    }

    public String getLibraryName() {
        String name = this.getClass().getName();
        name = name.substring(name.lastIndexOf(46) + 1);
        return name;
    }

    protected QTEAbstractTransformation.Mode getTransformationMode() {
        return QTEAbstractTransformation.Mode.INDEXED;
    }

    public QTEAbstractTransformation.ApplicableIterations getApplicableIterations() {
        return QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
    }

    public QTETransformationLibrary(int startingPassNumber, int numberOfPasses) {
        this.mStartingPassNumber = startingPassNumber;
        this.mNumberOfPasses = numberOfPasses + 1;
        this.addSharedPassNumberCollections();
        this.buildTransformationLibrary();
        this.resolveTransformationRules();
        this.assignLibraryToTransformationRules();
        this.alignPassNumbersWithLibrary();
    }

    private void alignPassNumbersWithLibrary() {
        for (QTEAbstractTransformation<N, P> aTransformation : this.transformations) {
            aTransformation.alignPassNumbersWithLibraryBasePassNumber(this.getStartingPassNumber());
        }
        if (this.mSharedPassNumberCollection == null) {
            return;
        }
        for (QTESharedPassNumbers passNumberCollection : this.mSharedPassNumberCollection) {
            passNumberCollection.alignPassNumbersWithLibraryBasePassNumber(this.getStartingPassNumber());
        }
    }

    protected abstract void buildTransformationLibrary();

    protected void addSharedPassNumberCollections() {
    }

    public void resolveTransformationRules() {
        for (QTEAbstractTransformation<N, P> aTransformation : this.transformations) {
            aTransformation.resolveApplicableIterations(this.getApplicableIterations());
            aTransformation.resolveMode(this.getTransformationMode());
        }
    }

    protected List<QTEAbstractTransformation<N, P>> getTransformations() {
        return this.transformations;
    }

    private void assignLibraryToTransformationRules() {
        for (QTEAbstractTransformation<N, P> transformation : this.transformations) {
            transformation.setTransformationLibrary(this);
        }
    }

    public void addSharedPassNumberCollection(int identifier, int[] passNumbers) {
        if (this.mSharedPassNumberCollection == null) {
            this.mSharedPassNumberCollection = new ArrayList<QTESharedPassNumbers>();
        }
        QTESharedPassNumbers passNumberCollection = new QTESharedPassNumbers(passNumbers);
        this.mSharedPassNumberCollection.add(identifier, passNumberCollection);
    }

    public QTESharedPassNumbers getSharedPassNumberCollection(int identifier) {
        if (this.mSharedPassNumberCollection == null) {
            return null;
        }
        return this.mSharedPassNumberCollection.get(identifier);
    }

    public boolean passesCondition(N node, P environment, QTEAbstractTransformation<N, P> transformation) {
        return true;
    }
}

