/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqeqte;

import com.cognos.xqeqte.QTEAbstractTransformation;
import com.cognos.xqeqte.QTEPassTransformations;
import com.cognos.xqeqte.QTEPlanningEnvironment;
import com.cognos.xqeqte.QTEQueryNode;
import com.cognos.xqeqte.QTETransformationLibrary;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class QTETransformationLibraryManager<N extends QTEQueryNode, P extends QTEPlanningEnvironment<N>> {
    public static final int ALL_PASSES = -1;
    protected static final String STRING_PASS_NUMBER = "passNumber";
    protected static final String STRING_PASS = "pass";
    protected List<QTETransformationLibrary<N, P>> transformationLibraries;
    protected int mMaximumPassNumber = 0;
    protected QTEPassTransformations<N, P> transformsAllPasses = new QTEPassTransformations();
    protected Map<Integer, QTEPassTransformations<N, P>> transformsByPass = new HashMap<Integer, QTEPassTransformations<N, P>>();
    protected Map<Integer, List<QTETransformationLibrary<N, P>>> passLibraries = new HashMap<Integer, List<QTETransformationLibrary<N, P>>>();
    protected boolean passLibraryMapPopulated;
    protected int mPassNumber = 0;
    protected List<QTETransformationLibrary<N, P>> mLibraryList = new ArrayList<QTETransformationLibrary<N, P>>();

    protected QTETransformationLibraryManager() {
        this.loadTransformationLibraries();
        this.createIndexes();
        this.mergeIndexes();
        this.constructNodeTypeIndexes();
    }

    private void constructNodeTypeIndexes() {
        for (QTETransformationLibrary<N, P> library : this.transformationLibraries) {
            List<QTEAbstractTransformation<N, P>> transformations = library.getTransformations();
            for (QTEAbstractTransformation<N, P> transformation : transformations) {
                int[] passNumbers;
                int[] nodeTypes = transformation.getTypes();
                for (int passNumber : passNumbers = transformation.getPassNumbers()) {
                    QTEPassTransformations<N, P> passTransformations = this.getTransformations(passNumber);
                    for (int nodeType : nodeTypes) {
                        List<QTEAbstractTransformation<N, P>> passTransformationList = passTransformations.getTransformationsForNodeType(nodeType);
                        if (!passTransformationList.isEmpty()) continue;
                        passTransformations.createTransformationListForNodeType(nodeType);
                    }
                }
            }
        }
        for (int passNum = 0; passNum <= this.mMaximumPassNumber; ++passNum) {
            QTEPassTransformations<N, P> passTransformations = this.getTransformations(passNum);
            if (passTransformations == null) continue;
            passTransformations.setNodeTypes();
        }
    }

    private void mergeIndexes() {
        Set<Map.Entry<Integer, QTEPassTransformations<N, P>>> entrySetMap = this.transformsByPass.entrySet();
        for (Map.Entry<Integer, QTEPassTransformations<N, P>> anEntry : entrySetMap) {
            QTEPassTransformations<N, P> passTransformations;
            passTransformations.setContainsBottomUpTransformations((passTransformations = anEntry.getValue()).getContainsBottomUpTransformations() || this.transformsAllPasses.getContainsBottomUpTransformations());
            passTransformations.setContainsIndexedTransformations(passTransformations.getContainsIndexedTransformations() || this.transformsAllPasses.getContainsIndexedTransformations());
            passTransformations.setContainsTopDownTransformations(passTransformations.getContainsTopDownTransformations() || this.transformsAllPasses.getContainsTopDownTransformations());
            passTransformations.setContainsTopDownFastTransformations(passTransformations.getContainsTopDownFastTransformations() || this.transformsAllPasses.getContainsTopDownFastTransformations());
            passTransformations.setContainsUnlimitedBottomUpTransformations(passTransformations.getContainsUnlimitedBottomUpTransformations() || this.transformsAllPasses.getContainsUnlimitedBottomUpTransformations());
            passTransformations.setContainsUnlimitedIndexedTransformations(passTransformations.getContainsUnlimitedIndexedTransformations() || this.transformsAllPasses.getContainsUnlimitedIndexedTransformations());
            passTransformations.setContainsUnlimitedTopDownTransformations(passTransformations.getContainsUnlimitedTopDownTransformations() || this.transformsAllPasses.getContainsUnlimitedTopDownTransformations());
            passTransformations.setContainsUnlimitedTopDownFastTransformations(passTransformations.getContainsUnlimitedTopDownFastTransformations() || this.transformsAllPasses.getContainsUnlimitedTopDownFastTransformations());
            Map<Integer, List<QTEAbstractTransformation<N, P>>> transformationMap = passTransformations.getTransformationMap();
            transformationMap.putAll(this.transformsAllPasses.getTransformationMap());
        }
    }

    protected abstract void loadTransformationLibraries();

    public QTEPassTransformations<N, P> getTransformations(int passNumber) {
        return this.transformsByPass.get(passNumber);
    }

    private void createIndexes() {
        for (QTETransformationLibrary<N, P> library : this.transformationLibraries) {
            this.createIndexesFromLibrary(library);
        }
    }

    private void createIndexesFromLibrary(QTETransformationLibrary<N, P> library) {
        List<QTEAbstractTransformation<N, P>> transformations = library.getTransformations();
        for (QTEAbstractTransformation<N, P> aTransformation : transformations) {
            this.indexByPass(aTransformation);
        }
    }

    private void indexByPass(QTEAbstractTransformation<N, P> aTransformation) {
        int[] passes;
        for (int pass : passes = aTransformation.getPassNumbers()) {
            Integer key = pass;
            if (pass > this.mMaximumPassNumber) {
                this.mMaximumPassNumber = pass;
            }
            QTEPassTransformations<N, P> passTransformations = null;
            if (pass == -1) {
                passTransformations = this.transformsAllPasses;
            } else {
                passTransformations = this.transformsByPass.get(key);
                if (passTransformations == null) {
                    passTransformations = new QTEPassTransformations();
                    this.transformsByPass.put(key, passTransformations);
                }
            }
            this.indexByType(aTransformation, passTransformations);
        }
    }

    private void indexByType(QTEAbstractTransformation<N, P> aTransformation, QTEPassTransformations<N, P> passTransformations) {
        int[] types;
        Map<Integer, List<QTEAbstractTransformation<N, P>>> transformationMap = passTransformations.getTransformationMap();
        List<QTEAbstractTransformation<N, P>> mapTransformationList = null;
        block6: for (int type : types = aTransformation.getTypes()) {
            Integer key = type;
            mapTransformationList = transformationMap.get(key);
            if (mapTransformationList == null) {
                mapTransformationList = new ArrayList<QTEAbstractTransformation<N, P>>();
                transformationMap.put(key, mapTransformationList);
            }
            mapTransformationList.add(aTransformation);
            switch (aTransformation.getMode()) {
                case TOP_DOWN: {
                    passTransformations.setContainsTopDownTransformations(true);
                    if (aTransformation.getApplicableIterations() != QTEAbstractTransformation.ApplicableIterations.UNLIMITED) continue block6;
                    passTransformations.setContainsUnlimitedTopDownTransformations(true);
                    continue block6;
                }
                case TOP_DOWN_FAST: {
                    passTransformations.setContainsTopDownFastTransformations(true);
                    if (aTransformation.getApplicableIterations() != QTEAbstractTransformation.ApplicableIterations.UNLIMITED) continue block6;
                    passTransformations.setContainsUnlimitedTopDownFastTransformations(true);
                    continue block6;
                }
                case BOTTOM_UP: {
                    passTransformations.setContainsBottomUpTransformations(true);
                    if (aTransformation.getApplicableIterations() != QTEAbstractTransformation.ApplicableIterations.UNLIMITED) continue block6;
                    passTransformations.setContainsUnlimitedBottomUpTransformations(true);
                    continue block6;
                }
                case INDEXED: {
                    passTransformations.setContainsIndexedTransformations(true);
                    if (aTransformation.getApplicableIterations() != QTEAbstractTransformation.ApplicableIterations.UNLIMITED) continue block6;
                    passTransformations.setContainsUnlimitedIndexedTransformations(true);
                    continue block6;
                }
                default: {
                    passTransformations.setContainsIndexedTransformations(true);
                    if (aTransformation.getApplicableIterations() != QTEAbstractTransformation.ApplicableIterations.UNLIMITED) continue block6;
                    passTransformations.setContainsUnlimitedIndexedTransformations(true);
                }
            }
        }
    }

    public QTEPassTransformations<N, P> getTransformsAllPasses() {
        return this.transformsAllPasses;
    }

    public List<QTETransformationLibrary<N, P>> getPassLibraryMap(int passNumber) {
        this.populatePassLibraryMap();
        return this.passLibraries.get(passNumber);
    }

    private void populatePassLibraryMap() {
        if (this.passLibraryMapPopulated) {
            return;
        }
        for (int passNumber = 0; passNumber <= this.getMaximumPassNumber(); ++passNumber) {
            HashSet<QTETransformationLibrary<N, P>> libraries = new HashSet<QTETransformationLibrary<N, P>>();
            QTEPassTransformations<N, P> passTransformations = this.getTransformations(passNumber);
            if (passTransformations == null) continue;
            Map<Integer, List<QTEAbstractTransformation<N, P>>> transformationMap = this.getTransformations(passNumber).getTransformationMap();
            Set<Map.Entry<Integer, List<QTEAbstractTransformation<N, P>>>> setOfTransformationList = transformationMap.entrySet();
            if (setOfTransformationList.size() == 0) {
                this.passLibraryMapPopulated = true;
                return;
            }
            for (Map.Entry<Integer, List<QTEAbstractTransformation<N, P>>> entry : setOfTransformationList) {
                List<QTEAbstractTransformation<N, P>> list = entry.getValue();
                if (list.size() == 0) continue;
                for (QTEAbstractTransformation<N, P> transformation : list) {
                    libraries.add(transformation.getTransformationLibrary());
                }
            }
            ArrayList<QTETransformationLibrary> listOfLibraries = new ArrayList<QTETransformationLibrary>();
            for (QTETransformationLibrary qTETransformationLibrary : libraries) {
                listOfLibraries.add(qTETransformationLibrary);
            }
            this.passLibraries.put(passNumber, listOfLibraries);
        }
        this.passLibraryMapPopulated = true;
    }

    protected void addTransformationLibraryToList(QTETransformationLibrary<N, P> transformationLibrary) {
        if (transformationLibrary != null) {
            this.setMaximumPassNumber(transformationLibrary.getFinalPassNumber());
            this.addLibraryToList(transformationLibrary);
        }
    }

    protected void addLibraryToList(QTETransformationLibrary<N, P> transformationLibrary) {
        this.getLibraryList().add(transformationLibrary);
    }

    protected List<QTETransformationLibrary<N, P>> getLibraryList() {
        return this.mLibraryList;
    }

    protected void setMaximumPassNumber(int passNumber) {
        this.mPassNumber = Math.max(passNumber, this.mPassNumber);
    }

    public int getMaximumPassNumber() {
        return this.mPassNumber;
    }
}

