/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqerdp.flint;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.collators.CollatorPoolFactory;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.providers.IDataProvider;
import com.cognos.xqe.data.providers.ProviderManager;
import com.cognos.xqe.data.providers.relational.AbstractConnection;
import com.cognos.xqe.data.providers.relational.SQLQueryArguments;
import com.cognos.xqe.data.providers.relational.TraceRelationalDataProvider;
import com.cognos.xqe.data.providers.relational.jdbc.JDBCLog;
import com.cognos.xqe.exception.RequestCanceledException;
import com.cognos.xqe.exception.XQEException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.pool.connection.IInstrumentedPooledConnection;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.resultset.interfaces.IColumnInfo;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.caching.CachedResultSet;
import com.cognos.xqe.resultsets.caching.CachedResultSetManager;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.ConnectionUtil;
import com.cognos.xqe.util.Pair;
import com.cognos.xqe.util.datasets.IFlintServerManager;
import com.cognos.xqemoser.MoserModuleManager;
import com.cognos.xqerdp.flint.ClientRequest;
import com.cognos.xqerdp.flint.ClientRequestExecutor;
import com.cognos.xqerdp.flint.ClientRequestWithResponse;
import com.cognos.xqerdp.flint.FlintApiFacade;
import com.cognos.xqerdp.flint.FlintApiFacadeImpl;
import com.cognos.xqerdp.flint.FlintDataProvider;
import com.cognos.xqerdp.flint.FlintTabularResult;
import com.ibm.ba.flint.client.BorrowedFlintClient;
import com.ibm.ba.flint.client.FlintClient;
import com.ibm.ba.flint.client.FlintClientPool;
import com.ibm.ba.flint.thrift.core.AnalysisException;
import com.ibm.ba.flint.thrift.core.CancellationException;
import com.ibm.ba.flint.thrift.core.GeneralException;
import com.ibm.ba.flint.thrift.core.TimeoutException;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.transport.TTransportException;

public class FlintConnection
extends AbstractConnection
implements ClientRequestExecutor,
IInstrumentedPooledConnection {
    private final FlintApiFacade apiFacade;
    private IFlintServerManager flintServerMgr;
    private FlintClientPool clientPool;
    private CachedResultSetManager cacheMgr;
    private ZoneId serverZoneId;
    private volatile long currentClientId = -1L;
    private IDataSourceCapabilities capabilities;
    private Map<String, Object> properties = new HashMap<String, Object>();

    public FlintConnection(IDataSource theDataSource) {
        super(theDataSource);
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        boolean cachingEnabled = config.getBooleanProperty("general.cacheResultSets[@enabled]", true) && config.getBooleanProperty("queryExecution.flintServer.cache[@sqlEnabled]", false);
        int memory = config.getIntProperty("general.cacheResultSets[@maxMemory]", 64);
        int threshold = config.getIntProperty("general.cacheResultSets[@threshold]", 10);
        XQELogger infoLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "CacheManager", LogLevel.INFO);
        this.cacheMgr = new CachedResultSetManager(cachingEnabled, memory, threshold);
        if (cachingEnabled) {
            infoLogger.log(String.format("Flint Native result set caching is enabled [maxMemory=%1$d, threshold=%2$d].", memory, threshold));
        } else {
            infoLogger.log("Flint Native result set caching is disabled.");
        }
        this.apiFacade = new FlintApiFacadeImpl(this);
    }

    @Override
    public void connect(Locale runLocale) throws XQEException {
        if (this.clientPool == null) {
            this.flintServerMgr = MoserModuleManager.getDatasetManager().getFlintServerManagerInstance();
            this.clientPool = this.flintServerMgr.getClientPool();
        }
        if (this.capabilities == null) {
            this.capabilities = ConnectionUtil.getCapabilitiesFromColumnarConnection(this.dataSource);
        }
        Pair dbCollationSequenceAndCharset = null;
        IDataProvider provider = ProviderManager.getInstance().getProvider(this.dataSource.getType());
        if (provider instanceof TraceRelationalDataProvider) {
            provider = ((TraceRelationalDataProvider)provider).getProvider();
        }
        if (provider instanceof FlintDataProvider) {
            dbCollationSequenceAndCharset = ((FlintDataProvider)provider).getDBCollationSequenceAndCharset(this.getConnectionString(), null);
        }
        if (dbCollationSequenceAndCharset != null) {
            this.setDatabaseCollationSequence((String)dbCollationSequenceAndCharset.getFirst());
            return;
        }
        String dbCollationSequenceName = this.retrieveDBSessionInfo();
        if (provider instanceof FlintDataProvider) {
            ((FlintDataProvider)provider).cacheDBCollationSequenceAndCharset(this.getConnectionString(), null, dbCollationSequenceName, null);
        }
    }

    private String retrieveDBSessionInfo() {
        StringBuilder collationSequenceName = new StringBuilder();
        String collationSequenceMappingName = "FLINT";
        String property = this.capabilities.getStringValue(String.format("collation.sequence.mapping.%1$s", collationSequenceMappingName), null);
        String[] seqAndWeight = property.split(",");
        collationSequenceName.append(seqAndWeight[0].trim());
        String collatorWeight = CollatorPoolFactory.getCollationLevel(seqAndWeight[1].trim());
        if (collatorWeight != null) {
            collationSequenceName.append(":");
            collationSequenceName.append(collatorWeight);
        }
        String ret = collationSequenceName.toString();
        this.setDatabaseCollationSequence(ret);
        return ret;
    }

    public IFlintServerManager getFlintServerManager() {
        return this.flintServerMgr;
    }

    @Override
    public String getConnectionString() {
        return this.getDataSource().getDataSourceConnection().getConnectionString(null);
    }

    @Override
    public String getDatabaseCollationSequence() {
        return (String)this.getProperty("databaseCollationSequenceName");
    }

    private void setDatabaseCollationSequence(String collationName) {
        this.setProperty("databaseCollationSequenceName", collationName);
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public void setProperty(String key, Object val) {
        this.properties.put(key, val);
    }

    @Override
    public String getConnectionCollationSequence() {
        return null;
    }

    @Override
    public String getDatabaseCharset() {
        return null;
    }

    public void disconnect() {
        this.cacheMgr.release();
        this.clientPool = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isConnected() {
        if (null == this.clientPool) {
            return false;
        }
        try (BorrowedFlintClient borrowed = new BorrowedFlintClient(this.clientPool);){
            boolean bl = borrowed.client().isOpen();
            return bl;
        }
        catch (Exception ex) {
            JDBCLog.getLogger().log(LogLevel.ERROR, (Throwable)ex);
            return false;
        }
    }

    public ZoneId getServerZoneId() {
        if (null == this.serverZoneId) {
            this.serverZoneId = this.getApiFacade().getServerZoneId();
        }
        return this.serverZoneId;
    }

    @Override
    public void execute(ClientRequest request) throws TException {
        this.assertConnected();
        try (BorrowedFlintClient borrowed = new BorrowedFlintClient(this.clientPool);){
            FlintClient client = borrowed.client();
            try {
                this.currentClientId = client.getClientId();
                request.execute(client);
            }
            catch (TApplicationException | TProtocolException | TTransportException ex) {
                JDBCLog.getLogger().log(LogLevel.ERROR, ex);
                borrowed.setNotReusable();
                throw new XQERuntimeException(XQEMessageKeys.DAT_DataSourceAdapterError, ex, ex.toString());
            }
            catch (AnalysisException | GeneralException ex) {
                JDBCLog.getLogger().log(LogLevel.ERROR, ex);
                throw new XQERuntimeException(XQEMessageKeys.DAT_DataSourceAdapterError, ex, ex.toString());
            }
            catch (CancellationException ex) {
                JDBCLog.getLogger().log(LogLevel.ERROR, (Throwable)ex);
                if (null == ex.getReason()) {
                    throw new RequestCanceledException(ex);
                }
                switch (ex.getReason()) {
                    case SERVER_STOPPING: {
                        throw new XQERuntimeException(XQEMessageKeys.FLT_ComputeServiceRequestCanceledByShutdown, (Throwable)ex);
                    }
                    case WORKLOAD_MANAGEMENT: {
                        throw new XQERuntimeException(XQEMessageKeys.FLT_ComputeServiceRequestCanceledByWLM, (Throwable)ex);
                    }
                }
                throw new RequestCanceledException(ex);
            }
            catch (TimeoutException ex) {
                JDBCLog.getLogger().log(LogLevel.ERROR, (Throwable)ex);
                throw new XQERuntimeException(XQEMessageKeys.FLT_ComputeServiceRequestTimeout, (Throwable)ex);
            }
            catch (TException ex) {
                JDBCLog.getLogger().log(LogLevel.ERROR, (Throwable)ex);
                throw ex;
            }
            finally {
                this.currentClientId = -1L;
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public <R> R executeWithResponse(ClientRequestWithResponse<R> request) throws TException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public FlintApiFacade getApiFacade() {
        return this.apiFacade;
    }

    ITabularResultSet getResultSet(XDataContext nonCacheableContext, IPooledConnection pooledConnection, SQLQueryArguments queryArgs, Integer nodeId, FlintDataProvider dataProvider) {
        XDataContext context;
        CachedResultSet flintTabularResult;
        boolean useCachedResults;
        String key = queryArgs.getSQLQuery();
        boolean bl = useCachedResults = queryArgs.isCacheable() && this.cacheMgr.isCachingEnabled();
        if (useCachedResults && (flintTabularResult = (CachedResultSet)this.cacheMgr.getCachedResultSet(key)) != null) {
            pooledConnection.returnConnection();
            return flintTabularResult;
        }
        boolean cacheResultSet = useCachedResults;
        if (cacheResultSet) {
            context = new XDataContext(null, nonCacheableContext.getEnvironment());
            context.setOptions(nonCacheableContext.getOptions());
        } else {
            context = nonCacheableContext;
        }
        FlintTabularResult flintTabularResult2 = this.getResultSetImpl(context, pooledConnection, queryArgs, nodeId, dataProvider);
        IRowsetInfo rowsetInfo = flintTabularResult2.getTabularRowsetInfo();
        ITabularResultSet resultSet = flintTabularResult2;
        if (cacheResultSet && rowsetInfo != null) {
            cacheResultSet = true;
            for (IColumnInfo columnInfo : rowsetInfo.getColumnInfos()) {
                if (!columnInfo.getDataType().isBlob()) continue;
                cacheResultSet = false;
                break;
            }
            if (cacheResultSet) {
                IDataSource ds = queryArgs.getDataSource();
                resultSet = this.cacheMgr.createCachedResultSet(context, flintTabularResult2, flintTabularResult2, dataProvider.getResourceTracker(), key, ds.getName());
                if (resultSet != flintTabularResult2) {
                    flintTabularResult2.setIsCaching(true);
                }
            }
        }
        if (flintTabularResult2 == resultSet && nonCacheableContext != context) {
            context.attachToParentAndTakeReference(nonCacheableContext);
        }
        return resultSet;
    }

    FlintTabularResult getResultSetImpl(XDataContext context, IPooledConnection pooledConnection, SQLQueryArguments queryArgs, Integer nodeId, FlintDataProvider dataProvider) {
        return new FlintTabularResult(context, pooledConnection, queryArgs, nodeId, dataProvider);
    }

    @Override
    public Set<Object> getCachingStatistics() {
        return this.cacheMgr.getCachedEntrySet();
    }

    public void removeResultSet(String key) {
        this.cacheMgr.removeResultSet(key);
    }

    boolean cancelActiveRequest() {
        long clientId = this.currentClientId;
        if (-1L != clientId) {
            JDBCLog.getLogger().log(LogLevel.ERROR, String.format("Attempting to cancel Flint client id: %1$d.", clientId));
            return this.getApiFacade().cancelByClientId(clientId);
        }
        JDBCLog.getLogger().log(LogLevel.ERROR, "No Flint client id to cancel.");
        return true;
    }

    private void assertConnected() {
        if (null == this.clientPool) {
            throw new IllegalStateException("Not connected");
        }
    }
}

