/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqerdp.flint;

import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceConnection;
import com.cognos.xqe.data.model.LogonFailureException;
import com.cognos.xqe.data.providers.ConnectionTestQueryArguments;
import com.cognos.xqe.data.providers.DataProviderBase;
import com.cognos.xqe.data.providers.connection.parameters.DataSourceParameter;
import com.cognos.xqe.data.providers.relational.IRelationalDataProvider;
import com.cognos.xqe.data.providers.relational.SQLQueryArguments;
import com.cognos.xqe.exception.XQEException;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IConnectionFactory;
import com.cognos.xqe.pool.connection.IConnectionSelector;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.pool.connection.ISelectorContext;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.util.ConnectionUtil;
import com.cognos.xqe.util.Pair;
import com.cognos.xqerdp.flint.FlintConnection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;

public class FlintDataProvider
extends DataProviderBase
implements IRelationalDataProvider {
    private final FlintConnectionSelector connectionSelector;
    private final FlintConnectionFactory connectionFactory;
    public static final String TYPE = "FLINT";
    private final AtomicReference<Pair> cachedCollationSequence = new AtomicReference<Object>(null);

    public FlintDataProvider(String instanceName, Properties properties) {
        super(instanceName, new Properties());
        this.connectionSelector = new FlintConnectionSelector();
        this.connectionFactory = new FlintConnectionFactory();
    }

    @Override
    public void releaseImpl() {
    }

    @Override
    public IConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    @Override
    public IConnectionSelector getConnectionSelector() {
        return this.connectionSelector;
    }

    @Override
    public ITabularResultSet query(XDataContext context, SQLQueryArguments queryArgs) throws XQEException {
        IExecutionEnvironment env = context.getEnvironment();
        IPooledConnection pooledConnection = ConnectionUtil.getPooledConnection(env, queryArgs.getDataSource());
        FlintConnection connection = (FlintConnection)pooledConnection.getConnection();
        env.registerDataSourceCollationInformation(connection.getDatabaseCollationSequence(), connection.getConnectionCollationSequence());
        return connection.getResultSet(context, pooledConnection, queryArgs, context.getNodeId(), this);
    }

    @Override
    public List<XQEMessage> testConnection(ConnectionTestQueryArguments theQueryArguments) {
        IDataSource dataSource = theQueryArguments.getDataSource();
        try {
            ConnectionUtil.connect(theQueryArguments.getExecutionEnvironment(), dataSource);
        }
        catch (LogonFailureException e) {
            if (e.getDataSource() == null) {
                e.setDataSource(dataSource);
            }
            throw e;
        }
        return null;
    }

    @Override
    public IPooledConnection borrowConnection(ConnectionParameters connectionParameters, IExecutionEnvironment executionEnvironment) {
        return executionEnvironment.getConnectionPool().borrowConnection(this.getProviderInstanceName(), connectionParameters, this.connectionSelector, this.connectionFactory);
    }

    public void cacheDBCollationSequenceAndCharset(String connectionStringNoSignon, String userId, String dbCollationSequenceName, String charset) {
        Pair p = new Pair(dbCollationSequenceName, charset);
        this.cachedCollationSequence.set(p);
    }

    public Pair getDBCollationSequenceAndCharset(String connectionStringNoSignon, String userId) {
        return this.cachedCollationSequence.get();
    }

    private static class FlintConnectionFactory
    implements IConnectionFactory {
        private FlintConnectionFactory() {
        }

        @Override
        public Object createConnection(ConnectionParameters parameters) {
            IDataSource dataSource = parameters.valueOf(DataSourceParameter.class, IDataSource.class);
            return new FlintConnection(dataSource);
        }

        @Override
        public void destroyConnection(IPooledConnection pooledConnection) {
            FlintConnection flintConnection = (FlintConnection)pooledConnection.getConnection();
            flintConnection.disconnect();
        }
    }

    private static class FlintConnectionSelector
    implements IConnectionSelector {
        private FlintConnectionSelector() {
        }

        @Override
        public IConnectionSelector.ReturnCode selectConnection(ConnectionParameters parameters, ISelectorContext context, IPooledConnection pooledConnection) {
            FlintConnection connection = (FlintConnection)pooledConnection.getConnection();
            IDataSource dataSource = parameters.valueOf(DataSourceParameter.class, IDataSource.class);
            IDataSourceConnection dsConnection = dataSource.getDataSourceConnection();
            IDataSource pooledDataSource = connection.getDataSource();
            if (!dataSource.getType().equals(pooledDataSource.getType())) {
                return IConnectionSelector.ReturnCode.NOT_MATCH;
            }
            if (dsConnection.getConnectionString(null) == null) {
                return IConnectionSelector.ReturnCode.NOT_MATCH;
            }
            if (connection.getConnectionString() == null) {
                return IConnectionSelector.ReturnCode.NOT_MATCH;
            }
            if (dsConnection.getConnectionString(null).compareTo(connection.getConnectionString()) != 0) {
                return IConnectionSelector.ReturnCode.NOT_MATCH;
            }
            return IConnectionSelector.ReturnCode.MATCH;
        }
    }
}

