/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqerdp.flint;

import com.cognos.xqe.ast.XQEBaseQueryNode;
import com.cognos.xqe.bibushandler.CancelRequestSourceEnum;
import com.cognos.xqe.bibushandler.CancelUnsuccessfulException;
import com.cognos.xqe.bibushandler.ICancelable;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.cache.ICaching;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.providers.ProviderResultSetBase;
import com.cognos.xqe.data.providers.relational.SQLQueryArguments;
import com.cognos.xqe.data.providers.relational.jdbc.JDBCLog;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.exception.RequestCanceledException;
import com.cognos.xqe.exception.XQEException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.resultset.interfaces.IColumnInfo;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.caching.CachedResultSetManager;
import com.cognos.xqe.resultsets.tabular.ColumnInfo;
import com.cognos.xqe.resultsets.tabular.RowsetInfo;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.runtree.relational.vectorization.XVectorContext;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatchUtil;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.Governors;
import com.cognos.xqe.util.datasets.FlintProcessExitCode;
import com.cognos.xqe.util.resource.ReleasableResourceTracker;
import com.cognos.xqe.zipi.ZipiBridge;
import com.cognos.xqe.zipi.ZipiContext;
import com.cognos.xqerdp.flint.FlintConnection;
import com.cognos.xqerdp.flint.FlintDataProvider;
import com.cognos.xqerdp.flint.FlintQueryExecutor;
import com.cognos.xqerdp.flint.result.QueryResultReader;
import com.cognos.xqerdp.flint.result.WritableRowValueAdapter;
import com.ibm.ba.flint.thrift.query.SamplingOptions;
import com.ibm.ba.flint.thrift.types.Schema;
import com.ibm.ba.flint.thrift.types.SchemaField;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.StringUtils;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.transport.TTransportException;

public class FlintTabularResult
extends ProviderResultSetBase
implements ITabularResultSet,
CachedResultSetManager.IPooledConnectionDelegator {
    private static final String ERR_INVALID_FLINT_TYPE = "FlintTabularResult: %s - Invalid type for FLINT result set column '%s'. Found dataType %s.";
    private static final String WARN_INVALIDATING_THE_POOLED_CONNECTION = "FlintResultSet: %s - Invalidating the Flint Pooled Connection (%s) due to exception: %s";
    public static final String INFO_RETURNING_THE_POOLED_CONNECTION = "FlintResultSet: %s - Returning the Flint Pooled Connection (%s).\nTotal Time Flint Pooled Connection was borrowed: %.3f secs.";
    private static final String INFO_SQL_EXECUTION_TIME = "FlintResultSet: %s - Flint SQL Statement (Flint Pooled Connection: %s):\n%s\nTime: %.3f secs.";
    private static final String ERROR_SQL_STATEMENT_MESSAGE = "FlintResultSet: %s - Flint failed executing the following SQL Statement (Flint Pooled Connection: %s): \n%s.\nCause: ";
    private static final String INFO_RESULT_SET_COMPUTATION_TIME = "FlintResultSet: %s - Total Computation Time (SQL Statement + Result Retrieval) for Flint Pooled Connection (%s): %.3f secs.- Total Rows Retrieved: %s.";
    protected IExecutionEnvironment execEnv = null;
    protected IPooledConnection pooledConnection;
    protected FlintConnection connection;
    protected FlintDataProvider dataProvider;
    protected SQLQueryArguments queryArgs;
    protected XQEBaseQueryNode parent;
    private boolean isCaching = false;
    protected FlintCancelHandler cancelHandler = null;
    protected boolean bCanceled = false;
    protected boolean vectorizable;
    protected int nIterators;
    protected List<ITabularResultSet> siblings = new ArrayList<ITabularResultSet>();
    protected QueryResultReader queryResult;
    private long flintTabularResultProcessingStart;
    private long flintPooledConnectionBorrowedTimeBegin = System.nanoTime();

    public FlintTabularResult(XDataContext context, IPooledConnection thePooledConnection, SQLQueryArguments theQueryArgs, Integer nodeId, FlintDataProvider theDataProvider) {
        super(theDataProvider, context, null, nodeId);
        this.execEnv = context.getEnvironment();
        this.dataProvider = theDataProvider;
        this.queryArgs = theQueryArgs;
        this.parent = this.queryArgs.getParent();
        String theSQLQuery = this.queryArgs.getSQLQuery();
        ZipiTimer zipiTimer = ZipiBridge.startTimer("XFlintSqlResultSet", this.parent.getNodeTypeName(), ZipiContext.getQRDName());
        try {
            this.pooledConnection = thePooledConnection;
            this.connection = (FlintConnection)thePooledConnection.getConnection();
            this.cancelHandler = new FlintCancelHandler(this);
            this.execEnv.getCancelManager().addCancelHandler(this.cancelHandler);
            this.connection.connect(null);
            long begin = System.nanoTime();
            this.queryResult = this.executeSqlQuery(theSQLQuery, context);
            long end = System.nanoTime();
            this.flintTabularResultProcessingStart = begin;
            JDBCLog.getLogger().log(String.format(INFO_SQL_EXECUTION_TIME, this, this.pooledConnection, theSQLQuery, Float.valueOf((float)(end - begin) * 1.0f / (float)TimeUnit.SECONDS.toNanos(1L))));
            this.rowsetInfo = new RowsetInfo();
            Schema mdSchema = this.queryResult.getSchema();
            for (SchemaField schemaField : mdSchema.getFields()) {
                IColumnInfo columnInfo = FlintTabularResult.generateColumnInfoFromSchemaField(schemaField, this);
                this.rowsetInfo.addColumnInfo(columnInfo);
            }
            this.mergeFlintRowsetInfoWithCalculatedRowsetInfo();
            this.vectorizable = true;
            for (int i = 0; i < this.rowsetInfo.getNumColumns(); ++i) {
                IColumnInfo colInfo = this.rowsetInfo.getColumnInfo(i);
                IDataType dataType = colInfo.getDataType();
                if (!dataType.isBlob() && !dataType.isClob() && !dataType.isArray() && !dataType.isPeriod()) continue;
                this.vectorizable = false;
                break;
            }
        }
        catch (Exception ex) {
            JDBCLog.getLogger(LogLevel.ERROR).log(String.format(ERROR_SQL_STATEMENT_MESSAGE, this, this.pooledConnection, theSQLQuery), (Throwable)ex);
            this.release();
            if (ex instanceof XQERuntimeException) {
                throw (XQERuntimeException)ex;
            }
            throw new XQERuntimeException(XQEMessageKeys.DAT_DataSourceAdapterError, (Throwable)ex, ex.toString());
        }
        finally {
            if (zipiTimer != null) {
                zipiTimer.stop();
            }
        }
    }

    private void mergeFlintRowsetInfoWithCalculatedRowsetInfo() {
        if (null == this.queryArgs || null == this.queryArgs.getCalculatedRowsetInfo()) {
            return;
        }
        IRowsetInfo calculatedRowsetInfo = this.queryArgs.getCalculatedRowsetInfo();
        for (int i = 0; i < calculatedRowsetInfo.getNumColumns(); ++i) {
            IDataType calDataType;
            IColumnInfo colInfo = this.rowsetInfo.getColumnInfo(i);
            IColumnInfo calcColInfo = calculatedRowsetInfo.getColumnInfo(i);
            if (null == calcColInfo) continue;
            if (calcColInfo.getDataType().isTime() || calcColInfo.getDataType().isTimestamp() || calcColInfo.getDataType().isInterval()) {
                colInfo.setDataType(calcColInfo.getDataType());
            }
            if (null == this.queryArgs.getVectorizationContext() || !(calDataType = calcColInfo.getDataType()).isNumeric()) continue;
            colInfo.setDataType(calDataType);
        }
    }

    @Override
    public long getPooledConnectionBorrowedTimeBegin() {
        return this.flintPooledConnectionBorrowedTimeBegin;
    }

    private QueryResultReader executeSqlQuery(String sql, XDataContext dataContext) throws Exception {
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        FlintQueryExecutor executor = new FlintQueryExecutor(this.connection.getApiFacade());
        SamplingOptions samplingOpts = this.getSamplingOptions(dataContext);
        boolean isStatsQuery = (Boolean)dataContext.getProperty(Governors.AllGovernors.IS_STATS_QUERY.getKey());
        try {
            if (isStatsQuery) {
                return executor.executeSqlToResultSetCacheOFF(sql, samplingOpts);
            }
            if (config.getBooleanProperty("queryExecution.flintServer.executeToSerializedFile[@enabled]", false)) {
                return executor.executeSqlToSerializedFile(sql, samplingOpts);
            }
            return executor.executeSqlToCursor(sql, samplingOpts);
        }
        catch (Exception ex) {
            this.invalidateConnectionIfUnstable(ex);
            throw ex;
        }
    }

    private SamplingOptions getSamplingOptions(XDataContext dataContext) {
        return null;
    }

    private void invalidateConnectionIfUnstable(Throwable t) {
        if (this.indicatesUnstableConnection(t)) {
            this.pooledConnection.setNotReusable();
            JDBCLog.getLogger().log(LogLevel.WARN, String.format(WARN_INVALIDATING_THE_POOLED_CONNECTION, this, this.pooledConnection, t.toString()));
        }
    }

    private boolean indicatesUnstableConnection(Throwable ex) {
        if (ex instanceof TApplicationException || ex instanceof TProtocolException || ex instanceof TTransportException) {
            return true;
        }
        Throwable cause = ex.getCause();
        if (null != cause) {
            return this.indicatesUnstableConnection(cause);
        }
        return false;
    }

    @Override
    public IPooledConnection delegatePooledConnection() {
        IPooledConnection result = this.pooledConnection;
        this.pooledConnection = null;
        return result;
    }

    public void setIsCaching(boolean caching) {
        this.isCaching = caching;
    }

    @Override
    public boolean isCaching() {
        return this.isCaching;
    }

    @Override
    public boolean isVectorized() {
        return this.vectorizable;
    }

    void setCanceled(boolean canceledFlag) {
        this.bCanceled = canceledFlag;
    }

    public boolean isCanceled() {
        return this.bCanceled;
    }

    public boolean cancelImpl() {
        return this.connection.cancelActiveRequest();
    }

    @Override
    public ITabularIterator getTabularIterator() {
        return this.getTabularIterator(null);
    }

    @Override
    public ITabularIterator getTabularIterator(XVectorContext vContext) {
        try {
            ITabularIterator tabIt;
            if (this.nIterators == 0) {
                tabIt = new FlintTabularResultIterator(this.getDataContext(), vContext, this.nodeId);
            } else {
                ITabularResultSet sibling = this.dataProvider.query(this.getDataContext(), this.queryArgs);
                this.siblings.add(sibling);
                tabIt = sibling.getTabularIterator();
            }
            ++this.nIterators;
            return tabIt;
        }
        catch (XQEException e) {
            throw new XQERuntimeException(e);
        }
    }

    @Override
    protected void releaseImpl() {
        try {
            this.releaseQueryResult();
            this.releaseSiblings();
            this.returnConnection();
            this.removeCancelHandler();
        }
        finally {
            super.releaseImpl();
        }
    }

    private void releaseQueryResult() {
        try {
            if (this.queryResult != null) {
                this.queryResult.close();
                this.queryResult = null;
            }
        }
        catch (Exception ex) {
            this.invalidateConnectionIfUnstable(ex);
            JDBCLog.getLogger().log(LogLevel.ERROR, (Throwable)ex);
        }
    }

    private void releaseSiblings() {
        for (ITabularResultSet sibling : this.siblings) {
            try {
                sibling.release();
            }
            catch (Exception ex) {
                JDBCLog.getLogger().log(LogLevel.ERROR, (Throwable)ex);
            }
        }
    }

    private void returnConnection() {
        this.connection = null;
        if (this.pooledConnection != null) {
            this.pooledConnection.returnConnection();
            long end = System.nanoTime();
            JDBCLog.getLogger().log(String.format(INFO_RETURNING_THE_POOLED_CONNECTION, this, this.pooledConnection, Float.valueOf((float)(end - this.flintPooledConnectionBorrowedTimeBegin) * 1.0f / (float)TimeUnit.SECONDS.toNanos(1L))));
            this.pooledConnection = null;
        }
    }

    private void removeCancelHandler() {
        if (this.cancelHandler != null) {
            this.execEnv.getCancelManager().removeCancelHandler(this.cancelHandler);
            this.cancelHandler = null;
        }
    }

    private static IColumnInfo generateColumnInfoFromSchemaField(SchemaField flintSchemaField, FlintTabularResult rs) {
        IDataType dt;
        JSONObject metaJson;
        String metaStr = flintSchemaField.getMetadata();
        if (StringUtils.isNotEmpty((String)metaStr)) {
            try {
                metaJson = JSONObject.parse((String)metaStr);
            }
            catch (IOException e) {
                throw new XQERuntimeException(e);
            }
        } else {
            metaJson = new JSONObject();
        }
        switch (flintSchemaField.getType()) {
            case BINARY: 
            case BYTE: {
                dt = DataTypeFactory.getBinaryType();
                break;
            }
            case BOOLEAN: {
                dt = DataTypeFactory.getBooleanType();
                break;
            }
            case DATE: {
                dt = DataTypeFactory.getDateType();
                break;
            }
            case DECIMAL: {
                dt = DataTypeFactory.getDecimalType(flintSchemaField.getPrecision(), flintSchemaField.getScale());
                break;
            }
            case DOUBLE: {
                dt = DataTypeFactory.getDoubleType();
                break;
            }
            case FLOAT: {
                dt = DataTypeFactory.getFloatType();
                break;
            }
            case INT: {
                dt = DataTypeFactory.getIntegerType();
                break;
            }
            case LONG: {
                dt = DataTypeFactory.getLongType();
                break;
            }
            case SHORT: {
                dt = DataTypeFactory.getSmallintType();
                break;
            }
            case STRING: {
                dt = FlintTabularResult.getStringOrIntervalType(metaJson);
                break;
            }
            case TIMESTAMP: {
                dt = FlintTabularResult.getTimeOrTimestampType(metaJson);
                break;
            }
            default: {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, String.format(ERR_INVALID_FLINT_TYPE, rs, flintSchemaField.getName(), flintSchemaField.getType().name()));
            }
        }
        ColumnInfo ci = new ColumnInfo(flintSchemaField.getName(), dt);
        ci.setNullable(flintSchemaField.isNullable());
        return ci;
    }

    private static IDataType getStringOrIntervalType(JSONObject metadata) {
        if (Boolean.TRUE.equals(metadata.get((Object)"isIntervalYM"))) {
            return DataTypeFactory.getIntervalYearMonthType();
        }
        if (Boolean.TRUE.equals(metadata.get((Object)"isIntervalDT"))) {
            return DataTypeFactory.getIntervalDayTimeType();
        }
        return DataTypeFactory.getStringType();
    }

    private static IDataType getTimeOrTimestampType(JSONObject metadata) {
        boolean hasTimeZone = Boolean.TRUE.equals(metadata.get((Object)"hasTimeZone"));
        if (Boolean.TRUE.equals(metadata.get((Object)"isTime"))) {
            if (hasTimeZone) {
                return DataTypeFactory.getTimeWithTZType();
            }
            return DataTypeFactory.getTimeType();
        }
        if (hasTimeZone) {
            return DataTypeFactory.getTimestampWithTZType();
        }
        return DataTypeFactory.getTimestampType();
    }

    protected class FlintTabularResultIterator
    extends XTabularIterator
    implements ICaching {
        protected final AtomicBoolean mReleased;
        protected int nColumns;
        private XVectorRowBatch batch;
        protected RowValue outputRow;
        protected WritableRowValueAdapter rowAdapter;
        private boolean eod;

        protected FlintTabularResultIterator(XDataContext context, XVectorContext vContext, Integer id) {
            super(context, id);
            this.mReleased = new AtomicBoolean(false);
            try {
                this.setMaxRowsRetrievedLimit(context.getEnvironment().getMultiRequestContext().fetchLongConfiguration("ibmcognos.flint.maxRowsRetrieved", 0L));
                this.setMaxRowsLocalProcessing(context.getEnvironment().getMaxRowsLocalProcessing());
                this.startTimer();
                this.nColumns = FlintTabularResult.this.rowsetInfo.getNumColumns();
                this.outputRow = DataValueFactory.createRowValue(context.getLocalCollator(), FlintTabularResult.this.rowsetInfo);
                this.rowAdapter = new WritableRowValueAdapter(this.outputRow, FlintTabularResult.this.connection.getServerZoneId(), ZoneId.systemDefault());
                if (FlintTabularResult.this.vectorizable) {
                    this.batch = XVectorRowBatchUtil.createRowBatch(vContext, FlintTabularResult.this.rowsetInfo, context.getLocalCollator());
                }
                ReleasableResourceTracker parentTracker = FlintTabularResult.this.getResourceTracker();
                parentTracker.addInstance(this, Thread.currentThread().getStackTrace());
            }
            catch (XQERuntimeException re) {
                FlintTabularResult.this.release();
                throw re;
            }
            finally {
                this.stopTimer();
            }
        }

        @Override
        public boolean isCaching() {
            return FlintTabularResult.this.isCaching();
        }

        @Override
        public Object nextImpl() {
            if (FlintTabularResult.this.isCanceled()) {
                throw new OperationCanceledException();
            }
            try {
                if (FlintTabularResult.this.queryResult == null || !FlintTabularResult.this.queryResult.hasMore()) {
                    JDBCLog.getLogger().log(String.format(FlintTabularResult.INFO_RESULT_SET_COMPUTATION_TIME, FlintTabularResult.this, FlintTabularResult.this.pooledConnection, Float.valueOf((float)(System.nanoTime() - FlintTabularResult.this.flintTabularResultProcessingStart) * 1.0f / (float)TimeUnit.SECONDS.toNanos(1L)), this.nRows));
                    this.release();
                    FlintTabularResult.this.returnConnection();
                    return null;
                }
                if (this.maxRowsRetrievedLimit > 0L) {
                    this.throwExceptionIfMaxRowsLimitReached();
                }
                if (this.maxRowsLocalProcessing > 0L) {
                    this.throwExceptionIfMaxRowsLocalProcessingLimitReached();
                }
                FlintTabularResult.this.queryResult.readRow(this.rowAdapter);
            }
            catch (Exception ex) {
                FlintTabularResult.this.invalidateConnectionIfUnstable(ex);
                if (ex instanceof RequestCanceledException && FlintProcessExitCode.OOM == FlintTabularResult.this.connection.getFlintServerManager().getExitCode(TimeUnit.SECONDS.toMillis(1L))) {
                    throw new XQERuntimeException(XQEMessageKeys.FLT_ComputeServiceOOMException, (Throwable)XQERuntimeException.wrap(ex));
                }
                throw XQERuntimeException.wrap(ex);
            }
            ++this.nRows;
            return this.outputRow;
        }

        @Override
        public Object nextBatch() {
            this.batch.reset();
            if (this.eod) {
                this.batch.eod = true;
                return this.batch;
            }
            while (this.batch.size != this.batch.maxBatchSize) {
                IRow tmpRow = (IRow)this.nextImpl();
                if (tmpRow == null) {
                    this.eod = true;
                    if (this.batch.size != 0) break;
                    this.batch.eod = true;
                    break;
                }
                this.batch.addRow(tmpRow);
            }
            return this.batch;
        }

        @Override
        public void release() {
            try {
                if (this.mReleased.compareAndSet(false, true)) {
                    ReleasableResourceTracker parentTracker = FlintTabularResult.this.getResourceTracker();
                    parentTracker.removeInstance(this);
                    FlintTabularResult.this.releaseQueryResult();
                    --FlintTabularResult.this.nIterators;
                }
            }
            catch (Exception ex) {
                JDBCLog.getLogger().log(LogLevel.ERROR, (Throwable)ex);
            }
        }
    }

    public class FlintCancelHandler
    implements ICancelable {
        FlintTabularResult flintResultSet;

        public FlintCancelHandler(FlintTabularResult rs) {
            this.flintResultSet = rs;
        }

        @Override
        public void cancel() {
            if (!this.flintResultSet.isCanceled()) {
                this.flintResultSet.setCanceled(true);
                if (!this.flintResultSet.cancelImpl()) {
                    throw new CancelUnsuccessfulException();
                }
            }
        }

        @Override
        public void cancel(CancelRequestSourceEnum cancelSource) {
            throw new CancelUnsuccessfulException();
        }
    }
}

