/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqerdp.flint.result;

import com.ibm.ba.flint.thrift.types.Schema;
import com.ibm.ba.flint.util.RowReader;
import com.ibm.ba.flint.util.StreamRowReaderFactory;
import com.ibm.ba.flint.util.UnionRowReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.fs.FileStatus;
import shaded.org.apache.hadoop.fs.FileSystem;
import shaded.org.apache.hadoop.fs.Path;

class DeserializePartitionsFromFiles {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeserializePartitionsFromFiles.class);
    private final Schema schema;
    private final Path inPath;
    private final String fileExtension;
    private final StreamRowReaderFactory readerFactory;
    private final Configuration hadoopConf;

    DeserializePartitionsFromFiles(Schema schema, Path inPath, String fileExtension, Configuration hadoopConf, StreamRowReaderFactory readerFactory) {
        if (null == schema) {
            throw new IllegalArgumentException("schema was null");
        }
        if (null == inPath) {
            throw new IllegalArgumentException("inPath was null");
        }
        if (null == hadoopConf) {
            throw new IllegalArgumentException("hadoopConf was null");
        }
        if (null == readerFactory) {
            throw new IllegalArgumentException("readerFactory was null");
        }
        this.schema = schema;
        this.inPath = inPath;
        this.fileExtension = fileExtension;
        this.hadoopConf = hadoopConf;
        this.readerFactory = readerFactory;
    }

    RowReader deserialize() throws IOException {
        LOGGER.info("Deserializing partitions in directory: {}", (Object)this.inPath);
        FileSystem fs = this.inPath.getFileSystem(this.hadoopConf);
        List<Path> partFiles = this.getPartitionFiles(fs);
        return new UnionRowReader(partFiles.stream().map(file -> this.getRowReaderSupplier(fs, (Path)file)).iterator());
    }

    private List<Path> getPartitionFiles(FileSystem fs) throws IOException {
        FileStatus[] listing = StringUtils.isNotEmpty((String)this.fileExtension) ? fs.listStatus(this.inPath, p -> p.getName().endsWith(this.fileExtension)) : fs.listStatus(this.inPath);
        List<Path> partFiles = Arrays.asList(listing).stream().filter(((Predicate<FileStatus>)FileStatus::isDir).negate()).map(FileStatus::getPath).sorted().collect(Collectors.toList());
        LOGGER.trace("Discovered partition files: {}", partFiles);
        return partFiles;
    }

    private UnionRowReader.RowReaderSupplier getRowReaderSupplier(FileSystem fs, Path file) {
        return () -> {
            LOGGER.trace("Reading partition file: {}", (Object)file);
            return this.readerFactory.create(this.schema, (InputStream)fs.open(file));
        };
    }
}

