/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqerdp.json;

import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceConnection;
import com.cognos.xqe.data.model.IDataSourceConnectionSignon;
import com.cognos.xqe.data.providers.relational.AbstractConnection;
import com.cognos.xqe.pool.connection.IInstrumentedPooledConnection;
import com.cognos.xqe.util.LocaleConverter;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class JSONConnection
extends AbstractConnection
implements IInstrumentedPooledConnection {
    private static final String FILE = "file";
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final String HEAD = "HEAD";
    private static final String EQUALS = "=";
    private String collationName = "en:P";
    public static final int DEFAULT_OBJECTS_TO_PROCESS = 10;
    public static final int MAX_OBJECTS_TO_PROCESS = 100;
    protected Map<String, Object> properties = new HashMap<String, Object>();

    public JSONConnection(IDataSource dataSource) {
        super(dataSource);
    }

    @Override
    public void connect(Locale runLocale) {
        String[] tokens;
        if (runLocale != null) {
            this.collationName = LocaleConverter.toString(runLocale) + ":P";
        }
        IDataSourceConnection dsConnection = this.dataSource.getDataSourceConnection();
        IDataSourceConnectionSignon dataSourceConnectionSignon = dsConnection.getSignon();
        String connectionString = dsConnection.getConnectionString(dataSourceConnectionSignon);
        for (String token : tokens = connectionString.split(";")) {
            String[] keyValue = token.split(EQUALS);
            if (keyValue.length != 2) continue;
            String key = keyValue[0];
            String value = keyValue[1];
            this.properties.put(key, value);
            if (!key.equals("AUTHENTICATION_TYPE")) continue;
            this.setAuthenticationType(value);
        }
    }

    @Override
    public void augmentQuery(Map<String, Object> props, String apiType, String query) {
        throw new UnsupportedOperationException();
    }

    protected void testConnection() throws IOException {
        URL url = new URL((String)this.properties.get("URL"));
        String protocol = url.getProtocol();
        if (protocol.equals(FILE)) {
            URLConnection connection = url.openConnection();
            connection.connect();
        } else if (protocol.equals(HTTP) || protocol.equals(HTTPS)) {
            url = new URL(HTTP, url.getHost(), url.getPort(), url.getFile());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod(HEAD);
            int responseCode = connection.getResponseCode();
            if (responseCode < 200 || responseCode >= 400) {
                throw new IOException(connection.getResponseMessage());
            }
        }
    }

    @Override
    public String getConnectionCollationSequence() {
        return this.collationName;
    }

    @Override
    public String getDatabaseCollationSequence() {
        return this.collationName;
    }

    @Override
    public Set<Object> getCachingStatistics() {
        return null;
    }

    @Override
    public String getDatabaseCharset() {
        return null;
    }
}

