/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqerdp.json;

import com.cognos.xqe.authentication.AuthenticationType;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceConnectionSignon;
import com.cognos.xqe.data.model.IUsernamePasswordSignon;
import com.cognos.xqe.data.model.LogonFailureException;
import com.cognos.xqe.data.providers.ConnectionTestQueryArguments;
import com.cognos.xqe.data.providers.DataProviderBase;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.data.providers.connection.parameters.DataSourceParameter;
import com.cognos.xqe.data.providers.connection.parameters.RunLocaleParameter;
import com.cognos.xqe.data.providers.relational.IRelationalDataProvider;
import com.cognos.xqe.data.providers.relational.SQLQueryArguments;
import com.cognos.xqe.exception.XQEException;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IConnectionFactory;
import com.cognos.xqe.pool.connection.IConnectionSelector;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.pool.connection.ISelectorContext;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.ConnectionUtil;
import com.cognos.xqerdp.json.JSONConnection;
import com.cognos.xqerdp.json.cloudant.CloudantConnection;
import com.cognos.xqerdp.json.cloudant.CouchDBConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class JSONDataProvider
extends DataProviderBase
implements IRelationalDataProvider {
    private final JSONConnectionSelector connectionSelector = new JSONConnectionSelector();
    private final JSONConnectionFactory connectionFactory = new JSONConnectionFactory();
    public static final String TYPE = "JSON";
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    public JSONDataProvider(String instanceName, Properties properties) {
        super(instanceName, new Properties());
    }

    @Override
    public void releaseImpl() {
    }

    @Override
    public IConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    @Override
    public IConnectionSelector getConnectionSelector() {
        return this.connectionSelector;
    }

    @Override
    public ITabularResultSet query(XDataContext context, SQLQueryArguments queryArgs) throws XQEException, LogonFailureException {
        throw new XQERuntimeException(XQEMessageKeys.GEN_MethodNotImplemented_INTERNAL, "JSONDataProvider.query");
    }

    @Override
    public List<XQEMessage> testConnection(ConnectionTestQueryArguments theQueryArguments) {
        IDataSource dataSource = theQueryArguments.getDataSource();
        ArrayList<XQEMessage> connectionDetails = new ArrayList<XQEMessage>();
        try {
            Locale runLocale = theQueryArguments.getExecutionEnvironment().getRequestEnvironment().getRunLocale();
            ConnectionParameters connectionParameters = ConnectionUtil.createConnectionParameters(runLocale, dataSource);
            JSONConnection connection = (JSONConnection)this.connectionFactory.createConnection(connectionParameters);
            connection.testConnection();
            this.connectionFactory.destroyConnection(connection);
        }
        catch (LogonFailureException e) {
            if (e.getDataSource() == null) {
                e.setDataSource(dataSource);
            }
            throw e;
        }
        catch (Exception e) {
            throw new XQERuntimeException(e);
        }
        return connectionDetails;
    }

    @Override
    public IPooledConnection borrowConnection(ConnectionParameters connectionParameters, IExecutionEnvironment executionEnvironment) {
        return executionEnvironment.getConnectionPool().borrowConnection(this.getProviderInstanceName(), connectionParameters, this.getConnectionSelector(), this.getConnectionFactory());
    }

    private static class JSONConnectionFactory
    implements IConnectionFactory {
        private JSONConnectionFactory() {
        }

        @Override
        public Object createConnection(ConnectionParameters parameters) {
            IDataSource dataSource = parameters.valueOf(DataSourceParameter.class, IDataSource.class);
            Locale runLocale = parameters.valueOf(RunLocaleParameter.class, Locale.class);
            String dbType = dataSource.getType();
            JSONConnection connection = DataSourceTypeEnum.isCouchDB(dbType) ? new CouchDBConnection(dataSource) : (DataSourceTypeEnum.isCloudant(dbType) ? new CloudantConnection(dataSource) : new JSONConnection(dataSource));
            ((JSONConnection)connection).connect(runLocale);
            return connection;
        }

        @Override
        public void destroyConnection(IPooledConnection pooledConnection) {
            try {
                this.destroyConnection((JSONConnection)pooledConnection.getConnection());
            }
            catch (Exception e) {
                mErrorLogger.log(e);
                Object var2_3 = null;
            }
        }

        public void destroyConnection(JSONConnection connection) {
        }
    }

    private static class JSONConnectionSelector
    implements IConnectionSelector {
        private JSONConnectionSelector() {
        }

        @Override
        public IConnectionSelector.ReturnCode selectConnection(ConnectionParameters connectionParameters, ISelectorContext context, IPooledConnection pooledConnection) {
            JSONConnection connectionToBeBorrowed = (JSONConnection)pooledConnection.getConnection();
            IDataSource currentDataSource = connectionParameters.valueOf(DataSourceParameter.class, IDataSource.class);
            String currentConnString = currentDataSource.getDataSourceConnection().getConnectionString(null);
            Map<String, String> currentConnProperties = JSONConnectionSelector.parseConnectionString(currentConnString);
            String currAuthType = currentConnProperties.get("AUTHENTICATION_TYPE");
            String connToBeBorrowedAuthType = (String)connectionToBeBorrowed.properties.get("AUTHENTICATION_TYPE");
            if (!currentConnProperties.get("SUBTYPE").equals(connectionToBeBorrowed.properties.get("SUBTYPE")) || !currAuthType.equals(connToBeBorrowedAuthType)) {
                return IConnectionSelector.ReturnCode.NOT_MATCH;
            }
            switch (AuthenticationType.getType(currAuthType)) {
                case NONE: {
                    return IConnectionSelector.ReturnCode.MATCH;
                }
                case BASIC: 
                case APIKEY: 
                case OAUTH1: 
                case OAUTH2: {
                    if (JSONConnectionSelector.compareSignons(currentDataSource, connectionToBeBorrowed)) {
                        return IConnectionSelector.ReturnCode.MATCH;
                    }
                    return IConnectionSelector.ReturnCode.NOT_MATCH;
                }
            }
            return IConnectionSelector.ReturnCode.NOT_MATCH;
        }

        private static Map<String, String> parseConnectionString(String connectionString) {
            String[] tokens;
            HashMap<String, String> properties = new HashMap<String, String>();
            for (String token : tokens = connectionString.split(";")) {
                String[] keyValue = token.split("=");
                if (keyValue.length != 2) continue;
                String key = keyValue[0];
                String value = keyValue[1];
                properties.put(key, value);
            }
            return properties;
        }

        public static boolean compareSignons(IDataSource currentDataSource, JSONConnection connectionToBeBorrowed) {
            String currentEncrSignon = currentDataSource.getDataSourceConnection().getEncryptedSignon();
            String connToBeBorrowedEncrSignon = connectionToBeBorrowed.getDataSource().getDataSourceConnection().getEncryptedSignon();
            if (currentEncrSignon != null && currentEncrSignon.equals(connToBeBorrowedEncrSignon)) {
                return true;
            }
            IDataSourceConnectionSignon currSignon = currentDataSource.getDataSourceConnection().getSignon();
            IDataSourceConnectionSignon connToBeBorrowedSignon = connectionToBeBorrowed.getDataSource().getDataSourceConnection().getSignon();
            if (currSignon != null && connToBeBorrowedSignon != null) {
                String connToBeBorrowedUserName;
                IUsernamePasswordSignon currUNPASSSignon = (IUsernamePasswordSignon)currSignon;
                IUsernamePasswordSignon connToBeBorrowedUNPASSSignon = (IUsernamePasswordSignon)connToBeBorrowedSignon;
                String currUserName = currUNPASSSignon.getUserName();
                if (currUserName.equals(connToBeBorrowedUserName = connToBeBorrowedUNPASSSignon.getUserName())) {
                    return true;
                }
            }
            return false;
        }
    }
}

