/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqerdp.json.cloudant;

import com.cognos.xqe.ast.QueryFormatter;
import com.cognos.xqe.bibushandler.datasource.ProviderCapabilites;
import com.cognos.xqe.data.model.CapabilitiesKey;
import com.cognos.xqe.data.model.CapabilitiesKeyParts;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.model.IDataSourceConnection;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqerdp.json.JSONConnection;
import com.cognos.xqerdp.json.cloudant.CloudantQueryBuilder;
import com.cognos.xqerdp.json.cloudant.LuceneQueryBuilder;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.util.Map;

public class CloudantConnection
extends JSONConnection {
    private static final String QUERY = "query";
    private static final String Q = "q";
    private static final String AMPERSAND = "&";
    private static final String ESCAPED_QUESTION_MARK = "\\?";
    private static final String QUESTION_MARK = "?";
    private static final String SELECTOR = "selector";
    private static final String _SEARCH = "_search";
    private static final String _FIND = "_find";

    public CloudantConnection(IDataSource dataSource) {
        super(dataSource);
        Map<String, Object> properties = dataSource.getMetadataProperties();
        IDataSourceConnection dsConnection = dataSource.getDataSourceConnection();
        String connectionString = dsConnection.getConnectionString(null);
        String apiType = (String)properties.get("subType");
        IDataSourceCapabilities capabilities = ProviderCapabilites.getInstance().getCapabilities(new CapabilitiesKey(null, null, apiType, connectionString));
        if (capabilities == null) {
            CapabilitiesKeyParts parts = new CapabilitiesKeyParts(null, apiType, null, null, null, connectionString);
            dataSource.createCapabilities(parts, null);
        } else {
            dataSource.setCapabilities(capabilities);
        }
    }

    @Override
    public QueryFormatter getQueryBuilder(String apiType, boolean formatted) {
        QueryFormatter queryBuilder = null;
        if (apiType != null) {
            if (apiType.equals(_SEARCH)) {
                queryBuilder = new LuceneQueryBuilder();
            } else if (apiType.equals(_FIND)) {
                queryBuilder = new CloudantQueryBuilder();
            }
        }
        return queryBuilder;
    }

    @Override
    public void augmentQuery(Map<String, Object> properties, String apiType, String query) {
        if (query == null || query.isEmpty()) {
            return;
        }
        String method = (String)properties.get("METHOD");
        if (method.equals("POST")) {
            String data = (String)properties.get("DATA");
            try {
                JSONObject requestBody;
                if (apiType.equals(_FIND)) {
                    requestBody = JSONObject.parse((String)query);
                    JSONObject currentQuery = JSONObject.parse((String)data);
                    if (currentQuery.containsKey((Object)SELECTOR)) {
                        if (!requestBody.containsKey((Object)SELECTOR)) {
                            requestBody.put((Object)SELECTOR, currentQuery.get((Object)SELECTOR));
                        } else {
                            JSONArray jArray = new JSONArray();
                            jArray.add(requestBody.get((Object)SELECTOR));
                            jArray.add(currentQuery.get((Object)SELECTOR));
                            JSONObject jObject3 = new JSONObject();
                            jObject3.put((Object)"$and", (Object)jArray);
                            requestBody.put((Object)SELECTOR, (Object)jObject3);
                        }
                    }
                } else {
                    requestBody = JSONObject.parse((String)data);
                    if (requestBody.containsKey((Object)QUERY)) {
                        query = (String)requestBody.get((Object)QUERY) + " AND " + query;
                    }
                    requestBody.put((Object)QUERY, (Object)query);
                }
                properties.put("DATA", requestBody.toString());
            }
            catch (IOException e) {
                throw new XQERuntimeException(e);
            }
        } else {
            String datasetURL = (String)properties.get("URL");
            String[] urlParts = datasetURL.split(ESCAPED_QUESTION_MARK);
            String[] queryParts = urlParts[1].split(AMPERSAND);
            int index = 0;
            for (String queryPart : queryParts) {
                String[] keyValue = queryPart.split("=");
                if (keyValue[0].equals(Q) || keyValue[0].equals(QUERY)) {
                    query = String.format("(%s) AND (%s)", keyValue[1], query);
                    queryParts[index] = String.format("%s=%s", keyValue[0], query);
                    StringBuilder b = new StringBuilder(urlParts[0]);
                    b.append(QUESTION_MARK);
                    for (int i = 0; i < queryParts.length; ++i) {
                        if (i > 0) {
                            b.append(AMPERSAND);
                        }
                        b.append(queryParts[i]);
                    }
                    properties.put("URL", b.toString());
                    break;
                }
                ++index;
            }
        }
    }
}

