/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqerdp.json.cloudant;

import com.cognos.xqe.ast.QueryFormatter;
import com.cognos.xqe.ast.sql.SQLAbstractFunction;
import com.cognos.xqe.ast.sql.SQLComparison;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLFilter;
import com.cognos.xqe.ast.sql.SQLIn;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLLogical;
import com.cognos.xqe.ast.sql.SQLParameter;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLRangeVar;
import com.cognos.xqe.ast.sql.SQLRelation;
import com.cognos.xqe.ast.sql.SQLSort;
import com.cognos.xqe.ast.sql.SQLSortKey;
import com.cognos.xqe.ast.sql.SQLSortKeyList;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.exception.XQERuntimeException;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;

public class CloudantQueryBuilder
extends QueryFormatter {
    private static final String OPENING_BRACE = "{";
    private static final String CLOSING_BRACE = "}";
    private static final String SELECTOR = "selector";
    private SQLValueList fieldList;
    protected String data;

    private String getDelimitedKey(String key) {
        return String.format("\"%s\"", key);
    }

    public CloudantQueryBuilder() {
    }

    public CloudantQueryBuilder(CloudantQueryBuilder parent) {
        this.fieldList = parent.fieldList;
    }

    public void setInitialQuery(String initialQuery) {
        this.data = initialQuery;
    }

    @Override
    public String bufferToString() {
        String query = this.buffer.toString();
        if (this.data == null) {
            return query;
        }
        try {
            JSONObject jObject1 = JSONObject.parse((String)query);
            JSONObject jObject2 = JSONObject.parse((String)this.data);
            if (jObject2.containsKey((Object)SELECTOR)) {
                if (!jObject1.containsKey((Object)SELECTOR)) {
                    jObject1.put((Object)SELECTOR, jObject2.get((Object)SELECTOR));
                } else {
                    JSONArray jArray = new JSONArray();
                    jArray.add(jObject1.get((Object)SELECTOR));
                    jArray.add(jObject2.get((Object)SELECTOR));
                    JSONObject jObject3 = new JSONObject();
                    jObject3.put((Object)"$and", (Object)jArray);
                    jObject1.put((Object)SELECTOR, (Object)jObject3);
                }
            }
            return jObject1.toString();
        }
        catch (IOException e) {
            throw new XQERuntimeException(e);
        }
    }

    private Object[] dumpChildren(SQLQueryNode node, IDataSourceCapabilities capabilities) {
        CloudantQueryBuilder formatter = new CloudantQueryBuilder(this);
        int nArgs = node.getNumberChildren();
        Object[] argValues = new Object[nArgs];
        for (int i = 0; i < nArgs; ++i) {
            ((SQLQueryNode)node.getChild(i)).accept(formatter, capabilities);
            argValues[i] = ((QueryFormatter)formatter).bufferToString();
            formatter.clear();
        }
        return argValues;
    }

    @Override
    public void visit(SQLAbstractFunction node, IDataSourceCapabilities capabilities) {
        this.addText(String.format(node.getPattern(capabilities), this.dumpChildren(node, capabilities)));
    }

    @Override
    public void visit(SQLComparison node, IDataSourceCapabilities capabilities) {
        this.visit((SQLAbstractFunction)node, capabilities);
    }

    @Override
    public void visit(SQLFid node, IDataSourceCapabilities capabilities) {
        StringBuilder b = new StringBuilder(node.getName());
        if (node.isFieldRef()) {
            do {
                node = (SQLFid)node.getChild(0);
                b.insert(0, ".").insert(0, node.getName());
            } while (node.getNumberChildren() > 0);
        }
        this.addText(this.getDelimitedKey(b.toString()));
    }

    @Override
    public void visit(SQLFilter node, IDataSourceCapabilities capabilities) {
        CloudantQueryBuilder formatter = new CloudantQueryBuilder(this);
        ((SQLQueryNode)node.getChild(1)).accept(formatter, capabilities);
        this.addText(",");
        this.addText(String.format(node.getPattern(capabilities), ((QueryFormatter)formatter).bufferToString()));
        ((SQLQueryNode)node.getChild(0)).accept(this, capabilities);
    }

    @Override
    public void visit(SQLIn node, IDataSourceCapabilities capabilities) {
        this.visit((SQLAbstractFunction)node, capabilities);
    }

    @Override
    public void visit(SQLLiteral node, IDataSourceCapabilities capabilities) {
        this.addText(node.getValue().getJSONLiteral());
    }

    @Override
    public void visit(SQLLogical node, IDataSourceCapabilities capabilities) {
        this.addText(String.format(node.getPattern(capabilities), this.dumpChildren(node, capabilities)));
    }

    @Override
    public void visit(SQLProject node, IDataSourceCapabilities capabilities) {
        this.fieldList = node.getOutputList();
        Object[] argValues = this.dumpChildren(this.fieldList, capabilities);
        StringBuilder sBuilder = new StringBuilder();
        for (int i = 0; i < argValues.length; ++i) {
            if (i > 0) {
                sBuilder.append(",");
            }
            sBuilder.append(argValues[i]);
        }
        this.addText(String.format("\"fields\":[%1$s]", sBuilder.toString()));
        ((SQLQueryNode)node.getChild(0)).accept(this, capabilities);
    }

    @Override
    public void visit(SQLQueryBlock node, IDataSourceCapabilities capabilities) {
        if (node.getChild(0).getType() != 301016) {
            this.addText(OPENING_BRACE);
        }
        ((SQLQueryNode)node.getChild(0)).accept(this, capabilities);
        if (node.getChild(0).getType() != 301016) {
            this.addText(CLOSING_BRACE);
        }
    }

    @Override
    public void visit(SQLRangeVar node, IDataSourceCapabilities capabilities) {
        ((SQLQueryNode)node.getChild(0)).accept(this, capabilities);
    }

    @Override
    public void visit(SQLRelation node, IDataSourceCapabilities capabilities) {
        this.data = (String)node.getMetadataProperties().get("DATA");
    }

    @Override
    public void visit(SQLSort node, IDataSourceCapabilities capabilities) {
        ((SQLQueryNode)node.getChild(0)).accept(this, capabilities);
        Object[] argValues = this.dumpChildren(node.getSortKeyList(), capabilities);
        StringBuilder sBuilder = new StringBuilder();
        for (int i = 0; i < argValues.length; ++i) {
            if (i > 0) {
                sBuilder.append(",");
            }
            sBuilder.append(argValues[i]);
        }
        String pattern = node.getPattern(capabilities);
        this.addText(",");
        this.addText(String.format(pattern, sBuilder.toString()));
    }

    @Override
    public void visit(SQLSortKeyList node, IDataSourceCapabilities capabilities) {
        for (int i = 0; i < node.getNumberChildren(); ++i) {
            ((SQLQueryNode)node.getChild(i)).accept(this, capabilities);
        }
    }

    @Override
    public void visit(SQLSortKey node, IDataSourceCapabilities capabilities) {
        SQLFid fid = (SQLFid)node.getChild(0);
        fid = (SQLFid)this.fieldList.getChild(fid.getColumnNo());
        String key = this.getDelimitedKey(fid.getName());
        if (node.isAscending()) {
            this.addText(String.format("{%s: \"asc\"}", key));
        } else {
            this.addText(String.format("{%s: \"desc\"}", key));
        }
    }

    @Override
    public void visit(SQLValueList node, IDataSourceCapabilities capabilities) {
        for (int i = 0; i < node.getNumberChildren(); ++i) {
            if (i > 0) {
                this.addText(",");
                this.addSpace();
            }
            ((SQLQueryNode)node.getChild(i)).accept(this, capabilities);
        }
    }

    @Override
    public void visit(SQLParameter node, IDataSourceCapabilities capabilities) {
        this.addText(String.format(":%s:", node.getName().replace(":", "::")));
    }
}

