/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqerdp.odata;

import com.cognos.xqe.ast.QueryFormatter;
import com.cognos.xqe.bibushandler.CancelManager;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceConnection;
import com.cognos.xqe.data.model.IDataSourceConnectionSignon;
import com.cognos.xqe.data.providers.relational.AbstractConnection;
import com.cognos.xqe.data.providers.relational.SQLQueryArguments;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.function.IProcedure;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqerdp.odata.ODataCancelHandler;
import com.cognos.xqerdp.odata.ODataDataProvider;
import com.cognos.xqerdp.odata.ODataQueryBuilder;
import com.cognos.xqerdp.odata.ODataTabularResult;
import java.util.Locale;

public class ODataConnection
extends AbstractConnection {
    private static final String FORWARD_SLASH = "/";
    private static final String EQUALS = "=";
    private static final String URL = "URL";
    private static final String QUERY_EXECUTION_O_DATA_RESPONSE_LIMIT = "queryExecution.OData.responseLimit[@value]";
    private static final int ONE_KB = 1024;
    private static final int ONE_MB = 0x100000;
    private static final int DEFAULT_RESPONSE_LIMIT = 16;
    private static final int MAX_ALLOWED_RESPONSE_LIMIT = 0x40000000;
    public static final int RESPONSE_LIMIT;
    private int availableResponseLimit = 0;
    protected String collationName = "en:P";
    protected String uri;

    public ODataConnection(IDataSource dataSource) {
        super(dataSource);
        this.increaseAvailableResponseLimit(RESPONSE_LIMIT);
    }

    @Override
    public void connect(Locale runLocale) {
        String[] tokens;
        if (runLocale != null) {
            this.collationName = LocaleConverter.toString(runLocale) + ":P";
        }
        IDataSourceConnection dsConnection = this.dataSource.getDataSourceConnection();
        IDataSourceConnectionSignon dataSourceConnectionSignon = dsConnection.getSignon();
        String connectionString = dsConnection.getConnectionString(dataSourceConnectionSignon);
        for (String token : tokens = connectionString.split(";")) {
            if (!token.startsWith(URL)) continue;
            this.uri = token.split(EQUALS)[1];
        }
        if (!this.uri.endsWith(FORWARD_SLASH)) {
            this.uri = this.uri + FORWARD_SLASH;
        }
    }

    public String getURI() {
        return this.uri;
    }

    @Override
    public String getConnectionCollationSequence() {
        return this.collationName;
    }

    @Override
    public String getDatabaseCollationSequence() {
        return this.collationName;
    }

    @Override
    public String getDatabaseCharset() {
        return null;
    }

    @Override
    public IProcedure getProcedure(String procName, IDataType[] argTypes) {
        return null;
    }

    public ITabularResultSet getResultSet(XDataContext context, IPooledConnection pooledConnection, SQLQueryArguments queryArgs, Integer nodeId, ODataDataProvider dataProvider) {
        CancelManager cancelMgr = context.getEnvironment().getCancelManager();
        ODataTabularResult resultSet = new ODataTabularResult(context, pooledConnection, queryArgs, nodeId, dataProvider);
        ODataCancelHandler ch = new ODataCancelHandler(resultSet);
        cancelMgr.addCancelHandler(ch);
        return resultSet;
    }

    @Override
    public QueryFormatter getQueryBuilder(boolean formatted) {
        return new ODataQueryBuilder();
    }

    public int getAvailableResponseLimit() {
        return this.availableResponseLimit;
    }

    public void increaseAvailableResponseLimit(int availableBytes) {
        this.availableResponseLimit += availableBytes;
    }

    public void decreaseAvailableResponseLimit(int allocatedBytes) {
        this.availableResponseLimit -= allocatedBytes;
        if (this.availableResponseLimit < 0) {
            throw new AssertionError((Object)"Available Response Limit cannot be negative!");
        }
    }

    public void resetAvailableResponseLimit() {
        this.availableResponseLimit = RESPONSE_LIMIT;
    }

    public void disconnect() {
    }

    static {
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        long inputResponseLimit = configuration.getIntegerProperty(QUERY_EXECUTION_O_DATA_RESPONSE_LIMIT, 16) * 0x100000;
        RESPONSE_LIMIT = inputResponseLimit > 0x40000000L ? 0x1000000 : (int)inputResponseLimit;
    }
}

