/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqerdp.odata;

import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.LogonFailureException;
import com.cognos.xqe.data.providers.ConnectionTestQueryArguments;
import com.cognos.xqe.data.providers.DataProviderBase;
import com.cognos.xqe.data.providers.connection.parameters.DataSourceParameter;
import com.cognos.xqe.data.providers.connection.parameters.RunLocaleParameter;
import com.cognos.xqe.data.providers.relational.IRelationalDataProvider;
import com.cognos.xqe.data.providers.relational.SQLQueryArguments;
import com.cognos.xqe.exception.XQEException;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IConnectionFactory;
import com.cognos.xqe.pool.connection.IConnectionSelector;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.pool.connection.ISelectorContext;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.util.ConnectionUtil;
import com.cognos.xqerdp.odata.ODataConnection;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

public class ODataDataProvider
extends DataProviderBase
implements IRelationalDataProvider {
    private static final ODataConnectionSelector CONNECTION_SELECTOR = new ODataConnectionSelector();
    private static final ODataConnectionFactory CONNECTION_FACTORY = new ODataConnectionFactory();
    public static final String TYPE = "ODATA";

    public ODataDataProvider(String instanceName, Properties properties) {
        super(instanceName, new Properties());
    }

    @Override
    public void releaseImpl() {
    }

    @Override
    public IConnectionFactory getConnectionFactory() {
        return CONNECTION_FACTORY;
    }

    @Override
    public IConnectionSelector getConnectionSelector() {
        return CONNECTION_SELECTOR;
    }

    @Override
    public ITabularResultSet query(XDataContext context, SQLQueryArguments queryArgs) throws XQEException, LogonFailureException {
        ExecutionEnvironment env = (ExecutionEnvironment)context.getEnvironment();
        IPooledConnection pooledConnection = ConnectionUtil.getPooledConnection(env, queryArgs.getDataSource());
        ODataConnection connection = (ODataConnection)pooledConnection.getConnection();
        env.registerDataSourceCollationInformation(connection.getDatabaseCollationSequence(), connection.getConnectionCollationSequence());
        ITabularResultSet resultSet = connection.getResultSet(context, pooledConnection, queryArgs, context.getNodeId(), this);
        return resultSet;
    }

    @Override
    public List<XQEMessage> testConnection(ConnectionTestQueryArguments theQueryArguments) {
        IDataSource dataSource = theQueryArguments.getDataSource();
        try {
            ConnectionUtil.connect(theQueryArguments.getExecutionEnvironment(), dataSource);
        }
        catch (LogonFailureException e) {
            if (e.getDataSource() == null) {
                e.setDataSource(dataSource);
            }
            throw e;
        }
        return null;
    }

    @Override
    public IPooledConnection borrowConnection(ConnectionParameters connectionParameters, IExecutionEnvironment executionEnvironment) {
        return executionEnvironment.getConnectionPool().borrowConnection(this.getProviderInstanceName(), connectionParameters, this.getConnectionSelector(), this.getConnectionFactory());
    }

    private static class ODataConnectionFactory
    implements IConnectionFactory {
        private ODataConnectionFactory() {
        }

        @Override
        public Object createConnection(ConnectionParameters parameters) {
            IDataSource dataSource = parameters.valueOf(DataSourceParameter.class, IDataSource.class);
            Locale runLocale = parameters.valueOf(RunLocaleParameter.class, Locale.class);
            ODataConnection connection = new ODataConnection(dataSource);
            connection.connect(runLocale);
            return connection;
        }

        @Override
        public void destroyConnection(IPooledConnection pooledConnection) {
        }
    }

    private static class ODataConnectionSelector
    implements IConnectionSelector {
        private ODataConnectionSelector() {
        }

        @Override
        public IConnectionSelector.ReturnCode selectConnection(ConnectionParameters connectionParameters, ISelectorContext context, IPooledConnection pooledConnection) {
            return IConnectionSelector.ReturnCode.MATCH;
        }
    }
}

