/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqerdp.parquet;

import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceConnection;
import com.cognos.xqe.data.model.IDataSourceConnectionSignon;
import com.cognos.xqe.data.providers.relational.AbstractConnection;
import com.cognos.xqe.data.providers.relational.SQLQueryArguments;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqerdp.parquet.ParquetDataProvider;
import java.util.Locale;

public class ParquetConnection
extends AbstractConnection {
    protected static final int URL_INDEX = 3;
    protected static final String URL_PREFIX = "URL=";
    protected String url;
    protected String collationName;

    public ParquetConnection(IDataSource dataSource) {
        super(dataSource);
        IDataSourceConnection dsConnection = dataSource.getDataSourceConnection();
        IDataSourceConnectionSignon dataSourceConnectionSignon = dsConnection.getSignon();
        String connectionString = dsConnection.getConnectionString(dataSourceConnectionSignon);
        String[] tokens = connectionString.split(";");
        for (int i = 3; i < tokens.length; ++i) {
            String token = tokens[i];
            if (!token.startsWith(URL_PREFIX)) continue;
            this.url = token.substring(URL_PREFIX.length());
            break;
        }
    }

    @Override
    public void connect(Locale runLocale) {
        this.collationName = runLocale.toString() + ":P";
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getConnectionCollationSequence() {
        return this.collationName;
    }

    @Override
    public String getDatabaseCollationSequence() {
        return this.collationName;
    }

    @Override
    public String getDatabaseCharset() {
        return null;
    }

    public ITabularResultSet getResultSet(XDataContext context, IPooledConnection pooledConnection, SQLQueryArguments queryArgs, Integer nodeId, ParquetDataProvider dataProvider) {
        throw new UnsupportedOperationException();
    }

    public void disconnect() {
    }
}

