/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.xqe.resultsdk.wrapper;

import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.resultsets.ContextBase;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.runtree.XIterator;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.trace.XQETrace;
import com.ibm.cognos.xqe.resultsdk.IDataItemInfo;
import com.ibm.cognos.xqe.resultsdk.IEdge;
import com.ibm.cognos.xqe.resultsdk.IPropertyInfo;
import com.ibm.cognos.xqe.resultsdk.IRow;
import com.ibm.cognos.xqe.resultsdk.IRowIterator;
import com.ibm.cognos.xqe.resultsdk.IRowsetInfo;
import com.ibm.cognos.xqe.resultsdk.wrapper.RowsetValue;
import com.ibm.cognos.xqe.resultsdk.wrapper.V5ResultSetWrapper;
import com.ibm.cognos.xqe.resultsdk.wrapper.V5RowIterator;
import com.ibm.cognos.xqe.resultsdk.wrapper.V5RowWrapper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class V5EdgeWrapper
implements IEdge {
    private static final String LOG_ROW_SEPARATOR = "=======";
    private static final String LOG_DATA_ITEM_INDEX = "    data item index: ";
    private static final String LOG_ROWSET_ID = "    rowset id: ";
    private V5ResultSetWrapper mResultSetWrapper;
    private Set<Integer> mTracedRowsets = new HashSet<Integer>();
    private RSAPIEdge mEdge;
    private XIterator mEdgeIterator = null;
    private V5RowIterator mRowIterator = null;
    private RowValue mCurrentRow;
    private RowsetValue[] mCurrentRowsetValues;
    private ContextBase[] mControlBreaks;
    private List<RSAPIEdgeRowset> mDepthRowset;
    private long mRowNumber = -1L;
    private long mSuppressedRowNumber = -1L;
    private boolean mSuppressRows = false;
    private V5RowWrapper mLastV5Row = null;

    V5EdgeWrapper(V5ResultSetWrapper resultSetWrapper, RSAPIEdge edge) {
        this.mResultSetWrapper = resultSetWrapper;
        this.mEdge = edge;
        this.mCurrentRowsetValues = new RowsetValue[this.mEdge.getRowsets().length];
        this.mControlBreaks = new ContextBase[this.mEdge.getRowsets().length];
        this.mDepthRowset = new ArrayList<RSAPIEdgeRowset>();
        if (resultSetWrapper.hasTracingStarted()) {
            this.mTracedRowsets.clear();
            XQETrace trace = resultSetWrapper.getTrace();
            resultSetWrapper.startTraceElement();
            trace.beginElement("Edge");
            trace.attribute("ordinal", this.getOrdinal());
            trace.attribute("size", this.getSize());
        }
    }

    @Override
    public IRowIterator getRowIterator() {
        V5RowIterator rowIterator = new V5RowIterator(this, 0);
        this.initEdgeIterator(rowIterator);
        return rowIterator;
    }

    @Override
    public long getSize() {
        return this.mResultSetWrapper.getV5ResultSet().getV5EdgeSize(this.mEdge);
    }

    private void initEdgeIterator(V5RowIterator rowIterator) {
        if (this.mEdgeIterator != null) {
            this.mEdgeIterator.release();
        }
        this.mEdgeIterator = this.mResultSetWrapper.getV5ResultSet().getV5EdgeIterator(this.mEdge);
        if (this.mRowIterator != null) {
            this.mRowIterator.markAsInvalid();
        }
        this.mRowIterator = rowIterator;
        for (int i = 0; i < this.mControlBreaks.length; ++i) {
            this.mControlBreaks[i] = null;
        }
        this.nextEdgeRow();
    }

    private void nextEdgeRow() {
        for (int i = 0; i < this.mCurrentRowsetValues.length; ++i) {
            this.mCurrentRowsetValues[i] = null;
        }
        this.mCurrentRow = (RowValue)this.mEdgeIterator.next();
        if (this.mCurrentRow == null) {
            return;
        }
        XQEDebugLog.out.println("New row");
        ++this.mRowNumber;
        if (!this.mSuppressRows) {
            ++this.mSuppressedRowNumber;
        }
        IValue[] columns = this.mCurrentRow.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            RowsetValue rowsetValue;
            ContextBase column = (ContextBase)((Object)columns[i]);
            RSAPIEdgeRowset rowset = (RSAPIEdgeRowset)column.getRowset();
            if (rowset == null) continue;
            XQEDebugLog.out.println(LOG_ROWSET_ID + rowset.getRowsetId());
            XQEDebugLog.out.println(LOG_DATA_ITEM_INDEX + column.getDataItemIndex());
            if (column.contextIsAMember()) {
                XQEDebugLog.out.println("    unique name: " + ((ContextMember)column).getUniqueName());
            }
            if ((rowsetValue = this.mCurrentRowsetValues[rowset.getRowsetId()]) == null) {
                XQEDebugLog.out.println("    Column is for new rowset");
                this.mCurrentRowsetValues[rowset.getRowsetId()] = rowsetValue = new RowsetValue();
            } else {
                XQEDebugLog.out.println("    Additional column for rowset");
            }
            rowsetValue.addColumn(i);
            if (column.getDataItemIndex() == -1) {
                IValue controlBreak = (IValue)((Object)this.mControlBreaks[rowset.getRowsetId()]);
                if (controlBreak != null && controlBreak.compareTo(column) == 0) {
                    rowsetValue.setReturnRow(false);
                } else {
                    this.mControlBreaks[rowset.getRowsetId()] = column;
                    if (rowset.getNestedRowset() != null) {
                        this.clearNestedRowsetValues(rowset.getNestedRowset());
                    }
                    if (this.mSuppressRows) {
                        this.getResultSetWrapper().removeInvalidEdgeUpdates(this.getOrdinal(), this.mSuppressedRowNumber, rowset.getRowsetId());
                    }
                }
            }
            XQEDebugLog.out.print("    Rowset columns=");
            int[] rowsetColumns = rowsetValue.getColumns();
            for (int j = 0; j < rowsetColumns.length; ++j) {
                if (j > 0) {
                    XQEDebugLog.out.print(", ");
                }
                XQEDebugLog.out.print(rowsetColumns[j]);
            }
            XQEDebugLog.out.println(".");
            XQEDebugLog.out.println("    Return rowset row value=" + this.mCurrentRowsetValues[rowset.getRowsetId()].returnRow());
            XQEDebugLog.out.println(LOG_ROW_SEPARATOR);
        }
    }

    private void clearNestedRowsetValues(RSAPIEdgeRowset nestedRowset) {
        this.mControlBreaks[nestedRowset.getRowsetId()] = null;
        if (nestedRowset.getNestedRowset() != null) {
            this.clearNestedRowsetValues(nestedRowset.getNestedRowset());
        }
        if (nestedRowset.getSiblingRowset() != null) {
            this.clearNestedRowsetValues(nestedRowset.getSiblingRowset());
        }
        if (this.mSuppressRows) {
            this.getResultSetWrapper().removeInvalidEdgeUpdates(this.getOrdinal(), this.mSuppressedRowNumber, nestedRowset.getRowsetId());
        }
    }

    boolean hasNext(int depth) {
        while (this.mCurrentRow != null) {
            if (depth >= this.mCurrentRow.getColumns().length) {
                return false;
            }
            for (int checkDepth = 0; checkDepth <= depth; ++checkDepth) {
                boolean hasRow;
                RSAPIEdgeRowset rowset = this.getRowsetForDepth(checkDepth);
                if (rowset == null) {
                    return false;
                }
                if (rowset.isEmpty()) break;
                int rowsetId = rowset.getRowsetId();
                boolean bl = hasRow = this.mCurrentRowsetValues[rowsetId] != null && this.mCurrentRowsetValues[rowsetId].returnRow();
                if (hasRow) {
                    return checkDepth == depth;
                }
                if (!this.mSuppressRows || checkDepth != depth) continue;
                this.mResultSetWrapper.suppressRow(this.mEdge.getPositionalOrdinal(), this.mRowNumber);
            }
            this.nextEdgeRow();
            this.clearDepthRowset(depth);
        }
        return false;
    }

    private void clearDepthRowset(int depth) {
        for (int i = this.mDepthRowset.size() - 1; i > -1; --i) {
            if (this.mCurrentRowsetValues[this.mDepthRowset.get(i).getRowsetId()] != null) continue;
            this.mDepthRowset.remove(i);
        }
    }

    RSAPIEdgeRowset getRowsetForDepth(int depth) {
        RSAPIEdgeRowset rowset = null;
        if (depth < this.mDepthRowset.size()) {
            rowset = this.mDepthRowset.get(depth);
            if (depth == 0) {
                for (int i = 0; i < this.mCurrentRowsetValues.length; ++i) {
                    if (this.mCurrentRowsetValues[i] == null) continue;
                    rowset = this.mEdge.getRowset(i);
                    this.mDepthRowset.set(0, rowset);
                    break;
                }
            }
        } else {
            if (depth == 0) {
                for (int i = 0; i < this.mCurrentRowsetValues.length; ++i) {
                    if (this.mCurrentRowsetValues[i] == null) continue;
                    rowset = this.mEdge.getRowset(i);
                    break;
                }
            } else if (depth == this.mDepthRowset.size()) {
                RSAPIEdgeRowset contextRowset = this.mDepthRowset.get(depth - 1);
                for (int i = 0; i < this.mCurrentRowsetValues.length; ++i) {
                    RSAPIEdgeRowset valueRowset;
                    if (i == contextRowset.getRowsetId() || this.mCurrentRowsetValues[i] == null || (valueRowset = this.mEdge.getRowset(i)).getParentRowset() != contextRowset) continue;
                    rowset = valueRowset;
                    break;
                }
            } else {
                return null;
            }
            if (rowset != null) {
                this.mDepthRowset.add(rowset);
            }
        }
        if (rowset != null) {
            return rowset;
        }
        return null;
    }

    IRow next(int depth) {
        if (this.hasNext(depth)) {
            RSAPIEdgeRowset rowset = this.getRowsetForDepth(depth);
            int rowsetId = rowset.getRowsetId();
            this.mCurrentRowsetValues[rowsetId].setReturnRow(false);
            long ordinal = -1L;
            if (rowset.isDetailRowset()) {
                ordinal = this.mRowNumber;
            }
            this.mLastV5Row = new V5RowWrapper(this, rowset, depth, ordinal);
            return this.mLastV5Row;
        }
        return null;
    }

    RSAPIEdge getRSAPIEdge() {
        return this.mEdge;
    }

    @Override
    public int getOrdinal() {
        return this.mEdge.getPositionalOrdinal();
    }

    void suppressRow(V5RowWrapper row) {
        boolean validState;
        boolean bl = validState = this.mLastV5Row == row;
        if (validState) {
            RSAPIEdgeRowset rowset;
            IValue[] columns = this.mCurrentRow.getColumns();
            for (int checkDepth = row.getDepth() + 1; checkDepth < columns.length && (rowset = this.getRowsetForDepth(checkDepth)) != null; ++checkDepth) {
                int rowsetId = rowset.getRowsetId();
                if (this.mCurrentRowsetValues[rowsetId].returnRow()) continue;
                validState = false;
                break;
            }
        }
        if (!validState) {
            throw new IllegalStateException();
        }
        this.mSuppressRows = true;
        this.hasNext(row.getDepth());
        this.mSuppressRows = false;
    }

    void traceRowset(IRowsetInfo rowsetInfo) {
        Integer rowsetId = rowsetInfo.getRowsetId();
        if (!this.mTracedRowsets.contains(rowsetId)) {
            this.mTracedRowsets.add(rowsetId);
            XQETrace trace = this.mResultSetWrapper.getTrace();
            trace.beginElement("RowsetInfo");
            trace.attribute("rowsetId", rowsetId);
            for (IDataItemInfo dataItemInfo : rowsetInfo.getDataItemInfo()) {
                trace.beginElement("DataItem");
                trace.attribute("name", dataItemInfo.getName());
                trace.attribute("valueDataType", dataItemInfo.getValueDataType().toString());
                trace.attribute("isMeasure", dataItemInfo.isMeasure());
                for (IPropertyInfo propertyInfo : dataItemInfo.getPropertyInfo()) {
                    trace.beginElement("Property");
                    trace.attribute("name", propertyInfo.getName());
                    trace.attribute("dataType", propertyInfo.getDataType().toString());
                    trace.attribute("isIntrinsic", propertyInfo.isIntrinsic());
                    trace.endElement();
                }
                trace.endElement();
            }
            trace.endElement();
        }
    }

    V5ResultSetWrapper getResultSetWrapper() {
        return this.mResultSetWrapper;
    }

    RowsetValue[] getCurrentRowsetValues() {
        return this.mCurrentRowsetValues;
    }

    RowValue getCurrentRow() {
        return this.mCurrentRow;
    }

    long getRowNumber() {
        return this.mRowNumber;
    }

    long getSuppressedRowNumber() {
        return this.mSuppressedRowNumber;
    }
}

