/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.xqe.resultsdk.wrapper;

import com.cognos.xqe.resultset.interfaces.IV5ResultSet;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.runtree.v5.edgeupdate.XEdgeUpdateForResult;
import com.cognos.xqe.runtree.v5.edgeupdate.XEdgeUpdateSpec;
import com.cognos.xqe.runtree.v5.edgeupdate.XSuppressByOrdinalSpec;
import com.cognos.xqe.trace.XQETrace;
import com.ibm.cognos.xqe.resultsdk.ICellIterator;
import com.ibm.cognos.xqe.resultsdk.IEdge;
import com.ibm.cognos.xqe.resultsdk.IEdgeIterator;
import com.ibm.cognos.xqe.resultsdk.IResultSet;
import com.ibm.cognos.xqe.resultsdk.wrapper.V5CellIteratorWrapper;
import com.ibm.cognos.xqe.resultsdk.wrapper.V5EdgeIteratorWrapper;
import com.ibm.cognos.xqe.resultsdk.wrapper.V5EdgeWrapper;
import java.util.List;

public class V5ResultSetWrapper
implements IResultSet {
    private XQETrace mTrace = null;
    private boolean mTraceStarted = false;
    private boolean mTraceResultSet = false;
    private boolean mTraceOriginalResultSet = false;
    private boolean mTraceElementStarted = false;
    public static final int THREE = 3;
    private IV5ResultSet mV5ResultSet;
    private String mConversationID;
    private RSAPIDataset mRsapiDataset = null;
    private RSAPIEdge[] mEdges = null;
    private long[] mEdgeSizes = null;
    private XEdgeUpdateForResult mEdgeUpdateSpecs;
    private List<XSuppressByOrdinalSpec> mSuppressSpecs;

    public V5ResultSetWrapper(IV5ResultSet v5ResultSet, RSAPIDataset rsapiDataset, XEdgeUpdateForResult edgeUpdateSpecs, List<XSuppressByOrdinalSpec> suppressSpecs, String conversationID, XQETrace trace) {
        this.mV5ResultSet = v5ResultSet;
        this.mRsapiDataset = rsapiDataset;
        this.mEdges = rsapiDataset.getEdges();
        this.mEdgeSizes = new long[this.mEdges.length];
        for (int i = 0; i < this.mEdgeSizes.length; ++i) {
            this.mEdgeSizes[i] = this.mV5ResultSet.getV5EdgeSize(this.mEdges[i]);
        }
        this.mEdgeUpdateSpecs = edgeUpdateSpecs;
        this.mSuppressSpecs = suppressSpecs;
        this.mConversationID = conversationID;
        this.mTrace = trace;
        if (this.mTrace != null) {
            this.mTrace.beginElement("ResultSet");
            this.mTrace.attribute("conversationID", this.mConversationID);
            this.mTrace.attribute("queryName", this.getQueryName());
            this.mTraceStarted = true;
        }
    }

    public V5ResultSetWrapper(long[] edgeSizes) {
        this.mEdgeSizes = edgeSizes;
    }

    @Override
    public IEdgeIterator getEdgeIterator() {
        if (this.mTraceElementStarted) {
            this.mTrace.endElement();
            this.mTraceElementStarted = false;
        }
        return new V5EdgeIteratorWrapper(this, this.mEdges);
    }

    @Override
    public ICellIterator getCellIterator() {
        if (this.mTraceElementStarted) {
            this.mTrace.endElement();
            this.mTraceElementStarted = false;
        }
        if (this.mRsapiDataset.isListReport()) {
            return null;
        }
        return new V5CellIteratorWrapper(this);
    }

    @Override
    public long[] getEdgeOrdinals(long cellOrdinal) {
        int i;
        long[] edgeOrdinals = new long[this.mEdgeSizes.length];
        int combinedSize = 1;
        for (i = this.mEdgeSizes.length - 2; i >= 0; --i) {
            if (this.mEdgeSizes[i] <= 0L) continue;
            combinedSize = (int)((long)combinedSize * this.mEdgeSizes[i]);
        }
        for (i = this.mEdgeSizes.length - 1; i > 0; --i) {
            edgeOrdinals[i] = cellOrdinal / (long)combinedSize;
            cellOrdinal -= (long)combinedSize * edgeOrdinals[i];
            if (this.mEdgeSizes[i - 1] <= 0L) continue;
            combinedSize = (int)((long)combinedSize / this.mEdgeSizes[i - 1]);
        }
        edgeOrdinals[0] = cellOrdinal;
        return edgeOrdinals;
    }

    @Override
    public long getCellOrdinal(long[] edgeOrdinals) {
        long cellOrdinal = edgeOrdinals[0];
        long totalEdgeSize = 1L;
        for (int i = 1; i < edgeOrdinals.length; ++i) {
            if (this.mEdgeSizes[i - 1] != 0L) {
                totalEdgeSize *= this.mEdgeSizes[i - 1];
            }
            cellOrdinal += totalEdgeSize * edgeOrdinals[i];
        }
        return cellOrdinal;
    }

    @Override
    public int getNumEdges() {
        return this.mEdges.length;
    }

    @Override
    public IEdge getEdge(int ordinal) {
        if (ordinal < 0 || ordinal >= this.mEdges.length) {
            return null;
        }
        if (this.mTraceElementStarted) {
            this.mTrace.endElement();
            this.mTraceElementStarted = false;
        }
        return new V5EdgeWrapper(this, this.mEdges[ordinal]);
    }

    @Override
    public String getQueryName() {
        return this.mRsapiDataset.getRefQueryName();
    }

    IV5ResultSet getV5ResultSet() {
        return this.mV5ResultSet;
    }

    void addEdgeUpdate(XEdgeUpdateSpec updateSpec) {
        this.mEdgeUpdateSpecs.addUpdateSpec(updateSpec);
    }

    void suppressRow(int edgeNumber, long rowNumber) {
        this.mSuppressSpecs.add(new XSuppressByOrdinalSpec(edgeNumber, rowNumber));
    }

    public XQETrace getTrace() {
        return this.mTrace;
    }

    public void endTrace() {
        if (this.mTraceStarted) {
            if (this.mTraceElementStarted) {
                this.mTrace.endElement();
                this.mTraceElementStarted = false;
            }
            this.mTrace.endElement();
            this.mTrace.close();
        }
    }

    public boolean hasTracingStarted() {
        return this.mTraceStarted;
    }

    public void startTraceElement() {
        if (this.mTraceElementStarted) {
            this.mTrace.endElement();
        }
        this.mTraceElementStarted = true;
    }

    List<XEdgeUpdateSpec> getEdgeUpdates(int edgeNumber, long rowNumber) {
        XEdgeUpdateForResult.XEdgeUpdateSpecForEdge edgeUpdates = this.mEdgeUpdateSpecs.getSpecsForEdge(edgeNumber);
        if (edgeUpdates != null) {
            return edgeUpdates.getSpecsForRow(rowNumber);
        }
        return null;
    }

    void removeInvalidEdgeUpdates(int edgeNumber, long rowNumber, int rowsetId) {
        List<XEdgeUpdateSpec> rowUpdates = this.getEdgeUpdates(edgeNumber, rowNumber);
        if (rowUpdates != null) {
            for (int i = rowUpdates.size() - 1; i >= 0; --i) {
                XEdgeUpdateSpec updateSpec = rowUpdates.get(i);
                if (updateSpec.getRowsetId() != rowsetId) continue;
                rowUpdates.remove(i);
            }
        }
    }

    public RSAPIEdgeRowset getRSAPIRowset(int edgeOrdinal, int rowsetId) {
        return this.mRsapiDataset.getEdge(edgeOrdinal).getRowset(rowsetId);
    }

    @Override
    public boolean getTraceResultSet() {
        return this.mTraceResultSet;
    }

    @Override
    public void setTraceResultSet(boolean traceOn) {
        this.mTraceResultSet = traceOn;
    }

    @Override
    public void setTraceOriginalResultSet(boolean traceOn) {
        this.mTraceOriginalResultSet = traceOn;
    }

    @Override
    public boolean getTraceOriginalResultSet() {
        return this.mTraceOriginalResultSet;
    }
}

