/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.xqe.resultsdk.wrapper;

import com.cognos.xqe.data.types.BusinessKeyType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.MemberType;
import com.cognos.xqe.data.types.StringType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueState;
import com.cognos.xqe.metadata.RoleTypeEnum;
import com.cognos.xqe.resultsets.ContextBase;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.resultsets.ContextValue;
import com.cognos.xqe.rsapi.RSAPIColumn;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.rsapi.RSAPIUsage;
import com.cognos.xqe.runtree.v5.edgeupdate.XEdgeUpdateSpec;
import com.cognos.xqe.trace.XQETrace;
import com.ibm.cognos.xqe.resultsdk.IDataItemInfo;
import com.ibm.cognos.xqe.resultsdk.IPropertyInfo;
import com.ibm.cognos.xqe.resultsdk.IRow;
import com.ibm.cognos.xqe.resultsdk.IRowIterator;
import com.ibm.cognos.xqe.resultsdk.IRowsetInfo;
import com.ibm.cognos.xqe.resultsdk.ValueStateEnum;
import com.ibm.cognos.xqe.resultsdk.wrapper.DataTypeWrapper;
import com.ibm.cognos.xqe.resultsdk.wrapper.RowsetValue;
import com.ibm.cognos.xqe.resultsdk.wrapper.V5DataItemInfo;
import com.ibm.cognos.xqe.resultsdk.wrapper.V5EdgeWrapper;
import com.ibm.cognos.xqe.resultsdk.wrapper.V5PropertyInfo;
import com.ibm.cognos.xqe.resultsdk.wrapper.V5RowIterator;
import com.ibm.cognos.xqe.resultsdk.wrapper.V5RowsetInfo;
import com.ibm.cognos.xqe.resultsdk.wrapper.V5ValueWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

class V5RowWrapper
implements IRow {
    private static final int NOT_FOUND = -99;
    private V5EdgeWrapper mEdge;
    private RSAPIEdgeRowset mRowset;
    private ContextBase[] mCurrentRowColumns;
    private long mRowNumber;
    private RowsetValue mRowsetValue;
    private int mDepth;
    private long mOrdinal;
    private V5DataItemInfo[] mDataItemInfo = null;

    V5RowWrapper(V5EdgeWrapper edge, RSAPIEdgeRowset rowset, int depth, long ordinal) {
        this.mEdge = edge;
        this.mRowset = rowset;
        this.mDepth = depth;
        this.mOrdinal = ordinal;
        this.mRowsetValue = edge.getCurrentRowsetValues()[rowset.getRowsetId()];
        IValue[] currentColumns = edge.getCurrentRow().getColumns();
        this.mCurrentRowColumns = new ContextBase[currentColumns.length];
        for (int i = 0; i < currentColumns.length; ++i) {
            this.mCurrentRowColumns[i] = (ContextBase)((Object)currentColumns[i]);
        }
        this.mRowNumber = edge.getSuppressedRowNumber();
    }

    @Override
    public long getOrdinal() {
        return this.mOrdinal;
    }

    @Override
    public IRowsetInfo getRowsetInfo() {
        if (this.mDataItemInfo == null) {
            this.initializeDataItemInfo();
        }
        return new V5RowsetInfo(this.mRowset, this.mDataItemInfo);
    }

    void initializeDataItemInfo() {
        ContextBase column;
        int i;
        int[] columns = this.mRowsetValue.getColumns();
        int additionalDataItems = 0;
        for (i = 0; i < columns.length; ++i) {
            Collection<ContextValue> gbms;
            column = this.mCurrentRowColumns[columns[i]];
            if (!column.contextIsAMember()) continue;
            ContextMember member = (ContextMember)column;
            List<Integer> additionalDataItemIndices = member.getAdditionalDataItemIndices();
            if (additionalDataItemIndices != null) {
                for (int adi : additionalDataItemIndices) {
                    if (adi == -1) continue;
                    ++additionalDataItems;
                }
            }
            if ((gbms = member.getGroupBodyMeasures()) == null) continue;
            additionalDataItems += gbms.size();
        }
        this.mDataItemInfo = new V5DataItemInfo[columns.length + additionalDataItems];
        for (i = 0; i < columns.length; ++i) {
            Collection<ContextValue> gbms;
            column = this.mCurrentRowColumns[columns[i]];
            int dataItemIndex = column.getDataItemIndex();
            RSAPIDataItem dataItem = this.getRefDataItem(dataItemIndex);
            IDataType dataType = dataItem.getDataType();
            ArrayList<V5PropertyInfo> propertyInfo = new ArrayList<V5PropertyInfo>();
            boolean isMeasureItem = dataItem.isMeasure();
            if (column.contextIsAMember()) {
                dataType = MemberType.MEMBERTYPE;
                propertyInfo.add(new V5PropertyInfo("_memberCaption", true, new DataTypeWrapper(StringType.DEFAULTSTRINGTYPE)));
                propertyInfo.add(new V5PropertyInfo("_memberUniqueName", true, new DataTypeWrapper(StringType.DEFAULTSTRINGTYPE)));
                if (dataItem.getUsage() != RSAPIUsage.FACT) {
                    propertyInfo.add(new V5PropertyInfo("_businessKey", true, new DataTypeWrapper(BusinessKeyType.DEFAULTBUSINESSKEYTYPE)));
                    propertyInfo.add(new V5PropertyInfo("_memberDescription", true, new DataTypeWrapper(StringType.DEFAULTSTRINGTYPE)));
                    propertyInfo.add(new V5PropertyInfo("_parentUniqueName", true, new DataTypeWrapper(StringType.DEFAULTSTRINGTYPE)));
                }
            } else if (column.contextIsAValue()) {
                dataType = ((ContextValue)column).getDataType();
                if (column.getContextMember() != null) {
                    propertyInfo.add(new V5PropertyInfo("_memberCaption", true, new DataTypeWrapper(StringType.DEFAULTSTRINGTYPE)));
                    propertyInfo.add(new V5PropertyInfo("_memberUniqueName", true, new DataTypeWrapper(StringType.DEFAULTSTRINGTYPE)));
                }
            }
            for (RSAPIColumn rowsetColumn : this.mRowset.getColumns()) {
                if (rowsetColumn.getBaseRefDataItem() != dataItem || rowsetColumn.getColumnRepresentsDataItemValue() || rowsetColumn.getIsCanonicalProperty()) continue;
                propertyInfo.add(new V5PropertyInfo(rowsetColumn.getName(), false, new DataTypeWrapper(rowsetColumn.getDatatype())));
            }
            this.mDataItemInfo[i] = new V5DataItemInfo(dataItem.getName(), propertyInfo.toArray(new V5PropertyInfo[propertyInfo.size()]), new DataTypeWrapper(dataType), isMeasureItem);
            if (!column.contextIsAMember()) continue;
            int infoIndex = columns.length;
            ContextMember member = (ContextMember)column;
            List<Integer> additionDataItemIndices = member.getAdditionalDataItemIndices();
            if (additionDataItemIndices != null) {
                for (int adi = 0; adi < additionDataItemIndices.size(); ++adi) {
                    dataItemIndex = additionDataItemIndices.get(adi);
                    if (dataItemIndex == -1) continue;
                    dataItem = this.mRowset.getDataItem(dataItemIndex);
                    isMeasureItem = dataItem.isMeasure();
                    dataType = dataItem.getDataType();
                    propertyInfo = new ArrayList();
                    this.mDataItemInfo[infoIndex] = new V5DataItemInfo(dataItem.getName(), propertyInfo.toArray(new V5PropertyInfo[propertyInfo.size()]), new DataTypeWrapper(dataType), isMeasureItem);
                    ++infoIndex;
                }
            }
            if ((gbms = member.getGroupBodyMeasures()) == null) continue;
            for (ContextValue value : gbms) {
                dataItemIndex = value.getDataItemIndex();
                dataItem = this.mRowset.getDataItem(dataItemIndex);
                dataType = dataItem.getDataType();
                propertyInfo = new ArrayList();
                propertyInfo.add(new V5PropertyInfo("_memberCaption", true, new DataTypeWrapper(StringType.DEFAULTSTRINGTYPE)));
                propertyInfo.add(new V5PropertyInfo("_memberUniqueName", true, new DataTypeWrapper(StringType.DEFAULTSTRINGTYPE)));
                this.mDataItemInfo[infoIndex] = new V5DataItemInfo(dataItem.getName(), propertyInfo.toArray(new V5PropertyInfo[propertyInfo.size()]), new DataTypeWrapper(dataType), true);
                ++infoIndex;
            }
        }
    }

    @Override
    public IRowIterator getChildRowIterator() {
        return new V5RowIterator(this.mEdge, this.mDepth + 1);
    }

    @Override
    public V5ValueWrapper getValue(String dataItemName) {
        RSAPIColumn rowsetColumn;
        int dataItemIndex = this.getDataItemIndex(dataItemName);
        if (dataItemIndex == -99) {
            return null;
        }
        RSAPIDataItem dataItem = this.getRefDataItem(dataItemIndex);
        if (dataItem.isMemberProperty() && (rowsetColumn = this.getDataItemPropertyColumn(dataItemName)) != null) {
            return this.getPropertyValue(rowsetColumn);
        }
        ContextValue gbmValue = this.getDataItemGroupBodyMeasureValue(dataItemName);
        if (gbmValue != null) {
            return new V5ValueWrapper((Value)gbmValue.getValue());
        }
        ContextBase column = this.getDataItemColumn(dataItemIndex);
        if (column == null) {
            return null;
        }
        if (column.contextIsAMember()) {
            ContextMember contextMember = (ContextMember)column;
            return new V5ValueWrapper(contextMember.getCaptionValue());
        }
        ContextValue contextValue = (ContextValue)column;
        return new V5ValueWrapper((Value)contextValue.getValue());
    }

    private ContextBase getDataItemColumn(int dataItemIndex) {
        for (ContextBase column : this.mCurrentRowColumns) {
            if (column.getRowset() != this.mRowset || column.getDataItemIndex() != dataItemIndex) continue;
            return column;
        }
        return null;
    }

    @Override
    public void setValue(String dataItemName, Object theValue) {
        ContextBase column;
        RSAPIColumn rowsetColumn;
        int dataItemIndex = this.getDataItemIndex(dataItemName);
        if (dataItemIndex == -99) {
            return;
        }
        RSAPIDataItem dataItem = this.getRefDataItem(dataItemIndex);
        if (dataItem.isMemberProperty() && (rowsetColumn = this.getDataItemPropertyColumn(dataItemName)) != null) {
            this.setCustomPropertyValue(this.mRowset.getRefDataItem().getName(), rowsetColumn, theValue);
            return;
        }
        ContextValue contextValue = this.getDataItemGroupBodyMeasureValue(dataItemName);
        if (contextValue != null && contextValue.getRowset() != null) {
            Value newValue = (Value)contextValue.getDataType().createValue();
            newValue.set(theValue);
            XEdgeUpdateSpec updateSpec = new XEdgeUpdateSpec(this.mEdge.getOrdinal(), this.getRowNumber(), contextValue.getRowset().getRowsetId(), contextValue.getDataItemIndex(), newValue);
            this.mEdge.getResultSetWrapper().addEdgeUpdate(updateSpec);
        }
        if ((column = this.getDataItemColumn(dataItemIndex)) == null) {
            return;
        }
        if (column.contextIsAMember() && column.getRowset() != null) {
            StringValue stringValue = DataValueFactory.createStringValue();
            stringValue.set(theValue);
            XEdgeUpdateSpec updateSpec = new XEdgeUpdateSpec(this.mEdge.getOrdinal(), this.getRowNumber(), column.getRowset().getRowsetId(), dataItemIndex, stringValue);
            this.mEdge.getResultSetWrapper().addEdgeUpdate(updateSpec);
        }
    }

    @Override
    public void setValueState(String dataItemName, ValueStateEnum theValueState) {
        ContextBase column;
        RSAPIColumn rowsetColumn;
        int dataItemIndex = this.getDataItemIndex(dataItemName);
        if (dataItemIndex == -99) {
            return;
        }
        RSAPIDataItem dataItem = this.getRefDataItem(dataItemIndex);
        if (dataItem.isMemberProperty() && (rowsetColumn = this.getDataItemPropertyColumn(dataItemName)) != null) {
            this.setCustomPropertyValueState(this.mRowset.getRefDataItem().getName(), rowsetColumn, theValueState);
            return;
        }
        ContextValue contextValue = this.getDataItemGroupBodyMeasureValue(dataItemName);
        if (contextValue != null && contextValue.getRowset() != null) {
            XEdgeUpdateSpec updateSpec = new XEdgeUpdateSpec(this.mEdge.getOrdinal(), this.getRowNumber(), contextValue.getRowset().getRowsetId(), contextValue.getDataItemIndex(), V5RowWrapper.getValueState(theValueState));
            this.mEdge.getResultSetWrapper().addEdgeUpdate(updateSpec);
        }
        if ((column = this.getDataItemColumn(dataItemIndex)) == null) {
            return;
        }
        if (column.contextIsAMember() || column.contextIsAValue() && column.getRowset() != null) {
            XEdgeUpdateSpec updateSpec = new XEdgeUpdateSpec(this.mEdge.getOrdinal(), this.getRowNumber(), column.getRowset().getRowsetId(), dataItemIndex, V5RowWrapper.getValueState(theValueState));
            this.mEdge.getResultSetWrapper().addEdgeUpdate(updateSpec);
        }
    }

    private RSAPIDataItem getRefDataItem(int dataItemIndex) {
        RSAPIDataItem dataItem = null;
        dataItem = dataItemIndex == -1 ? this.mRowset.getRefDataItem() : this.mRowset.getDataItem(dataItemIndex);
        return dataItem;
    }

    private static ValueState getValueState(ValueStateEnum valueStateEnum) {
        switch (valueStateEnum) {
            case OK: {
                return ValueState.OK;
            }
            case NULL: {
                return ValueState.NULL;
            }
            case ERROR: {
                return ValueState.ERROR;
            }
            case SECURITY_VIOLATION: {
                return ValueState.SECURITY_VIOLATION;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public V5ValueWrapper getPropertyValue(String dataItemName, String propertyName) {
        if (dataItemName == null || propertyName == null) {
            return null;
        }
        int index = this.getDataItemIndex(dataItemName);
        if (index == -99) {
            return null;
        }
        ContextBase column = this.getDataItemColumn(index);
        if (column == null) {
            return null;
        }
        ContextMember contextMember = null;
        if (column.contextIsAMember()) {
            contextMember = (ContextMember)column;
        } else if (column.contextIsAValue()) {
            contextMember = ((ContextValue)column).getContextMember();
        }
        if (contextMember != null) {
            Value propertyValue = null;
            if (propertyName.equals("_memberCaption")) {
                propertyValue = contextMember.getCaptionValue();
            } else if (propertyName.equals("_memberUniqueName")) {
                StringValue uniqueName = DataValueFactory.createStringValue();
                uniqueName.set(contextMember.getV5UniqueName());
                propertyValue = uniqueName;
            } else if (propertyName.equals("_businessKey")) {
                propertyValue = contextMember.getBusinessKeyValue();
            } else if (propertyName.equals("_memberDescription")) {
                StringValue description = DataValueFactory.createStringValue();
                description.set(contextMember.getDescription());
                propertyValue = description;
            } else if (propertyName.equals("_parentUniqueName")) {
                StringValue parentName = DataValueFactory.createStringValue();
                parentName.set(contextMember.getParentObjectUniqueName());
                propertyValue = parentName;
            } else {
                propertyValue = (Value)contextMember.getProperty(propertyName);
            }
            if (propertyValue == null) {
                return null;
            }
            return new V5ValueWrapper(propertyValue);
        }
        return null;
    }

    public V5ValueWrapper getPropertyValue(RSAPIColumn rowsetColumn) {
        RSAPIDataItem rowsetDataItem = rowsetColumn.getBaseRefDataItem();
        String propertyName = null;
        propertyName = rowsetColumn.getIsIntrinsicProperty() ? RoleTypeEnum.dataTypeToV5(rowsetDataItem.getDataType()) : rowsetColumn.getPropertyName();
        String dataItemName = null;
        if (this.mRowset != null && this.mRowset.getRefDataItem() != null) {
            dataItemName = this.mRowset.getRefDataItem().getName();
        }
        return this.getPropertyValue(dataItemName, propertyName);
    }

    @Override
    public void setPropertyValue(String dataItemName, String propertyName, Object thePropertyValue) {
        int index = this.getDataItemIndex(dataItemName);
        if (index == -99) {
            return;
        }
        ContextBase column = this.getDataItemColumn(index);
        if (column == null || column.getRowset() == null) {
            return;
        }
        int rowsetId = column.getRowset().getRowsetId();
        if (column.contextIsAMember() || column.contextIsAValue()) {
            if (propertyName.equals("_memberCaption") || propertyName.equals("_memberDescription") || propertyName.equals("_memberUniqueName") || propertyName.equals("_parentUniqueName")) {
                StringValue stringValue = DataValueFactory.createStringValue();
                stringValue.set(thePropertyValue);
                this.addEdgeUpdate(rowsetId, index, propertyName, stringValue);
            } else if (propertyName.equals("_businessKey")) {
                Value newValue = (Value)BusinessKeyType.DEFAULTBUSINESSKEYTYPE.createValue();
                newValue.set(thePropertyValue);
                this.addEdgeUpdate(rowsetId, index, propertyName, newValue);
            } else {
                for (RSAPIColumn rowsetColumn : this.mRowset.getColumns()) {
                    if (rowsetColumn.getColumnRepresentsDataItemValue() || rowsetColumn.getIsCanonicalProperty() || !rowsetColumn.getBaseRefDataItem().getName().equals(dataItemName) || !rowsetColumn.getName().equals(propertyName)) continue;
                    Value newValue = (Value)rowsetColumn.getDatatype().createValue();
                    newValue.set(thePropertyValue);
                    this.addEdgeUpdate(rowsetId, index, propertyName, newValue);
                    break;
                }
            }
        }
    }

    private void setCustomPropertyValue(String dataItemName, RSAPIColumn rowsetColumn, Object thePropertyValue) {
        int index = this.getDataItemIndex(dataItemName);
        if (index == -99) {
            return;
        }
        ContextBase column = this.getDataItemColumn(index);
        if (column == null || column.getRowset() == null) {
            return;
        }
        int rowsetId = column.getRowset().getRowsetId();
        Value newValue = (Value)rowsetColumn.getDatatype().createValue();
        newValue.set(thePropertyValue);
        String propertyName = null;
        propertyName = rowsetColumn.getIsIntrinsicProperty() ? RoleTypeEnum.dataTypeToV5(rowsetColumn.getDatatype()) : rowsetColumn.getPropertyName();
        this.addEdgeUpdate(rowsetId, index, propertyName, newValue);
    }

    private void setCustomPropertyValueState(String dataItemName, RSAPIColumn rowsetColumn, ValueStateEnum theValueState) {
        int index = this.getDataItemIndex(dataItemName);
        if (index == -99) {
            return;
        }
        ContextBase column = this.getDataItemColumn(index);
        if (column.getRowset() == null) {
            return;
        }
        XEdgeUpdateSpec updateSpec = new XEdgeUpdateSpec(this.mEdge.getOrdinal(), this.getRowNumber(), column.getRowset().getRowsetId(), index, rowsetColumn.getBaseRefDataItem().getPropertyName(), V5RowWrapper.getValueState(theValueState));
        this.mEdge.getResultSetWrapper().addEdgeUpdate(updateSpec);
    }

    private void addEdgeUpdate(int rowsetId, int index, String propertyName, Value newValue) {
        XEdgeUpdateSpec updateSpec = new XEdgeUpdateSpec(this.mEdge.getOrdinal(), this.getRowNumber(), rowsetId, index, propertyName, newValue);
        this.mEdge.getResultSetWrapper().addEdgeUpdate(updateSpec);
    }

    int getDataItemIndex(String dataItemName) {
        boolean isRefDataItem;
        int dataItemIndex = -99;
        boolean bl = isRefDataItem = this.mRowset.getRefDataItem() != null && this.mRowset.getRefDataItem().getName().equals(dataItemName);
        if (isRefDataItem) {
            dataItemIndex = -1;
        } else {
            dataItemIndex = this.mRowset.getDataItemOrdinalByName(dataItemName);
            if (dataItemIndex == -1) {
                dataItemIndex = -99;
            }
        }
        return dataItemIndex;
    }

    private RSAPIColumn getDataItemPropertyColumn(String dataItemName) {
        for (RSAPIColumn column : this.mRowset.getColumns()) {
            RSAPIDataItem dataItem = column.getBaseRefDataItem();
            if (!dataItem.getName().equals(dataItemName) || !column.getIsCustomMemberProperty() && !column.getIsIntrinsicProperty()) continue;
            return column;
        }
        return null;
    }

    private ContextValue getDataItemGroupBodyMeasureValue(String dataItemName) {
        int[] columns = this.mRowsetValue.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            ContextMember member;
            Collection<ContextValue> gbms;
            ContextBase column = this.mCurrentRowColumns[columns[i]];
            if (!column.contextIsAMember() || (gbms = (member = (ContextMember)column).getGroupBodyMeasures()) == null) continue;
            for (ContextValue value : gbms) {
                int dataItemIndex = value.getDataItemIndex();
                RSAPIDataItem gbmDataItem = this.mRowset.getDataItem(dataItemIndex);
                if (!gbmDataItem.getName().equals(dataItemName)) continue;
                return value;
            }
        }
        return null;
    }

    ContextBase getColumn(int index) {
        return this.mCurrentRowColumns[index];
    }

    @Override
    public void setPropertyValueState(String dataItemName, String propertyName, ValueStateEnum theValueState) {
        int index = this.getDataItemIndex(dataItemName);
        if (index == -99) {
            return;
        }
        ContextBase column = this.getDataItemColumn(index);
        if (column == null) {
            return;
        }
        if (column.contextIsAMember() || column.contextIsAValue() && column.getRowset() != null) {
            XEdgeUpdateSpec updateSpec = new XEdgeUpdateSpec(this.mEdge.getOrdinal(), this.getRowNumber(), column.getRowset().getRowsetId(), index, propertyName, V5RowWrapper.getValueState(theValueState));
            this.mEdge.getResultSetWrapper().addEdgeUpdate(updateSpec);
        }
    }

    @Override
    public int getEdgeOrdinal() {
        return this.mEdge.getOrdinal();
    }

    @Override
    public void suppress() {
        this.mEdge.suppressRow(this);
    }

    @Override
    public void trace() {
        if (!this.mEdge.getResultSetWrapper().hasTracingStarted()) {
            return;
        }
        XQETrace trace = this.mEdge.getResultSetWrapper().getTrace();
        IRowsetInfo rowsetInfo = this.getRowsetInfo();
        Integer rowsetId = rowsetInfo.getRowsetId();
        this.mEdge.traceRowset(rowsetInfo);
        trace.beginElement("Row");
        trace.attribute("rowsetId", rowsetId);
        trace.attribute("ordinal", this.getOrdinal());
        for (IDataItemInfo dataItemInfo : rowsetInfo.getDataItemInfo()) {
            String dataItemName = dataItemInfo.getName();
            trace.beginElement("DataItem");
            trace.attribute("name", dataItemName);
            V5ValueWrapper value = this.getValue(dataItemName);
            if (value != null) {
                value.trace(trace);
            }
            for (IPropertyInfo propertyInfo : dataItemInfo.getPropertyInfo()) {
                String propertyName = propertyInfo.getName();
                trace.beginElement("PropertyValue");
                trace.attribute("name", propertyName);
                V5ValueWrapper propValue = this.getPropertyValue(dataItemName, propertyName);
                if (propValue != null) {
                    propValue.trace(trace);
                }
                trace.endElement();
            }
            trace.endElement();
        }
        trace.endElement();
    }

    int getDepth() {
        return this.mDepth;
    }

    long getRowNumber() {
        return this.mRowNumber;
    }
}

