/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel;

import java.io.ObjectStreamException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.collections.set.MapBackedSet;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.audit.Auditor;
import org.apache.openjpa.conf.BrokerValue;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.conf.OpenJPAConfigurationImpl;
import org.apache.openjpa.conf.OpenJPAVersion;
import org.apache.openjpa.datacache.DataCacheStoreManager;
import org.apache.openjpa.ee.ManagedRuntime;
import org.apache.openjpa.enhance.ManagedClassSubclasser;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.event.BrokerFactoryEvent;
import org.apache.openjpa.event.RemoteCommitEventManager;
import org.apache.openjpa.instrumentation.InstrumentationManager;
import org.apache.openjpa.kernel.AuditManager;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.kernel.BrokerFactory;
import org.apache.openjpa.kernel.BrokerImpl;
import org.apache.openjpa.kernel.DelegatingStoreManager;
import org.apache.openjpa.kernel.FinalizingBrokerImpl;
import org.apache.openjpa.kernel.ROPStoreManager;
import org.apache.openjpa.kernel.StoreManager;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.lib.instrumentation.InstrumentationLevel;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.Options;
import org.apache.openjpa.lib.util.concurrent.ConcurrentReferenceHashSet;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.util.GeneralException;
import org.apache.openjpa.util.InvalidStateException;
import org.apache.openjpa.util.OpenJPAException;
import org.apache.openjpa.util.UserException;

public abstract class AbstractBrokerFactory
implements BrokerFactory {
    private static final Localizer _loc = Localizer.forPackage(AbstractBrokerFactory.class);
    private static final Map<Object, AbstractBrokerFactory> _pool = Collections.synchronizedMap(new HashMap());
    private final OpenJPAConfiguration _conf;
    private transient boolean _readOnly = false;
    private transient boolean _closed = false;
    private transient RuntimeException _closedException = null;
    private Map<Object, Object> _userObjects = null;
    private final ReentrantLock _lock = new ReentrantLock();
    private transient ConcurrentHashMap<Object, Collection<Broker>> _transactional = new ConcurrentHashMap();
    private transient Set<Broker> _brokers;
    private transient Collection<String> _pcClassNames = null;
    private transient Collection<ClassLoader> _pcClassLoaders = null;
    private transient boolean _persistentTypesLoaded = false;
    private transient Map<Object, Class<?>[]> _lifecycleListeners = null;
    private transient List<Object> _transactionListeners = null;
    private Object _poolKey;

    protected static Object toPoolKey(Map<String, Object> map) {
        Map<String, Object> key = Configurations.getProperty("Id", map);
        return key != null ? key : map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void pool(Object key, AbstractBrokerFactory factory) {
        Map<Object, AbstractBrokerFactory> map = _pool;
        synchronized (map) {
            _pool.put(key, factory);
            factory.setPoolKey(key);
            factory.makeReadOnly();
        }
    }

    public static AbstractBrokerFactory getPooledFactoryForKey(Object key) {
        return _pool.get(key);
    }

    protected AbstractBrokerFactory(OpenJPAConfiguration config) {
        this._conf = config;
        this._brokers = this.newBrokerSet();
        this.getPcClassLoaders();
    }

    @Override
    public OpenJPAConfiguration getConfiguration() {
        return this._conf;
    }

    @Override
    public Broker newBroker() {
        return this.newBroker(this._conf.getConnectionUserName(), this._conf.getConnectionPassword());
    }

    public Broker newBroker(String user, String pass) {
        return this.newBroker(user, pass, this._conf.isTransactionModeManaged(), this._conf.getConnectionRetainModeConstant());
    }

    public Broker newBroker(boolean managed, int connRetainMode) {
        return this.newBroker(this._conf.getConnectionUserName(), this._conf.getConnectionPassword(), managed, connRetainMode);
    }

    public Broker newBroker(String user, String pass, boolean managed, int connRetainMode) {
        return this.newBroker(user, pass, managed, connRetainMode, true);
    }

    @Override
    public Broker newBroker(String user, String pass, boolean managed, int connRetainMode, boolean findExisting) {
        return this.newBroker(user, pass, managed, connRetainMode, findExisting, "", "");
    }

    @Override
    public Broker newBroker(String user, String pass, boolean managed, int connRetainMode, boolean findExisting, String cf1Name, String cf2Name) {
        try {
            this.assertOpen();
            if (StringUtils.isNotEmpty((String)cf1Name)) {
                try {
                    this._conf.getConnectionFactory();
                }
                catch (UserException ue) {
                    this._conf.setConnectionFactoryName(cf1Name);
                }
            }
            this.makeReadOnly();
            Broker broker = null;
            if (findExisting) {
                broker = this.findBroker(user, pass, managed);
            }
            if (broker == null) {
                broker = this.newBrokerImpl(user, pass);
                broker.setConnectionFactoryName(cf1Name);
                broker.setConnectionFactory2Name(cf2Name);
                this.initializeBroker(managed, connRetainMode, broker, false);
            }
            return broker;
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (RuntimeException re) {
            throw new GeneralException(re);
        }
    }

    void initializeBroker(boolean managed, int connRetainMode, Broker broker, boolean fromDeserialization) {
        this.assertOpen();
        this.makeReadOnly();
        DelegatingStoreManager dsm = this.createDelegatingStoreManager();
        ((BrokerImpl)broker).initialize(this, dsm, managed, connRetainMode, fromDeserialization);
        RemoteCommitEventManager remote = this._conf.getRemoteCommitEventManager();
        if (remote.areRemoteEventsEnabled()) {
            broker.addTransactionListener(remote);
        }
        this.loadPersistentTypes(broker.getClassLoader());
        this._brokers.add(broker);
        this._conf.setReadOnly(2);
    }

    protected void addListeners(Broker broker) {
        if (this._lifecycleListeners != null && !this._lifecycleListeners.isEmpty()) {
            for (Map.Entry<Object, Class<?>[]> entry : this._lifecycleListeners.entrySet()) {
                broker.addLifecycleListener(entry.getKey(), entry.getValue());
            }
        }
        if (this._transactionListeners != null && !this._transactionListeners.isEmpty()) {
            Iterator<Object> itr = this._transactionListeners.iterator();
            while (itr.hasNext()) {
                broker.addTransactionListener(itr.next());
            }
        }
    }

    public void loadPersistentTypes(ClassLoader envLoader) {
        if (this._persistentTypesLoaded && this._pcClassNames.isEmpty()) {
            return;
        }
        ClassLoader loader = this._conf.getClassResolverInstance().getClassLoader(this.getClass(), envLoader);
        ArrayList toRedefine = new ArrayList();
        if (!this._persistentTypesLoaded) {
            Collection<Class<?>> clss = this._conf.getMetaDataRepositoryInstance().loadPersistentTypes(false, loader, this._conf.isInitializeEagerly());
            if (clss.isEmpty()) {
                this._pcClassNames = Collections.emptyList();
            } else {
                ArrayList<String> c = new ArrayList<String>(clss.size());
                for (Class<?> cls : clss) {
                    c.add(cls.getName());
                    if (!this.needsSub(cls)) continue;
                    toRedefine.add(cls);
                }
                this.getPcClassLoaders().add(loader);
                this._pcClassNames = c;
            }
            this._persistentTypesLoaded = true;
        } else if (this.getPcClassLoaders().add(loader)) {
            for (String clsName : this._pcClassNames) {
                try {
                    Class<?> cls = Class.forName(clsName, true, loader);
                    if (!this.needsSub(cls)) continue;
                    toRedefine.add(cls);
                }
                catch (Throwable t) {
                    this._conf.getLog("openjpa.Runtime").warn(null, t);
                }
            }
        }
        ManagedClassSubclasser.prepareUnenhancedClasses(this._conf, toRedefine, envLoader);
    }

    private boolean needsSub(Class<?> cls) {
        return !cls.isInterface() && !PersistenceCapable.class.isAssignableFrom(cls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLifecycleListener(Object listener, Class<?>[] classes) {
        this.lock();
        try {
            this.assertOpen();
            if (this._lifecycleListeners == null) {
                this._lifecycleListeners = new HashMap<Object, Class<?>[]>(7);
            }
            this._lifecycleListeners.put(listener, classes);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLifecycleListener(Object listener) {
        this.lock();
        try {
            this.assertOpen();
            if (this._lifecycleListeners != null) {
                this._lifecycleListeners.remove(listener);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTransactionListener(Object listener) {
        this.lock();
        try {
            this.assertOpen();
            if (this._transactionListeners == null) {
                this._transactionListeners = new LinkedList<Object>();
            }
            this._transactionListeners.add(listener);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTransactionListener(Object listener) {
        this.lock();
        try {
            this.assertOpen();
            if (this._transactionListeners != null) {
                this._transactionListeners.remove(listener);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public boolean isClosed() {
        return this._closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.lock();
        try {
            this.assertOpen();
            this.assertNoActiveTransaction();
            Map<Object, AbstractBrokerFactory> map = _pool;
            synchronized (map) {
                if (_pool.get(this._poolKey) == this) {
                    _pool.remove(this._poolKey);
                }
            }
            for (Broker broker : this._brokers) {
                if (broker == null || broker.isClosed()) continue;
                broker.close();
            }
            if (this._conf.metaDataRepositoryAvailable()) {
                PCRegistry.removeRegisterClassListener(this._conf.getMetaDataRepositoryInstance());
            }
            this._conf.close();
            this._closed = true;
            Log log = this._conf.getLog("openjpa.Runtime");
            if (log.isTraceEnabled()) {
                this._closedException = new IllegalStateException();
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public Map<String, Object> getProperties() {
        Map<String, Object> props = this._conf.toProperties(true);
        props.put("VendorName", "OpenJPA");
        props.put("VersionNumber", OpenJPAVersion.VERSION_NUMBER);
        props.put("VersionId", OpenJPAVersion.VERSION_ID);
        return props;
    }

    @Override
    public Set<String> getSupportedProperties() {
        return this._conf.getPropertyKeys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getUserObject(Object key) {
        this.lock();
        try {
            this.assertOpen();
            Object object = this._userObjects == null ? null : this._userObjects.get(key);
            return object;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object putUserObject(Object key, Object val) {
        this.lock();
        try {
            this.assertOpen();
            if (val == null) {
                Object object = this._userObjects == null ? null : this._userObjects.remove(key);
                return object;
            }
            if (this._userObjects == null) {
                this._userObjects = new HashMap<Object, Object>();
            }
            Object object = this._userObjects.put(key, val);
            return object;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void lock() {
        this._lock.lock();
    }

    @Override
    public void unlock() {
        this._lock.unlock();
    }

    protected Object readResolve() throws ObjectStreamException {
        AbstractBrokerFactory factory = AbstractBrokerFactory.getPooledFactoryForKey(this._poolKey);
        if (factory != null) {
            return factory;
        }
        this._transactional = new ConcurrentHashMap();
        this._brokers = this.newBrokerSet();
        String saveLogConfig = this._conf.getLog();
        this._conf.setLog("none");
        this.makeReadOnly();
        this._conf.setLog(saveLogConfig);
        return this;
    }

    private Set<Broker> newBrokerSet() {
        BrokerValue bv = this._conf instanceof OpenJPAConfigurationImpl ? ((OpenJPAConfigurationImpl)this._conf).brokerPlugin : (BrokerValue)this._conf.getValue("BrokerImpl");
        if (FinalizingBrokerImpl.class.isAssignableFrom(bv.getTemplateBrokerType(this._conf))) {
            return MapBackedSet.decorate(new ConcurrentHashMap(), (Object)new Object(){});
        }
        return new ConcurrentReferenceHashSet<Broker>(2);
    }

    protected abstract StoreManager newStoreManager();

    protected Broker findBroker(String user, String pass, boolean managed) {
        if (managed) {
            return this.findTransactionalBroker(user, pass);
        }
        return null;
    }

    protected BrokerImpl newBrokerImpl(String user, String pass) {
        BrokerImpl broker = this._conf.newBrokerInstance(user, pass);
        if (broker == null) {
            throw new UserException(_loc.get("no-broker-class", this._conf.getBrokerImpl()));
        }
        return broker;
    }

    protected void setup() {
    }

    protected Broker findTransactionalBroker(String user, String pass) {
        Object txKey;
        ManagedRuntime mr = this._conf.getManagedRuntimeInstance();
        try {
            Transaction trans = mr.getTransactionManager().getTransaction();
            txKey = mr.getTransactionKey();
            if (trans == null || trans.getStatus() == 6 || trans.getStatus() == 5) {
                return null;
            }
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (Exception e) {
            throw new GeneralException(e);
        }
        Collection<Broker> brokers = this._transactional.get(txKey);
        if (brokers != null) {
            for (Broker broker : brokers) {
                if (!StringUtils.equals((String)broker.getConnectionUserName(), (String)user) || !StringUtils.equals((String)broker.getConnectionPassword(), (String)pass)) continue;
                return broker;
            }
        }
        return null;
    }

    protected void configureBroker(BrokerImpl broker) {
        broker.setOptimistic(this._conf.getOptimistic());
        broker.setNontransactionalRead(this._conf.getNontransactionalRead());
        broker.setNontransactionalWrite(this._conf.getNontransactionalWrite());
        broker.setRetainState(this._conf.getRetainState());
        broker.setRestoreState(this._conf.getRestoreStateConstant());
        broker.setAutoClear(this._conf.getAutoClearConstant());
        broker.setIgnoreChanges(this._conf.getIgnoreChanges());
        broker.setMultithreaded(this._conf.getMultithreaded());
        broker.setAutoDetach(this._conf.getAutoDetachConstant());
        broker.setDetachState(this._conf.getDetachStateInstance().getDetachState());
        broker.setPostLoadOnMerge(this._conf.getPostLoadOnMerge());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeReadOnly() {
        if (this._readOnly) {
            return;
        }
        this.lock();
        try {
            if (this._readOnly) {
                return;
            }
            this._readOnly = true;
            Log log = this._conf.getLog("openjpa.Runtime");
            if (log.isInfoEnabled()) {
                log.info(this.getFactoryInitializationBanner());
            }
            if (log.isTraceEnabled()) {
                Map<String, Object> props = this._conf.toProperties(true);
                String lineSep = J2DoPrivHelper.getLineSeparator();
                StringBuilder buf = new StringBuilder();
                Iterator<Map.Entry<String, Object>> itr = props.entrySet().iterator();
                while (itr.hasNext()) {
                    Map.Entry<String, Object> entry = itr.next();
                    Object value = entry.getValue();
                    buf.append((Object)entry.getKey()).append(": ").append(value != null && value.getClass().isArray() ? Arrays.toString((Object[])value) : value);
                    if (!itr.hasNext()) continue;
                    buf.append(lineSep);
                }
                log.trace(_loc.get("factory-properties", buf.toString()));
            }
            this.setup();
            MetaDataRepository repos = this._conf.getMetaDataRepositoryInstance();
            repos.setValidate(8, true);
            repos.setResolve(8, true);
            PCRegistry.addRegisterClassListener(repos);
            this._conf.setReadOnly(1);
            this._conf.instantiateAll();
            if (this._conf.isInitializeEagerly()) {
                this._conf.setReadOnly(2);
            }
            this._conf.getBrokerFactoryEventManager().fireEvent(new BrokerFactoryEvent(this, 0));
        }
        finally {
            this.unlock();
        }
    }

    protected Object getFactoryInitializationBanner() {
        return _loc.get("factory-init", OpenJPAVersion.VERSION_NUMBER);
    }

    @Override
    public void assertOpen() {
        if (this._closed) {
            if (this._closedException == null) {
                throw new InvalidStateException(_loc.get("closed-factory-notrace"));
            }
            throw new InvalidStateException(_loc.get("closed-factory")).setCause(this._closedException);
        }
    }

    private void assertNoActiveTransaction() {
        if (this._transactional.isEmpty()) {
            return;
        }
        ArrayList<OpenJPAException> excs = new ArrayList<OpenJPAException>(this._transactional.size());
        for (Collection<Broker> brokers : this._transactional.values()) {
            for (Broker broker : brokers) {
                excs.add(new InvalidStateException(_loc.get("active")).setFailedObject(broker));
            }
        }
        if (!excs.isEmpty()) {
            throw new InvalidStateException(_loc.get("nested-exceps")).setNestedThrowables(excs.toArray(new Throwable[excs.size()]));
        }
    }

    boolean syncWithManagedTransaction(BrokerImpl broker, boolean begin) {
        try {
            ManagedRuntime mr = broker.getManagedRuntime();
            TransactionManager tm = mr.getTransactionManager();
            Transaction trans = tm.getTransaction();
            if (trans != null && (trans.getStatus() == 6 || trans.getStatus() == 5)) {
                trans = null;
            }
            if (trans == null && begin) {
                tm.begin();
                trans = tm.getTransaction();
            } else if (trans == null) {
                return false;
            }
            trans.registerSynchronization((Synchronization)broker);
            Object txKey = mr.getTransactionKey();
            Collection<Broker> brokers = this._transactional.get(txKey);
            if (brokers == null) {
                brokers = new ArrayList<Broker>(2);
                this._transactional.put(txKey, brokers);
                trans.registerSynchronization((Synchronization)new RemoveTransactionSync(txKey));
            }
            brokers.add(broker);
            return true;
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (Exception e) {
            throw new GeneralException(e);
        }
    }

    public Collection<Broker> getOpenBrokers() {
        return Collections.unmodifiableCollection(this._brokers);
    }

    protected void releaseBroker(BrokerImpl broker) {
        this._brokers.remove(broker);
    }

    public Object getPoolKey() {
        return this._poolKey;
    }

    void setPoolKey(Object key) {
        this._poolKey = key;
    }

    private Collection<ClassLoader> getPcClassLoaders() {
        if (this._pcClassLoaders == null) {
            this._pcClassLoaders = new ConcurrentReferenceHashSet<ClassLoader>(2);
        }
        return this._pcClassLoaders;
    }

    protected DelegatingStoreManager createDelegatingStoreManager() {
        StoreManager sm = this.newStoreManager();
        DelegatingStoreManager dsm = null;
        if (this._conf.getDataCacheManagerInstance().getSystemDataCache() != null) {
            dsm = new DataCacheStoreManager(sm);
        }
        dsm = new ROPStoreManager(dsm == null ? sm : dsm);
        return dsm;
    }

    @Override
    public void postCreationCallback() {
        InstrumentationManager imgr;
        Options o;
        Auditor auditor = this._conf.getAuditorInstance();
        if (auditor != null) {
            this.addTransactionListener(new AuditManager(auditor));
        }
        if (this._conf.isInitializeEagerly()) {
            this.newBroker(this._conf.getConnectionUserName(), this._conf.getConnectionPassword(), this._conf.isConnectionFactoryModeManaged(), this._conf.getConnectionRetainModeConstant(), false).close();
        }
        if (MetaDataRepository.needsPreload(o = Configurations.parseProperties(Configurations.getProperties(this._conf.getMetaDataRepository())))) {
            MetaDataRepository mdr = this._conf.getMetaDataRepositoryInstance();
            mdr.setValidate(8, true);
            mdr.setResolve(8, true);
            this.loadPersistentTypes(AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction()));
            mdr.preload();
        }
        if ((imgr = this._conf.getInstrumentationManagerInstance()) != null) {
            imgr.start(InstrumentationLevel.FACTORY, this);
        }
    }

    private class RemoveTransactionSync
    implements Synchronization {
        private final Object _trans;

        public RemoveTransactionSync(Object trans) {
            this._trans = trans;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            AbstractBrokerFactory.this._transactional.remove(this._trans);
        }
    }
}

