/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.openjpa.lib.util.JavaVersions;
import serp.bytecode.lowlevel.ConstantPoolTable;

public class TemporaryClassLoader
extends ClassLoader {
    public TemporaryClassLoader(ClassLoader parent) {
        super(parent);
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c != null) {
            return c;
        }
        if (name.startsWith("java.") || name.startsWith("javax.") || name.startsWith("sun.")) {
            return Class.forName(name, resolve, this.getClass().getClassLoader());
        }
        String resourceName = name.replace('.', '/') + ".class";
        InputStream resource = this.getResourceAsStream(resourceName);
        if (resource == null) {
            throw new ClassNotFoundException(name);
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] b = new byte[1024];
        try {
            int n = 0;
            while ((n = resource.read(b, 0, b.length)) != -1) {
                bout.write(b, 0, n);
            }
            byte[] classBytes = bout.toByteArray();
            if (TemporaryClassLoader.isAnnotation(classBytes) || TemporaryClassLoader.isEnum(classBytes)) {
                try {
                    Class<?> frameworkClass = Class.forName(name, resolve, this.getClass().getClassLoader());
                    return frameworkClass;
                }
                catch (ClassNotFoundException frameworkClass) {
                    // empty catch block
                }
            }
            try {
                return this.defineClass(name, classBytes, 0, classBytes.length);
            }
            catch (SecurityException e) {
                return super.loadClass(name, resolve);
            }
        }
        catch (IOException ioe) {
            return super.loadClass(name, resolve);
        }
    }

    private static boolean isAnnotation(byte[] b) {
        if (JavaVersions.VERSION < 5) {
            return false;
        }
        int idx = ConstantPoolTable.getEndIndex((byte[])b);
        int access = ConstantPoolTable.readUnsignedShort((byte[])b, (int)idx);
        return (access & 0x2000) != 0;
    }

    private static boolean isEnum(byte[] b) {
        if (JavaVersions.VERSION < 5) {
            return false;
        }
        int idx = ConstantPoolTable.getEndIndex((byte[])b);
        int access = ConstantPoolTable.readUnsignedShort((byte[])b, (int)idx);
        return (access & 0x4000) != 0;
    }
}

