/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.IBMJCE;
import java.io.ObjectStreamException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.KeyRep;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

final class PBKDF2KeyImpl
implements PBEKey {
    static final long serialVersionUID = -2234868909660948157L;
    private char[] passwd;
    private byte[] salt;
    private int iterCount;
    private byte[] key;
    private Mac prf;
    private static String[] z;

    private static byte[] a(char[] cArray) {
        Charset charset = Charset.forName(z[2]);
        CharBuffer charBuffer = CharBuffer.wrap(cArray);
        ByteBuffer byteBuffer = charset.encode(charBuffer);
        int n2 = byteBuffer.limit();
        byte[] byArray = new byte[n2];
        byteBuffer.get(byArray, 0, n2);
        return byArray;
    }

    PBKDF2KeyImpl(PBEKeySpec pBEKeySpec, String string) throws InvalidKeySpecException {
        char[] cArray = pBEKeySpec.getPassword();
        this.passwd = cArray == null ? new char[0] : (char[])cArray.clone();
        byte[] byArray = PBKDF2KeyImpl.a(this.passwd);
        this.salt = pBEKeySpec.getSalt();
        if (this.salt == null) {
            throw new InvalidKeySpecException(z[5]);
        }
        this.iterCount = pBEKeySpec.getIterationCount();
        if (this.iterCount == 0) {
            throw new InvalidKeySpecException(z[4]);
        }
        if (this.iterCount < 0) {
            throw new InvalidKeySpecException(z[3]);
        }
        int n2 = pBEKeySpec.getKeyLength();
        if (n2 == 0) {
            throw new InvalidKeySpecException(z[7]);
        }
        if (n2 == 0) {
            throw new InvalidKeySpecException(z[6]);
        }
        try {
            this.prf = Mac.getInstance(string, new IBMJCE());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            InvalidKeySpecException invalidKeySpecException = new InvalidKeySpecException();
            invalidKeySpecException.initCause(noSuchAlgorithmException);
            throw invalidKeySpecException;
        }
        this.key = PBKDF2KeyImpl.a(this.prf, byArray, this.salt, this.iterCount, n2);
    }

    private static byte[] a(Mac mac, byte[] byArray, byte[] byArray2, int n2, int n3) {
        int n4 = n3 / 8;
        byte[] byArray3 = new byte[n4];
        try {
            int n5 = mac.getMacLength();
            int n6 = (n4 + n5 - 1) / n5;
            int n7 = n4 - (n6 - 1) * n5;
            byte[] byArray4 = new byte[n5];
            byte[] byArray5 = new byte[n5];
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, mac.getAlgorithm());
            mac.init(secretKeySpec);
            byte[] byArray6 = new byte[4];
            for (int i2 = 1; i2 <= n6; ++i2) {
                mac.update(byArray2);
                byArray6[3] = (byte)i2;
                byArray6[2] = (byte)(i2 >> 8 & 0xFF);
                byArray6[1] = (byte)(i2 >> 16 & 0xFF);
                byArray6[0] = (byte)(i2 >> 24 & 0xFF);
                mac.update(byArray6);
                mac.doFinal(byArray4, 0);
                System.arraycopy(byArray4, 0, byArray5, 0, byArray4.length);
                for (int i3 = 2; i3 <= n2; ++i3) {
                    mac.update(byArray4);
                    mac.doFinal(byArray4, 0);
                    for (int i4 = 0; i4 < byArray4.length; ++i4) {
                        int n8 = i4;
                        byArray5[n8] = (byte)(byArray5[n8] ^ byArray4[i4]);
                    }
                }
                if (i2 == n6) {
                    System.arraycopy(byArray5, 0, byArray3, (i2 - 1) * n5, n7);
                    continue;
                }
                System.arraycopy(byArray5, 0, byArray3, (i2 - 1) * n5, n5);
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new RuntimeException(z[8]);
        }
        return byArray3;
    }

    public byte[] getEncoded() {
        return (byte[])this.key.clone();
    }

    public String getAlgorithm() {
        return z[1] + this.prf.getAlgorithm();
    }

    public int getIterationCount() {
        return this.iterCount;
    }

    public char[] getPassword() {
        return (char[])this.passwd.clone();
    }

    public byte[] getSalt() {
        return (byte[])this.salt.clone();
    }

    public String getFormat() {
        return z[0];
    }

    public int hashCode() {
        int n2 = 0;
        for (int i2 = 1; i2 < this.key.length; ++i2) {
            n2 += this.key[i2] * i2;
        }
        return n2 ^= this.getAlgorithm().toLowerCase().hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SecretKey)) {
            return false;
        }
        SecretKey secretKey = (SecretKey)object;
        if (!secretKey.getAlgorithm().equalsIgnoreCase(this.getAlgorithm())) {
            return false;
        }
        if (!secretKey.getFormat().equalsIgnoreCase(z[0])) {
            return false;
        }
        byte[] byArray = secretKey.getEncoded();
        boolean bl = Arrays.equals(this.key, secretKey.getEncoded());
        Arrays.fill(byArray, (byte)0);
        return bl;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new KeyRep(KeyRep.Type.SECRET, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.passwd != null) {
                Arrays.fill(this.passwd, '0');
                this.passwd = null;
            }
            if (this.key != null) {
                Arrays.fill(this.key, (byte)0);
                this.key = null;
            }
        }
        finally {
            super.finalize();
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block89: {
            int n2;
            int n3;
            block88: {
                char[] cArray2;
                Object var0;
                block87: {
                    int n4;
                    block86: {
                        char[] cArray3;
                        block85: {
                            int n5;
                            block84: {
                                char[] cArray4;
                                block83: {
                                    int n6;
                                    block82: {
                                        char[] cArray5;
                                        block81: {
                                            int n7;
                                            block80: {
                                                char[] cArray6;
                                                block79: {
                                                    int n8;
                                                    block78: {
                                                        char[] cArray7;
                                                        block77: {
                                                            int n9;
                                                            block76: {
                                                                char[] cArray8;
                                                                block75: {
                                                                    int n10;
                                                                    block74: {
                                                                        char[] cArray9;
                                                                        block73: {
                                                                            int n11;
                                                                            block72: {
                                                                                stringArray = new String[9];
                                                                                var0 = null;
                                                                                char[] cArray10 = "o\u0015-".toCharArray();
                                                                                cArray9 = cArray10;
                                                                                n11 = cArray10.length;
                                                                                n3 = 0;
                                                                                if (!true) break block72;
                                                                                n11 = n11;
                                                                                if (n11 <= n3) break block73;
                                                                            }
                                                                            do {
                                                                                int n12;
                                                                                cArray9 = cArray9;
                                                                                int n13 = n3;
                                                                                char c2 = cArray9[n13];
                                                                                switch (n3 % 5) {
                                                                                    case 0: {
                                                                                        n12 = 61;
                                                                                        break;
                                                                                    }
                                                                                    case 1: {
                                                                                        n12 = 84;
                                                                                        break;
                                                                                    }
                                                                                    case 2: {
                                                                                        n12 = 122;
                                                                                        break;
                                                                                    }
                                                                                    case 3: {
                                                                                        n12 = 3;
                                                                                        break;
                                                                                    }
                                                                                    default: {
                                                                                        n12 = 55;
                                                                                    }
                                                                                }
                                                                                cArray9[n13] = (char)(c2 ^ n12);
                                                                                ++n3;
                                                                                n11 = n11;
                                                                            } while (n11 > n3);
                                                                        }
                                                                        stringArray[0] = new String(cArray9).intern();
                                                                        var0 = null;
                                                                        char[] cArray11 = "m\u00161Gq\u000f\u0003\u0013w_".toCharArray();
                                                                        cArray8 = cArray11;
                                                                        n10 = cArray11.length;
                                                                        n3 = 0;
                                                                        if (!true) break block74;
                                                                        n10 = n10;
                                                                        if (n10 <= n3) break block75;
                                                                    }
                                                                    do {
                                                                        int n14;
                                                                        cArray8 = cArray8;
                                                                        int n15 = n3;
                                                                        char c3 = cArray8[n15];
                                                                        switch (n3 % 5) {
                                                                            case 0: {
                                                                                n14 = 61;
                                                                                break;
                                                                            }
                                                                            case 1: {
                                                                                n14 = 84;
                                                                                break;
                                                                            }
                                                                            case 2: {
                                                                                n14 = 122;
                                                                                break;
                                                                            }
                                                                            case 3: {
                                                                                n14 = 3;
                                                                                break;
                                                                            }
                                                                            default: {
                                                                                n14 = 55;
                                                                            }
                                                                        }
                                                                        cArray8[n15] = (char)(c3 ^ n14);
                                                                        ++n3;
                                                                        n10 = n10;
                                                                    } while (n10 > n3);
                                                                }
                                                                stringArray[1] = new String(cArray8).intern();
                                                                var0 = null;
                                                                char[] cArray12 = "h\u0000<.\u000f".toCharArray();
                                                                cArray7 = cArray12;
                                                                n9 = cArray12.length;
                                                                n3 = 0;
                                                                if (!true) break block76;
                                                                n9 = n9;
                                                                if (n9 <= n3) break block77;
                                                            }
                                                            do {
                                                                int n16;
                                                                cArray7 = cArray7;
                                                                int n17 = n3;
                                                                char c4 = cArray7[n17];
                                                                switch (n3 % 5) {
                                                                    case 0: {
                                                                        n16 = 61;
                                                                        break;
                                                                    }
                                                                    case 1: {
                                                                        n16 = 84;
                                                                        break;
                                                                    }
                                                                    case 2: {
                                                                        n16 = 122;
                                                                        break;
                                                                    }
                                                                    case 3: {
                                                                        n16 = 3;
                                                                        break;
                                                                    }
                                                                    default: {
                                                                        n16 = 55;
                                                                    }
                                                                }
                                                                cArray7[n17] = (char)(c4 ^ n16);
                                                                ++n3;
                                                                n9 = n9;
                                                            } while (n9 > n3);
                                                        }
                                                        stringArray[2] = new String(cArray7).intern();
                                                        var0 = null;
                                                        char[] cArray13 = "t \u001fqVI=\u0015m\u0017^;\u000fmC\u001d=\t#YX3\u001bw^K1".toCharArray();
                                                        cArray6 = cArray13;
                                                        n8 = cArray13.length;
                                                        n3 = 0;
                                                        if (!true) break block78;
                                                        n8 = n8;
                                                        if (n8 <= n3) break block79;
                                                    }
                                                    do {
                                                        int n18;
                                                        cArray6 = cArray6;
                                                        int n19 = n3;
                                                        char c5 = cArray6[n19];
                                                        switch (n3 % 5) {
                                                            case 0: {
                                                                n18 = 61;
                                                                break;
                                                            }
                                                            case 1: {
                                                                n18 = 84;
                                                                break;
                                                            }
                                                            case 2: {
                                                                n18 = 122;
                                                                break;
                                                            }
                                                            case 3: {
                                                                n18 = 3;
                                                                break;
                                                            }
                                                            default: {
                                                                n18 = 55;
                                                            }
                                                        }
                                                        cArray6[n19] = (char)(c5 ^ n18);
                                                        ++n3;
                                                        n8 = n8;
                                                    } while (n8 > n3);
                                                }
                                                stringArray[3] = new String(cArray6).intern();
                                                var0 = null;
                                                char[] cArray14 = "t \u001fqVI=\u0015m\u0017^;\u000fmC\u001d:\u0015w\u0017[;\u000fmS".toCharArray();
                                                cArray5 = cArray14;
                                                n7 = cArray14.length;
                                                n3 = 0;
                                                if (!true) break block80;
                                                n7 = n7;
                                                if (n7 <= n3) break block81;
                                            }
                                            do {
                                                int n20;
                                                cArray5 = cArray5;
                                                int n21 = n3;
                                                char c6 = cArray5[n21];
                                                switch (n3 % 5) {
                                                    case 0: {
                                                        n20 = 61;
                                                        break;
                                                    }
                                                    case 1: {
                                                        n20 = 84;
                                                        break;
                                                    }
                                                    case 2: {
                                                        n20 = 122;
                                                        break;
                                                    }
                                                    case 3: {
                                                        n20 = 3;
                                                        break;
                                                    }
                                                    default: {
                                                        n20 = 55;
                                                    }
                                                }
                                                cArray5[n21] = (char)(c6 ^ n20);
                                                ++n3;
                                                n7 = n7;
                                            } while (n7 > n3);
                                        }
                                        stringArray[4] = new String(cArray5).intern();
                                        var0 = null;
                                        char[] cArray15 = "n5\u0016w\u0017S;\u000e#QR!\u0014g".toCharArray();
                                        cArray4 = cArray15;
                                        n6 = cArray15.length;
                                        n3 = 0;
                                        if (!true) break block82;
                                        n6 = n6;
                                        if (n6 <= n3) break block83;
                                    }
                                    do {
                                        int n22;
                                        cArray4 = cArray4;
                                        int n23 = n3;
                                        char c7 = cArray4[n23];
                                        switch (n3 % 5) {
                                            case 0: {
                                                n22 = 61;
                                                break;
                                            }
                                            case 1: {
                                                n22 = 84;
                                                break;
                                            }
                                            case 2: {
                                                n22 = 122;
                                                break;
                                            }
                                            case 3: {
                                                n22 = 3;
                                                break;
                                            }
                                            default: {
                                                n22 = 55;
                                            }
                                        }
                                        cArray4[n23] = (char)(c7 ^ n22);
                                        ++n3;
                                        n6 = n6;
                                    } while (n6 > n3);
                                }
                                stringArray[5] = new String(cArray4).intern();
                                var0 = null;
                                char[] cArray16 = "v1\u0003#[X:\u001dw_\u001d=\t#YX3\u001bw^K1".toCharArray();
                                cArray3 = cArray16;
                                n5 = cArray16.length;
                                n3 = 0;
                                if (!true) break block84;
                                n5 = n5;
                                if (n5 <= n3) break block85;
                            }
                            do {
                                int n24;
                                cArray3 = cArray3;
                                int n25 = n3;
                                char c8 = cArray3[n25];
                                switch (n3 % 5) {
                                    case 0: {
                                        n24 = 61;
                                        break;
                                    }
                                    case 1: {
                                        n24 = 84;
                                        break;
                                    }
                                    case 2: {
                                        n24 = 122;
                                        break;
                                    }
                                    case 3: {
                                        n24 = 3;
                                        break;
                                    }
                                    default: {
                                        n24 = 55;
                                    }
                                }
                                cArray3[n25] = (char)(c8 ^ n24);
                                ++n3;
                                n5 = n5;
                            } while (n5 > n3);
                        }
                        stringArray[6] = new String(cArray3).intern();
                        var0 = null;
                        char[] cArray17 = "v1\u0003#[X:\u001dw_\u001d:\u0015w\u0017[;\u000fmS".toCharArray();
                        cArray2 = cArray17;
                        n4 = cArray17.length;
                        n3 = 0;
                        if (!true) break block86;
                        n4 = n4;
                        if (n4 <= n3) break block87;
                    }
                    do {
                        int n26;
                        cArray2 = cArray2;
                        int n27 = n3;
                        char c9 = cArray2[n27];
                        switch (n3 % 5) {
                            case 0: {
                                n26 = 61;
                                break;
                            }
                            case 1: {
                                n26 = 84;
                                break;
                            }
                            case 2: {
                                n26 = 122;
                                break;
                            }
                            case 3: {
                                n26 = 3;
                                break;
                            }
                            default: {
                                n26 = 55;
                            }
                        }
                        cArray2[n27] = (char)(c9 ^ n26);
                        ++n3;
                        n4 = n4;
                    } while (n4 > n3);
                }
                stringArray[7] = new String(cArray2).intern();
                var0 = null;
                char[] cArray18 = "x&\blE\u001d0\u001fq^K=\u0014d\u0017m\u00161Gq\u000ft\u0011fNN".toCharArray();
                cArray = cArray18;
                n2 = cArray18.length;
                n3 = 0;
                if (!true) break block88;
                n2 = n2;
                if (n2 <= n3) break block89;
            }
            do {
                int n28;
                cArray = cArray;
                int n29 = n3;
                char c10 = cArray[n29];
                switch (n3 % 5) {
                    case 0: {
                        n28 = 61;
                        break;
                    }
                    case 1: {
                        n28 = 84;
                        break;
                    }
                    case 2: {
                        n28 = 122;
                        break;
                    }
                    case 3: {
                        n28 = 3;
                        break;
                    }
                    default: {
                        n28 = 55;
                    }
                }
                cArray[n29] = (char)(c10 ^ n28);
                ++n3;
                n2 = n2;
            } while (n2 > n3);
        }
        stringArray[8] = new String(cArray).intern();
        z = stringArray;
    }
}

