/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.SecureRandom;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandomSpi;
import java.util.Random;

public final class SHA1PRNG
extends SecureRandomSpi
implements Serializable {
    static final long serialVersionUID = -3888978670357092251L;
    private transient MessageDigest sha1;
    private SecureRandom seedGenerator;
    private BigInteger P64;
    private int[] syms = new int[16];
    private byte[] sbuf = new byte[256];
    private byte[] rngTestBuf = null;
    private long accu = 0L;
    private boolean firstTrng = true;
    private long rngTest = 0L;
    private int bits = 0;
    private int nsam = 64;
    private static final short[] logtab;
    byte[] state = new byte[85];
    boolean resetState = false;
    private static transient Random random;
    private static String[] z;

    public SHA1PRNG() {
        this.a(null);
    }

    public SHA1PRNG(byte[] byArray) {
        this.a(byArray);
    }

    private void a(byte[] byArray) {
        random = new Random();
        byte[] byArray2 = new byte[9];
        try {
            this.sha1 = MessageDigest.getInstance(z[3], z[2]);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalError(z[1]);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new InternalError(z[0]);
        }
        byArray2[0] = 1;
        byArray2[8] = 13;
        this.P64 = new BigInteger(1, byArray2);
        SHA1PRNG.a(128, this.state, 49);
        SHA1PRNG.a(30, this.state, 53);
        if (byArray != null) {
            this.engineSetSeed(byArray);
        }
    }

    public boolean isFipsApproved() {
        return true;
    }

    public synchronized void engineSetSeed(byte[] byArray) {
        this.b(byArray);
    }

    protected synchronized void b(byte[] byArray) {
        if (byArray != null) {
            int n2 = 0;
            int n3 = byArray.length;
            if (n3 > 40) {
                MessageDigest messageDigest = null;
                try {
                    messageDigest = MessageDigest.getInstance(z[3], z[2]);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new InternalError(z[1]);
                }
                catch (NoSuchProviderException noSuchProviderException) {
                    throw new InternalError(z[0]);
                }
                byte[] byArray2 = new byte[20];
                messageDigest.update(byArray);
                byArray2 = messageDigest.digest();
                n3 = 20;
                byArray = this.state;
                n2 = 65;
                System.arraycopy(byArray2, 0, this.state, 65, n3);
            }
            while (--n3 >= 0) {
                int n4 = 25 + n3 % 20;
                this.state[n4] = (byte)(this.state[n4] ^ byArray[n2 + n3]);
            }
            if (this.state[0] == 0) {
                this.state[0] = 25;
            }
        }
    }

    public synchronized void engineNextBytes(byte[] byArray) {
        this.c(byArray);
    }

    protected synchronized void c(byte[] byArray) {
        this.b(byArray, 0, byArray.length);
    }

    public byte[] engineGenerateSeed(int n2) {
        return this.a(n2);
    }

    protected byte[] a(int n2) {
        byte[] byArray = new byte[n2];
        this.b(byArray, 0, byArray.length);
        return byArray;
    }

    private int a() {
        int n2;
        while (this.bits == 0) {
            BigInteger bigInteger;
            long l2;
            this.accu = 0L;
            int n3 = 0;
            do {
                this.syms[n3] = 0;
            } while (++n3 < 16);
            int n4 = this.sbuf.length - 1;
            int n5 = 0;
            n2 = 0;
            int n6 = 0;
            int n7 = 0;
            while (true) {
                int n8 = 0;
                do {
                    l2 = System.currentTimeMillis();
                } while ((n8 = random.nextInt(Integer.MAX_VALUE)) == 0);
                this.sbuf[n4] = (byte)(this.sbuf[n4] << 4 | n8 % 16);
                n4 -= n5;
                n5 ^= 1;
                if ((n7 - n8) * (n7 - n8) != 1) {
                    n7 = n8;
                }
                int n9 = n7 % 16;
                this.syms[n9] = this.syms[n9] + n2;
                n2 |= 1;
                if (n4 < 0) {
                    bigInteger = new BigInteger(1, this.sbuf);
                    this.accu ^= bigInteger.multiply(bigInteger).remainder(this.P64).longValue();
                    n4 += this.sbuf.length;
                    n2 = 0;
                }
                if (++n6 < this.nsam) continue;
                n3 = 0;
                int n10 = 0;
                int n11 = SHA1PRNG.b(n6);
                do {
                    n2 = this.syms[n3];
                    n10 += n2 * (n11 - SHA1PRNG.b(n2));
                } while (++n3 < 16);
                this.nsam = 96000 * n6 / n10;
                if (this.nsam <= n6) break;
                this.nsam = n10 > n6 ? this.nsam + 3 : n6 + 32;
                n2 = 0;
            }
            bigInteger = new BigInteger(1, this.sbuf);
            this.accu ^= bigInteger.multiply(bigInteger).remainder(this.P64).longValue() ^ l2;
            this.bits = 64;
            if (!this.firstTrng) continue;
            this.accu = 0L;
            this.bits = 0;
            this.firstTrng = false;
        }
        n2 = (int)(this.accu & 0xFFL);
        this.accu >>>= 8;
        this.bits -= 8;
        return n2;
    }

    private void a(byte[] byArray, int n2, int n3) {
        byte[] byArray2 = this.state;
        while (--n3 >= 0) {
            int n4 = 25 + n3 % 20;
            byArray2[n4] = (byte)(byArray2[n4] ^ this.a());
        }
        long l2 = (long)SHA1PRNG.a(byArray2, 53) * 1000L + System.currentTimeMillis();
        SHA1PRNG.a((int)(l2 >>> 32), byArray2, 57);
        SHA1PRNG.a((int)l2, byArray2, 61);
        if (byArray2[0] == 0) {
            byArray2[0] = 25;
        }
        this.state = byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private synchronized void b(byte[] byArray, int n2, int n3) {
        int n4;
        byte[] byArray2 = this.state;
        byte[] byArray3 = new byte[45];
        byte[] byArray4 = null;
        if (this.resetState) {
            this.state = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            this.resetState = false;
        }
        while ((n4 = byArray2[0]) == 0) {
            this.a(null, 0, 20);
            byArray2 = this.state;
        }
        while (true) {
            if (--n3 < 0) {
                byArray2[0] = (byte)n4;
                return;
            }
            while (n4 == 25 || this.rngTestBuf == null) {
                int n5 = SHA1PRNG.a(byArray2, 49);
                if (n5 > 0) {
                    long l2 = ((long)SHA1PRNG.a(byArray2, 57) << 32) + ((long)SHA1PRNG.a(byArray2, 61) & 0xFFFFFFFFL);
                    int n6 = SHA1PRNG.a(byArray2, 45);
                    int n7 = n6 + 20;
                    if (n7 < n6) {
                        n6 = 0;
                        n7 = 0 + 20;
                    }
                    SHA1PRNG.a(n7, byArray2, 45);
                    n6 += n5 - n6 % n5;
                    while (n6 < n7) {
                        if (n6 > 0x59999994 || n6 < -1503238548) {
                            this.resetState = true;
                        }
                        byte[] byArray5 = this.sbuf;
                        // MONITORENTER : this.sbuf
                        if (this.bits > 0 || System.currentTimeMillis() >= l2) {
                            int n8 = 25 + n6 / n5 % 20;
                            byArray2[n8] = (byte)(byArray2[n8] ^ this.a());
                            l2 = (long)SHA1PRNG.a(byArray2, 53) * 1000L + System.currentTimeMillis();
                            SHA1PRNG.a((int)(l2 >>> 32), byArray2, 57);
                            SHA1PRNG.a((int)l2, byArray2, 61);
                        }
                        // MONITOREXIT : byArray5
                        n6 += n5;
                    }
                }
                System.arraycopy(byArray2, 5, byArray3, 0, 45);
                this.sha1.update(byArray3, 0, byArray3.length);
                byArray4 = this.sha1.digest();
                System.arraycopy(byArray4, 0, byArray2, 5, 20);
                if (this.rngTestBuf != null) {
                    n4 = 5;
                    continue;
                }
                this.rngTestBuf = new byte[20];
                n4 = 25;
            }
            byArray[n2++] = byArray2[n4++];
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        try {
            this.sha1 = MessageDigest.getInstance(z[3], z[2]);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalError(z[1]);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new InternalError(z[0]);
        }
    }

    private static final int b(int n2) {
        int n3 = 6;
        if (n2 == 0) {
            return 0;
        }
        while (n2 < 64) {
            n2 <<= 1;
            --n3;
        }
        while (n2 >= 128) {
            n2 >>= 1;
            ++n3;
        }
        return n3 * 1000 + logtab[n2 & 0x3F];
    }

    static final int a(byte[] byArray, int n2) {
        return byArray[n2] << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF;
    }

    static final void a(int n2, byte[] byArray, int n3) {
        byArray[n3] = (byte)(n2 >>> 24);
        byArray[n3 + 1] = (byte)(n2 >>> 16);
        byArray[n3 + 2] = (byte)(n2 >>> 8);
        byArray[n3 + 3] = (byte)n2;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block39: {
            int n2;
            int n3;
            block38: {
                char[] cArray2;
                Object var0;
                block37: {
                    int n4;
                    block36: {
                        char[] cArray3;
                        block35: {
                            int n5;
                            block34: {
                                char[] cArray4;
                                block33: {
                                    int n6;
                                    block32: {
                                        stringArray = new String[4];
                                        var0 = null;
                                        char[] cArray5 = "-\f .\f!n\u0004\u0017o\n!\u0019D.\u0012/\u0004\b.\u0006\"\b".toCharArray();
                                        cArray4 = cArray5;
                                        n6 = cArray5.length;
                                        n3 = 0;
                                        if (!true) break block32;
                                        n6 = n6;
                                        if (n6 <= n3) break block33;
                                    }
                                    do {
                                        int n7;
                                        cArray4 = cArray4;
                                        int n8 = n3;
                                        char c2 = cArray4[n8];
                                        switch (n3 % 5) {
                                            case 0: {
                                                n7 = 100;
                                                break;
                                            }
                                            case 1: {
                                                n7 = 78;
                                                break;
                                            }
                                            case 2: {
                                                n7 = 109;
                                                break;
                                            }
                                            case 3: {
                                                n7 = 100;
                                                break;
                                            }
                                            default: {
                                                n7 = 79;
                                            }
                                        }
                                        cArray4[n8] = (char)(c2 ^ n7);
                                        ++n3;
                                        n6 = n6;
                                    } while (n6 > n3);
                                }
                                stringArray[0] = new String(cArray4).intern();
                                var0 = null;
                                char[] cArray6 = "-\f .\f!n>,\u000eUn\u0004\u0017o\n!\u0019D.\u0012/\u0004\b.\u0006\"\b".toCharArray();
                                cArray3 = cArray6;
                                n5 = cArray6.length;
                                n3 = 0;
                                if (!true) break block34;
                                n5 = n5;
                                if (n5 <= n3) break block35;
                            }
                            do {
                                int n9;
                                cArray3 = cArray3;
                                int n10 = n3;
                                char c3 = cArray3[n10];
                                switch (n3 % 5) {
                                    case 0: {
                                        n9 = 100;
                                        break;
                                    }
                                    case 1: {
                                        n9 = 78;
                                        break;
                                    }
                                    case 2: {
                                        n9 = 109;
                                        break;
                                    }
                                    case 3: {
                                        n9 = 100;
                                        break;
                                    }
                                    default: {
                                        n9 = 79;
                                    }
                                }
                                cArray3[n10] = (char)(c3 ^ n9);
                                ++n3;
                                n5 = n5;
                            } while (n5 > n3);
                        }
                        stringArray[1] = new String(cArray3).intern();
                        var0 = null;
                        char[] cArray7 = "-\f .\f!".toCharArray();
                        cArray2 = cArray7;
                        n4 = cArray7.length;
                        n3 = 0;
                        if (!true) break block36;
                        n4 = n4;
                        if (n4 <= n3) break block37;
                    }
                    do {
                        int n11;
                        cArray2 = cArray2;
                        int n12 = n3;
                        char c4 = cArray2[n12];
                        switch (n3 % 5) {
                            case 0: {
                                n11 = 100;
                                break;
                            }
                            case 1: {
                                n11 = 78;
                                break;
                            }
                            case 2: {
                                n11 = 109;
                                break;
                            }
                            case 3: {
                                n11 = 100;
                                break;
                            }
                            default: {
                                n11 = 79;
                            }
                        }
                        cArray2[n12] = (char)(c4 ^ n11);
                        ++n3;
                        n4 = n4;
                    } while (n4 > n3);
                }
                stringArray[2] = new String(cArray2).intern();
                var0 = null;
                char[] cArray8 = "7\u0006,U".toCharArray();
                cArray = cArray8;
                n2 = cArray8.length;
                n3 = 0;
                if (!true) break block38;
                n2 = n2;
                if (n2 <= n3) break block39;
            }
            do {
                int n13;
                cArray = cArray;
                int n14 = n3;
                char c5 = cArray[n14];
                switch (n3 % 5) {
                    case 0: {
                        n13 = 100;
                        break;
                    }
                    case 1: {
                        n13 = 78;
                        break;
                    }
                    case 2: {
                        n13 = 109;
                        break;
                    }
                    case 3: {
                        n13 = 100;
                        break;
                    }
                    default: {
                        n13 = 79;
                    }
                }
                cArray[n14] = (char)(c5 ^ n13);
                ++n3;
                n2 = n2;
            } while (n2 > n3);
        }
        stringArray[3] = new String(cArray).intern();
        z = stringArray;
        logtab = new short[]{0, 22, 44, 66, 87, 109, 129, 150, 170, 190, 209, 229, 248, 267, 285, 304, 322, 340, 358, 375, 392, 409, 426, 443, 459, 476, 492, 508, 524, 539, 555, 570, 585, 600, 615, 629, 644, 658, 672, 687, 700, 714, 728, 741, 755, 768, 781, 794, 807, 820, 833, 845, 858, 870, 883, 895, 907, 919, 931, 943, 954, 966, 977, 989};
    }
}

