/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.certclient;

import com.ibm.misc.Debug;
import com.ibm.security.certclient.PkEeFactory;
import com.ibm.security.certclient.PkEeTransaction;
import com.ibm.security.certclient.base.PkActiveSource;
import com.ibm.security.certclient.base.PkConstants;
import com.ibm.security.certclient.base.PkException;
import com.ibm.security.certclient.base.PkNLSConstants;
import com.ibm.security.certclient.base.PkPipe;
import com.ibm.security.certclient.base.PkRejectionException;
import com.ibm.security.certclient.base.PkRevoReqEvent;
import com.ibm.security.certclient.beans.PkEeXMgr;
import com.ibm.security.certclient.beans.PkTcpClient;
import com.ibm.security.certclient.util.JPKI;
import com.ibm.security.certclient.util.PkConnector;
import com.ibm.security.x509.X509CertImpl;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;

public final class PkEeRevokeFactory
extends PkEeFactory {
    private PkEeRevokeFactory() {
        throw new UnsupportedOperationException();
    }

    public static PkEeTransaction newRevoke(String certAlias, String certPwd, String reason, String revoPwd) throws PkException {
        return new RevokeImpl(certAlias, certPwd, reason, revoPwd);
    }

    private static final class RevokeImpl
    implements PkEeTransaction {
        private static Debug debug = Debug.getInstance("keycertmanage");
        private final Object className = this.toString();
        private PkEe1 ee = new PkEe1();

        RevokeImpl(String certAlias, String certPwd, String reason, String revoPwd) throws PkException {
            this.ee.keyStore(PkEeFactory.keyStoreType, PkEeFactory.keystoreFilename, PkEeFactory.keystorePwd);
            this.ee.setCertAlias(certAlias);
            this.ee.setCertPwd(certPwd);
            this.ee.setrevoReason(reason);
            this.ee.setrevoPwd(revoPwd);
            this.ee.setCaDn(PkEeFactory.caDn);
            this.ee.setCaPort(PkEeFactory.caPort);
        }

        @Override
        public void actionRequest() throws PkException {
            this.runRevoke();
        }

        private void runRevoke() throws PkException {
            try {
                String host = this.ee.getCaDn();
                int port = this.ee.getCaPort();
                if (debug != null) {
                    debug.text(1L, this.className, "runRevoke", "EE_CARA_HOST={0}", host);
                    debug.text(1L, this.className, "runRevoke", "EE_CARA_CMP_PORT={0}", new Integer(port));
                }
                PkTcpClient client = new PkTcpClient(host, port, PkEeFactory.getCmpFmt(), 1);
                PkConnector.connect((PkActiveSource)this.ee, new PkPipe[]{new PkEeXMgr(), client}).run();
                if (this.ee.getRunFailed()) {
                    throw this.ee.getRunException();
                }
            }
            catch (Exception e2) {
                if (debug != null) {
                    debug.exception(4L, this.className, "runRevoke()", e2);
                }
                throw new PkException(e2);
            }
        }
    }

    static final class PkEe1
    extends PkActiveSource
    implements PkConstants {
        private static Debug debug = Debug.getInstance("keycertmanage");
        private final Object className = this.toString();
        private X509CertImpl cert;
        private String revoPwd;
        private String caDn;
        private int caPort;
        private String reason = null;
        private KeyStore kstore = null;
        private String certAlias;
        private String certPwd;
        private Exception runException = null;
        private boolean runFailed = false;

        protected PkEe1() {
            if (debug != null) {
                debug.text(1L, this.className, "PkEe1", "Begin");
            }
        }

        protected boolean getRunFailed() {
            return this.runFailed;
        }

        protected Exception getRunException() {
            return this.runException;
        }

        protected void setcert(X509CertImpl cert) {
            this.cert = cert;
        }

        protected void setrevoReason(String reason) throws PkException {
            if (reason == null || reason.length() == 0) {
                throw new PkException(PkNLSConstants.HTTP_INVALID_REVO_REASON);
            }
            this.reason = reason;
        }

        protected void setrevoPwd(String revoPwd) {
            this.revoPwd = revoPwd;
        }

        protected void setCertAlias(String alias) throws PkException {
            if (alias == null || alias.length() == 0) {
                throw new PkException(PkNLSConstants.EE_BAD_OR_MISSING_ALIAS);
            }
            this.certAlias = alias;
        }

        protected void setCertPwd(String initPwd) {
            if ((PkEeFactory.keystorePwd == null || PkEeFactory.keystorePwd.length == 0) && initPwd != null && initPwd.length() > 0) {
                PkEeFactory.keystorePwd = initPwd.toCharArray();
            }
            this.certPwd = initPwd;
        }

        protected void setCaDn(String caDn) {
            this.caDn = caDn != null ? caDn : PkEeFactory.caDn;
        }

        protected void setCaPort(int caPort) {
            this.caPort = caPort != 0 ? caPort : PkEeFactory.caPort;
        }

        protected String getCaDn() {
            return this.caDn;
        }

        protected int getCaPort() {
            return this.caPort;
        }

        protected void keyStore(String keyStoreType, String fileName, char[] keyStorePwd) throws PkException {
            FileInputStream inp = null;
            this.kstore = null;
            try {
                this.kstore = KeyStore.getInstance(keyStoreType, PkEeFactory.provider);
                try {
                    inp = new FileInputStream(fileName);
                    this.kstore.load(inp, keyStorePwd);
                    inp.close();
                }
                catch (FileNotFoundException e2) {
                    if (debug != null) {
                        debug.exception(4L, this.className, "keyStore", e2);
                    }
                    throw new PkException(e2);
                }
            }
            catch (GeneralSecurityException e3) {
                if (debug != null) {
                    debug.exception(4L, this.className, "keyStore", e3);
                }
                throw new PkException(e3);
            }
            catch (IOException ioe) {
                if (debug != null) {
                    debug.exception(4L, this.className, "keyStore", ioe);
                }
                throw new PkException(ioe);
            }
        }

        private void setCert() throws PkRejectionException {
            try {
                this.cert = (X509CertImpl)this.kstore.getCertificate(this.certAlias);
                if (this.cert == null) {
                    throw new PkRejectionException(PkNLSConstants.EE_MISSING_CERTIFICATE);
                }
            }
            catch (KeyStoreException kse) {
                throw new PkRejectionException(PkNLSConstants.EE_BAD_OR_MISSING_ALIAS, kse);
            }
        }

        @Override
        public void run() {
            int intReason;
            this.runFailed = false;
            this.runException = null;
            if (this.reason.equalsIgnoreCase("unspecified")) {
                intReason = 0;
            } else if (this.reason.equalsIgnoreCase("key compromise")) {
                intReason = 1;
            } else if (this.reason.equalsIgnoreCase("ca compromise")) {
                intReason = 2;
            } else if (this.reason.equalsIgnoreCase("affiliation changed")) {
                intReason = 3;
            } else if (this.reason.equalsIgnoreCase("superseded")) {
                intReason = 4;
            } else if (this.reason.equalsIgnoreCase("cessation of operation")) {
                intReason = 5;
            } else if (this.reason.equalsIgnoreCase("certificate hold")) {
                intReason = 6;
            } else if (this.reason.equalsIgnoreCase("remove from crl")) {
                intReason = 8;
            } else {
                intReason = 0;
                if (debug != null) {
                    debug.text(1L, this.className, "PkEe1.run", "Invalid reason - defaults to unspecified");
                }
            }
            try {
                this.setCert();
            }
            catch (PkRejectionException ex) {
                this.runFailed = true;
                this.runException = ex;
                if (debug != null) {
                    debug.exception(4L, this.className, "PkEe1.run", ex);
                }
                return;
            }
            Object[] items = new Object[]{this.cert, new Integer(intReason), null, this.revoPwd};
            JPKI pkcert = new JPKI();
            try {
                this.propagate(new PkRevoReqEvent(this, null, pkcert.revoRequest(items)));
            }
            catch (Exception e2) {
                this.runFailed = true;
                this.runException = e2;
                if (debug != null) {
                    debug.exception(4L, this.className, "PkEe1.run", e2);
                }
                return;
            }
            if (debug != null) {
                debug.text(1L, this.className, "PkEe1.run", "propagated revoke-request");
            }
        }
    }
}

