/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.certclient.fmt;

import com.ibm.misc.Debug;
import com.ibm.security.certclient.base.PkAttrs;
import com.ibm.security.certclient.base.PkCertRepEvent;
import com.ibm.security.certclient.base.PkCertReqEvent;
import com.ibm.security.certclient.base.PkConfRepEvent;
import com.ibm.security.certclient.base.PkConfReqEvent;
import com.ibm.security.certclient.base.PkEvent;
import com.ibm.security.certclient.base.PkException;
import com.ibm.security.certclient.base.PkPollException;
import com.ibm.security.certclient.base.PkPollReqEvent;
import com.ibm.security.certclient.base.PkReqEvent;
import com.ibm.security.certclient.base.PkRevoRepEvent;
import com.ibm.security.certclient.base.PkRevoReqEvent;
import com.ibm.security.certclient.base.PkSecnReqEvent;
import com.ibm.security.certclient.base.PkXcerRepEvent;
import com.ibm.security.certclient.base.PkXcerReqEvent;
import com.ibm.security.certclient.fmt.PkCmpEventFormatter;
import com.ibm.security.certclient.fmt.PkTcpV10CmpException;
import com.ibm.security.cmp.PKIHeader;
import com.ibm.security.cmp.PKIMessage;
import com.ibm.security.cmp.TCPMessage;
import com.ibm.security.cmp.TCPMsgRfc2510;
import com.ibm.security.cmp.TCPMsgV10;
import com.ibm.security.cmp.TCPMsgV10ErrorMsgRep;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

public class PkTcpV10CmpEventFormatter
extends PkCmpEventFormatter {
    private static final String sccsid = "%Z% %M% %I%    %W% %G% %U%";
    private static Debug debug = Debug.getInstance("keycertmanage");
    private final Object className = this.toString();
    private final byte[] emptyByteArray = new byte[0];
    static int i = 0;

    @Override
    public PkEvent readEvent(Object source, InputStream is, PkReqEvent req) throws PkException, IOException {
        TCPMessage msg0 = new TCPMessage(is);
        TCPMsgV10 msg = null;
        TCPMsgRfc2510 msg1 = null;
        boolean v10msg = true;
        if (msg0.getVersion() == 0) {
            block26: {
                if (debug != null) {
                    debug.text(1L, this.className, "readEvent", "Message is TCP_MESSAGE_RFC_2510");
                }
                try {
                    msg1 = (TCPMsgRfc2510)msg0.getMessage();
                }
                catch (Exception e2) {
                    if (debug == null) break block26;
                    debug.text(1L, this.className, "readEvent", e2.getMessage());
                }
            }
            if (debug != null) {
                debug.text(1L, this.className, "readEvent", "After creating rfc2510 request");
            }
            v10msg = false;
        } else {
            msg = (TCPMsgV10)msg0.getMessage();
        }
        if (debug != null) {
            debug.text(1L, this.className, "readEvent", " #### TcpV10CmpEvent... req = {0}", req);
        }
        if (v10msg) {
            if (debug != null) {
                debug.text(1L, this.className, "readEvent", "#### TcpV10CmpEvent... msg type = {0}", new Byte(msg.getMessageType()));
            }
            int tmpInt = is.available();
            is.skip(tmpInt);
            switch (msg.getMessageType()) {
                case 0: 
                case 5: {
                    return super.readEvent(source, new ByteArrayInputStream(msg.getValue()), req);
                }
                case 1: {
                    byte[] buffer = new byte[4];
                    System.arraycopy(msg.getValue(), 0, buffer, 0, 4);
                    int pollReference = new BigInteger(buffer).intValue();
                    System.arraycopy(msg.getValue(), 4, buffer, 0, 4);
                    int timeToCheckBack = new BigInteger(buffer).intValue();
                    throw new PkPollException(pollReference, timeToCheckBack);
                }
                case 2: {
                    byte[] buffer = new byte[4];
                    System.arraycopy(msg.getValue(), 0, buffer, 0, 4);
                    int pollReference = new BigInteger(buffer).intValue();
                    return new PkPollReqEvent(source, msg, new PkAttrs(), pollReference);
                }
                case 3: {
                    if (debug != null) {
                        debug.text(1L, this.className, "readEvent", "Received a fin_rep ");
                        debug.text(1L, this.className, "readEvent", " msg.getValue = {0}", new String(msg.getValue()));
                    }
                    return new PkConfRepEvent(source, null, req);
                }
                case 6: {
                    if (debug != null) {
                        debug.text(1L, this.className, "readEvent", "########### from TcpV10Cmp....msg= {0}", msg);
                        debug.text(1L, this.className, "readEvent", "########### from TcpV10Cmp....msg.getValue= {0}", new String(msg.getValue()));
                    }
                    TCPMsgV10ErrorMsgRep error = new TCPMsgV10ErrorMsgRep(1, 1, null, "Invalid data value");
                    if (debug != null) {
                        debug.text(1L, this.className, "readEvent", "########### from TcpV10Cmp...error= {0}", error);
                    }
                    throw new PkTcpV10CmpException(error);
                }
            }
            throw new PkTcpV10CmpException(new TCPMsgV10ErrorMsgRep(2, 2, new byte[]{msg.getMessageType()}, null));
        }
        if (debug != null) {
            debug.text(1L, this.className, "readEvent", "#### 2510 Event... msg1 type = {0}", new Byte(msg1.getFlag()));
        }
        int tmpInt = is.available();
        is.skip(tmpInt);
        if (debug != null) {
            debug.text(1L, this.className, "readEvent", "####### ms1.getFlag() = {0}", new Byte(msg1.getFlag()));
        }
        switch (msg1.getFlag()) {
            case 0: {
                return super.readEvent(source, new ByteArrayInputStream(msg1.getValue()), req);
            }
            case 2: {
                byte[] buffer = new byte[4];
                System.arraycopy(msg1.getValue(), 0, buffer, 0, 4);
                int pollReference = new BigInteger(buffer).intValue();
                if (debug != null) {
                    debug.text(1L, this.className, "readEvent", "######### 2510 poll-req event.poll ref = {0}", new Integer(pollReference));
                }
                return new PkPollReqEvent(source, msg1, new PkAttrs(), pollReference);
            }
        }
        throw new PkTcpV10CmpException(new TCPMsgV10ErrorMsgRep(2, 2, new byte[]{msg.getMessageType()}, null));
    }

    @Override
    public void writeException(Exception e2, OutputStream out) throws IOException {
        if (e2 instanceof PkTcpV10CmpException) {
            TCPMsgV10ErrorMsgRep error = new TCPMsgV10ErrorMsgRep(2, 0, this.emptyByteArray, null);
            new TCPMsgV10(0, 6, ((PkTcpV10CmpException)e2).getError().getEncoded()).write(out);
        } else if (e2 instanceof PkPollException) {
            byte[] b1 = this.to4bytes(((PkPollException)e2).getPollReference());
            byte[] b2 = this.to4bytes(((PkPollException)e2).getTimeToCheckBack());
            byte[] value = new byte[8];
            System.arraycopy(b1, 0, value, 0, 4);
            System.arraycopy(b2, 0, value, 4, 4);
            new TCPMsgV10(0, 1, value).write(out);
        } else {
            ByteArrayOutputStream o2 = new ByteArrayOutputStream();
            super.writeException(e2, o2);
            new TCPMsgV10(0, 5, o2.toByteArray()).write(out);
        }
    }

    @Override
    public void writeCertReq(PkCertReqEvent req, OutputStream out) throws IOException, PkException {
        ByteArrayOutputStream o2 = new ByteArrayOutputStream();
        super.writeCertReq(req, o2);
        new TCPMsgV10(0, 0, o2.toByteArray()).write(out);
    }

    @Override
    public void writeCertRep(PkCertRepEvent rep, OutputStream out) throws IOException, PkException {
        ByteArrayOutputStream o2 = new ByteArrayOutputStream();
        super.writeCertRep(rep, o2);
        new TCPMsgV10(0, 5, o2.toByteArray()).write(out);
    }

    @Override
    public void writeRevoReq(PkRevoReqEvent req, OutputStream out) throws IOException, PkException {
        ByteArrayOutputStream o2 = new ByteArrayOutputStream();
        super.writeRevoReq(req, o2);
        new TCPMsgV10(0, 0, o2.toByteArray()).write(out);
    }

    @Override
    public void writeConfReq(PkConfReqEvent req, OutputStream out) throws IOException {
        ByteArrayOutputStream o2 = new ByteArrayOutputStream();
        super.writeConfReq(req, o2);
        new TCPMsgV10(0, 0, o2.toByteArray()).write(out);
    }

    @Override
    public void writeSecnReq(PkSecnReqEvent req, OutputStream out) throws IOException, PkException {
        ByteArrayOutputStream o2 = new ByteArrayOutputStream();
        super.writeSecnReq(req, o2);
        new TCPMsgV10(0, 0, o2.toByteArray()).write(out);
    }

    @Override
    public void writeXcerReq(PkXcerReqEvent req, OutputStream out) throws IOException, PkException {
        ByteArrayOutputStream o2 = new ByteArrayOutputStream();
        super.writeXcerReq(req, o2);
        new TCPMsgV10(0, 0, o2.toByteArray()).write(out);
    }

    @Override
    public void writeRevoRep(PkRevoRepEvent rep, OutputStream out) throws IOException {
        ByteArrayOutputStream o2 = new ByteArrayOutputStream();
        super.writeRevoRep(rep, o2);
        new TCPMsgV10(0, 5, o2.toByteArray()).write(out);
    }

    @Override
    public void writeXcerRep(PkXcerRepEvent rep, OutputStream out) throws IOException, PkException {
        ByteArrayOutputStream o2 = new ByteArrayOutputStream();
        super.writeXcerRep(rep, o2);
        new TCPMsgV10(0, 5, o2.toByteArray()).write(out);
    }

    @Override
    public void writeConfRep(PkConfRepEvent rep, OutputStream out) throws IOException {
        PKIMessage reqMsg = (PKIMessage)rep.getReq().getMsg();
        PKIHeader hdr = reqMsg.getHeader();
        BigInteger cmpVersion = hdr.getPvno();
        ByteArrayOutputStream o2 = new ByteArrayOutputStream();
        Object msg = rep.getMsg();
        if (cmpVersion.equals(BIG_ONE)) {
            if (msg == null) {
                new TCPMsgV10(0, 3, o2.toByteArray()).write(out);
            } else {
                new TCPMsgV10(0, 6, o2.toByteArray()).write(out);
            }
        } else {
            super.writeConfRep(rep, o2);
            new TCPMsgV10(0, 5, o2.toByteArray()).write(out);
        }
    }

    @Override
    public void writePollReq(PkPollReqEvent req, OutputStream out) throws IOException {
        new TCPMsgV10(0, 2, this.to4bytes(req.getPollReference())).write(out);
    }

    private byte[] to4bytes(int value) {
        byte[] b2 = BigInteger.valueOf(value).toByteArray();
        if (b2.length == 4) {
            return b2;
        }
        byte init = (byte)(value >= 0 ? 0 : -1);
        byte[] result = new byte[]{init, init, init, init};
        System.arraycopy(b2, 0, result, 4 - b2.length, b2.length);
        return result;
    }
}

